/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantRecordConstructorInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(0);
        }
        if (!HighlightingFeature.RECORDS.isAvailable((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RedundantRecordConstructorInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !aClass.isRecord()) {
                    return;
                }
                if (JavaPsiRecordUtil.isCompactConstructor(method)) {
                    this.checkCompact(method);
                } else if (JavaPsiRecordUtil.isExplicitCanonicalConstructor(method)) {
                    this.checkCanonical(method);
                }
            }

            private void checkCanonical(PsiMethod ctor) {
                PsiCodeBlock body2 = ctor.getBody();
                if (body2 == null) {
                    return;
                }
                PsiIdentifier nameIdentifier = ctor.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                Object[] components = Objects.requireNonNull(ctor.getContainingClass()).getRecordComponents();
                Object[] parameters2 = ctor.getParameterList().getParameters();
                PsiAnnotation.TargetType[] targets = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
                if (!EntryStream.zip((Object[])components, (Object[])parameters2).mapKeys(c -> ContainerUtil.filter((Object[])c.getAnnotations(), anno -> AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)anno, (PsiAnnotation.TargetType[])targets) != null)).mapValues(p -> Arrays.asList(p.getAnnotations())).allMatch(List::equals)) {
                    return;
                }
                PsiStatement[] statements = body2.getStatements();
                int assignedCount = RedundantRecordConstructorInspection.getAssignedComponentsCount((PsiRecordComponent[])components, (PsiParameter[])parameters2, statements);
                if (statements.length == components.length && assignedCount == components.length && ctor.getModifierList().getAnnotations().length == 0 && ctor.getDocComment() == null) {
                    holder.registerProblem((PsiElement)nameIdentifier, JavaBundle.message((String)"inspection.redundant.record.constructor.canonical.message", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteElementFix((PsiElement)ctor)});
                    return;
                }
                if (PsiUtil.findReturnStatements((PsiCodeBlock)body2).length > 0) {
                    return;
                }
                if (PsiUtil.getLanguageLevel((PsiElement)ctor) != LanguageLevel.JDK_14_PREVIEW && assignedCount != components.length) {
                    return;
                }
                holder.registerProblem((PsiElement)ctor.getParameterList(), JavaBundle.message((String)"inspection.redundant.record.constructor.can.be.compact.message", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ConvertToCompactConstructorFix()});
            }

            private void checkCompact(PsiMethod ctor) {
                PsiCodeBlock body2 = ctor.getBody();
                if (body2 == null) {
                    return;
                }
                PsiStatement[] statements = body2.getStatements();
                if (statements.length > 0) {
                    PsiParameter[] parameters2 = ctor.getParameterList().getParameters();
                    PsiRecordComponent[] components = Objects.requireNonNull(ctor.getContainingClass()).getRecordComponents();
                    int count = RedundantRecordConstructorInspection.getAssignedComponentsCount(components, parameters2, statements);
                    if (count < statements.length) {
                        for (int i = statements.length - count; i < statements.length; ++i) {
                            holder.registerProblem((PsiElement)statements[i], JavaBundle.message((String)"inspection.redundant.record.constructor.statement.message", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteElementFix((PsiElement)statements[i])});
                        }
                        return;
                    }
                }
                if (ctor.getModifierList().getAnnotations().length == 0 && ctor.getDocComment() == null) {
                    holder.registerProblem((PsiElement)Objects.requireNonNull(ctor.getNameIdentifier()), JavaBundle.message((String)"inspection.redundant.record.constructor.compact.message", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteElementFix((PsiElement)ctor)});
                }
            }
        };
    }

    private static int getAssignedComponentsCount(PsiRecordComponent @NotNull [] components, PsiParameter @NotNull [] parameters2, PsiStatement @NotNull [] statements) {
        PsiReferenceExpression rValue;
        PsiParameter parameter2;
        PsiRecordComponent component;
        PsiField field;
        PsiReferenceExpression lValue;
        PsiAssignmentExpression assignment;
        if (components == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(2);
        }
        if (parameters2 == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(3);
        }
        if (statements == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(4);
        }
        assert (parameters2.length == components.length);
        HashSet<PsiRecordComponent> unprocessed = new HashSet<PsiRecordComponent>(Arrays.asList(components));
        for (int i = statements.length - 1; i >= 0 && !unprocessed.isEmpty() && (assignment = ExpressionUtils.getAssignment((PsiElement)statements[i])) != null && (lValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression()), PsiReferenceExpression.class)) != null && ExpressionUtil.isEffectivelyUnqualified(lValue) && (field = (PsiField)ObjectUtils.tryCast((Object)lValue.resolve(), PsiField.class)) != null && (component = JavaPsiRecordUtil.getComponentForField(field)) != null && unprocessed.contains(component) && (parameter2 = parameters2[ArrayUtil.indexOf((Object[])components, (Object)component)]).getName().equals(component.getName()) && (rValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()), PsiReferenceExpression.class)) != null && rValue.getQualifierExpression() == null && parameter2.getName().equals(rValue.getReferenceName()); --i) {
            unprocessed.remove(component);
        }
        return components.length - unprocessed.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantRecordConstructorInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantRecordConstructorInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedComponentsCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertToCompactConstructorFix
    implements LocalQuickFix {
        private ConvertToCompactConstructorFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.redundant.record.constructor.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ConvertToCompactConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiStatement[] statements;
            PsiParameterList parameterList;
            PsiParameter[] parameters2;
            PsiMethod ctor;
            if (project == null) {
                ConvertToCompactConstructorFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ConvertToCompactConstructorFix.$$$reportNull$$$0(2);
            }
            if ((ctor = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethod.class)) == null || !JavaPsiRecordUtil.isExplicitCanonicalConstructor(ctor)) {
                return;
            }
            PsiClass record = ctor.getContainingClass();
            if (record == null) {
                return;
            }
            PsiCodeBlock body2 = ctor.getBody();
            if (body2 == null) {
                return;
            }
            PsiRecordComponent[] components = record.getRecordComponents();
            int assignedComponents = RedundantRecordConstructorInspection.getAssignedComponentsCount(components, parameters2 = (parameterList = ctor.getParameterList()).getParameters(), statements = body2.getStatements());
            PsiStatement firstStatementToDelete = assignedComponents == 0 ? null : statements[statements.length - assignedComponents];
            StringBuilder resultText = new StringBuilder();
            for (PsiElement child : ctor.getChildren()) {
                if (child == parameterList) continue;
                if (child == body2) break;
                resultText.append(child.getText());
            }
            boolean skipStatements = false;
            CommentTracker ct = new CommentTracker();
            for (PsiElement child : body2.getChildren()) {
                if (child == firstStatementToDelete) {
                    skipStatements = true;
                }
                if (skipStatements && child.getNextSibling() != null) {
                    ct.grabComments(child);
                    continue;
                }
                resultText.append(child.getText());
            }
            PsiMethod compactCtor = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(resultText.toString(), (PsiElement)ctor);
            PsiMethod result = (PsiMethod)ctor.replace((PsiElement)compactCtor);
            ct.insertCommentsBefore((PsiElement)Objects.requireNonNull(Objects.requireNonNull(result.getBody()).getRBrace()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantRecordConstructorInspection$ConvertToCompactConstructorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantRecordConstructorInspection$ConvertToCompactConstructorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

