/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class DeprecatedIsStillUsedInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            DeprecatedIsStillUsedInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            DeprecatedIsStillUsedInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitIdentifier(PsiIdentifier identifier) {
                PsiElement parent = identifier.getParent();
                if (parent instanceof PsiMember && parent instanceof PsiNameIdentifierOwner && ((PsiNameIdentifierOwner)parent).getNameIdentifier() == identifier) {
                    DeprecatedIsStillUsedInspection.checkMember((PsiMember)parent, identifier, holder);
                }
                super.visitIdentifier(identifier);
            }
        };
    }

    private static void checkMember(@NotNull PsiMember member, @NotNull PsiIdentifier identifier, @NotNull ProblemsHolder holder) {
        if (member == null) {
            DeprecatedIsStillUsedInspection.$$$reportNull$$$0(2);
        }
        if (identifier == null) {
            DeprecatedIsStillUsedInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            DeprecatedIsStillUsedInspection.$$$reportNull$$$0(4);
        }
        if (!(member instanceof PsiDocCommentOwner) || !DeprecatedIsStillUsedInspection.isDeprecated((PsiDocCommentOwner)member)) {
            return;
        }
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)member.getProject());
        String name2 = member.getName();
        if (name2 != null && DeprecatedIsStillUsedInspection.hasUsages((PsiElement)member, name2, searchHelper, member.getResolveScope())) {
            holder.registerProblem((PsiElement)identifier, JavaAnalysisBundle.message((String)"deprecated.member.0.is.still.used", (Object[])new Object[]{name2}), new LocalQuickFix[0]);
        }
    }

    private static boolean isDeprecated(PsiDocCommentOwner element) {
        return element.isDeprecated();
    }

    private static boolean hasUsages(@NotNull PsiElement element, @NotNull String name2, @NotNull PsiSearchHelper psiSearchHelper, @NotNull GlobalSearchScope searchScope) {
        PsiSearchHelper.SearchCostResult cheapEnough;
        if (element == null) {
            DeprecatedIsStillUsedInspection.$$$reportNull$$$0(5);
        }
        if (name2 == null) {
            DeprecatedIsStillUsedInspection.$$$reportNull$$$0(6);
        }
        if (psiSearchHelper == null) {
            DeprecatedIsStillUsedInspection.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            DeprecatedIsStillUsedInspection.$$$reportNull$$$0(8);
        }
        if ((cheapEnough = psiSearchHelper.isCheapEnoughToSearch(name2, searchScope, null, null)) == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES || cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return false;
        }
        return ReferencesSearch.search((PsiElement)element, (SearchScope)searchScope, (boolean)false).anyMatch(reference -> {
            PsiElement referenceElement = reference.getElement();
            return !DeprecationInspectionBase.isElementInsideDeprecated(referenceElement) && !PsiUtil.isInsideJavadocComment((PsiElement)referenceElement);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiSearchHelper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/DeprecatedIsStillUsedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMember";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

