/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public class MethodReturnTypeMacro
extends Macro {
    public String getName() {
        return "methodReturnType";
    }

    public String getPresentableName() {
        return "methodReturnType()";
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        if (params == null) {
            MethodReturnTypeMacro.$$$reportNull$$$0(0);
        }
        for (PsiElement place = context.getPsiElementAtStartOffset(); place != null; place = place.getParent()) {
            if (!(place instanceof PsiMethod)) continue;
            PsiType returnType = ((PsiMethod)place).getReturnType();
            if (returnType == null) break;
            return new PsiTypeResult(returnType, place.getProject());
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/MethodReturnTypeMacro", "calculateResult"));
    }
}

