/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class SplitDeclarationAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.split.declaration.family", (Object[])new Object[0]);
        if (string == null) {
            SplitDeclarationAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SplitDeclarationAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            SplitDeclarationAction.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!SplitDeclarationAction.canModify((PsiElement)element)) {
            return false;
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        PsiDeclarationStatement context = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class, (boolean)false, (Class[])new Class[]{PsiClass.class, PsiCodeBlock.class});
        return context != null && this.isAvailableOnDeclarationStatement(context);
    }

    private boolean isAvailableOnDeclarationStatement(PsiDeclarationStatement decl) {
        PsiElement[] declaredElements = decl.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        if (!(declaredElements[0] instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable var = (PsiLocalVariable)declaredElements[0];
        if (var.getInitializer() == null) {
            return false;
        }
        if (var.getTypeElement().isInferredType() && !PsiTypesUtil.isDenotableType((PsiType)var.getType(), (PsiElement)var)) {
            return false;
        }
        PsiElement parent = decl.getParent();
        if (parent instanceof PsiForStatement) {
            final String varName = var.getName();
            for (parent = parent.getNextSibling(); parent != null; parent = parent.getNextSibling()) {
                final Ref conflictFound = new Ref((Object)false);
                parent.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitVariable(PsiVariable variable) {
                        super.visitVariable(variable);
                        if (varName.equals(variable.getName())) {
                            conflictFound.set((Object)true);
                            this.stopWalking();
                        }
                    }
                });
                if (!((Boolean)conflictFound.get()).booleanValue()) continue;
                return false;
            }
        }
        this.setText(JavaBundle.message((String)"intention.split.declaration.assignment.text", (Object[])new Object[0]));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiDeclarationStatement decl;
        if (project == null) {
            SplitDeclarationAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SplitDeclarationAction.$$$reportNull$$$0(4);
        }
        if ((decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class)) != null) {
            ExpressionUtils.splitDeclaration(decl, project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitDeclarationAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitDeclarationAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

