/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class MoveIntoIfBranchesAction
implements IntentionAction {
    public @IntentionName @NotNull String getText() {
        String string = JavaBundle.message((String)"intention.name.move.into.if.branches", (Object[])new Object[0]);
        if (string == null) {
            MoveIntoIfBranchesAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public @IntentionFamilyName String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            MoveIntoIfBranchesAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static List<PsiStatement> extractStatements(Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return Collections.emptyList();
        }
        SelectionModel model = editor.getSelectionModel();
        if (!model.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement pos = file.findElementAt(offset);
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiStatement.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiCodeBlock.class});
            return statement == null ? Collections.emptyList() : Collections.singletonList(statement);
        }
        int startOffset = model.getSelectionStart();
        int endOffset = model.getSelectionEnd();
        Object[] elements = CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset);
        return ((Optional)StreamEx.of((Object[])elements).map(e -> (PsiStatement)ObjectUtils.tryCast((Object)e, PsiStatement.class)).collect(MoreCollectors.ifAllMatch(Objects::nonNull, Collectors.toList()))).orElse(Collections.emptyList());
    }

    private static boolean hasConflictingDeclarations(@NotNull PsiIfStatement ifStatement, @NotNull List<PsiStatement> statements) {
        if (ifStatement == null) {
            MoveIntoIfBranchesAction.$$$reportNull$$$0(2);
        }
        if (statements == null) {
            MoveIntoIfBranchesAction.$$$reportNull$$$0(3);
        }
        PsiStatement lastStatement = statements.get(statements.size() - 1);
        ArrayList<PsiElement> afterLast = new ArrayList<PsiElement>();
        for (PsiElement e = lastStatement.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (e instanceof PsiComment || e instanceof PsiWhiteSpace) continue;
            afterLast.add(e);
        }
        List declaredInIf = StreamEx.of((Object[])new PsiStatement[]{ifStatement.getThenBranch(), ifStatement.getElseBranch()}).flatArray(ControlFlowUtils::unwrapBlock).select(PsiDeclarationStatement.class).flatArray(PsiDeclarationStatement::getDeclaredElements).select(PsiNamedElement.class).map(PsiNamedElement::getName).nonNull().toList();
        if (afterLast.isEmpty() && declaredInIf.isEmpty()) {
            return false;
        }
        Set declared = StreamEx.of(statements).flatCollection(VariableAccessUtils::findDeclaredVariables).toSet();
        if (declared.isEmpty()) {
            return false;
        }
        if (((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots(afterLast)).filter(PsiJavaCodeReferenceElement.class).filter(ref -> declared.contains(ref.resolve())).first() != null) {
            return true;
        }
        return ContainerUtil.exists((Iterable)declaredInIf, name2 -> ContainerUtil.exists((Iterable)declared, d -> name2.equals(d.getName())));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        List<PsiStatement> statements;
        if (project == null) {
            MoveIntoIfBranchesAction.$$$reportNull$$$0(4);
        }
        if ((statements = MoveIntoIfBranchesAction.extractStatements(editor, file)).isEmpty()) {
            return false;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)((PsiElement)statements.get(0)));
        return prev instanceof PsiIfStatement && !MoveIntoIfBranchesAction.hasConflictingDeclarations((PsiIfStatement)prev, statements);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        List<PsiStatement> statements;
        if (project == null) {
            MoveIntoIfBranchesAction.$$$reportNull$$$0(5);
        }
        if ((statements = MoveIntoIfBranchesAction.extractStatements(editor, file)).isEmpty()) {
            return;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)((PsiElement)statements.get(0))), PsiIfStatement.class);
        if (ifStatement == null || MoveIntoIfBranchesAction.hasConflictingDeclarations(ifStatement, statements)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch == null) {
            ifStatement.setThenBranch(factory.createStatementFromText("{}", null));
            thenBranch = Objects.requireNonNull(ifStatement.getThenBranch());
        } else if (!(thenBranch instanceof PsiBlockStatement)) {
            thenBranch = (PsiStatement)BlockUtils.expandSingleStatementToBlockStatement(thenBranch).getParent().getParent();
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch == null) {
            ifStatement.setElseBranch(factory.createStatementFromText("{}", null));
            elseBranch = Objects.requireNonNull(ifStatement.getElseBranch());
        } else if (!(elseBranch instanceof PsiBlockStatement)) {
            elseBranch = (PsiStatement)BlockUtils.expandSingleStatementToBlockStatement(elseBranch).getParent().getParent();
        }
        PsiCodeBlock thenBlock = ((PsiBlockStatement)thenBranch).getCodeBlock();
        PsiCodeBlock elseBlock = ((PsiBlockStatement)elseBranch).getCodeBlock();
        PsiJavaToken thenBrace = thenBlock.getRBrace();
        PsiJavaToken elseBrace = elseBlock.getRBrace();
        if (thenBrace == null || elseBrace == null) {
            return;
        }
        thenBlock.addRangeBefore((PsiElement)statements.get(0), (PsiElement)statements.get(statements.size() - 1), (PsiElement)thenBrace);
        elseBlock.addRangeBefore((PsiElement)statements.get(0), (PsiElement)statements.get(statements.size() - 1), (PsiElement)elseBrace);
        ifStatement.getParent().deleteChildRange((PsiElement)statements.get(0), (PsiElement)statements.get(statements.size() - 1));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/MoveIntoIfBranchesAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/MoveIntoIfBranchesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasConflictingDeclarations";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

