/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.JavaTypeHintsPresentationFactory;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InsetPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J*\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInsight/hints/ImplicitTypeInlayProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "()V", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "", "getName", "()Ljava/lang/String;", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "intellij.java.impl"})
public final class ImplicitTypeInlayProvider
implements InlayHintsProvider<NoSettings> {
    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        return (InlayHintsCollector)new FactoryInlayHintsCollector(editor, editor){
            final /* synthetic */ Editor $editor;

            public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                if (element instanceof PsiLocalVariable) {
                    PsiExpression psiExpression = ((PsiLocalVariable)element).getInitializer();
                    if (psiExpression == null) {
                        return true;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiExpression, (String)"element.initializer ?: return true");
                    PsiExpression initializer = psiExpression;
                    PsiElement psiElement = ((PsiLocalVariable)element).getIdentifyingElement();
                    if (psiElement == null) {
                        return true;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.identifyingElement ?: return true");
                    PsiElement identifier = psiElement;
                    if (initializer instanceof PsiLiteral || initializer instanceof PsiPolyadicExpression || initializer instanceof PsiNewExpression) {
                        return true;
                    }
                    PsiTypeElement psiTypeElement = ((PsiLocalVariable)element).getTypeElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeElement, (String)"element.typeElement");
                    if (psiTypeElement.isInferredType()) {
                        PsiType psiType = ((PsiLocalVariable)element).getType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"element.type");
                        InlayPresentation presentation = JavaTypeHintsPresentationFactory.Companion.presentationWithColon(psiType, this.getFactory());
                        InsetPresentation shifted = PresentationFactory.inset$default((PresentationFactory)this.getFactory(), (InlayPresentation)presentation, (int)3, (int)0, (int)0, (int)0, (int)28, null);
                        TextRange textRange = identifier.getTextRange();
                        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"identifier.textRange");
                        sink.addInlineElement(textRange.getEndOffset(), true, (InlayPresentation)shifted);
                    }
                }
                return true;
            }
            {
                this.$editor = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @NotNull
    public String getName() {
        String string = JavaBundle.message((String)"settings.inlay.java.implicit.types", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaBundle.message(\"sett\u2026lay.java.implicit.types\")");
        return string;
    }

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return new SettingsKey("java.implicit.types");
    }

    @Nullable
    public String getPreviewText() {
        return null;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){

            @NotNull
            public JComponent createComponent(@NotNull ChangeListener listener) {
                Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
                return new JPanel();
            }
        };
    }

    public boolean isVisibleInSettings() {
        return InlayHintsProvider.DefaultImpls.isVisibleInSettings((InlayHintsProvider)this);
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return InlayHintsProvider.DefaultImpls.isLanguageSupported((InlayHintsProvider)this, (Language)language);
    }
}

