/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightExceptionsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.ui.SimpleListCellRenderer;
import java.util.Arrays;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class HighlightThrowsClassesHandler
extends HighlightExceptionsHandler {
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    private final PsiElement myResolved;

    HighlightThrowsClassesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PsiClassType type2, @NotNull PsiElement block, @NotNull PsiElement resolved) {
        if (editor == null) {
            HighlightThrowsClassesHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HighlightThrowsClassesHandler.$$$reportNull$$$0(1);
        }
        if (target == null) {
            HighlightThrowsClassesHandler.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            HighlightThrowsClassesHandler.$$$reportNull$$$0(3);
        }
        if (block == null) {
            HighlightThrowsClassesHandler.$$$reportNull$$$0(4);
        }
        if (resolved == null) {
            HighlightThrowsClassesHandler.$$$reportNull$$$0(5);
        }
        super(editor, file, target, new PsiClassType[]{type2}, block, null, (Condition<? super PsiType>)Conditions.alwaysTrue());
        this.myEditor = editor;
        this.myFile = file;
        this.myResolved = resolved;
    }

    public void highlightUsages() {
        String className2 = "'" + ((PsiClass)this.myResolved).getName() + "'";
        String throwingPlacesMode = JavaBundle.message((String)"highlight.throws.popup.throwing.places", (Object[])new Object[]{className2});
        final String showUsagesMode = JavaBundle.message((String)"highlight.throws.popup.usages", (Object[])new Object[]{className2});
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList(throwingPlacesMode, showUsagesMode)).setRenderer((ListCellRenderer)new SimpleListCellRenderer<String>(){

            public void customize(@NotNull JList<? extends String> list, String value2, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setIcon(showUsagesMode.equals(value2) ? AllIcons.Nodes.Class : AllIcons.Nodes.ExceptionClass);
                this.setText(value2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/highlighting/HighlightThrowsClassesHandler$1", "customize"));
            }
        }).setSelectionMode(0).setItemChosenCallback(selected -> {
            MODE mode;
            MODE mODE = mode = selected.equals(showUsagesMode) ? MODE.SHOW_USAGES : MODE.SHOW_THROWING_PLACES;
            if (mode == MODE.SHOW_THROWING_PLACES) {
                super.highlightUsages();
            } else {
                new PsiElement2UsageTargetAdapter(this.myResolved).highlightUsages(this.myFile, this.myEditor, HighlightUsagesHandler.isClearHighlights((Editor)this.myEditor));
            }
        }).setTitle(JavaBundle.message((String)"highlight.throws.class.name", (Object[])new Object[]{className2}));
        builder.createPopup().showInBestPositionFor(this.myEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "block";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "resolved";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/highlighting/HighlightThrowsClassesHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum MODE {
        SHOW_USAGES,
        SHOW_THROWING_PLACES;

    }
}

