/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HighlightSuppressedWarningsHandler
extends HighlightUsagesHandlerBase<PsiLiteralExpression> {
    private static final Logger LOG = Logger.getInstance(HighlightSuppressedWarningsHandler.class);
    private final PsiAnnotation myTarget;
    private final PsiLiteralExpression mySuppressedExpression;
    @NotNull
    private final ProperTextRange myPriorityRange;

    HighlightSuppressedWarningsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiAnnotation target, @Nullable PsiLiteralExpression suppressedExpression, @NotNull ProperTextRange priorityRange) {
        if (editor == null) {
            HighlightSuppressedWarningsHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HighlightSuppressedWarningsHandler.$$$reportNull$$$0(1);
        }
        if (target == null) {
            HighlightSuppressedWarningsHandler.$$$reportNull$$$0(2);
        }
        if (priorityRange == null) {
            HighlightSuppressedWarningsHandler.$$$reportNull$$$0(3);
        }
        super(editor, file);
        this.myTarget = target;
        this.mySuppressedExpression = suppressedExpression;
        this.myPriorityRange = priorityRange;
    }

    @NotNull
    public List<PsiLiteralExpression> getTargets() {
        PsiNameValuePair[] attributes;
        ArrayList<PsiLiteralExpression> result = new ArrayList<PsiLiteralExpression>();
        if (this.mySuppressedExpression != null) {
            result.add(this.mySuppressedExpression);
            ArrayList<PsiLiteralExpression> arrayList = result;
            if (arrayList == null) {
                HighlightSuppressedWarningsHandler.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        PsiAnnotationParameterList list = this.myTarget.getParameterList();
        for (PsiNameValuePair attribute : attributes = list.getAttributes()) {
            PsiAnnotationMemberValue[] initializers;
            PsiAnnotationMemberValue value2 = attribute.getValue();
            if (!(value2 instanceof PsiArrayInitializerMemberValue)) continue;
            for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                if (!(initializer instanceof PsiLiteralExpression)) continue;
                result.add((PsiLiteralExpression)initializer);
            }
        }
        ArrayList<PsiLiteralExpression> arrayList = result;
        if (arrayList == null) {
            HighlightSuppressedWarningsHandler.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected void selectTargets(@NotNull List<? extends PsiLiteralExpression> targets, final @NotNull Consumer<? super List<? extends PsiLiteralExpression>> selectionConsumer) {
        if (targets == null) {
            HighlightSuppressedWarningsHandler.$$$reportNull$$$0(6);
        }
        if (selectionConsumer == null) {
            HighlightSuppressedWarningsHandler.$$$reportNull$$$0(7);
        }
        if (targets.size() == 1) {
            selectionConsumer.consume(targets);
        } else {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiLiteralExpression>(JavaBundle.message((String)"highlight.suppressed.warnings.choose.inspections", (Object[])new Object[0]), targets){

                public PopupStep onChosen(PsiLiteralExpression selectedValue, boolean finalChoice) {
                    selectionConsumer.consume(Collections.singletonList(selectedValue));
                    return FINAL_CHOICE;
                }

                @NotNull
                public String getTextFor(PsiLiteralExpression value2) {
                    Object o = value2.getValue();
                    LOG.assertTrue(o instanceof String);
                    String string = (String)o;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/HighlightSuppressedWarningsHandler$1", "getTextFor"));
                }
            }).showInBestPositionFor(this.myEditor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeUsages(@NotNull List<? extends PsiLiteralExpression> targets) {
        if (targets == null) {
            HighlightSuppressedWarningsHandler.$$$reportNull$$$0(8);
        }
        Project project = this.myTarget.getProject();
        PsiElement parent = this.myTarget.getParent().getParent();
        LocalInspectionsPass pass = new LocalInspectionsPass(this.myFile, this.myFile.getViewProvider().getDocument(), parent.getTextRange().getStartOffset(), parent.getTextRange().getEndOffset(), (TextRange)this.myPriorityRange, false, HighlightInfoProcessor.getEmpty(), true);
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        for (PsiLiteralExpression psiLiteralExpression : targets) {
            List tools;
            Object value2 = psiLiteralExpression.getValue();
            if (!(value2 instanceof String) || (tools = inspectionProfile.findToolsById((String)value2, (PsiElement)psiLiteralExpression)).isEmpty()) continue;
            ArrayList<LocalInspectionToolWrapper> toolsCopy = new ArrayList<LocalInspectionToolWrapper>(tools.size());
            for (InspectionToolWrapper tool : tools) {
                if (!(tool instanceof LocalInspectionToolWrapper)) continue;
                toolsCopy.add((LocalInspectionToolWrapper)tool.createCopy());
            }
            if (toolsCopy.isEmpty()) continue;
            InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
            GlobalInspectionContextImpl context = managerEx.createNewGlobalContext();
            for (InspectionToolWrapper inspectionToolWrapper : toolsCopy) {
                inspectionToolWrapper.initialize((GlobalInspectionContext)context);
            }
            ((RefManagerImpl)context.getRefManager()).inspectionReadActionStarted();
            try {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                Runnable runnable = () -> pass.doInspectInBatch(context, (InspectionManager)managerEx, toolsCopy);
                if (indicator == null) {
                    ProgressManager.getInstance().executeProcessUnderProgress(runnable, (ProgressIndicator)new ProgressIndicatorBase());
                } else {
                    runnable.run();
                }
                for (HighlightInfo info : pass.getInfos()) {
                    PsiElement element = CollectHighlightsUtil.findCommonParent((PsiElement)this.myFile, (int)info.startOffset, (int)info.endOffset);
                    if (element == null) continue;
                    this.addOccurrence(element);
                }
            }
            finally {
                ((RefManagerImpl)context.getRefManager()).inspectionReadActionFinished();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightSuppressedWarningsHandler";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightSuppressedWarningsHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

