/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightRecordMember;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightRecordComponentsRecordFactory
extends HighlightUsagesHandlerFactoryBase {
    @Nullable
    public HighlightUsagesHandlerBase<?> createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        if (editor == null) {
            HighlightRecordComponentsRecordFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HighlightRecordComponentsRecordFactory.$$$reportNull$$$0(1);
        }
        if (target == null) {
            HighlightRecordComponentsRecordFactory.$$$reportNull$$$0(2);
        }
        if (!(target instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement parent = target.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolved = ((PsiReferenceExpression)parent).resolve();
        if (!(resolved instanceof LightRecordMember)) {
            return null;
        }
        LightRecordMember member = (LightRecordMember)resolved;
        PsiRecordComponent component = member.getRecordComponent();
        return new RecordComponentHighlightUsagesHandler(editor, file, component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/highlighting/HighlightRecordComponentsRecordFactory";
        objectArray[2] = "createHighlightUsagesHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RecordComponentHighlightUsagesHandler
    extends HighlightUsagesHandlerBase<PsiRecordComponent> {
        private final PsiRecordComponent myComponent;

        RecordComponentHighlightUsagesHandler(Editor editor, PsiFile file, PsiRecordComponent component) {
            super(editor, file);
            this.myComponent = component;
        }

        @NotNull
        public List<PsiRecordComponent> getTargets() {
            List<PsiRecordComponent> list = Collections.singletonList(this.myComponent);
            if (list == null) {
                RecordComponentHighlightUsagesHandler.$$$reportNull$$$0(0);
            }
            return list;
        }

        protected void selectTargets(@NotNull List<? extends PsiRecordComponent> targets, @NotNull Consumer<? super List<? extends PsiRecordComponent>> selectionConsumer) {
            if (targets == null) {
                RecordComponentHighlightUsagesHandler.$$$reportNull$$$0(1);
            }
            if (selectionConsumer == null) {
                RecordComponentHighlightUsagesHandler.$$$reportNull$$$0(2);
            }
            selectionConsumer.consume(targets);
        }

        public void computeUsages(@NotNull List<? extends PsiRecordComponent> targets) {
            if (targets == null) {
                RecordComponentHighlightUsagesHandler.$$$reportNull$$$0(3);
            }
            assert (targets.size() == 1);
            PsiRecordComponent record = targets.get(0);
            PsiIdentifier nameIdentifier = record.getNameIdentifier();
            if (nameIdentifier != null) {
                this.addOccurrence((PsiElement)nameIdentifier);
                final String name2 = nameIdentifier.getText();
                final Consumer onOccurence = expr2 -> this.addOccurrence((PsiElement)expr2);
                JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        super.visitReferenceExpression(expression2);
                        if (this.isReferenceToRecordComponent(name2, expression2)) {
                            onOccurence.consume((Object)expression2);
                        }
                    }
                };
                this.myComponent.getContainingFile().accept((PsiElementVisitor)visitor2);
            }
        }

        private boolean isReferenceToRecordComponent(String name2, PsiReferenceExpression referenceExpression) {
            if (!name2.equals(referenceExpression.getReferenceName())) {
                return false;
            }
            LightRecordMember recordMember = (LightRecordMember)ObjectUtils.tryCast((Object)referenceExpression.resolve(), LightRecordMember.class);
            if (recordMember == null) {
                return false;
            }
            return recordMember.getRecordComponent() == this.myComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightRecordComponentsRecordFactory$RecordComponentHighlightUsagesHandler";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargets";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightRecordComponentsRecordFactory$RecordComponentHighlightUsagesHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "selectTargets";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computeUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

