/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems;

import com.intellij.codeInsight.daemon.problems.Member;
import com.intellij.codeInsight.daemon.problems.MemberUsageCollector;
import com.intellij.codeInsight.daemon.problems.Problem;
import com.intellij.codeInsight.daemon.problems.ProblemSearcher;
import com.intellij.codeInsight.daemon.problems.ScopedMember;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ProblemCollector;", "", "()V", "Companion", "intellij.java.impl"})
public final class ProblemCollector {
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @JvmName(name="collect")
    @Nullable
    public static final Set<Problem> collect(@Nullable ScopedMember prevMember, @NotNull PsiMember curMember) {
        return Companion.collect(prevMember, curMember);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0001J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\rH\u0002J \u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\tH\u0002J0\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ProblemCollector$Companion;", "", "()V", "collect", "", "Lcom/intellij/codeInsight/daemon/problems/Problem;", "prevMember", "Lcom/intellij/codeInsight/daemon/problems/ScopedMember;", "curMember", "Lcom/intellij/psi/PsiMember;", "extractUsage", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "index", "", "isMethodSearch", "", "getUnionScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "processMemberChange", "containingFile", "processUsages", "member", "psiMember", "memberName", "", "scope", "intellij.java.impl"})
    public static final class Companion {
        @JvmStatic
        @JvmName(name="collect")
        @Nullable
        public final Set<Problem> collect(@Nullable ScopedMember prevMember, @NotNull PsiMember curMember) {
            Intrinsics.checkParameterIsNotNull((Object)curMember, (String)"curMember");
            PsiFile containingFile = curMember.getContainingFile();
            if (prevMember != null && Intrinsics.areEqual((Object)prevMember.getName(), (Object)curMember.getName())) {
                PsiFile psiFile = containingFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
                return this.processMemberChange(prevMember, curMember, psiFile);
            }
            boolean bl = false;
            Set problems = new LinkedHashSet();
            if (prevMember != null) {
                PsiFile psiFile = containingFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
                Set<Problem> set = this.processUsages(psiFile, prevMember);
                if (set == null) {
                    return null;
                }
                Set<Problem> memberProblems = set;
                problems.addAll((Collection)memberProblems);
            }
            PsiFile psiFile = containingFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
            Set<Problem> set = this.processUsages(psiFile, curMember);
            if (set == null) {
                return null;
            }
            Set<Problem> memberProblems = set;
            problems.addAll((Collection)memberProblems);
            return problems;
        }

        private final Set<Problem> processMemberChange(ScopedMember prevMember, PsiMember curMember, PsiFile containingFile) {
            GlobalSearchScope globalSearchScope = this.getUnionScope(prevMember, curMember);
            if (globalSearchScope == null) {
                return null;
            }
            GlobalSearchScope unionScope = globalSearchScope;
            String memberName = prevMember.getName();
            boolean isMethodSearch = curMember instanceof PsiMethod;
            return this.processUsages(memberName, isMethodSearch, containingFile, unionScope);
        }

        private final Set<Problem> processUsages(PsiFile containingFile, PsiMember psiMember) {
            String string = psiMember.getName();
            if (string == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"psiMember.name ?: return null");
            String memberName = string;
            SearchScope searchScope = psiMember.getUseScope();
            if (!(searchScope instanceof GlobalSearchScope)) {
                searchScope = null;
            }
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope;
            if (globalSearchScope == null) {
                return null;
            }
            GlobalSearchScope scope = globalSearchScope;
            boolean isMethodSearch = psiMember instanceof PsiMethod;
            return this.processUsages(memberName, isMethodSearch, containingFile, scope);
        }

        private final Set<Problem> processUsages(PsiFile containingFile, ScopedMember member) {
            SearchScope searchScope = member.getScope();
            if (!(searchScope instanceof GlobalSearchScope)) {
                searchScope = null;
            }
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope;
            if (globalSearchScope == null) {
                return null;
            }
            GlobalSearchScope scope = globalSearchScope;
            String memberName = member.getName();
            boolean isMethodSearch = member.getMember() instanceof Member.Method;
            return this.processUsages(memberName, isMethodSearch, containingFile, scope);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Problem> processUsages(String memberName, boolean isMethodSearch, PsiFile containingFile, GlobalSearchScope scope) {
            void $this$flatMapTo$iv;
            Function2 usageExtractor2 = (Function2)new Function2<PsiFile, Integer, PsiElement>(isMethodSearch){
                final /* synthetic */ boolean $isMethodSearch;

                @Nullable
                public final PsiElement invoke(@NotNull PsiFile file, int index) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    return com.intellij.codeInsight.daemon.problems.ProblemCollector$Companion.access$extractUsage(ProblemCollector.Companion, file, index, this.$isMethodSearch);
                }
                {
                    this.$isMethodSearch = bl;
                    super(2);
                }
            };
            MemberUsageCollector collector = new MemberUsageCollector(memberName, containingFile, (Function2<? super PsiFile, ? super Integer, ? extends PsiElement>)usageExtractor2);
            PsiSearchHelper.getInstance((Project)containingFile.getProject()).processAllFilesWithWord(memberName, scope, (Processor)collector, true);
            List<PsiElement> list = collector.getCollectedUsages();
            if (list == null) {
                return null;
            }
            List<PsiElement> usages = list;
            Iterable iterable = usages;
            boolean bl = false;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                Iterable list$iv = ProblemSearcher.Companion.getProblems$intellij_java_impl(it, containingFile);
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            return (Set)destination$iv;
        }

        private final PsiElement extractUsage(PsiFile psiFile, int index, boolean isMethodSearch) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiFile.findElementAt(index);
            if (!(psiElement2 instanceof PsiIdentifier)) {
                psiElement2 = null;
            }
            PsiIdentifier psiIdentifier = (PsiIdentifier)psiElement2;
            if (psiIdentifier == null) {
                return null;
            }
            PsiIdentifier identifier = psiIdentifier;
            PsiElement parent = identifier.getParent();
            if (parent instanceof PsiReference) {
                PsiJavaReference javaReference;
                PsiElement psiElement3 = ((PsiReference)parent).getElement();
                if (!(psiElement3 instanceof PsiJavaReference)) {
                    psiElement3 = null;
                }
                if ((javaReference = (PsiJavaReference)psiElement3) != null) {
                    PsiJavaReference psiJavaReference = javaReference;
                    if (!(psiJavaReference instanceof PsiElement)) {
                        psiJavaReference = null;
                    }
                    psiElement = (PsiElement)psiJavaReference;
                } else {
                    psiElement = null;
                }
            } else {
                psiElement = parent instanceof PsiMethod && isMethodSearch ? parent : null;
            }
            PsiElement usage = psiElement;
            return usage instanceof Navigatable ? usage : null;
        }

        private final GlobalSearchScope getUnionScope(ScopedMember prevMember, PsiMember curMember) {
            SearchScope searchScope = prevMember.getScope();
            if (!(searchScope instanceof GlobalSearchScope)) {
                searchScope = null;
            }
            GlobalSearchScope prevScope = (GlobalSearchScope)searchScope;
            SearchScope searchScope2 = curMember.getUseScope();
            if (!(searchScope2 instanceof GlobalSearchScope)) {
                searchScope2 = null;
            }
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope2;
            if (globalSearchScope == null) {
                return prevScope;
            }
            GlobalSearchScope curScope = globalSearchScope;
            if (prevScope == null) {
                return curScope;
            }
            if (Intrinsics.areEqual((Object)prevScope, (Object)curScope)) {
                return curScope;
            }
            return prevScope.union((SearchScope)curScope);
        }

        private Companion() {
        }

        public static final /* synthetic */ PsiElement access$extractUsage(Companion $this, PsiFile psiFile, int index, boolean isMethodSearch) {
            return $this.extractUsage(psiFile, index, isMethodSearch);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

