/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapExpressionFix
implements IntentionAction {
    private final PsiExpression myExpression;
    private final PsiClassType myExpectedType;
    private final boolean myPrimitiveExpected;
    private final String myMethodPresentation;

    public WrapExpressionFix(@NotNull PsiType expectedType, @NotNull PsiExpression expression2) {
        if (expectedType == null) {
            WrapExpressionFix.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            WrapExpressionFix.$$$reportNull$$$0(1);
        }
        this.myExpression = expression2;
        this.myExpectedType = WrapExpressionFix.getClassType(expectedType, (PsiElement)expression2);
        this.myPrimitiveExpected = expectedType instanceof PsiPrimitiveType;
        this.myMethodPresentation = WrapExpressionFix.getMethodPresentation(this.myExpression, this.myExpectedType, this.myPrimitiveExpected);
    }

    @Nullable
    private static PsiClassType getClassType(PsiType type2, PsiElement place) {
        if (type2 instanceof PsiClassType) {
            return (PsiClassType)type2;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)type2).getBoxedType(place.getManager(), GlobalSearchScope.allScope((Project)place.getProject()));
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("wrap.expression.using.static.accessor.text", this.myMethodPresentation);
        if (string == null) {
            WrapExpressionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String getMethodPresentation(PsiExpression expression2, PsiClassType expectedType, boolean primitiveExpected) {
        PsiClass containingClass;
        PsiMethod wrapper;
        PsiType type2 = expression2.getType();
        if (expectedType != null && type2 != null && (wrapper = WrapExpressionFix.findWrapper(type2, expectedType, primitiveExpected)) != null && (containingClass = wrapper.getContainingClass()) != null) {
            return containingClass.getName() + '.' + wrapper.getName();
        }
        return null;
    }

    @Nullable
    private static PsiMethod findWrapper(@NotNull PsiType type2, @NotNull PsiClassType expectedType, boolean primitiveExpected) {
        PsiClass aClass;
        if (type2 == null) {
            WrapExpressionFix.$$$reportNull$$$0(3);
        }
        if (expectedType == null) {
            WrapExpressionFix.$$$reportNull$$$0(4);
        }
        if ((aClass = expectedType.resolve()) != null) {
            PsiClassType expectedReturnType = expectedType;
            if (primitiveExpected) {
                expectedReturnType = PsiPrimitiveType.getUnboxedType((PsiType)expectedType);
            }
            if (expectedReturnType == null) {
                return null;
            }
            PsiMethod[] methods = aClass.getMethods();
            LinkedHashSet<PsiMethod> wrapperMethods = new LinkedHashSet<PsiMethod>();
            for (PsiMethod method : methods) {
                if (!method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != 1 || !Objects.requireNonNull(method.getParameterList().getParameter(0)).getType().isAssignableFrom(type2) || method.getReturnType() == null || !expectedReturnType.equals(method.getReturnType())) continue;
                String methodName = method.getName();
                if (methodName.startsWith("parse") || methodName.equals("valueOf")) {
                    return method;
                }
                wrapperMethods.add(method);
            }
            if (!wrapperMethods.isEmpty()) {
                return (PsiMethod)wrapperMethods.iterator().next();
            }
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("wrap.expression.using.static.accessor.family", new Object[0]);
        if (string == null) {
            WrapExpressionFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            WrapExpressionFix.$$$reportNull$$$0(6);
        }
        return this.myMethodPresentation != null && this.myExpression.isValid() && BaseIntentionAction.canModify((PsiElement)this.myExpression) && PsiImplUtil.getSwitchLabel(this.myExpression) == null && this.myExpectedType != null && this.myExpectedType.isValid() && this.myExpression.getType() != null && WrapExpressionFix.findWrapper(this.myExpression.getType(), this.myExpectedType, this.myPrimitiveExpected) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            WrapExpressionFix.$$$reportNull$$$0(7);
        }
        PsiType type2 = this.myExpression.getType();
        assert (type2 != null);
        PsiMethod wrapper = WrapExpressionFix.findWrapper(type2, this.myExpectedType, this.myPrimitiveExpected);
        assert (wrapper != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)file.getProject());
        String methodCallText = "Foo." + wrapper.getName() + "()";
        PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText(methodCallText, null);
        call.getArgumentList().add((PsiElement)this.myExpression);
        ((PsiReferenceExpression)call.getMethodExpression().getQualifierExpression()).bindToElement((PsiElement)wrapper.getContainingClass());
        this.myExpression.replace((PsiElement)call);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void registerWrapAction(JavaResolveResult[] candidates, PsiExpression[] expressions2, HighlightInfo highlightInfo, TextRange fixRange) {
        PsiType expectedType = null;
        PsiExpression expr2 = null;
        block0: for (int i = 0; i < candidates.length && expectedType == null; ++i) {
            JavaResolveResult candidate = candidates[i];
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            PsiElement element = candidate.getElement();
            assert (element != null);
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (!method.isVarArgs() && parameters2.length != expressions2.length) continue;
            for (int j = 0; j < expressions2.length; ++j) {
                PsiExpression expression2 = expressions2[j];
                PsiType exprType = expression2.getType();
                if (exprType == null || PsiType.NULL.equals((Object)exprType)) continue;
                PsiType paramType = parameters2[Math.min(j, parameters2.length - 1)].getType();
                if (paramType instanceof PsiEllipsisType) {
                    paramType = ((PsiEllipsisType)paramType).getComponentType();
                }
                if ((paramType = substitutor.substitute(paramType)).isAssignableFrom(exprType)) continue;
                PsiClassType classType = WrapExpressionFix.getClassType(paramType, (PsiElement)expression2);
                if (expectedType == null && classType != null && WrapExpressionFix.findWrapper(exprType, classType, paramType instanceof PsiPrimitiveType) != null) {
                    expectedType = paramType;
                    expr2 = expression2;
                    continue;
                }
                expectedType = null;
                expr2 = null;
                continue block0;
            }
        }
        if (expectedType != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)new WrapExpressionFix(expectedType, expr2));
        }
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            WrapExpressionFix.$$$reportNull$$$0(8);
        }
        return new WrapExpressionFix((PsiType)this.myExpectedType, (PsiExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myExpression, (PsiFile)target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

