/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExtLibraryDependencyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddLibraryDependencyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddModuleDependencyFix;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UastContextKt;

public abstract class OrderEntryFix
implements IntentionAction,
LocalQuickFix {
    private final SmartPsiFileRange myReferencePointer;

    protected OrderEntryFix(@Nullable PsiReference reference) {
        this.myReferencePointer = OrderEntryFix.createReferencePointer(reference);
    }

    @Nullable
    private static SmartPsiFileRange createReferencePointer(@Nullable PsiReference reference) {
        if (reference != null) {
            PsiElement element = reference.getElement();
            int offset = element.getTextRange().getStartOffset() + reference.getRangeInElement().getStartOffset();
            PsiFile file = element.getContainingFile();
            if (OrderEntryFix.areReferencesEquivalent(reference, file.findReferenceAt(offset))) {
                return SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiFileRangePointer(file, TextRange.from((int)offset, (int)0));
            }
        }
        return null;
    }

    private static boolean areReferencesEquivalent(@NotNull PsiReference ref1, @Nullable PsiReference ref2) {
        if (ref1 == null) {
            OrderEntryFix.$$$reportNull$$$0(0);
        }
        if (ref2 == null) {
            return false;
        }
        if (ref1.getClass() != ref2.getClass()) {
            return false;
        }
        if (ref1.getElement() != ref2.getElement()) {
            return false;
        }
        return ref1.getRangeInElement().equals((Object)ref2.getRangeInElement());
    }

    @Nullable
    protected PsiReference restoreReference() {
        PsiFile file = this.myReferencePointer == null ? null : this.myReferencePointer.getContainingFile();
        Segment range = this.myReferencePointer == null ? null : this.myReferencePointer.getPsiRange();
        return file == null || range == null ? null : file.findReferenceAt(range.getStartOffset());
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            OrderEntryFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            OrderEntryFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            OrderEntryFix.$$$reportNull$$$0(3);
        }
        this.invoke(project, null, descriptor.getPsiElement().getContainingFile());
    }

    @Nullable
    public static List<LocalQuickFix> registerFixes(@NotNull QuickFixActionRegistrar registrar, @NotNull PsiReference reference) {
        String qualifiedName;
        DependencyScope scope;
        if (registrar == null) {
            OrderEntryFix.$$$reportNull$$$0(4);
        }
        if (reference == null) {
            OrderEntryFix.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = reference.getElement();
        String shortReferenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile refVFile = containingFile.getVirtualFile();
        if (refVFile == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module currentModule = fileIndex.getModuleForFile(refVFile);
        if (currentModule == null) {
            return null;
        }
        DependencyScope dependencyScope = scope = fileIndex.isInTestSourceContent(refVFile) ? DependencyScope.TEST : DependencyScope.COMPILE;
        if (reference instanceof PsiJavaModuleReference) {
            SmartList result = new SmartList();
            OrderEntryFix.createModuleFixes((PsiJavaModuleReference)reference, currentModule, scope, (List<? super LocalQuickFix>)result);
            result.forEach(fix -> registrar.register((IntentionAction)fix));
            return result;
        }
        SmartList result = new SmartList();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        OrderEntryFix.registerExternalFixes(reference, psiElement, shortReferenceName, facade, currentModule, scope, registrar, (List<? super LocalQuickFix>)result);
        if (!result.isEmpty()) {
            return result;
        }
        PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(shortReferenceName, GlobalSearchScope.allScope((Project)project));
        List<PsiClass> allowedDependencies = OrderEntryFix.filterAllowedDependencies(psiElement, classes2);
        if (allowedDependencies.isEmpty()) {
            return result;
        }
        if (reference instanceof PsiJavaCodeReferenceElement && (qualifiedName = OrderEntryFix.getQualifiedName((PsiJavaCodeReferenceElement)reference, shortReferenceName, containingFile)) != null) {
            allowedDependencies.removeIf(aClass -> !qualifiedName.equals(aClass.getQualifiedName()));
        }
        AddModuleDependencyFix moduleDependencyFix = new AddModuleDependencyFix(reference, currentModule, scope, allowedDependencies);
        registrar.register((IntentionAction)moduleDependencyFix);
        result.add(moduleDependencyFix);
        THashSet librariesToAdd = new THashSet();
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)currentModule).getFileIndex();
        for (PsiClass aClass2 : allowedDependencies) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass2, psiElement, aClass2) || (psiFile = aClass2.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(virtualFile)) {
                OrderEntry entryForFile;
                VirtualFile jar;
                VirtualFile[] files;
                LibraryOrderEntry libraryEntry;
                Library library;
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)orderEntry).getLibrary()) == null || (files = library.getFiles(OrderRootType.CLASSES)).length == 0 || (jar = files[0]) == null || libraryEntry.isModuleLevel() && !librariesToAdd.add(jar) || !librariesToAdd.add(library) || (entryForFile = moduleFileIndex.getOrderEntryForFile(virtualFile)) != null && (!(entryForFile instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entryForFile).getScope() != DependencyScope.TEST || moduleFileIndex.isInTestSourceContent(refVFile))) continue;
                AddLibraryDependencyFix fix2 = new AddLibraryDependencyFix(reference, currentModule, library, scope, false, aClass2.getQualifiedName());
                registrar.register((IntentionAction)fix2);
                result.add(fix2);
            }
        }
        return result;
    }

    @Nullable
    private static String getQualifiedName(@NotNull PsiJavaCodeReferenceElement reference, String shortReferenceName, PsiFile containingFile) {
        PsiImportStatementBase statement;
        PsiImportList list;
        if (reference == null) {
            OrderEntryFix.$$$reportNull$$$0(6);
        }
        String qualifiedName = null;
        if (reference.isQualified()) {
            qualifiedName = reference.getQualifiedName();
        } else if (containingFile instanceof PsiJavaFile && (list = ((PsiJavaFile)containingFile).getImportList()) != null && (statement = list.findSingleImportStatement(shortReferenceName)) != null) {
            qualifiedName = statement.getImportReference().getQualifiedName();
        }
        return qualifiedName;
    }

    private static void createModuleFixes(PsiJavaModuleReference reference, Module currentModule, DependencyScope scope, List<? super LocalQuickFix> result) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)currentModule.getProject()).getFileIndex();
        List targets = Stream.of(reference.multiResolve(true)).map(ResolveResult::getElement).filter(Objects::nonNull).collect(Collectors.toList());
        PsiElement statement = reference.getElement().getParent();
        boolean exported = statement instanceof PsiRequiresStatement && ((PsiRequiresStatement)statement).hasModifierProperty("transitive");
        Set<Module> modules = targets.stream().map(e -> !(e instanceof PsiCompiledElement) ? e.getContainingFile() : null).map(f -> f != null ? f.getVirtualFile() : null).filter(vf -> vf != null && index.isInSource(vf)).map(vf -> index.getModuleForFile(vf)).filter(m -> m != null && m != currentModule).collect(Collectors.toSet());
        if (!modules.isEmpty()) {
            result.add(0, new AddModuleDependencyFix(reference, currentModule, modules, scope, exported));
        }
        targets.stream().map(e -> e instanceof PsiCompiledElement ? e.getContainingFile() : null).map(f -> f != null ? f.getVirtualFile() : null).flatMap(vf -> vf != null ? index.getOrderEntriesForFile(vf).stream() : Stream.empty()).map(e -> e instanceof LibraryOrderEntry ? ((LibraryOrderEntry)e).getLibrary() : null).filter(Objects::nonNull).distinct().forEach(l -> result.add(new AddLibraryDependencyFix((PsiReference)reference, currentModule, (Library)l, scope, exported, null)));
    }

    private static void registerExternalFixes(PsiReference reference, PsiElement psiElement, String shortReferenceName, JavaPsiFacade facade, Module currentModule, DependencyScope scope, QuickFixActionRegistrar registrar, List<? super LocalQuickFix> result) {
        String fullReferenceText = reference.getCanonicalText();
        ThreeState refToAnnotation = OrderEntryFix.isReferenceToAnnotation(psiElement);
        for (ExternalLibraryResolver resolver : (ExternalLibraryResolver[])ExternalLibraryResolver.EP_NAME.getExtensions()) {
            ExternalLibraryDescriptor descriptor;
            ExternalLibraryResolver.ExternalClassResolveResult resolveResult = resolver.resolveClass(shortReferenceName, refToAnnotation, currentModule);
            AddExtLibraryDependencyFix fix = null;
            if (resolveResult != null && facade.findClass(resolveResult.getQualifiedClassName(), currentModule.getModuleWithDependenciesAndLibrariesScope(true)) == null) {
                fix = new AddExtLibraryDependencyFix(reference, currentModule, resolveResult.getLibrary(), scope, resolveResult.getQualifiedClassName());
            } else if (!fullReferenceText.equals(shortReferenceName) && (descriptor = resolver.resolvePackage(fullReferenceText)) != null) {
                fix = new AddExtLibraryDependencyFix(reference, currentModule, descriptor, scope, null);
            }
            if (fix == null) continue;
            registrar.register(fix);
            result.add(fix);
        }
    }

    private static List<PsiClass> filterAllowedDependencies(PsiElement element, PsiClass[] classes2) {
        DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance((Project)element.getProject());
        PsiFile fromFile = element.getContainingFile();
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (PsiClass psiClass : classes2) {
            PsiFile containingFile = psiClass.getContainingFile();
            if (containingFile == null || dependencyValidationManager.getViolatorDependencyRule(fromFile, containingFile) != null) continue;
            result.add(psiClass);
        }
        return result;
    }

    private static ThreeState isReferenceToAnnotation(PsiElement psiElement) {
        if (psiElement.getLanguage() == JavaLanguage.INSTANCE && !PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiElement)) {
            return ThreeState.NO;
        }
        if (UastContextKt.getUastParentOfType((PsiElement)psiElement, UAnnotation.class) != null) {
            return ThreeState.YES;
        }
        if (UastContextKt.getUastParentOfType((PsiElement)psiElement, UImportStatement.class) != null) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    public static void importClass(@NotNull Module currentModule, @Nullable Editor editor, @Nullable PsiReference reference, @Nullable String className2) {
        if (currentModule == null) {
            OrderEntryFix.$$$reportNull$$$0(7);
        }
        Project project = currentModule.getProject();
        if (editor != null && reference != null && className2 != null) {
            DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
                GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)currentModule);
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className2, scope);
                if (aClass != null) {
                    new AddImportAction(project, reference, editor, aClass).execute();
                }
            });
        }
    }

    public static void addJarToRoots(@NotNull String jarPath, @NotNull Module module, @Nullable PsiElement location) {
        if (jarPath == null) {
            OrderEntryFix.$$$reportNull$$$0(8);
        }
        if (module == null) {
            OrderEntryFix.$$$reportNull$$$0(9);
        }
        OrderEntryFix.addJarsToRoots(Collections.singletonList(jarPath), null, module, location);
    }

    public static void addJarsToRoots(@NotNull List<String> jarPaths, @Nullable String libraryName, @NotNull Module module, @Nullable PsiElement location) {
        if (jarPaths == null) {
            OrderEntryFix.$$$reportNull$$$0(10);
        }
        if (module == null) {
            OrderEntryFix.$$$reportNull$$$0(11);
        }
        List<String> urls = OrderEntryFix.refreshAndConvertToUrls(jarPaths);
        DependencyScope scope = OrderEntryFix.suggestScopeByLocation(module, location);
        ModuleRootModificationUtil.addModuleLibrary((Module)module, (String)libraryName, urls, Collections.emptyList(), (DependencyScope)scope);
    }

    @NotNull
    public static List<String> refreshAndConvertToUrls(@NotNull List<String> jarPaths) {
        if (jarPaths == null) {
            OrderEntryFix.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.map(jarPaths, OrderEntryFix::refreshAndConvertToUrl);
        if (list == null) {
            OrderEntryFix.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static DependencyScope suggestScopeByLocation(@NotNull Module module, @Nullable PsiElement location) {
        VirtualFile vFile;
        if (module == null) {
            OrderEntryFix.$$$reportNull$$$0(14);
        }
        if (location != null && (vFile = location.getContainingFile().getVirtualFile()) != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(vFile)) {
            DependencyScope dependencyScope = DependencyScope.TEST;
            if (dependencyScope == null) {
                OrderEntryFix.$$$reportNull$$$0(15);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = DependencyScope.COMPILE;
        if (dependencyScope == null) {
            OrderEntryFix.$$$reportNull$$$0(16);
        }
        return dependencyScope;
    }

    @NotNull
    private static String refreshAndConvertToUrl(String jarPath) {
        File libraryRoot = new File(jarPath);
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libraryRoot);
        String string = VfsUtil.getUrlForLibraryRoot((File)libraryRoot);
        if (string == null) {
            OrderEntryFix.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref1";
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentModule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndConvertToUrls";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestScopeByLocation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndConvertToUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areReferencesEquivalent";
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addJarToRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addJarsToRoots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndConvertToUrls";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "suggestScopeByLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

