/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportClassFixBase<T extends PsiElement, R extends PsiReference>
implements HintAction,
HighPriorityAction {
    @NotNull
    private final T myElement;
    @NotNull
    private final R myRef;
    private final List<PsiClass> myClassesToImport;

    protected ImportClassFixBase(@NotNull T elem, @NotNull R ref) {
        if (elem == null) {
            ImportClassFixBase.$$$reportNull$$$0(0);
        }
        if (ref == null) {
            ImportClassFixBase.$$$reportNull$$$0(1);
        }
        this.myElement = elem;
        this.myRef = ref;
        this.myClassesToImport = this.calcClassesToImport();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiFile file) {
        PsiExpression expression2;
        if (project == null) {
            ImportClassFixBase.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ImportClassFixBase.$$$reportNull$$$0(3);
        }
        if (!this.myElement.isValid() || !this.myRef.getElement().isValid()) {
            return false;
        }
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression && (expression2 = ((PsiReferenceExpression)parent).getQualifierExpression()) != null && expression2 != this.myElement) {
            return false;
        }
        if (file instanceof PsiJavaCodeReferenceCodeFragment && !((PsiJavaCodeReferenceCodeFragment)file).isClassesAccepted()) {
            return false;
        }
        return !this.getClassesToImport(true).isEmpty();
    }

    @Nullable
    protected abstract String getReferenceName(@NotNull R var1);

    protected abstract PsiElement getReferenceNameElement(@NotNull R var1);

    protected abstract boolean hasTypeParameters(@NotNull R var1);

    @NotNull
    public List<PsiClass> getClassesToImport() {
        List<PsiClass> list = this.getClassesToImport(false);
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<PsiClass> getClassesToImport(boolean acceptWrongNumberOfTypeParams) {
        if (!this.myElement.isValid() || ContainerUtil.exists(this.myClassesToImport, c -> !c.isValid())) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ImportClassFixBase.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (!acceptWrongNumberOfTypeParams && this.hasTypeParameters(this.myRef)) {
            List list = ContainerUtil.findAll(this.myClassesToImport, PsiTypeParameterListOwner::hasTypeParameters);
            if (list == null) {
                ImportClassFixBase.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<PsiClass> list = this.myClassesToImport;
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    private List<PsiClass> calcClassesToImport() {
        JavaResolveResult result;
        PsiElement element;
        if (this.myRef instanceof PsiJavaReference && (element = (result = ((PsiJavaReference)this.myRef).advancedResolve(true)).getElement()) instanceof PsiClass && (result.isValidResult() || result.getCurrentFileResolveScope() instanceof PsiImportStatement)) {
            return Collections.emptyList();
        }
        String name2 = this.getReferenceName(this.myRef);
        GlobalSearchScope scope = this.myElement.getResolveScope();
        if (name2 == null) {
            return Collections.emptyList();
        }
        if (!this.canReferenceClass(this.myRef)) {
            return Collections.emptyList();
        }
        Project project = this.myElement.getProject();
        PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(name2, scope);
        if (classes2.length == 0) {
            return Collections.emptyList();
        }
        List<PsiClass> classList = new ArrayList<PsiClass>(classes2.length);
        boolean isAnnotationReference = this.myElement.getParent() instanceof PsiAnnotation;
        PsiFile file = this.myElement.getContainingFile();
        for (PsiClass aClass2 : classes2) {
            String qName;
            if (isAnnotationReference && !aClass2.isAnnotationType() || JavaCompletionUtil.isInExcludedPackage((PsiMember)aClass2, false) || (qName = aClass2.getQualifiedName()) == null || qName.indexOf(46) == -1 || !PsiNameHelper.getInstance((Project)project).isQualifiedName(qName) || !qName.endsWith(name2) || file != null && !ImportFilter.shouldImport((PsiFile)file, (String)qName)) continue;
            classList.add(aClass2);
        }
        boolean anyAccessibleFound = classList.stream().anyMatch(aClass -> this.isAccessible((PsiMember)aClass, this.myElement));
        PsiManager manager = this.myElement.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        classList.removeIf(aClass -> (anyAccessibleFound || !BaseIntentionAction.canModify((PsiElement)aClass) || facade.arePackagesTheSame((PsiElement)aClass, this.myElement)) && !this.isAccessible((PsiMember)aClass, this.myElement));
        classList = this.filterByRequiredMemberName(classList);
        List<PsiClass> filtered = this.filterByContext(classList, this.myElement);
        if (!filtered.isEmpty()) {
            classList = filtered;
        }
        this.filerByPackageName(classList, file);
        return ImportClassFixBase.removeDuplicates(classList);
    }

    @NotNull
    private static List<PsiClass> removeDuplicates(@NotNull List<PsiClass> classList) {
        if (classList == null) {
            ImportClassFixBase.$$$reportNull$$$0(8);
        }
        HashSet uniqueNames = new HashSet();
        classList.removeIf(aClass -> !uniqueNames.add(aClass.getQualifiedName()));
        List<PsiClass> list = classList;
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(9);
        }
        return list;
    }

    private void filerByPackageName(@NotNull List<? extends PsiClass> classList, PsiFile file) {
        String packageName;
        if (classList == null) {
            ImportClassFixBase.$$$reportNull$$$0(10);
        }
        if (!(packageName = StringUtil.getPackageName((String)this.getQualifiedName(this.myElement))).isEmpty() && file instanceof PsiJavaFile && Arrays.binarySearch(((PsiJavaFile)file).getImplicitlyImportedPackages(), packageName) < 0) {
            Iterator<? extends PsiClass> iterator = classList.iterator();
            while (iterator.hasNext()) {
                String classQualifiedName = iterator.next().getQualifiedName();
                if (classQualifiedName == null || packageName.equals(StringUtil.getPackageName((String)classQualifiedName))) continue;
                iterator.remove();
            }
        }
    }

    protected boolean canReferenceClass(@NotNull R ref) {
        if (ref == null) {
            ImportClassFixBase.$$$reportNull$$$0(11);
        }
        return true;
    }

    @NotNull
    private List<PsiClass> filterByRequiredMemberName(@NotNull List<PsiClass> classList) {
        List filtered;
        String memberName;
        if (classList == null) {
            ImportClassFixBase.$$$reportNull$$$0(12);
        }
        if ((memberName = this.getRequiredMemberName(this.myElement)) != null && !(filtered = ContainerUtil.findAll(classList, psiClass -> {
            PsiField field = psiClass.findFieldByName(memberName, true);
            if (field != null && field.hasModifierProperty("static") && this.isAccessible((PsiMember)field, this.myElement)) {
                return true;
            }
            PsiClass inner = psiClass.findInnerClassByName(memberName, true);
            if (inner != null && this.isAccessible((PsiMember)inner, this.myElement)) {
                return true;
            }
            for (PsiMethod method : psiClass.findMethodsByName(memberName, true)) {
                if (!method.hasModifierProperty("static") || !this.isAccessible((PsiMember)method, this.myElement)) continue;
                return true;
            }
            return false;
        })).isEmpty()) {
            classList = filtered;
        }
        List list = classList;
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(13);
        }
        return list;
    }

    private void filterAlreadyImportedButUnresolved(@NotNull List<? extends PsiClass> list) {
        PsiElement element;
        PsiFile containingFile;
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(14);
        }
        if (!((containingFile = (element = this.myRef.getElement()).getContainingFile()) instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        PsiImportList importList = javaFile.getImportList();
        PsiImportStatementBase[] importStatements = importList == null ? PsiImportStatementBase.EMPTY_ARRAY : importList.getAllImportStatements();
        THashSet importedNames = new THashSet(importStatements.length);
        for (PsiImportStatementBase statement : importStatements) {
            String name2;
            PsiJavaCodeReferenceElement ref = statement.getImportReference();
            String string = name2 = ref == null ? null : ref.getReferenceName();
            if (name2 == null || ref.resolve() != null) continue;
            importedNames.add(name2);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            PsiClass aClass = list.get(i);
            String className2 = aClass.getName();
            if (className2 == null || !importedNames.contains(className2)) continue;
            list.remove(i);
        }
    }

    @Nullable
    protected String getRequiredMemberName(@NotNull T reference) {
        if (reference == null) {
            ImportClassFixBase.$$$reportNull$$$0(15);
        }
        return null;
    }

    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull T ref) {
        if (candidates == null) {
            ImportClassFixBase.$$$reportNull$$$0(16);
        }
        if (ref == null) {
            ImportClassFixBase.$$$reportNull$$$0(17);
        }
        List<PsiClass> list = candidates;
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(18);
        }
        return list;
    }

    protected abstract boolean isAccessible(@NotNull PsiMember var1, @NotNull T var2);

    protected abstract String getQualifiedName(@NotNull T var1);

    @NotNull
    protected static List<PsiClass> filterAssignableFrom(@NotNull PsiType type2, @NotNull List<PsiClass> candidates) {
        PsiClass actualClass;
        if (type2 == null) {
            ImportClassFixBase.$$$reportNull$$$0(19);
        }
        if (candidates == null) {
            ImportClassFixBase.$$$reportNull$$$0(20);
        }
        if ((actualClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2)) != null) {
            List list = ContainerUtil.findAll(candidates, psiClass -> InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)psiClass, (boolean)true));
            if (list == null) {
                ImportClassFixBase.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<PsiClass> list = candidates;
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    protected static List<PsiClass> filterBySuperMethods(@NotNull PsiParameter parameter2, @NotNull List<PsiClass> candidates) {
        PsiMethod method;
        PsiElement granny;
        PsiElement parent;
        if (parameter2 == null) {
            ImportClassFixBase.$$$reportNull$$$0(23);
        }
        if (candidates == null) {
            ImportClassFixBase.$$$reportNull$$$0(24);
        }
        if ((parent = parameter2.getParent()) instanceof PsiParameterList && (granny = parent.getParent()) instanceof PsiMethod && (method = (PsiMethod)granny).getModifierList().hasAnnotation("java.lang.Override")) {
            PsiClass aClass = method.getContainingClass();
            HashSet probableTypes = new HashSet();
            InheritanceUtil.processSupers((PsiClass)aClass, (boolean)false, psiClass -> {
                for (PsiMethod psiMethod : psiClass.findMethodsByName(method.getName(), false)) {
                    for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                        ContainerUtil.addIfNotNull((Collection)probableTypes, (Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)psiParameter.getType()));
                    }
                }
                return true;
            });
            List filtered = ContainerUtil.filter(candidates, psiClass -> probableTypes.contains(psiClass));
            if (!filtered.isEmpty()) {
                List list = filtered;
                if (list == null) {
                    ImportClassFixBase.$$$reportNull$$$0(25);
                }
                return list;
            }
        }
        List<PsiClass> list = candidates;
        if (list == null) {
            ImportClassFixBase.$$$reportNull$$$0(26);
        }
        return list;
    }

    public boolean fixSilently(@NotNull Editor editor) {
        PsiFile file;
        if (editor == null) {
            ImportClassFixBase.$$$reportNull$$$0(27);
        }
        PsiFile psiFile = file = this.myElement.isValid() ? this.myElement.getContainingFile() : null;
        if (file == null || !ShowAutoImportPass.isAddUnambiguousImportsOnTheFlyEnabled((PsiFile)file)) {
            return false;
        }
        return this.doFix(editor, false, false, true) == Result.CLASS_AUTO_IMPORTED;
    }

    @NotNull
    public Result doFix(@NotNull Editor editor, boolean allowPopup, boolean allowCaretNearRef, boolean mayAddUnambiguousImportsSilently) {
        List<PsiClass> classesToImport;
        block13: {
            Result result;
            if (editor == null) {
                ImportClassFixBase.$$$reportNull$$$0(28);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            classesToImport = this.getClassesToImport();
            this.filterAlreadyImportedButUnresolved(classesToImport);
            if (classesToImport.isEmpty()) {
                Result result2 = Result.POPUP_NOT_SHOWN;
                if (result2 == null) {
                    ImportClassFixBase.$$$reportNull$$$0(29);
                }
                return result2;
            }
            try {
                Pattern pattern;
                Matcher matcher;
                String name2 = this.getQualifiedName(this.myElement);
                if (name2 == null || !(matcher = (pattern = Pattern.compile(DaemonCodeAnalyzerSettings.getInstance().NO_AUTO_IMPORT_PATTERN)).matcher(name2)).matches()) break block13;
                result = Result.POPUP_NOT_SHOWN;
            }
            catch (PatternSyntaxException name2) {
                // empty catch block
            }
            if (result == null) {
                ImportClassFixBase.$$$reportNull$$$0(30);
            }
            return result;
        }
        PsiFile psiFile = this.myElement.getContainingFile();
        if (classesToImport.size() > 1) {
            ImportClassFixBase.reduceSuggestedClassesBasedOnDependencyRuleViolation(psiFile, classesToImport);
        }
        PsiClass[] classes2 = classesToImport.toArray(PsiClass.EMPTY_ARRAY);
        Project project = this.myElement.getProject();
        CodeInsightUtil.sortIdenticalShortNamedMembers((PsiMember[])classes2, this.myRef);
        AddImportAction action = this.createAddImportAction(classes2, project, editor);
        boolean canImportHere = true;
        if (classes2.length == 1 && (canImportHere = this.canImportHere(allowCaretNearRef, editor, psiFile, classes2[0].getName())) && mayAddUnambiguousImportsSilently && !ImportClassFixBase.autoImportWillInsertUnexpectedCharacters(classes2[0])) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> action.execute());
            Result result = Result.CLASS_AUTO_IMPORTED;
            if (result == null) {
                ImportClassFixBase.$$$reportNull$$$0(31);
            }
            return result;
        }
        if (allowPopup && canImportHere) {
            String hintText = ShowAutoImportPass.getMessage((classes2.length > 1 ? 1 : 0) != 0, (String)classes2[0].getQualifiedName());
            if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
                HintManager.getInstance().showQuestionHint(editor, hintText, this.getStartOffset(this.myElement, this.myRef), this.getEndOffset(this.myElement, this.myRef), (QuestionAction)action);
            }
            Result result = Result.POPUP_SHOWN;
            if (result == null) {
                ImportClassFixBase.$$$reportNull$$$0(32);
            }
            return result;
        }
        Result result = Result.POPUP_NOT_SHOWN;
        if (result == null) {
            ImportClassFixBase.$$$reportNull$$$0(33);
        }
        return result;
    }

    protected int getStartOffset(@NotNull T element, @NotNull R ref) {
        if (element == null) {
            ImportClassFixBase.$$$reportNull$$$0(34);
        }
        if (ref == null) {
            ImportClassFixBase.$$$reportNull$$$0(35);
        }
        return element.getTextOffset();
    }

    protected int getEndOffset(@NotNull T element, @NotNull R ref) {
        if (element == null) {
            ImportClassFixBase.$$$reportNull$$$0(36);
        }
        if (ref == null) {
            ImportClassFixBase.$$$reportNull$$$0(37);
        }
        return element.getTextRange().getEndOffset();
    }

    private static boolean autoImportWillInsertUnexpectedCharacters(@NotNull PsiClass aClass) {
        PsiClass containingClass;
        if (aClass == null) {
            ImportClassFixBase.$$$reportNull$$$0(38);
        }
        return (containingClass = aClass.getContainingClass()) != null && !((JavaCodeStyleSettings)CodeStyle.getSettings((PsiFile)aClass.getContainingFile()).getCustomSettings(JavaCodeStyleSettings.class)).INSERT_INNER_CLASS_IMPORTS;
    }

    private boolean canImportHere(boolean allowCaretNearRef, @NotNull Editor editor, PsiFile psiFile, String exampleClassName) {
        if (editor == null) {
            ImportClassFixBase.$$$reportNull$$$0(39);
        }
        return (allowCaretNearRef || !this.isCaretNearRef(editor, this.myRef)) && !this.hasUnresolvedImportWhichCanImport(psiFile, exampleClassName);
    }

    protected abstract boolean isQualified(@NotNull R var1);

    public boolean showHint(@NotNull Editor editor) {
        PsiFile file;
        if (editor == null) {
            ImportClassFixBase.$$$reportNull$$$0(40);
        }
        if (this.isQualified(this.myRef)) {
            return false;
        }
        PsiFile psiFile = file = this.myElement.isValid() ? this.myElement.getContainingFile() : null;
        if (file == null) {
            return false;
        }
        Result result = this.doFix(editor, true, false, ShowAutoImportPass.mayAutoImportNow((PsiFile)file));
        return result == Result.POPUP_SHOWN || result == Result.CLASS_AUTO_IMPORTED;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("import.class.fix", new Object[0]);
        if (string == null) {
            ImportClassFixBase.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("import.class.fix", new Object[0]);
        if (string == null) {
            ImportClassFixBase.$$$reportNull$$$0(42);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean hasUnresolvedImportWhichCanImport(PsiFile var1, String var2);

    private static void reduceSuggestedClassesBasedOnDependencyRuleViolation(@NotNull PsiFile file, @NotNull List<? extends PsiClass> availableClasses) {
        if (file == null) {
            ImportClassFixBase.$$$reportNull$$$0(43);
        }
        if (availableClasses == null) {
            ImportClassFixBase.$$$reportNull$$$0(44);
        }
        Project project = file.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)project);
        for (int i = availableClasses.size() - 1; i >= 0; --i) {
            DependencyRule[] violated;
            PsiClass psiClass = availableClasses.get(i);
            PsiFile targetFile = psiClass.getContainingFile();
            if (targetFile == null || (violated = validationManager.getViolatorDependencyRules(file, targetFile)).length == 0) continue;
            availableClasses.remove(i);
            if (availableClasses.size() == 1) break;
        }
    }

    private boolean isCaretNearRef(@NotNull Editor editor, @NotNull R ref) {
        PsiElement nameElement;
        if (editor == null) {
            ImportClassFixBase.$$$reportNull$$$0(45);
        }
        if (ref == null) {
            ImportClassFixBase.$$$reportNull$$$0(46);
        }
        if ((nameElement = this.getReferenceNameElement(ref)) == null) {
            return false;
        }
        TextRange range = nameElement.getTextRange();
        int offset = editor.getCaretModel().getOffset();
        return offset == range.getEndOffset();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ImportClassFixBase.$$$reportNull$$$0(47);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<PsiClass> classesToImport = this.getClassesToImport(true);
            PsiClass[] classes2 = classesToImport.toArray(PsiClass.EMPTY_ARRAY);
            if (classes2.length == 0) {
                return;
            }
            AddImportAction action = this.createAddImportAction(classes2, project, editor);
            action.execute();
        });
    }

    protected void bindReference(@NotNull PsiReference reference, @NotNull PsiClass targetClass) {
        if (reference == null) {
            ImportClassFixBase.$$$reportNull$$$0(48);
        }
        if (targetClass == null) {
            ImportClassFixBase.$$$reportNull$$$0(49);
        }
        reference.bindToElement((PsiElement)targetClass);
    }

    @NotNull
    protected AddImportAction createAddImportAction(PsiClass @NotNull [] classes2, @NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            ImportClassFixBase.$$$reportNull$$$0(50);
        }
        if (editor == null) {
            ImportClassFixBase.$$$reportNull$$$0(51);
        }
        if (classes2 == null) {
            ImportClassFixBase.$$$reportNull$$$0(52);
        }
        return new AddImportAction(project, (PsiReference)this.myRef, editor, classes2){

            @Override
            protected void bindReference(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (targetClass == null) {
                    1.$$$reportNull$$$0(1);
                }
                ImportClassFixBase.this.bindReference(ref, targetClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ref";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetClass";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase$1";
                objectArray[2] = "bindReference";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 1: 
            case 11: 
            case 17: 
            case 35: 
            case 37: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 15: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 16: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 27: 
            case 28: 
            case 39: 
            case 40: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableClasses";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesToImport";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByRequiredMemberName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByContext";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAssignableFrom";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBySuperMethods";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "doFix";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filerByPackageName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canReferenceClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterByRequiredMemberName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyImportedButUnresolved";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredMemberName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterByContext";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterAssignableFrom";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "filterBySuperMethods";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fixSilently";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffset";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getEndOffset";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "autoImportWillInsertUnexpectedCharacters";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "canImportHere";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "reduceSuggestedClassesBasedOnDependencyRuleViolation";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isCaretNearRef";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "bindReference";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createAddImportAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Result {
        POPUP_SHOWN,
        CLASS_AUTO_IMPORTED,
        POPUP_NOT_SHOWN;

    }
}

