/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public enum CreateClassKind implements ClassKind
{
    CLASS(JavaElementKind.CLASS),
    INTERFACE(JavaElementKind.INTERFACE),
    ENUM(JavaElementKind.ENUM),
    ANNOTATION(JavaElementKind.ANNOTATION),
    RECORD(JavaElementKind.RECORD);

    private final JavaElementKind myKind;

    private CreateClassKind(JavaElementKind kind2) {
        this.myKind = kind2;
    }

    @Override
    public String getDescription() {
        return this.myKind.subject();
    }

    @Override
    public String getDescriptionAccusative() {
        return this.myKind.object();
    }

    @NotNull
    public Icon getKindIcon() {
        switch (this) {
            case CLASS: {
                Icon icon = PlatformIcons.CLASS_ICON;
                if (icon == null) {
                    CreateClassKind.$$$reportNull$$$0(0);
                }
                return icon;
            }
            case INTERFACE: {
                Icon icon = PlatformIcons.INTERFACE_ICON;
                if (icon == null) {
                    CreateClassKind.$$$reportNull$$$0(1);
                }
                return icon;
            }
            case ENUM: {
                Icon icon = PlatformIcons.ENUM_ICON;
                if (icon == null) {
                    CreateClassKind.$$$reportNull$$$0(2);
                }
                return icon;
            }
            case ANNOTATION: {
                Icon icon = PlatformIcons.ANNOTATION_TYPE_ICON;
                if (icon == null) {
                    CreateClassKind.$$$reportNull$$$0(3);
                }
                return icon;
            }
            case RECORD: {
                Icon icon = PlatformIcons.RECORD_ICON;
                if (icon == null) {
                    CreateClassKind.$$$reportNull$$$0(4);
                }
                return icon;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    @NotNull
    public PsiClass create(PsiElementFactory factory, String name2) {
        switch (this) {
            case CLASS: {
                PsiClass psiClass = factory.createClass(name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(5);
                }
                return psiClass;
            }
            case INTERFACE: {
                PsiClass psiClass = factory.createInterface(name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(6);
                }
                return psiClass;
            }
            case ENUM: {
                PsiClass psiClass = factory.createEnum(name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(7);
                }
                return psiClass;
            }
            case ANNOTATION: {
                PsiClass psiClass = factory.createAnnotationType(name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(8);
                }
                return psiClass;
            }
            case RECORD: {
                PsiClass psiClass = factory.createRecord(name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(9);
                }
                return psiClass;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    @NotNull
    public PsiClass createInDirectory(PsiDirectory directory, String name2) {
        JavaDirectoryService service = JavaDirectoryService.getInstance();
        switch (this) {
            case INTERFACE: {
                PsiClass psiClass = service.createInterface(directory, name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(10);
                }
                return psiClass;
            }
            case CLASS: {
                PsiClass psiClass = service.createClass(directory, name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(11);
                }
                return psiClass;
            }
            case ENUM: {
                PsiClass psiClass = service.createEnum(directory, name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(12);
                }
                return psiClass;
            }
            case RECORD: {
                PsiClass psiClass = service.createRecord(directory, name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(13);
                }
                return psiClass;
            }
            case ANNOTATION: {
                PsiClass psiClass = service.createAnnotationType(directory, name2);
                if (psiClass == null) {
                    CreateClassKind.$$$reportNull$$$0(14);
                }
                return psiClass;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateClassKind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindIcon";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createInDirectory";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

