/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.UnusedImportProvider;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.analysis.ImportsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomNamedTarget;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

class PostHighlightingVisitor {
    private static final Logger LOG = Logger.getInstance(PostHighlightingVisitor.class);
    private final RefCountHolder myRefCountHolder;
    @NotNull
    private final Project myProject;
    private final PsiFile myFile;
    @NotNull
    private final Document myDocument;
    private boolean myHasRedundantImports;
    private int myCurrentEntryIndex;
    private boolean myHasMisSortedImports;
    private final UnusedSymbolLocalInspectionBase myUnusedSymbolInspection;
    private final HighlightDisplayKey myDeadCodeKey;
    private final HighlightInfoType myDeadCodeInfoType;
    private final UnusedDeclarationInspectionBase myDeadCodeInspection;
    private final Map<PsiMethod, Boolean> isOverriddenOrOverrides;

    private void optimizeImportsOnTheFlyLater(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(0);
        }
        if ((this.myHasRedundantImports || this.myHasMisSortedImports) && !progress.isCanceled()) {
            Disposable invokeFixLater = () -> AppUIExecutor.onUiThread().later().withDocumentsCommitted(this.myProject).execute(() -> {
                if (!this.myFile.isValid() || !this.myFile.isWritable()) {
                    return;
                }
                IntentionAction optimizeImportsFix = QuickFixFactory.getInstance().createOptimizeImportsFix(true);
                if (optimizeImportsFix.isAvailable(this.myProject, null, this.myFile)) {
                    optimizeImportsFix.invoke(this.myProject, null, this.myFile);
                }
            });
            try {
                Disposer.register((Disposable)((DaemonProgressIndicator)progress), (Disposable)invokeFixLater);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (progress.isCanceled()) {
                Disposer.dispose((Disposable)invokeFixLater);
                Disposer.dispose((Disposable)((DaemonProgressIndicator)progress));
                progress.checkCanceled();
            }
        }
    }

    PostHighlightingVisitor(@NotNull PsiFile file, @NotNull Document document, @NotNull RefCountHolder refCountHolder) throws ProcessCanceledException {
        if (file == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(1);
        }
        if (document == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(2);
        }
        if (refCountHolder == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(3);
        }
        this.isOverriddenOrOverrides = ConcurrentFactoryMap.createMap(method -> {
            boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
            return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
        });
        this.myProject = file.getProject();
        this.myFile = file;
        this.myDocument = document;
        this.myCurrentEntryIndex = -1;
        this.myRefCountHolder = refCountHolder;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
        this.myDeadCodeKey = HighlightDisplayKey.find((String)"unused");
        this.myDeadCodeInspection = (UnusedDeclarationInspectionBase)profile.getUnwrappedTool("unused", (PsiElement)this.myFile);
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || this.myDeadCodeInspection != null);
        this.myUnusedSymbolInspection = this.myDeadCodeInspection != null ? this.myDeadCodeInspection.getSharedLocalInspectionTool() : null;
        this.myDeadCodeInfoType = this.myDeadCodeKey == null ? HighlightInfoType.UNUSED_SYMBOL : new HighlightInfoType.HighlightInfoTypeImpl(profile.getErrorLevel(this.myDeadCodeKey, (PsiElement)this.myFile).getSeverity(), HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
    }

    void collectHighlights(@NotNull HighlightInfoHolder result, @NotNull ProgressIndicator progress) {
        PsiImportList importList;
        HighlightDisplayKey unusedImportKey;
        if (result == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(4);
        }
        if (progress == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(5);
        }
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
        boolean unusedSymbolEnabled = profile.isToolEnabled(this.myDeadCodeKey, (PsiElement)this.myFile);
        GlobalUsageHelper globalUsageHelper = this.myRefCountHolder.getGlobalUsageHelper(this.myFile, this.myDeadCodeInspection, unusedSymbolEnabled);
        boolean errorFound = false;
        if (unusedSymbolEnabled) {
            FileViewProvider viewProvider = this.myFile.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            for (Language language : relevantLanguages) {
                ProgressManager.checkCanceled();
                PsiFile psiRoot = viewProvider.getPsi(language);
                if (!HighlightingLevelManager.getInstance((Project)this.myProject).shouldInspect((PsiElement)psiRoot)) continue;
                List elements = CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, (int)0, (int)this.myFile.getTextLength());
                for (PsiElement element : elements) {
                    PsiIdentifier identifier;
                    HighlightInfo info;
                    ProgressManager.checkCanceled();
                    if (!(element instanceof PsiIdentifier) || (info = this.processIdentifier(identifier = (PsiIdentifier)element, progress, globalUsageHelper)) == null) continue;
                    errorFound |= info.getSeverity() == HighlightSeverity.ERROR;
                    result.add(info);
                    result.queueToUpdateIncrementally();
                }
            }
        }
        if (this.isUnusedImportEnabled(unusedImportKey = HighlightDisplayKey.find((String)"UNUSED_IMPORT")) && (importList = ((PsiJavaFile)this.myFile).getImportList()) != null) {
            PsiImportStatementBase[] imports2;
            for (PsiImportStatementBase statement : imports2 = importList.getAllImportStatements()) {
                ProgressManager.checkCanceled();
                HighlightInfo info = this.processImport(statement, unusedImportKey);
                if (info == null) continue;
                errorFound |= info.getSeverity() == HighlightSeverity.ERROR;
                result.add(info);
                result.queueToUpdateIncrementally();
            }
        }
        if (errorFound) {
            fileStatusMap.setErrorFoundFlag(this.myProject, this.myDocument, true);
        }
        this.optimizeImportsOnTheFlyLater(progress);
    }

    private boolean isUnusedImportEnabled(HighlightDisplayKey unusedImportKey) {
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
        if (profile.isToolEnabled(unusedImportKey, (PsiElement)this.myFile) && this.myFile instanceof PsiJavaFile && HighlightingLevelManager.getInstance((Project)this.myProject).shouldInspect((PsiElement)this.myFile)) {
            return true;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!(provider instanceof UnusedImportProvider) || !((UnusedImportProvider)provider).isUnusedImportEnabled((PsiElement)this.myFile)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private HighlightInfo processIdentifier(@NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        PsiElement declarationScope;
        PsiElement parent;
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(7);
        }
        if (helper == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(8);
        }
        if (!((parent = identifier.getParent()) instanceof PsiVariable) && !(parent instanceof PsiMember)) {
            return null;
        }
        if (SuppressionUtil.inspectionResultSuppressed((PsiElement)identifier, (LocalInspectionTool)this.myUnusedSymbolInspection)) {
            return null;
        }
        if (parent instanceof PsiLocalVariable && this.myUnusedSymbolInspection.LOCAL_VARIABLE) {
            return this.processLocalVariable((PsiLocalVariable)parent, identifier);
        }
        if (parent instanceof PsiField && PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)parent, this.myUnusedSymbolInspection.getFieldVisibility())) {
            return this.processField(this.myProject, (PsiField)parent, identifier, progress, helper);
        }
        if (parent instanceof PsiParameter && ((declarationScope = ((PsiParameter)parent).getDeclarationScope()) instanceof PsiMethod ? PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)declarationScope, this.myUnusedSymbolInspection.getParameterVisibility()) : this.myUnusedSymbolInspection.LOCAL_VARIABLE)) {
            if (SuppressionUtil.isSuppressed((PsiElement)identifier, (String)"UnusedParameters")) {
                return null;
            }
            return this.processParameter(this.myProject, (PsiParameter)parent, identifier);
        }
        if (parent instanceof PsiMethod) {
            if (this.myUnusedSymbolInspection.isIgnoreAccessors() && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)parent))) {
                return null;
            }
            if (PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)parent, this.myUnusedSymbolInspection.getMethodVisibility())) {
                return this.processMethod(this.myProject, (PsiMethod)parent, identifier, progress, helper);
            }
        }
        if (parent instanceof PsiClass) {
            String acceptedVisibility;
            String string = acceptedVisibility = ((PsiClass)parent).getContainingClass() == null ? this.myUnusedSymbolInspection.getClassVisibility() : this.myUnusedSymbolInspection.getInnerClassVisibility();
            if (PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)parent, acceptedVisibility)) {
                return this.processClass(this.myProject, (PsiClass)parent, identifier, progress, helper);
            }
        }
        return null;
    }

    private static boolean compareVisibilities(PsiModifierListOwner listOwner, String visibility) {
        if (visibility != null) {
            while (listOwner != null) {
                if (VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)listOwner.getModifierList()), (String)visibility) >= 0) {
                    return true;
                }
                listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)listOwner, PsiModifierListOwner.class, (boolean)true);
            }
        }
        return false;
    }

    @Nullable
    private HighlightInfo processLocalVariable(@NotNull PsiLocalVariable variable, @NotNull PsiIdentifier identifier) {
        if (variable == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(9);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(10);
        }
        if (variable instanceof PsiResourceVariable && PsiUtil.isIgnoredName((String)variable.getName())) {
            return null;
        }
        if (UnusedSymbolUtil.isImplicitUsage(this.myProject, (PsiModifierListOwner)variable)) {
            return null;
        }
        if (!this.myRefCountHolder.isReferenced((PsiElement)variable)) {
            String message2 = JavaErrorBundle.message("local.variable.is.never.used", identifier.getText());
            HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message2, this.myDeadCodeInfoType);
            IntentionAction fix = variable instanceof PsiResourceVariable ? QuickFixFactory.getInstance().createRenameToIgnoredFix((PsiNamedElement)variable) : QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)variable);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)fix, (HighlightDisplayKey)this.myDeadCodeKey);
            return highlightInfo;
        }
        if (!this.myRefCountHolder.isReferencedForRead((PsiVariable)variable) && !UnusedSymbolUtil.isImplicitRead(this.myProject, (PsiVariable)variable)) {
            String message3 = JavaErrorBundle.message("local.variable.is.not.used.for.reading", identifier.getText());
            HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message3, this.myDeadCodeInfoType);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)variable), (HighlightDisplayKey)this.myDeadCodeKey);
            return highlightInfo;
        }
        if (!(variable.hasInitializer() || this.myRefCountHolder.isReferencedForWrite((PsiVariable)variable) || UnusedSymbolUtil.isImplicitWrite(this.myProject, (PsiVariable)variable))) {
            String message4 = JavaErrorBundle.message("local.variable.is.not.assigned", identifier.getText());
            HighlightInfo unusedSymbolInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message4, this.myDeadCodeInfoType);
            QuickFixAction.registerQuickFixAction((HighlightInfo)unusedSymbolInfo, (IntentionAction)QuickFixFactory.getInstance().createAddVariableInitializerFix((PsiVariable)variable), (HighlightDisplayKey)this.myDeadCodeKey);
            return unusedSymbolInfo;
        }
        return null;
    }

    @Nullable
    private HighlightInfo processField(@NotNull Project project, @NotNull PsiField field, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(11);
        }
        if (field == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(12);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(13);
        }
        if (progress == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(14);
        }
        if (helper == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(15);
        }
        if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
            return null;
        }
        if (field.hasModifierProperty("private")) {
            QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
            if (!this.myRefCountHolder.isReferenced((PsiElement)field) && !UnusedSymbolUtil.isImplicitUsage(this.myProject, (PsiModifierListOwner)field)) {
                String message2 = JavaErrorBundle.message("private.field.is.not.used", identifier.getText());
                HighlightInfo highlightInfo = this.suggestionsToMakeFieldUsed(field, identifier, message2);
                if (!field.hasInitializer() && !field.hasModifierProperty("final")) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)field), (IntentionAction)quickFixFactory.createCreateConstructorParameterFromFieldFix(field), (HighlightDisplayKey)this.myDeadCodeKey);
                }
                return highlightInfo;
            }
            boolean readReferenced = this.myRefCountHolder.isReferencedForRead((PsiVariable)field);
            if (!readReferenced && !UnusedSymbolUtil.isImplicitRead(project, (PsiVariable)field)) {
                String message3 = PostHighlightingVisitor.getNotUsedForReadingMessage(field, identifier);
                return this.suggestionsToMakeFieldUsed(field, identifier, message3);
            }
            if (field.hasInitializer()) {
                return null;
            }
            boolean writeReferenced = this.myRefCountHolder.isReferencedForWrite((PsiVariable)field);
            if (!writeReferenced && !UnusedSymbolUtil.isImplicitWrite(project, (PsiVariable)field)) {
                String message4 = JavaErrorBundle.message("private.field.is.not.assigned", identifier.getText());
                HighlightInfo info = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message4, this.myDeadCodeInfoType);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)quickFixFactory.createCreateGetterOrSetterFix(false, true, field), (HighlightDisplayKey)this.myDeadCodeKey);
                if (!field.hasModifierProperty("final")) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)field), (IntentionAction)quickFixFactory.createCreateConstructorParameterFromFieldFix(field), (HighlightDisplayKey)this.myDeadCodeKey);
                }
                SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)field, (Processor<? super String>)((Processor)annoName -> {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)quickFixFactory.createAddToImplicitlyWrittenFieldsFix(project, annoName), (HighlightDisplayKey)this.myDeadCodeKey);
                    return true;
                }));
                return info;
            }
        } else {
            if (UnusedSymbolUtil.isImplicitUsage(this.myProject, (PsiModifierListOwner)field) && !UnusedSymbolUtil.isImplicitWrite(this.myProject, (PsiVariable)field)) {
                return null;
            }
            if (UnusedSymbolUtil.isFieldUnused(this.myProject, this.myFile, field, progress, helper)) {
                if (UnusedSymbolUtil.isImplicitWrite(this.myProject, (PsiVariable)field)) {
                    String message5 = PostHighlightingVisitor.getNotUsedForReadingMessage(field, identifier);
                    HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message5, this.myDeadCodeInfoType);
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)field), (HighlightDisplayKey)this.myDeadCodeKey);
                    return highlightInfo;
                }
                return PostHighlightingVisitor.formatUnusedSymbolHighlightInfo(project, "field.is.not.used", (PsiNameIdentifierOwner)field, this.myDeadCodeKey, this.myDeadCodeInfoType, (PsiElement)identifier);
            }
        }
        return null;
    }

    @NotNull
    private static String getNotUsedForReadingMessage(@NotNull PsiField field, @NotNull PsiIdentifier identifier) {
        if (field == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(16);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(17);
        }
        String visibility = VisibilityUtil.getVisibilityStringToDisplay((PsiMember)field);
        String message2 = JavaErrorBundle.message("field.is.not.used.for.reading", visibility, identifier.getText());
        String string = StringUtil.capitalize((String)message2);
        if (string == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(18);
        }
        return string;
    }

    private HighlightInfo suggestionsToMakeFieldUsed(@NotNull PsiField field, @NotNull PsiIdentifier identifier, @NotNull String message2) {
        if (field == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(19);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(20);
        }
        if (message2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(21);
        }
        HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message2, this.myDeadCodeInfoType);
        SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)field, (Processor<? super String>)((Processor)annoName -> {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(field.getProject(), annoName), (HighlightDisplayKey)this.myDeadCodeKey);
            return true;
        }));
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)field), (HighlightDisplayKey)this.myDeadCodeKey);
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createCreateGetterOrSetterFix(true, false, field), (HighlightDisplayKey)this.myDeadCodeKey);
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createCreateGetterOrSetterFix(false, true, field), (HighlightDisplayKey)this.myDeadCodeKey);
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createCreateGetterOrSetterFix(true, true, field), (HighlightDisplayKey)this.myDeadCodeKey);
        return highlightInfo;
    }

    private boolean isOverriddenOrOverrides(@NotNull PsiMethod method) {
        if (method == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(22);
        }
        return this.isOverriddenOrOverrides.get(method);
    }

    @Nullable
    private HighlightInfo processParameter(@NotNull Project project, @NotNull PsiParameter parameter2, @NotNull PsiIdentifier identifier) {
        HighlightInfo highlightInfo;
        PsiElement declarationScope;
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(23);
        }
        if (parameter2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(24);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(25);
        }
        if ((declarationScope = parameter2.getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)declarationScope;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
                return null;
            }
            if ((method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static") || !method.hasModifierProperty("abstract") && !this.isOverriddenOrOverrides(method)) && !method.hasModifierProperty("native") && !JavaHighlightUtil.isSerializationRelatedMethod(method, method.getContainingClass()) && !PsiClassImplUtil.isMainOrPremainMethod(method)) {
                if (UnusedSymbolUtil.isInjected(project, (PsiModifierListOwner)method)) {
                    return null;
                }
                HighlightInfo highlightInfo2 = this.checkUnusedParameter(parameter2, identifier, method);
                if (highlightInfo2 != null) {
                    QuickFixFactory.getInstance().registerFixesForUnusedParameter(parameter2, (Object)highlightInfo2);
                    return highlightInfo2;
                }
            }
        } else if (declarationScope instanceof PsiForeachStatement && !PsiUtil.isIgnoredName((String)parameter2.getName())) {
            HighlightInfo highlightInfo3 = this.checkUnusedParameter(parameter2, identifier, null);
            if (highlightInfo3 != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo3, (IntentionAction)QuickFixFactory.getInstance().createRenameToIgnoredFix((PsiNamedElement)parameter2), (HighlightDisplayKey)this.myDeadCodeKey);
                return highlightInfo3;
            }
        } else if (parameter2 instanceof PsiPatternVariable && (highlightInfo = this.checkUnusedParameter(parameter2, identifier, null)) != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createDeleteFix((PsiElement)parameter2));
            return highlightInfo;
        }
        return null;
    }

    private HighlightInfo checkUnusedParameter(@NotNull PsiParameter parameter2, @NotNull PsiIdentifier identifier, @Nullable PsiMethod declarationMethod) {
        if (parameter2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(26);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(27);
        }
        if (!this.myRefCountHolder.isReferenced((PsiElement)parameter2) && !UnusedSymbolUtil.isImplicitUsage(this.myProject, (PsiModifierListOwner)parameter2)) {
            String message2 = JavaErrorBundle.message(parameter2 instanceof PsiPatternVariable ? "pattern.variable.is.not.used" : "parameter.is.not.used", identifier.getText());
            HighlightInfo info = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message2, this.myDeadCodeInfoType);
            if (declarationMethod != null && declarationMethod.isConstructor()) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QuickFixFactory.getInstance().createAssignFieldFromParameterFix());
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QuickFixFactory.getInstance().createCreateFieldFromParameterFix());
            }
            return info;
        }
        return null;
    }

    @Nullable
    private HighlightInfo processMethod(@NotNull Project project, @NotNull PsiMethod method, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(28);
        }
        if (method == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(29);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(30);
        }
        if (progress == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(31);
        }
        if (helper == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(32);
        }
        if (UnusedSymbolUtil.isMethodReferenced(this.myProject, this.myFile, method, progress, helper)) {
            return null;
        }
        String key2 = method.hasModifierProperty("private") ? (method.isConstructor() ? "private.constructor.is.not.used" : "private.method.is.not.used") : (method.isConstructor() ? "constructor.is.not.used" : "method.is.not.used");
        int options = 8194;
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)method, PsiSubstitutor.EMPTY, options);
        String message2 = JavaErrorBundle.message(key2, symbolName);
        HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message2, this.myDeadCodeInfoType);
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)method), (HighlightDisplayKey)this.myDeadCodeKey);
        SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)method, (Processor<? super String>)((Processor)annoName -> {
            IntentionAction fix = QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project, annoName);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)fix, (HighlightDisplayKey)this.myDeadCodeKey);
            return true;
        }));
        return highlightInfo;
    }

    @Nullable
    private HighlightInfo processClass(@NotNull Project project, @NotNull PsiClass aClass, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(33);
        }
        if (aClass == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(34);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(35);
        }
        if (progress == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(36);
        }
        if (helper == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(37);
        }
        if (UnusedSymbolUtil.isClassUsed(project, this.myFile, aClass, progress, helper)) {
            return null;
        }
        String pattern = aClass.getContainingClass() != null && aClass.hasModifierProperty("private") ? (aClass.isInterface() ? "private.inner.interface.is.not.used" : "private.inner.class.is.not.used") : (aClass.getParent() instanceof PsiDeclarationStatement ? "local.class.is.not.used" : (aClass instanceof PsiTypeParameter ? "type.parameter.is.not.used" : (aClass.isInterface() ? "interface.is.not.used" : (aClass.isEnum() ? "enum.is.not.used" : "class.is.not.used"))));
        return PostHighlightingVisitor.formatUnusedSymbolHighlightInfo(this.myProject, pattern, (PsiNameIdentifierOwner)aClass, this.myDeadCodeKey, this.myDeadCodeInfoType, (PsiElement)identifier);
    }

    private static HighlightInfo formatUnusedSymbolHighlightInfo(@NotNull Project project, @NotNull @PropertyKey(resourceBundle="messages.JavaErrorBundle") String pattern, @NotNull PsiNameIdentifierOwner aClass, HighlightDisplayKey highlightDisplayKey, @NotNull HighlightInfoType highlightInfoType, @NotNull PsiElement identifier) {
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(38);
        }
        if (pattern == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(39);
        }
        if (aClass == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(40);
        }
        if (highlightInfoType == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(41);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(42);
        }
        String symbolName = aClass.getName();
        String message2 = JavaErrorBundle.message(pattern, symbolName);
        HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message2, highlightInfoType);
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)aClass), (HighlightDisplayKey)highlightDisplayKey);
        SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)aClass, (Processor<? super String>)((Processor)annoName -> {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project, annoName), (HighlightDisplayKey)highlightDisplayKey);
            return true;
        }));
        return highlightInfo;
    }

    @Nullable
    private HighlightInfo processImport(@NotNull PsiImportStatementBase importStatement, @NotNull HighlightDisplayKey unusedImportKey) {
        if (importStatement == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(43);
        }
        if (unusedImportKey == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(44);
        }
        if (importStatement.isForeignFileImport()) {
            return null;
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)importStatement)) {
            return null;
        }
        boolean isRedundant = this.myRefCountHolder.isRedundant(importStatement);
        if (!isRedundant && !(importStatement instanceof PsiImportStaticStatement)) {
            String qName;
            PsiElement resolved;
            String packageName = ((PsiClassOwner)importStatement.getContainingFile()).getPackageName();
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            PsiElement psiElement = resolved = reference == null ? null : reference.resolve();
            if (resolved instanceof PsiPackage) {
                isRedundant = packageName.equals(((PsiQualifiedNamedElement)resolved).getQualifiedName());
            } else if (resolved instanceof PsiClass && !importStatement.isOnDemand() && (qName = ((PsiClass)resolved).getQualifiedName()) != null) {
                String name2 = ((PomNamedTarget)resolved).getName();
                isRedundant = qName.equals(packageName + '.' + name2);
            }
        }
        if (isRedundant) {
            return this.registerRedundantImport(importStatement, unusedImportKey);
        }
        int entryIndex = JavaCodeStyleManager.getInstance((Project)this.myProject).findEntryIndex(importStatement);
        if (entryIndex < this.myCurrentEntryIndex) {
            this.myHasMisSortedImports = true;
        }
        this.myCurrentEntryIndex = entryIndex;
        return null;
    }

    private HighlightInfo registerRedundantImport(@NotNull PsiImportStatementBase importStatement, @NotNull HighlightDisplayKey unusedImportKey) {
        VirtualFile file;
        if (importStatement == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(45);
        }
        if (unusedImportKey == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(46);
        }
        Set imports2 = (file = PsiUtilCore.getVirtualFile((PsiElement)this.myFile)) != null ? (Set)file.getCopyableUserData(ImportsHighlightUtil.IMPORTS_FROM_TEMPLATE) : null;
        boolean predefinedImport = imports2 != null && imports2.contains(importStatement.getText());
        String description = !predefinedImport ? JavaAnalysisBundle.message((String)"unused.import.statement", (Object[])new Object[0]) : "Unused import (specified in template)";
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)JavaHighlightInfoTypes.UNUSED_IMPORT).range((PsiElement)importStatement).descriptionAndTooltip(description).group(5).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QuickFixFactory.getInstance().createOptimizeImportsFix(false), (HighlightDisplayKey)unusedImportKey);
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QuickFixFactory.getInstance().createEnableOptimizeImportsOnTheFlyFix(), (HighlightDisplayKey)unusedImportKey);
        if (!predefinedImport) {
            this.myHasRedundantImports = true;
        }
        return info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refCountHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 30: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: 
            case 15: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 11: 
            case 23: 
            case 28: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedImportKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotUsedForReadingMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImportsOnTheFlyLater";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processIdentifier";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processLocalVariable";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processField";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNotUsedForReadingMessage";
                break;
            }
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "suggestionsToMakeFieldUsed";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isOverriddenOrOverrides";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processParameter";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkUnusedParameter";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processMethod";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processClass";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "formatUnusedSymbolHighlightInfo";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processImport";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "registerRedundantImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

