/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LambdaHighlightingUtil {
    private static final Logger LOG = Logger.getInstance(LambdaHighlightingUtil.class);

    public static String checkInterfaceFunctional(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(0);
        }
        return LambdaHighlightingUtil.checkInterfaceFunctional(psiClass, JavaErrorBundle.message("target.type.of.a.lambda.conversion.must.be.an.interface", new Object[0]));
    }

    static String checkInterfaceFunctional(@NotNull PsiClass psiClass, @NotNull @Nls String interfaceNonFunctionalMessage) {
        if (psiClass == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(1);
        }
        if (interfaceNonFunctionalMessage == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(2);
        }
        if (psiClass instanceof PsiTypeParameter) {
            return null;
        }
        List signatures = LambdaUtil.findFunctionCandidates((PsiClass)psiClass);
        if (signatures == null) {
            return interfaceNonFunctionalMessage;
        }
        if (signatures.isEmpty()) {
            return JavaErrorBundle.message("no.target.method.found", new Object[0]);
        }
        if (signatures.size() == 1) {
            return null;
        }
        return JavaErrorBundle.message("multiple.non.overriding.abstract.methods.found.in.interface.0", HighlightUtil.formatClass(psiClass));
    }

    static HighlightInfo checkParametersCompatible(@NotNull PsiLambdaExpression expression2, PsiParameter @NotNull [] methodParameters, @NotNull PsiSubstitutor substitutor) {
        PsiParameter[] lambdaParameters;
        if (expression2 == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(3);
        }
        if (substitutor == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(4);
        }
        if (methodParameters == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(5);
        }
        if ((lambdaParameters = expression2.getParameterList().getParameters()).length != methodParameters.length) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2.getParameterList()).descriptionAndTooltip(JavaErrorBundle.message("incompatible.parameter.types.in.lambda.wrong.number.of.parameters", methodParameters.length, lambdaParameters.length)).create();
        }
        boolean hasFormalParameterTypes = expression2.hasFormalParameterTypes();
        for (int i = 0; i < lambdaParameters.length; ++i) {
            PsiParameter lambdaParameter = lambdaParameters[i];
            PsiType lambdaParameterType = lambdaParameter.getType();
            PsiType substitutedParamType = substitutor.substitute(methodParameters[i].getType());
            if ((!hasFormalParameterTypes || PsiTypesUtil.compareTypes((PsiType)lambdaParameterType, (PsiType)substitutedParamType, (boolean)true)) && TypeConversionUtil.isAssignable((PsiType)substitutedParamType, (PsiType)lambdaParameterType)) continue;
            String expectedType = substitutedParamType != null ? substitutedParamType.getPresentableText() : null;
            String actualType = lambdaParameterType.getPresentableText();
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2.getParameterList()).descriptionAndTooltip(JavaErrorBundle.message("incompatible.parameter.types.in.lambda", expectedType, actualType)).create();
        }
        return null;
    }

    public static boolean insertSemicolonAfter(@NotNull PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(6);
        }
        return lambdaExpression.getBody() instanceof PsiCodeBlock || LambdaHighlightingUtil.insertSemicolon(lambdaExpression.getParent());
    }

    public static boolean insertSemicolon(PsiElement parent) {
        return !(parent instanceof PsiExpressionList) && !(parent instanceof PsiExpression);
    }

    public static String checkInterfaceFunctional(@NotNull PsiType functionalInterfaceType) {
        if (functionalInterfaceType == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(7);
        }
        if (functionalInterfaceType instanceof PsiIntersectionType) {
            HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
            for (PsiType type2 : ((PsiIntersectionType)functionalInterfaceType).getConjuncts()) {
                if (LambdaHighlightingUtil.checkInterfaceFunctional(type2) != null) continue;
                MethodSignature signature = LambdaUtil.getFunction((PsiClass)PsiUtil.resolveClassInType((PsiType)type2));
                LOG.assertTrue(signature != null, (Object)type2.getCanonicalText());
                signatures.add(signature);
            }
            if (signatures.size() > 1) {
                return JavaErrorBundle.message("multiple.non.overriding.abstract.methods.found.in.0", functionalInterfaceType.getPresentableText());
            }
            return null;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiClass aClass = resolveResult.getElement();
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                return null;
            }
            MethodSignature functionalMethod = LambdaUtil.getFunction((PsiClass)aClass);
            if (functionalMethod != null && functionalMethod.getTypeParameters().length > 0) {
                return JavaErrorBundle.message("target.method.is.generic", new Object[0]);
            }
            return LambdaHighlightingUtil.checkInterfaceFunctional(aClass);
        }
        return JavaErrorBundle.message("not.a.functional.interface", functionalInterfaceType.getPresentableText());
    }

    static HighlightInfo checkConsistentParameterDeclaration(@NotNull PsiLambdaExpression expression2) {
        PsiParameter[] parameters2;
        if (expression2 == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(8);
        }
        if ((parameters2 = expression2.getParameterList().getParameters()).length < 2) {
            return null;
        }
        boolean hasExplicitParameterTypes = LambdaHighlightingUtil.hasExplicitType(parameters2[0]);
        for (int i = 1; i < parameters2.length; ++i) {
            if (hasExplicitParameterTypes == LambdaHighlightingUtil.hasExplicitType(parameters2[i])) continue;
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(JavaErrorBundle.message("lambda.parameters.consistency.message", new Object[0])).range((PsiElement)expression2.getParameterList()).create();
        }
        return null;
    }

    private static boolean hasExplicitType(@NotNull PsiParameter parameter2) {
        PsiTypeElement typeElement;
        if (parameter2 == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(9);
        }
        return (typeElement = parameter2.getTypeElement()) != null && !typeElement.isInferredType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceNonFunctionalMessage";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodParameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionalInterfaceType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/LambdaHighlightingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInterfaceFunctional";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParametersCompatible";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "insertSemicolonAfter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConsistentParameterDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hasExplicitType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

