/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddFinallyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.core.JavaPsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTryStatement;
import org.jetbrains.annotations.NotNull;

public class JavaErrorQuickFixProvider
implements ErrorQuickFixProvider {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    public void registerErrorQuickFix(@NotNull PsiErrorElement errorElement, @NotNull HighlightInfo highlightInfo) {
        PsiElement child;
        PsiElement parent;
        if (errorElement == null) {
            JavaErrorQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (highlightInfo == null) {
            JavaErrorQuickFixProvider.$$$reportNull$$$0(1);
        }
        if ((parent = errorElement.getParent()) instanceof PsiTryStatement && errorElement.getErrorDescription().equals(JavaPsiBundle.message((String)"expected.catch.or.finally", (Object[])new Object[0]))) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new AddExceptionToCatchFix(false));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new AddFinallyFix((PsiTryStatement)parent));
        }
        if (parent instanceof PsiSwitchLabeledRuleStatement && errorElement.getErrorDescription().equals(JavaPsiBundle.message((String)"expected.switch.rule", (Object[])new Object[0]))) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createWrapSwitchRuleStatementsIntoBlockFix((PsiSwitchLabeledRuleStatement)parent));
        }
        if (parent instanceof PsiJavaFile && errorElement.getErrorDescription().equals(JavaPsiBundle.message((String)"expected.class.or.interface", (Object[])new Object[0])) && (child = errorElement.getFirstChild()) instanceof PsiIdentifier) {
            HighlightingFeature feature;
            switch (child.getText()) {
                case "record": {
                    feature = HighlightingFeature.RECORDS;
                    break;
                }
                case "sealed": {
                    feature = HighlightingFeature.SEALED_CLASSES;
                    break;
                }
                default: {
                    feature = null;
                }
            }
            if (feature != null) {
                HighlightUtil.registerIncreaseLanguageLevelFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(highlightInfo), (PsiElement)errorElement, feature);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "errorElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "highlightInfo";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaErrorQuickFixProvider";
        objectArray[2] = "registerErrorQuickFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

