/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceAssignmentFromVoidWithStatementIntentionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceGetClassWithClassLiteralFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.PriorityIntentionActionWrapper;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.lang.jvm.util.JvmUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiJvmModifiersOwner;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.SwitchUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightFixUtil {
    private static final Logger LOG = Logger.getInstance(HighlightFixUtil.class);
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final CallMatcher COLLECTION_TO_ARRAY = CallMatcher.instanceCall("java.util.Collection", "toArray").parameterCount(0);

    static void registerCollectionToArrayFixAction(@Nullable HighlightInfo info, @Nullable PsiType fromType, @Nullable PsiType toType, @NotNull PsiExpression expression2) {
        PsiType arrayComponentType;
        if (expression2 == null) {
            HighlightFixUtil.$$$reportNull$$$0(0);
        }
        if (toType instanceof PsiArrayType && !((arrayComponentType = ((PsiArrayType)toType).getComponentType()) instanceof PsiPrimitiveType) && !(PsiUtil.resolveClassInType((PsiType)arrayComponentType) instanceof PsiTypeParameter)) {
            PsiType collectionItemType;
            PsiMethodCallExpression call;
            PsiExpression collection = expression2;
            if (expression2 instanceof PsiMethodCallExpression && COLLECTION_TO_ARRAY.test(call = (PsiMethodCallExpression)expression2)) {
                collection = call.getMethodExpression().getQualifierExpression();
                if (collection == null) {
                    return;
                }
                fromType = collection.getType();
            }
            if (fromType instanceof PsiClassType && ("java.lang.Object".equals(arrayComponentType.getCanonicalText()) || !((PsiClassType)fromType).isRaw()) && InheritanceUtil.isInheritor((PsiType)fromType, (String)"java.util.Collection") && (collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)fromType, (GlobalSearchScope)expression2.getResolveScope())) != null && arrayComponentType.isConvertibleFrom(collectionItemType)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createCollectionToArrayFix(collection, expression2, (PsiArrayType)toType));
            }
        }
    }

    static void registerAccessQuickFixAction(@NotNull PsiJvmMember refElement, @NotNull PsiJavaCodeReferenceElement place, @Nullable HighlightInfo errorResult, PsiElement fileResolveScope) {
        if (refElement == null) {
            HighlightFixUtil.$$$reportNull$$$0(1);
        }
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(2);
        }
        if (errorResult == null) {
            return;
        }
        PsiClass accessObjectClass = null;
        PsiElement qualifier = place.getQualifier();
        if (qualifier instanceof PsiExpression) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)((PsiExpression)qualifier)).getElement();
        }
        HighlightFixUtil.registerReplaceInaccessibleFieldWithGetterSetterFix((PsiMember)refElement, place, accessObjectClass, errorResult);
        if (refElement instanceof PsiCompiledElement) {
            return;
        }
        PsiModifierList modifierList = refElement.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiClass packageLocalClassInTheMiddle = HighlightFixUtil.getPackageLocalClassInTheMiddle((PsiElement)place);
        if (packageLocalClassInTheMiddle != null) {
            List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)packageLocalClassInTheMiddle, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.PUBLIC, (boolean)true));
            QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)fixes);
            return;
        }
        try {
            PsiClass containingClass;
            Project project = refElement.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiModifierList modifierListCopy = facade.getElementFactory().createFieldFromText("int a;", null).getModifierList();
            assert (modifierListCopy != null);
            modifierListCopy.setModifierProperty("static", modifierList.hasModifierProperty("static"));
            int minAccessLevel = 2;
            if (refElement.hasModifierProperty("packageLocal")) {
                minAccessLevel = 3;
            }
            if (refElement.hasModifierProperty("protected")) {
                minAccessLevel = 4;
            }
            if ((containingClass = refElement.getContainingClass()) != null && containingClass.isInterface()) {
                minAccessLevel = 4;
            }
            int[] accessLevels = new int[]{2, 3, 4};
            for (int i = ArrayUtil.indexOf((int[])accessLevels, (int)minAccessLevel); i < accessLevels.length; ++i) {
                int level = accessLevels[i];
                modifierListCopy.setModifierProperty(PsiUtil.getAccessModifier((int)level), true);
                if (!facade.getResolveHelper().isAccessible((PsiMember)refElement, modifierListCopy, (PsiElement)place, accessObjectClass, fileResolveScope)) continue;
                List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)refElement, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmUtil.getAccessModifier((int)level), (boolean)true));
                TextRange fixRange = new TextRange(errorResult.startOffset, errorResult.endOffset);
                PsiElement ref = place.getReferenceNameElement();
                if (ref != null) {
                    fixRange = fixRange.union(ref.getTextRange());
                }
                QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, (TextRange)fixRange, (Iterable)fixes);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    static PsiClass getPackageLocalClassInTheMiddle(@NotNull PsiElement place) {
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(3);
        }
        if (place instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression2 = (PsiReferenceExpression)place;
            while (true) {
                PsiField field;
                PsiClass aClass;
                PsiElement resolved;
                if ((resolved = expression2.resolve()) instanceof PsiField && (aClass = (field = (PsiField)resolved).getContainingClass()) != null && aClass.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, place)) {
                    return aClass;
                }
                PsiExpression qualifier = expression2.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) break;
                expression2 = (PsiReferenceExpression)qualifier;
            }
        }
        return null;
    }

    static void registerChangeVariableTypeFixes(@NotNull PsiExpression expression2, @NotNull PsiType type2, @Nullable PsiExpression lExpr, @Nullable HighlightInfo highlightInfo) {
        PsiMethod method;
        PsiElement parent;
        if (expression2 == null) {
            HighlightFixUtil.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            HighlightFixUtil.$$$reportNull$$$0(5);
        }
        if (highlightInfo == null || !(expression2 instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement element = ((PsiReferenceExpression)expression2).resolve();
        if (!(element instanceof PsiVariable)) {
            return;
        }
        HighlightFixUtil.registerChangeVariableTypeFixes((PsiVariable)element, type2, lExpr, highlightInfo);
        if (lExpr instanceof PsiMethodCallExpression && lExpr.getParent() instanceof PsiAssignmentExpression && (parent = lExpr.getParent()).getParent() instanceof PsiStatement && (method = ((PsiMethodCallExpression)lExpr).resolveMethod()) != null && PsiType.VOID.equals((Object)method.getReturnType())) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new ReplaceAssignmentFromVoidWithStatementIntentionAction(parent, lExpr));
        }
    }

    static void registerUnhandledExceptionFixes(PsiElement element, HighlightInfo errorResult) {
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddExceptionToCatchFix());
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddExceptionToThrowsFix(element));
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddExceptionFromFieldInitializerToConstructorThrowsFix(element));
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createSurroundWithTryCatchFix(element));
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddExceptionToExistingCatch(element));
    }

    static void registerStaticProblemQuickFixAction(@NotNull PsiElement refElement, HighlightInfo errorResult, @NotNull PsiJavaCodeReferenceElement place) {
        PsiModifierListOwner staticParent;
        if (refElement == null) {
            HighlightFixUtil.$$$reportNull$$$0(6);
        }
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(7);
        }
        if (refElement instanceof PsiJvmModifiersOwner) {
            List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((PsiJvmModifiersOwner)refElement), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)true));
            QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)fixes);
        }
        if ((staticParent = PsiUtil.getEnclosingStaticElement((PsiElement)place, null)) != null && HighlightFixUtil.isInstanceReference(place)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false));
        }
        if (place instanceof PsiReferenceExpression && refElement instanceof PsiField) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createCreateFieldFromUsageFix((PsiReferenceExpression)place));
        }
        if (place instanceof PsiReferenceExpression && place.getParent() instanceof PsiMethodCallExpression) {
            ReplaceGetClassWithClassLiteralFix.registerFix((PsiMethodCallExpression)place.getParent(), errorResult);
        }
    }

    private static boolean isInstanceReference(@NotNull PsiJavaCodeReferenceElement place) {
        PsiElement qualifier;
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(8);
        }
        if ((qualifier = place.getQualifier()) == null) {
            return true;
        }
        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement q = ((PsiReference)qualifier).resolve();
        if (q instanceof PsiClass) {
            return false;
        }
        if (q != null) {
            return true;
        }
        String qname = ((PsiJavaCodeReferenceElement)qualifier).getQualifiedName();
        return qname == null || !Character.isLowerCase(qname.charAt(0));
    }

    static void registerChangeVariableTypeFixes(@NotNull PsiVariable parameter2, PsiType itemType, @Nullable PsiExpression expr2, @Nullable HighlightInfo highlightInfo) {
        if (parameter2 == null) {
            HighlightFixUtil.$$$reportNull$$$0(9);
        }
        for (IntentionAction action : HighlightFixUtil.getChangeVariableTypeFixes(parameter2, itemType)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)action);
        }
        HighlightFixUtil.registerChangeReturnTypeFix(highlightInfo, expr2, parameter2.getType());
    }

    static void registerChangeReturnTypeFix(@Nullable HighlightInfo highlightInfo, @Nullable PsiExpression expr2, @NotNull PsiType toType) {
        PsiMethod method;
        if (toType == null) {
            HighlightFixUtil.$$$reportNull$$$0(10);
        }
        if (expr2 instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr2).resolveMethod()) != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)PriorityIntentionActionWrapper.lowPriority((IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, toType, true)));
        }
    }

    @NotNull
    public static List<IntentionAction> getChangeVariableTypeFixes(@NotNull PsiVariable variable, PsiType itemType) {
        PsiClassType boxedType;
        PsiType componentType;
        PsiType type2;
        if (variable == null) {
            HighlightFixUtil.$$$reportNull$$$0(11);
        }
        if (itemType instanceof PsiMethodReferenceType) {
            List<IntentionAction> list = Collections.emptyList();
            if (list == null) {
                HighlightFixUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        if (itemType != null && PsiTypesUtil.allTypeParametersResolved((PsiElement)variable, (PsiType)itemType)) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : ChangeVariableTypeQuickFixProvider.EP_NAME.getExtensionList()) {
                Collections.addAll(result, fixProvider.getFixes(variable, itemType));
            }
            IntentionAction changeFix = HighlightFixUtil.getChangeParameterClassFix(variable.getType(), itemType);
            if (changeFix != null) {
                result.add(changeFix);
            }
        } else if (itemType instanceof PsiArrayType && (type2 = variable.getType()) instanceof PsiArrayType && type2.getArrayDimensions() == itemType.getArrayDimensions() && (componentType = type2.getDeepComponentType()) instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)componentType).getBoxedType((PsiElement)variable)) != null) {
            return HighlightFixUtil.getChangeVariableTypeFixes(variable, PsiTypesUtil.createArrayType((PsiType)boxedType, (int)type2.getArrayDimensions()));
        }
        ArrayList<IntentionAction> arrayList = result;
        if (arrayList == null) {
            HighlightFixUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    static IntentionAction getChangeParameterClassFix(PsiType lType, PsiType rType) {
        PsiClass lClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)lType);
        PsiClass rClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)rType);
        if (rClass == null || lClass == null) {
            return null;
        }
        if (rClass instanceof PsiAnonymousClass) {
            return null;
        }
        if (rClass.isInheritor(lClass, true)) {
            return null;
        }
        if (lClass.isInheritor(rClass, true)) {
            return null;
        }
        if (lClass == rClass) {
            return null;
        }
        return QUICK_FIX_FACTORY.createChangeParameterClassFix(rClass, (PsiClassType)lType);
    }

    private static void registerReplaceInaccessibleFieldWithGetterSetterFix(PsiMember refElement, PsiJavaCodeReferenceElement place, PsiClass accessObjectClass, HighlightInfo error) {
        PsiField psiField;
        PsiClass containingClass;
        if (refElement instanceof PsiField && place instanceof PsiReferenceExpression && (containingClass = (psiField = (PsiField)refElement).getContainingClass()) != null) {
            PsiMethod getterPrototype;
            PsiMethod getter;
            if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)place))) {
                PsiElement element;
                PsiMethod setterPrototype = PropertyUtilBase.generateSetterPrototype((PsiField)psiField);
                PsiMethod setter = containingClass.findMethodBySignature(setterPrototype, true);
                if (setter != null && PsiUtil.isAccessible((PsiMember)setter, (PsiElement)place, (PsiClass)accessObjectClass) && (element = PsiTreeUtil.skipParentsOfType((PsiElement)place, (Class[])new Class[]{PsiParenthesizedExpression.class})) instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)element).getOperationTokenType() == JavaTokenType.EQ) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)error, (IntentionAction)QUICK_FIX_FACTORY.createReplaceInaccessibleFieldWithGetterSetterFix((PsiElement)place, setter, true));
                }
            } else if (PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)place)) && (getter = containingClass.findMethodBySignature(getterPrototype = PropertyUtilBase.generateGetterPrototype((PsiField)psiField), true)) != null && PsiUtil.isAccessible((PsiMember)getter, (PsiElement)place, (PsiClass)accessObjectClass)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)error, (IntentionAction)QUICK_FIX_FACTORY.createReplaceInaccessibleFieldWithGetterSetterFix((PsiElement)place, getter, false));
            }
        }
    }

    static void registerLambdaReturnTypeFixes(HighlightInfo info, PsiLambdaExpression lambda2, PsiExpression expression2) {
        PsiType type2 = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2);
        if (type2 != null) {
            PsiType exprType = expression2.getType();
            if (exprType != null && TypeConversionUtil.areTypesConvertible((PsiType)exprType, (PsiType)type2)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddTypeCastFix(type2, expression2));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createWrapWithOptionalFix(type2, expression2));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createWrapExpressionFix(type2, expression2));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createWrapWithAdapterFix(type2, expression2));
        }
    }

    static void registerChangeParameterClassFix(PsiType lType, PsiType rType, HighlightInfo info) {
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightFixUtil.getChangeParameterClassFix(lType, rType));
    }

    static PsiSwitchStatement findInitializingSwitch(@NotNull PsiVariable variable, @NotNull PsiElement topBlock, @NotNull PsiElement readPoint) {
        ControlFlow controlFlow;
        if (variable == null) {
            HighlightFixUtil.$$$reportNull$$$0(14);
        }
        if (topBlock == null) {
            HighlightFixUtil.$$$reportNull$$$0(15);
        }
        if (readPoint == null) {
            HighlightFixUtil.$$$reportNull$$$0(16);
        }
        PsiSwitchStatement switchForAll = null;
        for (PsiReferenceExpression reference : VariableAccessUtils.getVariableReferences(variable, topBlock)) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)reference)) continue;
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiSwitchStatement.class);
            if (switchStatement == null || !PsiTreeUtil.isAncestor((PsiElement)topBlock, (PsiElement)switchStatement, (boolean)true)) {
                return null;
            }
            if (switchForAll != null) {
                if (switchForAll == switchStatement) continue;
                return null;
            }
            switchForAll = switchStatement;
        }
        if (switchForAll == null) {
            return null;
        }
        if (SwitchUtils.calculateBranchCount(switchForAll) < 0) {
            return null;
        }
        List labels2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)switchForAll.getBody(), PsiSwitchLabelStatementBase.class);
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        try {
            controlFlow = ControlFlowFactory.getInstance(topBlock.getProject()).getControlFlow(topBlock, policy);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        int switchOffset = controlFlow.getStartOffset((PsiElement)switchForAll);
        int readOffset = controlFlow.getStartOffset(readPoint);
        if (switchOffset == -1 || readOffset == -1 || !ControlFlowUtil.isDominator(controlFlow, switchOffset, readOffset)) {
            return null;
        }
        boolean[] offsets = ControlFlowUtil.getVariablePossiblyUnassignedOffsets(variable, controlFlow);
        for (PsiSwitchLabelStatementBase label : labels2) {
            int offset = controlFlow.getStartOffset((PsiElement)label);
            if (offset != -1 && !offsets[offset]) continue;
            return null;
        }
        return switchForAll;
    }

    @Nullable
    static IntentionAction createInsertSwitchDefaultFix(@NotNull PsiVariable variable, @NotNull PsiElement topBlock, @NotNull PsiElement readPoint) {
        PsiSwitchStatement switchStatement;
        if (variable == null) {
            HighlightFixUtil.$$$reportNull$$$0(17);
        }
        if (topBlock == null) {
            HighlightFixUtil.$$$reportNull$$$0(18);
        }
        if (readPoint == null) {
            HighlightFixUtil.$$$reportNull$$$0(19);
        }
        if ((switchStatement = HighlightFixUtil.findInitializingSwitch(variable, topBlock, readPoint)) != null) {
            String message2 = QuickFixBundle.message("add.default.branch.to.variable.initializing.switch.fix.name", variable.getName());
            return QUICK_FIX_FACTORY.createAddSwitchDefaultFix((PsiSwitchBlock)switchStatement, message2);
        }
        return null;
    }

    static void registerMakeNotFinalAction(@NotNull PsiVariable var, @Nullable HighlightInfo highlightInfo) {
        if (var == null) {
            HighlightFixUtil.$$$reportNull$$$0(20);
        }
        if (var instanceof PsiField) {
            QuickFixAction.registerQuickFixActions((HighlightInfo)highlightInfo, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((PsiField)var), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)false)));
        } else {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)var, "final", false, false));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixUtil";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topBlock";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readPoint";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixUtil";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeVariableTypeFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerCollectionToArrayFixAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerAccessQuickFixAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageLocalClassInTheMiddle";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeVariableTypeFixes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerStaticProblemQuickFixAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceReference";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeReturnTypeFix";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChangeVariableTypeFixes";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findInitializingSwitch";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createInsertSwitchDefaultFix";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerMakeNotFinalAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

