/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.generation.GenerateEqualsHandler;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.OverrideMethodsHandler;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.TemplateGenerationInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.SmartList;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.CharArrayUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.GenerateToStringActionHandlerImpl;
import org.jetbrains.java.generate.exception.GenerateCodeException;

public class JavaGenerateMemberCompletionContributor {
    static final Key<Boolean> GENERATE_ELEMENT = Key.create((String)"GENERATE_ELEMENT");

    public static void fillCompletionVariants(CompletionParameters parameters2, CompletionResultSet result) {
        if (parameters2.getCompletionType() != CompletionType.BASIC && parameters2.getCompletionType() != CompletionType.SMART) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        if (DumbService.getInstance((Project)position.getProject()).isDumb()) {
            return;
        }
        if (((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiIdentifier.class).withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiTypeElement.class, PsiClass.class})).andNot(JavaKeywordCompletion.AFTER_DOT)).accepts((Object)position)) {
            PsiElement prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
            PsiModifierList modifierList = (PsiModifierList)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, PsiModifierList.class);
            if (modifierList != null) {
                String fileText = position.getContainingFile().getText();
                result = result.withPrefixMatcher((PrefixMatcher)new NoMiddleMatchesAfterSpace(fileText.substring(modifierList.getTextRange().getStartOffset(), parameters2.getOffset())));
            }
            JavaGenerateMemberCompletionContributor.suggestGeneratedMethods(result, position, modifierList);
        } else if (JavaGenerateMemberCompletionContributor.isTypingAnnotationForNewMember(position)) {
            PsiAnnotation annotation = Objects.requireNonNull((PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class));
            int annoStart = annotation.getTextRange().getStartOffset();
            result.addElement((LookupElement)JavaGenerateMemberCompletionContributor.itemWithOverrideImplementDialog(annoStart));
            JavaGenerateMemberCompletionContributor.suggestGeneratedMethods(result.withPrefixMatcher((PrefixMatcher)new NoMiddleMatchesAfterSpace(annotation.getText().substring(0, parameters2.getOffset() - annoStart))), position, (PsiModifierList)annotation.getParent());
        }
    }

    private static boolean isTypingAnnotationForNewMember(PsiElement position) {
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiIdentifier.class).withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class, PsiModifierList.class})).accepts((Object)position)) {
            PsiElement parent = Objects.requireNonNull((PsiModifierList)PsiTreeUtil.getParentOfType((PsiElement)position, PsiModifierList.class)).getParent();
            if (parent instanceof PsiClass) {
                return true;
            }
            if (parent instanceof PsiMethod || parent instanceof PsiField) {
                PsiAnnotation anno = Objects.requireNonNull((PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class));
                return anno.getTextRange().getStartOffset() == parent.getTextRange().getStartOffset() && JavaGenerateMemberCompletionContributor.isFollowedByEol(anno);
            }
        }
        return false;
    }

    private static boolean isFollowedByEol(PsiAnnotation anno) {
        CharSequence fileText = anno.getContainingFile().getViewProvider().getContents();
        int afterAnno = CharArrayUtil.shiftForward((CharSequence)fileText, (int)anno.getTextRange().getEndOffset(), (String)" \t");
        return fileText.length() > afterAnno && fileText.charAt(afterAnno) == '\n';
    }

    @NotNull
    private static LookupElementBuilder itemWithOverrideImplementDialog(int annoStart) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)"Override/Implement methods...").withInsertHandler((context, item) -> {
            context.getDocument().deleteString(annoStart, context.getTailOffset());
            context.commitDocument();
            context.setAddCompletionChar(false);
            context.setLaterRunnable(() -> new OverrideMethodsHandler().invoke(context.getProject(), context.getEditor(), context.getFile()));
        });
        if (lookupElementBuilder == null) {
            JavaGenerateMemberCompletionContributor.$$$reportNull$$$0(0);
        }
        return lookupElementBuilder;
    }

    private static void suggestGeneratedMethods(CompletionResultSet result, PsiElement position, @Nullable PsiModifierList modifierList) {
        PsiClass parent = (PsiClass)CompletionUtil.getOriginalElement((PsiElement)Objects.requireNonNull((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiClass.class)));
        if (parent != null) {
            HashSet addedSignatures = new HashSet();
            JavaGenerateMemberCompletionContributor.addGetterSetterElements(result, parent, addedSignatures);
            boolean generateDefaultMethods = modifierList != null && modifierList.hasModifierProperty("default");
            JavaGenerateMemberCompletionContributor.addSuperSignatureElements(parent, true, result, addedSignatures, generateDefaultMethods);
            JavaGenerateMemberCompletionContributor.addSuperSignatureElements(parent, false, result, addedSignatures, generateDefaultMethods);
        }
    }

    private static void addGetterSetterElements(CompletionResultSet result, PsiClass parent, Set<? super MethodSignature> addedSignatures) {
        int count = 0;
        for (PsiField field : parent.getFields()) {
            if (JavaGenerateMemberCompletionContributor.isConstant(field)) continue;
            SmartList prototypes = new SmartList();
            try {
                Collections.addAll(prototypes, GetterSetterPrototypeProvider.generateGetterSetters(field, true, false));
                if (!field.hasModifierProperty("final")) {
                    Collections.addAll(prototypes, GetterSetterPrototypeProvider.generateGetterSetters(field, false, false));
                }
            }
            catch (GenerateCodeException generateCodeException) {
                // empty catch block
            }
            for (final PsiMethod prototype : prototypes) {
                PsiMethod existingMethod = parent.findMethodBySignature(prototype, false);
                if (existingMethod != null && !(existingMethod instanceof SyntheticElement) || !addedSignatures.add((MethodSignature)prototype.getSignature(PsiSubstitutor.EMPTY))) continue;
                Icon icon = prototype.getIcon(1);
                result.addElement(JavaGenerateMemberCompletionContributor.createGenerateMethodElement(prototype, PsiSubstitutor.EMPTY, icon, "", new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                        if (context == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        JavaGenerateMemberCompletionContributor.removeLookupString(context);
                        JavaGenerateMemberCompletionContributor.insertGenerationInfos(context, Collections.singletonList(new PsiGenerationInfo<PsiMethod>(prototype)));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/codeInsight/completion/JavaGenerateMemberCompletionContributor$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, false, parent));
                if (count++ <= 100) continue;
                return;
            }
        }
    }

    private static boolean isConstant(PsiField field) {
        return field.hasModifierProperty("final") && field.hasModifierProperty("public") && field.hasModifierProperty("static");
    }

    private static void removeLookupString(InsertionContext context) {
        context.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
        context.commitDocument();
    }

    private static void addSuperSignatureElements(PsiClass parent, boolean implemented, CompletionResultSet result, Set<? super MethodSignature> addedSignatures, boolean generateDefaultMethods) {
        for (CandidateInfo candidate : OverrideImplementExploreUtil.getMethodsToOverrideImplement(parent, implemented)) {
            PsiMethod baseMethod = (PsiMethod)candidate.getElement();
            PsiClass baseClass = baseMethod.getContainingClass();
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            if (baseMethod.isConstructor() || baseClass == null || !addedSignatures.add((MethodSignature)baseMethod.getSignature(substitutor))) continue;
            result.addElement(JavaGenerateMemberCompletionContributor.createOverridingLookupElement(implemented, baseMethod, baseClass, substitutor, generateDefaultMethods, parent));
        }
    }

    private static LookupElement createOverridingLookupElement(boolean implemented, final PsiMethod baseMethod, PsiClass baseClass, PsiSubstitutor substitutor, final boolean generateDefaultMethods, PsiClass targetClass) {
        RowIcon icon = IconManager.getInstance().createRowIcon(new Icon[]{baseMethod.getIcon(0), implemented ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod});
        return JavaGenerateMemberCompletionContributor.createGenerateMethodElement(baseMethod, substitutor, (Icon)icon, baseClass.getName(), new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    2.$$$reportNull$$$0(1);
                }
                JavaGenerateMemberCompletionContributor.removeLookupString(context);
                PsiClass parent = (PsiClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiClass.class, (boolean)false);
                if (parent == null) {
                    return;
                }
                if (GenerateEqualsHandler.hasNonStaticFields(parent) && this.generateByWizards(context)) {
                    return;
                }
                try (AccessToken ignored = generateDefaultMethods ? JavaGenerateMemberCompletionContributor.forceDefaultMethodsInside() : AccessToken.EMPTY_ACCESS_TOKEN;){
                    List<PsiMethod> prototypes = OverrideImplementUtil.overrideOrImplementMethod(parent, baseMethod, false);
                    JavaGenerateMemberCompletionContributor.insertGenerationInfos(context, OverrideImplementUtil.convert2GenerationInfos(prototypes));
                }
            }

            private boolean generateByWizards(@NotNull InsertionContext context) {
                if (context == null) {
                    2.$$$reportNull$$$0(2);
                }
                PsiFile file = context.getFile();
                if (MethodUtils.isEquals(baseMethod) || MethodUtils.isHashCode(baseMethod)) {
                    context.setAddCompletionChar(false);
                    context.setLaterRunnable(() -> new GenerateEqualsHandler().invoke(context.getProject(), context.getEditor(), file));
                    return true;
                }
                if (MethodUtils.isToString(baseMethod)) {
                    context.setAddCompletionChar(false);
                    context.setLaterRunnable(() -> new GenerateToStringActionHandlerImpl().invoke(context.getProject(), context.getEditor(), file));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaGenerateMemberCompletionContributor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleInsert";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "generateByWizards";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, generateDefaultMethods, targetClass);
    }

    private static AccessToken forceDefaultMethodsInside() {
        final CommandProcessor instance = CommandProcessor.getInstance();
        final String commandName = instance.getCurrentCommandName();
        instance.setCurrentCommandName("implement");
        return new AccessToken(){

            public void finish() {
                instance.setCurrentCommandName(commandName);
            }
        };
    }

    private static void insertGenerationInfos(InsertionContext context, List<PsiGenerationInfo<PsiMethod>> infos) {
        List<PsiGenerationInfo<PsiMethod>> newInfos = GenerateMembersUtil.insertMembersAtOffset(context.getFile(), context.getStartOffset(), infos);
        if (!newInfos.isEmpty()) {
            ArrayList elements = new ArrayList();
            for (GenerationInfo generationInfo : newInfos) {
                if (generationInfo instanceof TemplateGenerationInfo) continue;
                ContainerUtil.addIfNotNull(elements, (Object)generationInfo.getPsiMember());
            }
            newInfos.get(0).positionCaret(context.getEditor(), true);
            GlobalInspectionContextBase.cleanupElements((Project)context.getProject(), null, (PsiElement[])elements.toArray(PsiElement.EMPTY_ARRAY));
        }
    }

    private static LookupElement createGenerateMethodElement(PsiMethod prototype, PsiSubstitutor substitutor, Icon icon, String typeText, InsertHandler<LookupElement> insertHandler, boolean generateDefaultMethod, PsiClass targetClass) {
        String modifiers;
        String methodName = prototype.getName();
        String visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)prototype.getModifierList());
        String string = modifiers = visibility == "packageLocal" || visibility == "public" && targetClass.isInterface() ? "" : visibility + " ";
        if (generateDefaultMethod) {
            modifiers = "default " + modifiers;
        }
        PsiType type2 = substitutor.substitute(prototype.getReturnType());
        String signature = modifiers + (type2 == null ? "" : type2.getPresentableText() + " ") + methodName;
        String parameters2 = "(" + StringUtil.join((Object[])prototype.getParameterList().getParameters(), p -> JavaGenerateMemberCompletionContributor.getShortParameterName(substitutor, p) + " " + p.getName(), (String)", ") + ")";
        String overrideSignature = " @Override " + signature;
        LookupElementBuilder element = LookupElementBuilder.create((Object)prototype, (String)signature).withLookupString(methodName).withLookupString(signature).withLookupString(overrideSignature).withInsertHandler(insertHandler).appendTailText(parameters2, false).appendTailText(" {...}", true).withTypeText(typeText).withIcon(icon);
        if (prototype.isDeprecated()) {
            element = element.withStrikeoutness(true);
        }
        element.putUserData(GENERATE_ELEMENT, (Object)true);
        return PrioritizedLookupElement.withPriority((LookupElement)element, (double)-1.0);
    }

    @NotNull
    private static String getShortParameterName(PsiSubstitutor substitutor, PsiParameter p) {
        String string = PsiNameHelper.getShortClassName((String)substitutor.substitute(p.getType()).getPresentableText(false));
        if (string == null) {
            JavaGenerateMemberCompletionContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/completion/JavaGenerateMemberCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "itemWithOverrideImplementDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortParameterName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NoMiddleMatchesAfterSpace
    extends CamelHumpMatcher {
        NoMiddleMatchesAfterSpace(String prefix) {
            super(prefix);
        }

        public boolean prefixMatches(@NotNull LookupElement element) {
            if (element == null) {
                NoMiddleMatchesAfterSpace.$$$reportNull$$$0(0);
            }
            if (!super.prefixMatches(element)) {
                return false;
            }
            if (!this.myPrefix.contains(" ")) {
                return true;
            }
            String signature = element.getLookupString();
            FList fragments = this.matchingFragments(signature);
            return fragments == null || fragments.stream().noneMatch(f -> NoMiddleMatchesAfterSpace.isMiddleMatch(signature, f));
        }

        private static boolean isMiddleMatch(String signature, TextRange fragment) {
            int start = fragment.getStartOffset();
            return start > 0 && Character.isJavaIdentifierPart(signature.charAt(start)) && Character.isJavaIdentifierPart(signature.charAt(start - 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaGenerateMemberCompletionContributor$NoMiddleMatchesAfterSpace", "prefixMatches"));
        }
    }
}

