/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.ArrayMemberAccess;
import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CatchTypeProvider;
import com.intellij.codeInsight.completion.CheckInitialized;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.ExcludeFilter;
import com.intellij.codeInsight.completion.ExpectedAnnotationsProvider;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.InstanceofTypeProvider;
import com.intellij.codeInsight.completion.InternalCompletionSettings;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaGenerateMemberCompletionContributor;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMemberNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaNoVariantsDelegator;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.JavaStaticMemberProcessor;
import com.intellij.codeInsight.completion.MethodReturnTypeProvider;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.SameSignatureCallParametersProvider;
import com.intellij.codeInsight.completion.SlowerTypeConversions;
import com.intellij.codeInsight.completion.SmartCastProvider;
import com.intellij.codeInsight.completion.StreamConversion;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.EqTailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.classes.AnnotationTypeFilter;
import com.intellij.psi.filters.classes.AssignableFromContextFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.filters.getters.JavaMembersGetter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSourceModuleNameIndex;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> UNEXPECTED_REFERENCE_AFTER_DOT = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})).insideStarting((ElementPattern)PsiJavaPatterns.psiExpressionStatement());
    private static final PsiNameValuePairPattern NAME_VALUE_PAIR = (PsiNameValuePairPattern)PsiJavaPatterns.psiNameValuePair().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotation.class));
    private static final ElementPattern<PsiElement> ANNOTATION_ATTRIBUTE_NAME = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent((ElementPattern)NAME_VALUE_PAIR), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withParent((ElementPattern)NAME_VALUE_PAIR))});
    public static final ElementPattern<PsiElement> IN_SWITCH_LABEL = PsiJavaPatterns.psiElement().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiExpressionList.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchLabelStatementBase.class).withSuperParent(2, PsiSwitchBlock.class)));
    private static final ElementPattern<PsiElement> IN_ENUM_SWITCH_LABEL = PsiJavaPatterns.psiElement().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiExpressionList.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchLabelStatementBase.class).withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchBlock.class).with((PatternCondition)new PatternCondition<PsiSwitchBlock>("enumExpressionType"){

        public boolean accepts(@NotNull PsiSwitchBlock psiSwitchBlock, ProcessingContext context) {
            PsiExpression expression2;
            if (psiSwitchBlock == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((expression2 = psiSwitchBlock.getExpression()) == null) {
                return false;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            return aClass != null && aClass.isEnum();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSwitchBlock", "com/intellij/codeInsight/completion/JavaCompletionContributor$1", "accepts"));
        }
    }))));
    private static final ElementPattern<PsiElement> AFTER_NUMBER_LITERAL = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{JavaTokenType.DOUBLE_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.INTEGER_LITERAL})));
    private static final ElementPattern<PsiElement> IMPORT_REFERENCE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent(PsiImportStatementBase.class));
    private static final ElementPattern<PsiElement> CATCH_OR_FINALLY = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("}")).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiCodeBlock.class).afterLeaf(new String[]{"try"})));
    private static final ElementPattern<PsiElement> INSIDE_CONSTRUCTOR = PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiMethod().constructor(true));
    private static final ElementPattern<PsiElement> AFTER_ENUM_CONSTANT = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiTypeElement.class)).afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().inside(true, (ElementPattern)PsiJavaPatterns.psiElement(PsiEnumConstant.class), (ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiClass.class, PsiExpressionList.class})));

    @Nullable
    public static ElementFilter getReferenceFilter(PsiElement position) {
        if (JavaCompletionContributor.isInExtendsOrImplementsList(position)) {
            return new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new NotFilter((ElementFilter)new AssignableFromContextFilter()));
        }
        if (JavaCompletionContributor.getAnnotationNameIfInside(position) != null) {
            return new OrFilter(new ElementFilter[]{ElementClassFilter.PACKAGE, new AnnotationTypeFilter()});
        }
        if (JavaKeywordCompletion.isDeclarationStart(position) || JavaKeywordCompletion.isInsideParameterList(position) || JavaCompletionContributor.isInsideAnnotationName(position) || ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class)).accepts((Object)position) || JavaCompletionContributor.isDefinitelyVariableType(position)) {
            return new OrFilter(new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.PACKAGE});
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"instanceof"})).accepts((Object)position)) {
            return new ElementExtractorFilter(ElementClassFilter.CLASS);
        }
        if (JavaKeywordCompletion.VARIABLE_AFTER_FINAL.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (CATCH_OR_FINALLY.accepts((Object)position) || JavaKeywordCompletion.START_SWITCH.accepts((Object)position) || JavaKeywordCompletion.isInstanceofPlace(position) || JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position)) {
            return null;
        }
        if (((PsiElementPattern)JavaKeywordCompletion.START_FOR.withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiExpressionStatement.class, PsiForStatement.class})).accepts((Object)position)) {
            return new OrFilter(new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.VARIABLE});
        }
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotationParameterList.class)).accepts((Object)position)) {
            return JavaCompletionContributor.createAnnotationFilter();
        }
        PsiVariable var = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)position, PsiVariable.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
        if (var != null && PsiTreeUtil.isAncestor((PsiElement)var.getInitializer(), (PsiElement)position, (boolean)false)) {
            return new ExcludeFilter(var);
        }
        if (IN_ENUM_SWITCH_LABEL.accepts((Object)position)) {
            return new ClassFilter(PsiField.class){

                public boolean isAcceptable(Object element, PsiElement context) {
                    return element instanceof PsiEnumConstant;
                }
            };
        }
        PsiForeachStatement loop = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiForeachStatement.class);
        if (loop != null && PsiTreeUtil.isAncestor((PsiElement)loop.getIteratedValue(), (PsiElement)position, (boolean)false)) {
            return new ExcludeFilter((PsiVariable)loop.getIterationParameter());
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiPackageAccessibilityStatement.class) != null) {
            return JavaCompletionContributor.applyScopeFilter(ElementClassFilter.PACKAGE, position);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{PsiUsesStatement.class, PsiProvidesStatement.class}) != null) {
            OrFilter filter = new OrFilter(new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.PACKAGE});
            if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceList.class) != null) {
                filter = JavaCompletionContributor.applyScopeFilter((ElementFilter)filter, position);
            }
            return filter;
        }
        return TrueFilter.INSTANCE;
    }

    private static boolean isDefinitelyVariableType(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiTypeElement.class, PsiDeclarationStatement.class})).afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiAnnotation()))).accepts((Object)position);
    }

    private static boolean isInExtendsOrImplementsList(PsiElement position) {
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiClass.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMethod.class, PsiExpressionList.class, PsiVariable.class, PsiAnnotation.class});
        return containingClass != null && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"extends", "implements", ",", "&"}))).withParent(PsiReferenceList.class))).accepts((Object)position);
    }

    private static boolean isInsideAnnotationName(PsiElement position) {
        PsiAnnotation anno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        return anno != null && PsiTreeUtil.isAncestor((PsiElement)anno.getNameReferenceElement(), (PsiElement)position, (boolean)true);
    }

    private static ElementFilter createAnnotationFilter() {
        return new OrFilter(new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.PACKAGE, new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final"))});
    }

    public static ElementFilter applyScopeFilter(ElementFilter filter, PsiElement position) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)position);
        return module != null ? new AndFilter(filter, (ElementFilter)new SearchScopeFilter(module.getModuleScope())) : filter;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet _result) {
        PsiElement position;
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(0);
        }
        if (_result == null) {
            JavaCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!JavaCompletionContributor.isInJavaContext(position = parameters2.getPosition())) {
            return;
        }
        if (AFTER_NUMBER_LITERAL.accepts((Object)position) || UNEXPECTED_REFERENCE_AFTER_DOT.accepts((Object)position) || AFTER_ENUM_CONSTANT.accepts((Object)position)) {
            _result.stopHere();
            return;
        }
        boolean smart = parameters2.getCompletionType() == CompletionType.SMART;
        CompletionResultSet result = JavaCompletionSorting.addJavaSorting(parameters2, _result);
        JavaCompletionSession session = new JavaCompletionSession(result);
        PrefixMatcher matcher = result.getPrefixMatcher();
        PsiElement parent = position.getParent();
        if (!smart && new JavaKeywordCompletion(parameters2, session).addWildcardExtendsSuper(result, position)) {
            result.stopHere();
            return;
        }
        boolean mayCompleteReference = true;
        if (position instanceof PsiIdentifier) {
            PsiReference ref;
            PsiAnnotation anno;
            boolean hasTypeMatchingSuggestions;
            JavaCompletionContributor.addIdentifierVariants(parameters2, position, result, session, matcher);
            HashSet expectedInfos = ContainerUtil.newHashSet((Object[])JavaSmartCompletionContributor.getExpectedTypes(parameters2));
            boolean shouldAddExpressionVariants = JavaCompletionContributor.shouldAddExpressionVariants(parameters2);
            boolean bl = hasTypeMatchingSuggestions = shouldAddExpressionVariants && JavaCompletionContributor.addExpectedTypeMembers(parameters2, false, expectedInfos, (Consumer<? super LookupElement>)((Consumer)item -> session.registerBatchItems(Collections.singleton(item))));
            if (!smart && (anno = JavaCompletionContributor.findAnnotationWhoseAttributeIsCompleted(position)) != null) {
                PsiClass annoClass = anno.resolveAnnotationType();
                boolean bl2 = mayCompleteReference = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).accepts((Object)position) && annoClass != null && annoClass.findMethodsByName("value", false).length > 0;
                if (annoClass != null) {
                    JavaCompletionContributor.completeAnnotationAttributeName(result, position, anno, annoClass);
                    JavaKeywordCompletion.addPrimitiveTypes((Consumer<? super LookupElement>)result, position, session);
                }
            }
            if ((ref = position.getContainingFile().findReferenceAt(parameters2.getOffset())) instanceof PsiLabelReference) {
                session.registerBatchItems(JavaCompletionContributor.processLabelReference((PsiLabelReference)ref));
                result.stopHere();
            }
            List<LookupElement> refSuggestions = Collections.emptyList();
            if (parent instanceof PsiJavaCodeReferenceElement && mayCompleteReference) {
                refSuggestions = JavaCompletionContributor.completeReference(parameters2, (PsiJavaCodeReferenceElement)parent, session, expectedInfos);
                List<LookupElement> filtered = JavaCompletionContributor.filterReferenceSuggestions(parameters2, result, (PsiJavaCodeReferenceElement)parent, expectedInfos, refSuggestions);
                hasTypeMatchingSuggestions |= ContainerUtil.exists(filtered, item -> ReferenceExpressionCompletionContributor.matchesExpectedType(item, expectedInfos));
                session.registerBatchItems(filtered);
                result.stopHere();
            }
            session.flushBatchItems();
            if (smart) {
                hasTypeMatchingSuggestions |= JavaCompletionContributor.smartCompleteExpression(parameters2, result, expectedInfos);
                JavaCompletionContributor.smartCompleteNonExpression(parameters2, result);
            }
            if ((!hasTypeMatchingSuggestions || parameters2.getInvocationCount() >= 2) && JavaSmartCompletionContributor.INSIDE_EXPRESSION.accepts((Object)position)) {
                SlowerTypeConversions.addChainedSuggestions(parameters2, result, expectedInfos, refSuggestions);
            }
            if (smart && parameters2.getInvocationCount() > 1 && shouldAddExpressionVariants) {
                JavaCompletionContributor.addExpectedTypeMembers(parameters2, true, expectedInfos, (Consumer<? super LookupElement>)result);
            }
        }
        if (!smart && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiLiteralExpression.class)).accepts((Object)position)) {
            HashSet usedWords = new HashSet();
            result.runRemainingContributors(parameters2, cr -> {
                usedWords.add(cr.getLookupElement().getLookupString());
                result.passResult(cr);
            });
            PsiReference reference = position.getContainingFile().findReferenceAt(parameters2.getOffset());
            if (reference == null || reference.isSoft()) {
                WordCompletionContributor.addWordCompletionVariants((CompletionResultSet)result, (CompletionParameters)parameters2, usedWords);
            }
        }
        if (!smart && position instanceof PsiIdentifier) {
            JavaGenerateMemberCompletionContributor.fillCompletionVariants(parameters2, result);
        }
        if (!smart && mayCompleteReference) {
            JavaCompletionContributor.addAllClasses(parameters2, result, session);
        }
        if (position instanceof PsiIdentifier) {
            FunctionalExpressionCompletionProvider.addFunctionalVariants(parameters2, true, result.getPrefixMatcher(), (Consumer<? super LookupElement>)result);
        }
        if (position instanceof PsiIdentifier && !smart && parent instanceof PsiReferenceExpression && !((PsiReferenceExpression)parent).isQualified() && parameters2.isExtendedCompletion() && StringUtil.isNotEmpty((String)matcher.getPrefix())) {
            new JavaStaticMemberProcessor(parameters2).processStaticMethodsGlobally(matcher, (Consumer<? super LookupElement>)result);
        }
        if (!smart && parent instanceof PsiJavaModuleReferenceElement) {
            JavaCompletionContributor.addModuleReferences(parent, parameters2.getOriginalFile(), result);
        }
    }

    private static List<LookupElement> filterReferenceSuggestions(CompletionParameters parameters2, CompletionResultSet result, PsiJavaCodeReferenceElement parent, Set<ExpectedTypeInfo> expectedInfos, List<LookupElement> refSuggestions) {
        if (parameters2.getCompletionType() == CompletionType.SMART) {
            refSuggestions = ReferenceExpressionCompletionContributor.smartCompleteReference(refSuggestions, expectedInfos);
        }
        List matching = ContainerUtil.findAll(refSuggestions, arg_0 -> ((PrefixMatcher)result.getPrefixMatcher()).prefixMatches(arg_0));
        if (parameters2.getInvocationCount() >= 2) {
            return matching;
        }
        return JavaCompletionProcessor.dispreferStaticAfterInstance(parent, matching);
    }

    private static void smartCompleteNonExpression(CompletionParameters parameters2, CompletionResultSet result) {
        PsiElement position = parameters2.getPosition();
        PsiElement parent = position.getParent();
        if (!SmartCastProvider.shouldSuggestCast(parameters2) && parent instanceof PsiJavaCodeReferenceElement) {
            JavaSmartCompletionContributor.addClassReferenceSuggestions(parameters2, result, position, (PsiJavaCodeReferenceElement)parent);
        }
        if (InstanceofTypeProvider.AFTER_INSTANCEOF.accepts((Object)position)) {
            InstanceofTypeProvider.addCompletions(parameters2, result);
        }
        if (ExpectedAnnotationsProvider.ANNOTATION_ATTRIBUTE_VALUE.accepts((Object)position)) {
            ExpectedAnnotationsProvider.addCompletions(position, result);
        }
        if (CatchTypeProvider.CATCH_CLAUSE_TYPE.accepts((Object)position)) {
            CatchTypeProvider.addCompletions(parameters2, result);
        }
    }

    private static boolean smartCompleteExpression(CompletionParameters parameters2, CompletionResultSet result, Set<ExpectedTypeInfo> infos) {
        PsiElement position = parameters2.getPosition();
        if (SmartCastProvider.shouldSuggestCast(parameters2) || !JavaSmartCompletionContributor.INSIDE_EXPRESSION.accepts((Object)position) || !(position.getParent() instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        boolean[] hadItems = new boolean[1];
        for (ExpectedTypeInfo info : new THashSet(infos, JavaSmartCompletionContributor.EXPECTED_TYPE_INFO_STRATEGY)) {
            BasicExpressionCompletionContributor.fillCompletionVariants(new JavaSmartCompletionParameters(parameters2, info), (Consumer<? super LookupElement>)((Consumer)lookupElement -> {
                PsiType psiType = JavaCompletionUtil.getLookupElementType(lookupElement);
                if (psiType != null && info.getType().isAssignableFrom(psiType)) {
                    hadItems[0] = true;
                    result.addElement((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, infos));
                }
            }), result.getPrefixMatcher());
        }
        return hadItems[0];
    }

    @Nullable
    private static PsiAnnotation findAnnotationWhoseAttributeIsCompleted(@NotNull PsiElement position) {
        if (position == null) {
            JavaCompletionContributor.$$$reportNull$$$0(2);
        }
        return ANNOTATION_ATTRIBUTE_NAME.accepts((Object)position) && !JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position) ? Objects.requireNonNull((PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class)) : null;
    }

    private static void addIdentifierVariants(@NotNull CompletionParameters parameters2, PsiElement position, CompletionResultSet result, JavaCompletionSession session, PrefixMatcher matcher) {
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(3);
        }
        session.registerBatchItems(JavaCompletionContributor.getFastIdentifierVariants(parameters2, position, matcher, position.getParent(), session));
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            session.flushBatchItems();
            boolean smart = parameters2.getCompletionType() == CompletionType.SMART;
            ConstructorInsertHandler handler = smart ? ConstructorInsertHandler.SMART_INSTANCE : ConstructorInsertHandler.BASIC_INSTANCE;
            ExpectedTypeInfo[] types = JavaSmartCompletionContributor.getExpectedTypes(parameters2);
            new JavaInheritorsGetter(handler).generateVariants(parameters2, matcher, types, (Consumer<? super LookupElement>)((Consumer)lookupElement -> {
                if ((smart || !JavaCompletionContributor.isSuggestedByKeywordCompletion(lookupElement)) && result.getPrefixMatcher().prefixMatches(lookupElement)) {
                    session.registerClassFrom((LookupElement)lookupElement);
                    result.addElement((LookupElement)(smart ? JavaSmartCompletionContributor.decorate(lookupElement, Arrays.asList(types)) : AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(lookupElement)));
                }
            }));
        }
        JavaCompletionContributor.suggestSmartCast(parameters2, session, false, (Consumer<? super LookupElement>)result);
    }

    private static boolean isSuggestedByKeywordCompletion(LookupElement lookupElement) {
        if (lookupElement instanceof PsiTypeLookupItem) {
            PsiType type2 = ((PsiTypeLookupItem)lookupElement).getType();
            return type2 instanceof PsiArrayType && ((PsiArrayType)type2).getComponentType() instanceof PsiPrimitiveType;
        }
        return false;
    }

    private static void suggestSmartCast(CompletionParameters parameters2, JavaCompletionSession session, boolean quick, Consumer<? super LookupElement> result) {
        if (SmartCastProvider.shouldSuggestCast(parameters2)) {
            session.flushBatchItems();
            SmartCastProvider.addCastVariants(parameters2, session.getMatcher(), (Consumer<? super LookupElement>)((Consumer)element -> {
                JavaCompletionContributor.registerClassFromTypeElement(element, session);
                result.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)element, (double)1.0));
            }), quick);
        }
    }

    private static List<LookupElement> getFastIdentifierVariants(@NotNull CompletionParameters parameters2, PsiElement position, PrefixMatcher matcher, PsiElement parent, @NotNull JavaCompletionSession session) {
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(4);
        }
        if (session == null) {
            JavaCompletionContributor.$$$reportNull$$$0(5);
        }
        boolean smart = parameters2.getCompletionType() == CompletionType.SMART;
        ArrayList<LookupElement> items = new ArrayList<LookupElement>();
        if (TypeArgumentCompletionProvider.IN_TYPE_ARGS.accepts((Object)position)) {
            new TypeArgumentCompletionProvider(smart, session).addTypeArgumentVariants(parameters2, (Consumer<? super LookupElement>)((Consumer)items::add), matcher);
        }
        FunctionalExpressionCompletionProvider.addFunctionalVariants(parameters2, false, matcher, (Consumer<? super LookupElement>)((Consumer)items::add));
        if (MethodReturnTypeProvider.IN_METHOD_RETURN_TYPE.accepts((Object)position)) {
            MethodReturnTypeProvider.addProbableReturnTypes(position, (Consumer<? super LookupElement>)((Consumer)element -> {
                JavaCompletionContributor.registerClassFromTypeElement(element, session);
                items.add((LookupElement)element);
            }));
        }
        JavaCompletionContributor.suggestSmartCast(parameters2, session, true, (Consumer<? super LookupElement>)((Consumer)items::add));
        if (parent instanceof PsiReferenceExpression) {
            List<ExpectedTypeInfo> expected = Arrays.asList(ExpectedTypesProvider.getExpectedTypes((PsiExpression)parent, true));
            StreamConversion.addCollectConversion((PsiReferenceExpression)parent, expected, (Consumer<? super LookupElement>)((Consumer)lookupElement -> items.add((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, expected))));
            if (!smart) {
                items.addAll(StreamConversion.addToStreamConversion((PsiReferenceExpression)parent, parameters2));
            }
        }
        if (IMPORT_REFERENCE.accepts((Object)position)) {
            items.add((LookupElement)LookupElementBuilder.create((String)"*"));
        }
        if (!smart && JavaCompletionContributor.findAnnotationWhoseAttributeIsCompleted(position) == null) {
            items.addAll(new JavaKeywordCompletion(parameters2, session).getResults());
        }
        JavaCompletionContributor.addExpressionVariants(parameters2, position, (Consumer<? super LookupElement>)((Consumer)items::add));
        return items;
    }

    private static void registerClassFromTypeElement(LookupElement element, JavaCompletionSession session) {
        PsiClass aClass;
        PsiType type2 = Objects.requireNonNull((PsiTypeLookupItem)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY)).getType();
        if (type2 instanceof PsiPrimitiveType) {
            session.registerKeyword(type2.getCanonicalText(false));
        } else if (type2 instanceof PsiClassType && ((PsiClassType)type2).getParameterCount() == 0 && (aClass = ((PsiClassType)type2).resolve()) != null) {
            session.registerClass(aClass);
        }
    }

    private static boolean shouldAddExpressionVariants(CompletionParameters parameters2) {
        return JavaSmartCompletionContributor.INSIDE_EXPRESSION.accepts((Object)parameters2.getPosition()) && !JavaKeywordCompletion.AFTER_DOT.accepts((Object)parameters2.getPosition()) && !SmartCastProvider.shouldSuggestCast(parameters2);
    }

    private static void addExpressionVariants(@NotNull CompletionParameters parameters2, PsiElement position, Consumer<? super LookupElement> result) {
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(6);
        }
        if (JavaCompletionContributor.shouldAddExpressionVariants(parameters2) && SameSignatureCallParametersProvider.IN_CALL_ARGUMENT.accepts((Object)position)) {
            new SameSignatureCallParametersProvider().addSignatureItems(position, result);
        }
    }

    public static boolean isInJavaContext(PsiElement position) {
        return PsiUtilCore.findLanguageFromElement((PsiElement)position).isKindOf((Language)JavaLanguage.INSTANCE);
    }

    public static void addAllClasses(CompletionParameters parameters2, CompletionResultSet result, JavaCompletionSession session) {
        if (!JavaCompletionContributor.isClassNamePossible(parameters2) || !JavaCompletionContributor.mayStartClassName(result)) {
            return;
        }
        if (parameters2.getInvocationCount() >= 2) {
            JavaNoVariantsDelegator.suggestNonImportedClasses(parameters2, result, session);
        } else {
            JavaCompletionContributor.advertiseSecondCompletion(parameters2.getPosition().getProject(), result);
        }
    }

    public static void advertiseSecondCompletion(Project project, CompletionResultSet result) {
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.second.basic", project)) {
            result.addLookupAdvertisement(JavaBundle.message((String)"press.0.to.see.non.imported.classes", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")}));
        }
    }

    private static List<LookupElement> completeReference(CompletionParameters parameters2, PsiJavaCodeReferenceElement ref, JavaCompletionSession session, Set<ExpectedTypeInfo> expectedTypes) {
        boolean smart;
        PsiElement position = parameters2.getPosition();
        ElementFilter filter = JavaCompletionContributor.getReferenceFilter(position);
        if (filter == null) {
            return Collections.emptyList();
        }
        boolean bl = smart = parameters2.getCompletionType() == CompletionType.SMART;
        if (smart) {
            if (JavaSmartCompletionContributor.INSIDE_TYPECAST_EXPRESSION.accepts((Object)position) || SmartCastProvider.shouldSuggestCast(parameters2)) {
                return Collections.emptyList();
            }
            ElementFilter smartRestriction = ReferenceExpressionCompletionContributor.getReferenceFilter(position, false);
            if (smartRestriction != TrueFilter.INSTANCE) {
                filter = new AndFilter(filter, smartRestriction);
            }
        }
        boolean inSwitchLabel = IN_SWITCH_LABEL.accepts((Object)position);
        TailType forcedTail = null;
        if (!smart) {
            if (inSwitchLabel) {
                forcedTail = TailTypes.forSwitchLabel(Objects.requireNonNull((PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)position, PsiSwitchBlock.class)));
            } else if (JavaCompletionContributor.shouldInsertSemicolon(position)) {
                forcedTail = TailType.SEMICOLON;
            }
        }
        ArrayList<LookupElement> items = new ArrayList<LookupElement>();
        if (INSIDE_CONSTRUCTOR.accepts((Object)position) && (parameters2.getInvocationCount() <= 1 || CheckInitialized.isInsideConstructorCall(position))) {
            filter = new AndFilter(filter, (ElementFilter)new CheckInitialized(position));
        }
        PsiFile originalFile = parameters2.getOriginalFile();
        boolean first = parameters2.getInvocationCount() <= 1;
        JavaCompletionProcessor.Options options = JavaCompletionProcessor.Options.DEFAULT_OPTIONS.withCheckAccess(first).withFilterStaticAfterInstance(false).withShowInstanceInStaticContext(!first && !smart);
        for (Object element : JavaCompletionUtil.processJavaReference(position, (PsiJavaReference)ref, new ElementExtractorFilter(filter), options, PrefixMatcher.ALWAYS_TRUE, parameters2)) {
            JavaMethodCallElement call;
            PsiMethod method;
            if (session.alreadyProcessed((LookupElement)element)) continue;
            LookupItem item = (LookupItem)element.as(LookupItem.CLASS_CONDITION_KEY);
            if (forcedTail != null) {
                element = TailTypeDecorator.withTail((LookupElement)element, (TailType)forcedTail);
            }
            if (inSwitchLabel && !smart) {
                element = new IndentingDecorator((LookupElement)element);
            }
            if (originalFile instanceof PsiJavaCodeReferenceCodeFragment && !((PsiJavaCodeReferenceCodeFragment)originalFile).isClassesAccepted() && item != null) {
                item.setTailType(TailType.NONE);
            }
            if (item instanceof JavaMethodCallElement && (method = (PsiMethod)(call = (JavaMethodCallElement)item).getObject()).getTypeParameters().length > 0) {
                ExpectedTypeInfo matchingExpectation;
                PsiType returned = TypeConversionUtil.erasure((PsiType)method.getReturnType());
                ExpectedTypeInfo expectedTypeInfo = matchingExpectation = returned == null ? null : (ExpectedTypeInfo)ContainerUtil.find(expectedTypes, info -> info.getDefaultType().isAssignableFrom(returned) || AssignableFromFilter.isAcceptable((PsiElement)method, position, info.getDefaultType(), call.getSubstitutor()));
                if (matchingExpectation != null) {
                    call.setInferenceSubstitutorFromExpectedType(position, matchingExpectation.getDefaultType());
                }
            }
            items.add((LookupElement)element);
            ContainerUtil.addIfNotNull(items, (Object)ArrayMemberAccess.accessFirstElement(position, element));
        }
        return items;
    }

    static boolean shouldInsertSemicolon(PsiElement position) {
        return position.getParent() instanceof PsiMethodReferenceExpression && LambdaHighlightingUtil.insertSemicolon(position.getParent().getParent());
    }

    private static List<LookupElement> processLabelReference(PsiLabelReference reference) {
        return ContainerUtil.map((Object[])reference.getVariants(), s -> TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)s), (TailType)TailType.SEMICOLON));
    }

    static boolean isClassNamePossible(CompletionParameters parameters2) {
        boolean isSecondCompletion = parameters2.getInvocationCount() >= 2;
        PsiElement position = parameters2.getPosition();
        if (JavaKeywordCompletion.isInstanceofPlace(position) || JavaMemberNameCompletionContributor.INSIDE_TYPE_PARAMS_PATTERN.accepts((Object)position) || AFTER_ENUM_CONSTANT.accepts((Object)position)) {
            return false;
        }
        PsiElement parent = position.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return isSecondCompletion;
        }
        if (((PsiJavaCodeReferenceElement)parent).getQualifier() != null) {
            return isSecondCompletion;
        }
        if (parent instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)parent).getKindEnum(parent.getContainingFile()) == PsiJavaCodeReferenceElementImpl.Kind.PACKAGE_NAME_KIND) {
            return false;
        }
        if (IN_SWITCH_LABEL.accepts((Object)position)) {
            return false;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiImportStatement.class)).accepts((Object)parent)) {
            return isSecondCompletion;
        }
        PsiElement grand = parent.getParent();
        if (grand instanceof PsiAnonymousClass) {
            grand = grand.getParent();
        }
        if (grand instanceof PsiNewExpression && ((PsiNewExpression)grand).getQualifier() != null) {
            return false;
        }
        return !JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position);
    }

    public static boolean mayStartClassName(CompletionResultSet result) {
        return InternalCompletionSettings.getInstance().mayStartClassNameCompletion(result);
    }

    private static void completeAnnotationAttributeName(CompletionResultSet result, PsiElement position, PsiAnnotation anno, PsiClass annoClass) {
        PsiNameValuePair[] existingPairs = anno.getParameterList().getAttributes();
        block0: for (PsiMethod method : annoClass.getMethods()) {
            String defText;
            if (!(method instanceof PsiAnnotationMethod)) continue;
            String attrName = method.getName();
            for (PsiNameValuePair existingAttr : existingPairs) {
                if (PsiTreeUtil.isAncestor((PsiElement)existingAttr, (PsiElement)position, (boolean)false)) break;
                if (Objects.equals(existingAttr.getName(), attrName) || "value".equals(attrName) && existingAttr.getName() == null) continue block0;
            }
            PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)method).getDefaultValue();
            String string = defText = defaultValue == null ? null : defaultValue.getText();
            if ("true".equals(defText) || "false".equals(defText)) {
                result.addElement((LookupElement)JavaCompletionContributor.createAnnotationAttributeElement(method, "true".equals(defText) ? "false" : "true"));
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)JavaCompletionContributor.createAnnotationAttributeElement(method, defText).withTailText(" (default)", true), (double)-1.0));
                continue;
            }
            LookupElementBuilder element = JavaCompletionContributor.createAnnotationAttributeElement(method, null);
            if (defText != null) {
                element = element.withTailText(" default " + defText, true);
            }
            result.addElement((LookupElement)element);
        }
    }

    @NotNull
    private static LookupElementBuilder createAnnotationAttributeElement(PsiMethod annoMethod, final @Nullable String value2) {
        String space = ReferenceExpressionCompletionContributor.getSpace(CodeStyle.getLanguageSettings((PsiFile)annoMethod.getContainingFile()).SPACE_AROUND_ASSIGNMENT_OPERATORS);
        String lookupString = annoMethod.getName() + (value2 == null ? "" : space + "=" + space + value2);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)annoMethod, (String)lookupString).withIcon(annoMethod.getIcon(0)).withStrikeoutness(PsiImplUtil.isDeprecated((PsiElement)annoMethod)).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    3.$$$reportNull$$$0(1);
                }
                Editor editor = context.getEditor();
                if (value2 == null) {
                    EqTailType.INSTANCE.processTail(editor, editor.getCaretModel().getOffset());
                }
                context.setAddCompletionChar(false);
                context.commitDocument();
                PsiAnnotationParameterList paramList = (PsiAnnotationParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiAnnotationParameterList.class, (boolean)false);
                if (paramList != null && paramList.getAttributes().length > 0 && paramList.getAttributes()[0].getName() == null) {
                    int valueOffset = paramList.getAttributes()[0].getTextRange().getStartOffset();
                    context.getDocument().insertString(valueOffset, (CharSequence)"value");
                    EqTailType.INSTANCE.processTail(editor, valueOffset + "value".length());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/JavaCompletionContributor$3";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (lookupElementBuilder == null) {
            JavaCompletionContributor.$$$reportNull$$$0(7);
        }
        return lookupElementBuilder;
    }

    public String advertise(@NotNull CompletionParameters parameters2) {
        PsiType[] psiTypes;
        String shortcut;
        String shortcut2;
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(8);
        }
        if (!(parameters2.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        if (parameters2.getCompletionType() == CompletionType.BASIC && parameters2.getInvocationCount() > 0) {
            PsiElement position = parameters2.getPosition();
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withFirstChild((ElementPattern)PsiJavaPatterns.psiReferenceExpression().referencing((ElementPattern)PsiJavaPatterns.psiClass())))).accepts((Object)position) && CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.global.member.name") && StringUtil.isNotEmpty((String)(shortcut2 = KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")))) {
                return JavaBundle.message((String)"pressing.0.twice.without.a.class.qualifier", (Object[])new Object[]{shortcut2});
            }
        }
        if (parameters2.getCompletionType() != CompletionType.SMART && JavaCompletionContributor.shouldSuggestSmartCompletion(parameters2.getPosition()) && CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.smarttype.general") && StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"SmartTypeCompletion")))) {
            return JavaBundle.message((String)"completion.smart.hint", (Object[])new Object[]{shortcut});
        }
        if (parameters2.getCompletionType() == CompletionType.SMART && parameters2.getInvocationCount() == 1 && (psiTypes = ExpectedTypesGetter.getExpectedTypes(parameters2.getPosition(), true)).length > 0) {
            if (CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.second.smarttype.toar") && StringUtil.isNotEmpty((String)(shortcut2 = KeymapUtil.getFirstKeyboardShortcutText((String)"SmartTypeCompletion")))) {
                for (PsiType psiType : psiTypes) {
                    PsiType type2 = PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)false);
                    if (type2 == null) continue;
                    return JavaBundle.message((String)"completion.smart.aslist.hint", (Object[])new Object[]{shortcut2, type2.getPresentableText()});
                }
            }
            if (CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.second.smarttype.aslist") && StringUtil.isNotEmpty((String)(shortcut2 = KeymapUtil.getFirstKeyboardShortcutText((String)"SmartTypeCompletion")))) {
                for (PsiType psiType : psiTypes) {
                    PsiType componentType;
                    if (!(psiType instanceof PsiArrayType) || (componentType = ((PsiArrayType)psiType).getComponentType()) instanceof PsiPrimitiveType) continue;
                    return JavaBundle.message((String)"completion.smart.toar.hint", (Object[])new Object[]{shortcut2, componentType.getPresentableText()});
                }
            }
            if (CompletionUtil.shouldShowFeature((CompletionParameters)parameters2, (String)"editing.completion.second.smarttype.chain") && StringUtil.isNotEmpty((String)(shortcut2 = KeymapUtil.getFirstKeyboardShortcutText((String)"SmartTypeCompletion")))) {
                return JavaBundle.message((String)"completion.smart.chain.hint", (Object[])new Object[]{shortcut2});
            }
        }
        return null;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters2, Editor editor) {
        String suffix;
        if (parameters2 == null) {
            JavaCompletionContributor.$$$reportNull$$$0(9);
        }
        if (!(parameters2.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        String ad = this.advertise(parameters2);
        String string = suffix = ad == null ? "" : "; " + StringUtil.decapitalize((String)ad);
        if (parameters2.getCompletionType() == CompletionType.SMART) {
            PsiInstanceOfExpression instanceOfExpression;
            PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)parameters2.getPosition(), PsiExpression.class, (boolean)true);
            if (expression2 instanceof PsiLiteralExpression) {
                return LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0]) + suffix;
            }
            if (expression2 instanceof PsiInstanceOfExpression && PsiTreeUtil.isAncestor((PsiElement)(instanceOfExpression = (PsiInstanceOfExpression)expression2).getCheckType(), (PsiElement)parameters2.getPosition(), (boolean)false)) {
                return LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0]) + suffix;
            }
            Set<PsiType> expectedTypes = JavaCompletionUtil.getExpectedTypes(parameters2);
            if (expectedTypes != null) {
                PsiType type2;
                PsiType psiType = type2 = expectedTypes.size() == 1 ? expectedTypes.iterator().next() : null;
                if (type2 != null) {
                    PsiType deepComponentType = type2.getDeepComponentType();
                    String expectedType = type2.getPresentableText();
                    if (expectedType.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) {
                        return null;
                    }
                    if (deepComponentType instanceof PsiClassType) {
                        if (((PsiClassType)deepComponentType).resolve() != null) {
                            return JavaBundle.message((String)"completion.no.suggestions.of.type", (Object[])new Object[]{expectedType}) + suffix;
                        }
                        return JavaBundle.message((String)"completion.unknown.type", (Object[])new Object[]{expectedType}) + suffix;
                    }
                    if (!PsiType.NULL.equals((Object)type2)) {
                        return JavaBundle.message((String)"completion.no.suggestions.of.type", (Object[])new Object[]{expectedType}) + suffix;
                    }
                }
            }
        }
        return LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0]) + suffix;
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            JavaCompletionContributor.$$$reportNull$$$0(10);
        }
        return typeChar == ':' && JavaTokenType.COLON == PsiUtilCore.getElementType((PsiElement)position);
    }

    private static boolean shouldSuggestSmartCompletion(PsiElement element) {
        if (JavaCompletionContributor.shouldSuggestClassNameCompletion(element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifier() != null) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression && parent.getParent() instanceof PsiReferenceExpression) {
            return true;
        }
        return ExpectedTypesGetter.getExpectedTypes(element, false).length > 0;
    }

    private static boolean shouldSuggestClassNameCompletion(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getParent() instanceof PsiTypeElement || parent.getParent() instanceof PsiExpressionStatement || parent.getParent() instanceof PsiReferenceList;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiFile file;
        if (context == null) {
            JavaCompletionContributor.$$$reportNull$$$0(11);
        }
        if ((file = context.getFile()) instanceof PsiJavaFile) {
            PsiJavaCodeReferenceElement ref;
            TextRange range;
            PsiLiteralExpression literal;
            String dummyIdentifier;
            if (context.getInvocationCount() > 0) {
                PsiType type2;
                PsiTypeElement typeElement;
                PsiVariable variable;
                JavaCompletionContributor.autoImport(file, context.getStartOffset() - 1, context.getEditor());
                PsiElement leaf = file.findElementAt(context.getStartOffset() - 1);
                if (leaf != null) {
                    leaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf);
                }
                if ((variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiVariable.class)) != null && (typeElement = variable.getTypeElement()) != null && (type2 = typeElement.getType()) instanceof PsiClassType && ((PsiClassType)type2).resolve() == null) {
                    JavaCompletionContributor.autoImportReference(file, context.getEditor(), typeElement.getInnermostComponentReferenceElement());
                }
            }
            if ((dummyIdentifier = JavaCompletionContributor.customizeDummyIdentifier(context, file)) != null) {
                context.setDummyIdentifier(dummyIdentifier);
            }
            if ((literal = (PsiLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)context.getStartOffset(), PsiLiteralExpression.class, (boolean)false)) != null && (range = literal.getTextRange()).getStartOffset() == context.getStartOffset()) {
                context.setReplacementOffset(range.getEndOffset());
            }
            if ((ref = JavaCompletionContributor.getAnnotationNameIfInside(file.findElementAt(context.getStartOffset()))) != null) {
                context.setReplacementOffset(ref.getTextRange().getEndOffset());
            }
        }
        if (context.getCompletionType() == CompletionType.SMART) {
            JavaSmartCompletionContributor.beforeSmartCompletion(context);
        }
    }

    @Nullable
    static PsiJavaCodeReferenceElement getAnnotationNameIfInside(@Nullable PsiElement position) {
        PsiAnnotation anno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class);
        PsiJavaCodeReferenceElement ref = anno == null ? null : anno.getNameReferenceElement();
        return ref != null && PsiTreeUtil.isAncestor((PsiElement)ref, (PsiElement)position, (boolean)false) ? ref : null;
    }

    @Nullable
    private static String customizeDummyIdentifier(@NotNull CompletionInitializationContext context, PsiFile file) {
        if (context == null) {
            JavaCompletionContributor.$$$reportNull$$$0(12);
        }
        if (context.getCompletionType() != CompletionType.BASIC) {
            return null;
        }
        int offset = context.getStartOffset();
        if (PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), PsiReferenceParameterList.class, (boolean)false) != null) {
            return "IntellijIdeaRulezzz";
        }
        if (JavaCompletionContributor.semicolonNeeded(file, offset)) {
            return "IntellijIdeaRulezzz;";
        }
        PsiElement leaf = file.findElementAt(offset);
        if (leaf instanceof PsiIdentifier || leaf instanceof PsiKeyword) {
            return "IntellijIdeaRulezzz";
        }
        return null;
    }

    public static boolean semicolonNeeded(PsiFile file, int startOffset) {
        return JavaCompletionContributor.semicolonNeeded(null, file, startOffset);
    }

    @Deprecated
    public static boolean semicolonNeeded(@Nullable Editor editor, PsiFile file, int startOffset) {
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)startOffset, PsiJavaCodeReferenceElement.class, (boolean)false);
        if (ref != null && !(ref instanceof PsiReferenceExpression) && ref.getParent() instanceof PsiTypeElement) {
            return true;
        }
        PsiElement at = file.findElementAt(startOffset);
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent((ElementPattern)PsiJavaPatterns.psiParameter())).accepts((Object)at)) {
            return true;
        }
        if (PsiUtilCore.getElementType((PsiElement)at) == JavaTokenType.IDENTIFIER) {
            at = PsiTreeUtil.nextLeaf((PsiElement)at);
        }
        if (PsiUtilCore.getElementType((PsiElement)(at = JavaCompletionContributor.skipWhitespacesAndComments(at))) == JavaTokenType.LPARENTH && PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiExpression.class, PsiClass.class}) == null) {
            return true;
        }
        if (PsiUtilCore.getElementType((PsiElement)at) == JavaTokenType.COLON && PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)startOffset, PsiConditionalExpression.class, (boolean)false) == null) {
            return true;
        }
        if (PsiUtilCore.getElementType((PsiElement)(at = JavaCompletionContributor.skipWhitespacesAndComments(at))) != JavaTokenType.IDENTIFIER) {
            return false;
        }
        at = PsiTreeUtil.nextLeaf((PsiElement)at);
        return (at = JavaCompletionContributor.skipWhitespacesAndComments(at)) != null && at.getNode().getElementType() == JavaTokenType.EQ;
    }

    @Nullable
    private static PsiElement skipWhitespacesAndComments(@Nullable PsiElement at) {
        PsiElement nextLeaf = at;
        while (nextLeaf != null && (nextLeaf instanceof PsiWhiteSpace || nextLeaf instanceof PsiComment || nextLeaf instanceof PsiErrorElement || nextLeaf.getTextLength() == 0)) {
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf, (boolean)true);
        }
        return nextLeaf;
    }

    private static void autoImport(@NotNull PsiFile file, int offset, @NotNull Editor editor) {
        if (file == null) {
            JavaCompletionContributor.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            JavaCompletionContributor.$$$reportNull$$$0(14);
        }
        CharSequence text2 = editor.getDocument().getCharsSequence();
        while (offset > 0 && Character.isJavaIdentifierPart(text2.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        while (offset > 0 && Character.isWhitespace(text2.charAt(offset))) {
            --offset;
        }
        if (offset <= 0 || text2.charAt(offset) != '.') {
            return;
        }
        --offset;
        while (offset > 0 && Character.isWhitespace(text2.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        JavaCompletionContributor.autoImportReference(file, editor, JavaCompletionContributor.extractReference(PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiExpression.class, (boolean)false)));
    }

    private static void autoImportReference(@NotNull PsiFile file, @NotNull Editor editor, @Nullable PsiJavaCodeReferenceElement element) {
        PsiJavaCodeReferenceElement qualifier;
        if (file == null) {
            JavaCompletionContributor.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            JavaCompletionContributor.$$$reportNull$$$0(16);
        }
        if (element == null) {
            return;
        }
        while ((qualifier = JavaCompletionContributor.extractReference(element.getQualifier())) != null) {
            element = qualifier;
        }
        if (!(element.getParent() instanceof PsiMethodCallExpression) && element.multiResolve(true).length == 0) {
            new ImportClassFix(element).fixSilently(editor);
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        }
    }

    @Nullable
    private static PsiJavaCodeReferenceElement extractReference(@Nullable PsiElement expression2) {
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            return (PsiJavaCodeReferenceElement)expression2;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression2).getMethodExpression();
        }
        return null;
    }

    private static boolean addExpectedTypeMembers(CompletionParameters parameters2, boolean searchInheritors, Collection<ExpectedTypeInfo> types, Consumer<? super LookupElement> result) {
        boolean smart;
        boolean[] added = new boolean[1];
        boolean bl = smart = parameters2.getCompletionType() == CompletionType.SMART;
        if (smart || parameters2.getInvocationCount() <= 1) {
            Consumer consumer = e -> {
                added[0] = true;
                result.consume((Object)(smart ? JavaSmartCompletionContributor.decorate(e, types) : e));
            };
            for (ExpectedTypeInfo info : types) {
                new JavaMembersGetter(info.getType(), parameters2).addMembers(searchInheritors, (Consumer<? super LookupElement>)consumer);
                if (info.getType().equals(info.getDefaultType())) continue;
                new JavaMembersGetter(info.getDefaultType(), parameters2).addMembers(searchInheritors, (Consumer<? super LookupElement>)consumer);
            }
        }
        return added[0];
    }

    private static void addModuleReferences(PsiElement moduleRef, PsiFile originalFile, CompletionResultSet result) {
        PsiElement parent;
        PsiElement statement = moduleRef.getParent();
        boolean requires = statement instanceof PsiRequiresStatement;
        if ((requires || statement instanceof PsiPackageAccessibilityStatement) && (parent = statement.getParent()) != null) {
            Module module;
            Project project = moduleRef.getProject();
            HashSet<String> filter = new HashSet<String>();
            filter.add(((PsiJavaModule)parent).getName());
            JavaModuleNameIndex index = JavaModuleNameIndex.getInstance();
            GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
            for (Object name2 : index.getAllKeys(project)) {
                if (index.get((String)name2, project, scope).size() <= 0 || !filter.add((String)name2)) continue;
                LookupElementBuilder lookup = LookupElementBuilder.create((String)name2).withIcon(AllIcons.Nodes.JavaModule);
                if (requires) {
                    lookup = TailTypeDecorator.withTail((LookupElement)lookup, (TailType)TailType.SEMICOLON);
                }
                result.addElement((LookupElement)lookup);
            }
            if (requires && (module = ModuleUtilCore.findModuleForFile((PsiFile)originalFile)) != null) {
                scope = GlobalSearchScope.projectScope((Project)project);
                for (String name3 : JavaSourceModuleNameIndex.getAllKeys(project)) {
                    if (JavaSourceModuleNameIndex.getFilesByKey(name3, scope).size() <= 0) continue;
                    JavaCompletionContributor.addAutoModuleReference(name3, parent, filter, result);
                }
                VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).orderEntries().withoutSdk().librariesOnly().getClassesRoots();
                scope = GlobalSearchScope.filesScope((Project)project, Arrays.asList(roots));
                for (String name4 : JavaAutoModuleNameIndex.getAllKeys(project)) {
                    if (JavaAutoModuleNameIndex.getFilesByKey(name4, scope).size() <= 0) continue;
                    JavaCompletionContributor.addAutoModuleReference(name4, parent, filter, result);
                }
            }
        }
    }

    private static void addAutoModuleReference(String name2, PsiElement parent, Set<String> filter, CompletionResultSet result) {
        if (PsiNameHelper.isValidModuleName((String)name2, (PsiElement)parent) && filter.add(name2)) {
            LookupElementBuilder lookup = LookupElementBuilder.create((String)name2).withIcon(AllIcons.FileTypes.Archive);
            lookup = TailTypeDecorator.withTail((LookupElement)lookup, (TailType)TailType.SEMICOLON);
            lookup = PrioritizedLookupElement.withPriority((LookupElement)lookup, (double)-1.0);
            result.addElement((LookupElement)lookup);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_result";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionContributor";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionContributor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationAttributeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationWhoseAttributeIsCompleted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addIdentifierVariants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFastIdentifierVariants";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addExpressionVariants";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "advertise";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleEmptyLookup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invokeAutoPopup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "customizeDummyIdentifier";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "autoImport";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "autoImportReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SearchScopeFilter
    implements ElementFilter {
        private final GlobalSearchScope myScope;

        SearchScopeFilter(GlobalSearchScope scope) {
            this.myScope = scope;
        }

        public boolean isAcceptable(Object element, @Nullable PsiElement context) {
            PsiFile psiFile;
            if (element instanceof PsiPackage) {
                return ((PsiDirectoryContainer)element).getDirectories(this.myScope).length > 0;
            }
            if (element instanceof PsiElement && (psiFile = ((PsiElement)element).getContainingFile()) != null) {
                VirtualFile file = psiFile.getVirtualFile();
                return file != null && this.myScope.contains(file);
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }

    static class IndentingDecorator
    extends LookupElementDecorator<LookupElement> {
        IndentingDecorator(LookupElement delegate) {
            super(delegate);
        }

        public void handleInsert(@NotNull InsertionContext context) {
            if (context == null) {
                IndentingDecorator.$$$reportNull$$$0(0);
            }
            super.handleInsert(context);
            Project project = context.getProject();
            Document document = context.getDocument();
            int lineStartOffset = DocumentUtil.getLineStartOffset((int)context.getStartOffset(), (Document)document);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(context.getFile(), lineStartOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/JavaCompletionContributor$IndentingDecorator", "handleInsert"));
        }
    }
}

