/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaAnalysisScope
extends AnalysisScope {
    public JavaAnalysisScope(@NotNull PsiPackage pack, Module module) {
        if (pack == null) {
            JavaAnalysisScope.$$$reportNull$$$0(0);
        }
        super(pack.getProject());
        this.myModule = module;
        this.myElement = pack;
        this.myType = 5;
    }

    JavaAnalysisScope(@NotNull PsiJavaFile psiFile) {
        if (psiFile == null) {
            JavaAnalysisScope.$$$reportNull$$$0(1);
        }
        super((PsiFile)psiFile);
    }

    @NotNull
    public AnalysisScope getNarrowedComplementaryScope(@NotNull Project defaultProject) {
        if (defaultProject == null) {
            JavaAnalysisScope.$$$reportNull$$$0(2);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)defaultProject).getFileIndex();
        if (this.myType == 3) {
            if (this.myElement instanceof PsiJavaFile && !FileTypeUtils.isInServerPageFile((PsiElement)this.myElement)) {
                PsiDirectory psiDirectory;
                PsiJavaFile psiJavaFile = (PsiJavaFile)this.myElement;
                PsiClass[] classes2 = psiJavaFile.getClasses();
                boolean onlyPackLocalClasses = true;
                for (PsiClass aClass : classes2) {
                    if (!aClass.hasModifierProperty("public")) continue;
                    onlyPackLocalClasses = false;
                    break;
                }
                if (onlyPackLocalClasses && (psiDirectory = psiJavaFile.getContainingDirectory()) != null) {
                    return new JavaAnalysisScope(JavaDirectoryService.getInstance().getPackage(psiDirectory), null);
                }
            }
        } else if (this.myType == 5) {
            PsiDirectory[] directories = ((PsiPackage)this.myElement).getDirectories();
            HashSet modules = new HashSet();
            for (PsiDirectory directory : directories) {
                modules.addAll(JavaAnalysisScope.getAllInterestingModules((ProjectFileIndex)fileIndex, (VirtualFile)directory.getVirtualFile()));
            }
            AnalysisScope analysisScope = JavaAnalysisScope.collectScopes((Project)defaultProject, modules);
            if (analysisScope == null) {
                JavaAnalysisScope.$$$reportNull$$$0(3);
            }
            return analysisScope;
        }
        AnalysisScope analysisScope = super.getNarrowedComplementaryScope(defaultProject);
        if (analysisScope == null) {
            JavaAnalysisScope.$$$reportNull$$$0(4);
        }
        return analysisScope;
    }

    @NotNull
    public String getShortenName() {
        if (this.myType == 5) {
            String string = JavaAnalysisBundle.message((String)"scope.package", (Object[])new Object[]{((PsiPackage)this.myElement).getQualifiedName()});
            if (string == null) {
                JavaAnalysisScope.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = super.getShortenName();
        if (string == null) {
            JavaAnalysisScope.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        if (this.myType == 5) {
            String string = JavaAnalysisBundle.message((String)"scope.package", (Object[])new Object[]{((PsiPackage)this.myElement).getQualifiedName()});
            if (string == null) {
                JavaAnalysisScope.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = super.getDisplayName();
        if (string == null) {
            JavaAnalysisScope.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected Set<VirtualFile> createFilesSet() {
        if (this.myType == 5) {
            CompactVirtualFileSet fileSet = new CompactVirtualFileSet();
            this.accept(this.createFileSearcher((Collection)fileSet));
            fileSet.freeze();
            CompactVirtualFileSet compactVirtualFileSet = fileSet;
            if (compactVirtualFileSet == null) {
                JavaAnalysisScope.$$$reportNull$$$0(9);
            }
            return compactVirtualFileSet;
        }
        Set set = super.createFilesSet();
        if (set == null) {
            JavaAnalysisScope.$$$reportNull$$$0(10);
        }
        return set;
    }

    public boolean accept(@NotNull Processor<? super VirtualFile> processor2) {
        if (processor2 == null) {
            JavaAnalysisScope.$$$reportNull$$$0(11);
        }
        if (this.myElement instanceof PsiPackage) {
            PsiPackage pack = (PsiPackage)this.myElement;
            HashSet dirs = new HashSet();
            ApplicationManager.getApplication().runReadAction(() -> ContainerUtil.addAll((Collection)dirs, (Object[])pack.getDirectories(GlobalSearchScope.projectScope((Project)this.myElement.getProject()))));
            for (PsiDirectory dir : dirs) {
                if (this.accept(dir, processor2)) continue;
                return false;
            }
            return true;
        }
        return super.accept(processor2);
    }

    @NotNull
    public SearchScope toSearchScope() {
        if (this.myType == 5) {
            return new PackageScope((PsiPackage)this.myElement, true, true);
        }
        SearchScope searchScope = super.toSearchScope();
        if (searchScope == null) {
            JavaAnalysisScope.$$$reportNull$$$0(12);
        }
        return searchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/JavaAnalysisScope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/JavaAnalysisScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNarrowedComplementaryScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortenName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilesSet";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedComplementaryScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

