/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.annotation.TargetVersions;

public class VersionMatcher {
    private static final String RANGE_TOKEN = " <=> ";
    @NotNull
    private final GradleVersion myGradleVersion;

    public VersionMatcher(@NotNull GradleVersion version) {
        if (version == null) {
            VersionMatcher.$$$reportNull$$$0(0);
        }
        this.myGradleVersion = version;
    }

    public boolean isVersionMatch(@Nullable TargetVersions targetVersions) {
        if (targetVersions == null || targetVersions.value().isEmpty()) {
            return true;
        }
        GradleVersion current = VersionMatcher.adjust(this.myGradleVersion, targetVersions.checkBaseVersions());
        if (targetVersions.value().endsWith("+")) {
            String minVersion = targetVersions.value().substring(0, targetVersions.value().length() - 1);
            return VersionMatcher.compare(current, minVersion, targetVersions.checkBaseVersions()) >= 0;
        }
        if (targetVersions.value().startsWith("<")) {
            if (targetVersions.value().startsWith("<=")) {
                String maxVersion = targetVersions.value().substring(2);
                return VersionMatcher.compare(current, maxVersion, targetVersions.checkBaseVersions()) <= 0;
            }
            String maxVersion = targetVersions.value().substring(1);
            return VersionMatcher.compare(current, maxVersion, targetVersions.checkBaseVersions()) < 0;
        }
        int rangeIndex = targetVersions.value().indexOf(RANGE_TOKEN);
        if (rangeIndex != -1) {
            String minVersion = targetVersions.value().substring(0, rangeIndex);
            String maxVersion = targetVersions.value().substring(rangeIndex + RANGE_TOKEN.length());
            return VersionMatcher.compare(current, minVersion, targetVersions.checkBaseVersions()) >= 0 && VersionMatcher.compare(current, maxVersion, targetVersions.checkBaseVersions()) <= 0;
        }
        return VersionMatcher.compare(current, targetVersions.value(), targetVersions.checkBaseVersions()) == 0;
    }

    private static int compare(@NotNull GradleVersion gradleVersion, @NotNull String otherGradleVersion, boolean checkBaseVersions) {
        if (gradleVersion == null) {
            VersionMatcher.$$$reportNull$$$0(1);
        }
        if (otherGradleVersion == null) {
            VersionMatcher.$$$reportNull$$$0(2);
        }
        return gradleVersion.compareTo(VersionMatcher.adjust(GradleVersion.version((String)otherGradleVersion), checkBaseVersions));
    }

    private static GradleVersion adjust(@NotNull GradleVersion version, boolean checkBaseVersions) {
        if (version == null) {
            VersionMatcher.$$$reportNull$$$0(3);
        }
        return checkBaseVersions ? version.getBaseVersion() : version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherGradleVersion";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/util/VersionMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjust";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

