/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ast.WasmModuleField;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/codegen/WasmCodegenContext;", "", "topLevelNames", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "imports", "", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmModuleField;", "getImports", "()Ljava/util/List;", "localNames", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getLocalNames", "()Ljava/util/Map;", "setLocalNames", "(Ljava/util/Map;)V", "stringLiterals", "getStringLiterals", "getGlobalName", "declaration", "getLocalName", "backend.wasm"})
public final class WasmCodegenContext {
    @NotNull
    private final List<WasmModuleField> imports;
    @NotNull
    private Map<IrValueDeclaration, String> localNames;
    @NotNull
    private final List<String> stringLiterals;
    private final Map<IrDeclarationWithName, String> topLevelNames;
    @NotNull
    private final WasmBackendContext backendContext;

    @NotNull
    public final List<WasmModuleField> getImports() {
        return this.imports;
    }

    @NotNull
    public final Map<IrValueDeclaration, String> getLocalNames() {
        return this.localNames;
    }

    public final void setLocalNames(@NotNull Map<IrValueDeclaration, String> map2) {
        Intrinsics.checkParameterIsNotNull(map2, "<set-?>");
        this.localNames = map2;
    }

    @NotNull
    public final List<String> getStringLiterals() {
        return this.stringLiterals;
    }

    @NotNull
    public final String getGlobalName(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        String string2 = this.topLevelNames.get(declaration2);
        if (string2 == null) {
            String string3 = "Can't find name for " + IrUtilsKt.getFqNameWhenAvailable(declaration2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return string2;
    }

    @NotNull
    public final String getLocalName(@NotNull IrValueDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        String string2 = this.localNames.get(declaration2);
        if (string2 == null) {
            String string3 = "Can't find local name for " + IrUtilsKt.getFqNameWhenAvailable(declaration2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return string2;
    }

    @NotNull
    public final WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    public WasmCodegenContext(@NotNull Map<IrDeclarationWithName, String> topLevelNames, @NotNull WasmBackendContext backendContext) {
        List list2;
        Intrinsics.checkParameterIsNotNull(topLevelNames, "topLevelNames");
        Intrinsics.checkParameterIsNotNull(backendContext, "backendContext");
        this.topLevelNames = topLevelNames;
        this.backendContext = backendContext;
        WasmCodegenContext wasmCodegenContext = this;
        boolean bl = false;
        wasmCodegenContext.imports = list2 = (List)new ArrayList();
        this.localNames = MapsKt.emptyMap();
        wasmCodegenContext = this;
        bl = false;
        wasmCodegenContext.stringLiterals = list2 = (List)new ArrayList();
    }
}

