/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.FxmlPresenceListener;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationArtifactType;

public class JavaFxModuleUtil {
    public static boolean isInJavaFxProject(@NotNull PsiFile file) {
        Project project;
        if (file == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(0);
        }
        if (JavaFxModuleUtil.hasJavaFxArtifacts(project = file.getProject())) {
            return true;
        }
        return JavaFxModuleUtil.isInJavaFxModule(file);
    }

    private static boolean isInJavaFxModule(@NotNull PsiFile file) {
        Project project;
        Module fileModule;
        VirtualFile virtualFile;
        if (file == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(1);
        }
        if ((virtualFile = file.getVirtualFile()) != null && (fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)(project = file.getProject()))) != null) {
            return JavaFxModuleUtil.getCachedJavaFxModules(project).contains(fileModule);
        }
        return false;
    }

    @NotNull
    private static Set<Module> getCachedJavaFxModules(@NotNull Project project) {
        if (project == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(2);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Collection files = FileTypeIndex.getFiles((FileType)JavaFxFileTypeFactory.getFileType(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            Set modules = (Set)files.stream().filter(JavaFxFileTypeFactory::isFxml).map(file -> ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)).collect(Collectors.toCollection(THashSet::new));
            return CachedValueProvider.Result.create((Object)modules, (Object[])new Object[]{FxmlPresenceListener.getModificationTracker(project)});
        });
        if (set == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static boolean hasJavaFxArtifacts(@NotNull Project project) {
        if (project == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(4);
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
            Collection artifacts = artifactManager.getArtifactsByType((ArtifactType)JavaFxApplicationArtifactType.getInstance());
            return CachedValueProvider.Result.create((Object)(!artifacts.isEmpty() ? 1 : 0), (Object[])new Object[]{artifactManager.getModificationTracker()});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedJavaFxModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInJavaFxProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInJavaFxModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCachedJavaFxModules";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasJavaFxArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JavaFxDetectionStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                JavaFxDetectionStartupActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> JavaFxDetectionStartupActivity.populateCachedJavaFxModules(project))));
        }

        private static void populateCachedJavaFxModules(@NotNull Project project) {
            if (project == null) {
                JavaFxDetectionStartupActivity.$$$reportNull$$$0(1);
            }
            if (!project.isDisposed() && project.isOpen()) {
                JavaFxModuleUtil.hasJavaFxArtifacts(project);
                JavaFxModuleUtil.getCachedJavaFxModules(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$JavaFxDetectionStartupActivity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runActivity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "populateCachedJavaFxModules";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

