/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SourceLineCounterUtil;
import com.intellij.coverage.listeners.CoverageListener;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.JavaCoverageViewExtension;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.impl.source.tree.java.PsiSwitchStatementImpl;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.testIntegration.TestFramework;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import jetbrains.coverage.report.ReportGenerationFailedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JavaCoverageEngine
extends CoverageEngine {
    private static final Logger LOG = Logger.getInstance((String)JavaCoverageEngine.class.getName());

    public static JavaCoverageEngine getInstance() {
        return (JavaCoverageEngine)((Object)EP_NAME.findExtensionOrFail(JavaCoverageEngine.class));
    }

    public boolean isApplicableTo(@Nullable RunConfigurationBase conf) {
        if (conf instanceof CommonJavaRunConfigurationParameters) {
            return true;
        }
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.isApplicableTo(conf)) continue;
            return true;
        }
        return false;
    }

    public boolean canHavePerTestCoverage(@Nullable RunConfigurationBase conf) {
        return !(conf instanceof ApplicationConfiguration) && conf instanceof CommonJavaRunConfigurationParameters;
    }

    public Set<String> getTestsForLine(Project project, String classFQName, int lineNumber) {
        return JavaCoverageEngine.extractTracedTests(project, classFQName, lineNumber);
    }

    public boolean wasTestDataCollected(Project project) {
        File[] files = JavaCoverageEngine.getTraceFiles(project);
        return files != null && files.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> extractTracedTests(Project project, String classFQName, int lineNumber) {
        File[] traceFiles;
        HashSet<String> tests = new HashSet<String>();
        for (File traceFile : traceFiles = JavaCoverageEngine.getTraceFiles(project)) {
            FilterInputStream in = null;
            try {
                in = new DataInputStream(new FileInputStream(traceFile));
                JavaCoverageEngine.extractTests(traceFile, (DataInputStream)in, tests, classFQName, lineNumber);
            }
            catch (Exception ex) {
                LOG.error(traceFile.getName(), (Throwable)ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                }
            }
        }
        return tests;
    }

    private static void extractTests(File traceFile, DataInputStream in, Set<? super String> tests, String classFQName, int lineNumber) throws IOException {
        long traceSize = in.readInt();
        int i = 0;
        while ((long)i < traceSize) {
            String className = in.readUTF();
            int linesSize = in.readInt();
            for (int l = 0; l < linesSize; ++l) {
                int line = in.readInt();
                if (!Comparing.strEqual((String)className, (String)classFQName) || lineNumber != line) continue;
                tests.add(FileUtilRt.getNameWithoutExtension((String)traceFile.getName()));
                return;
            }
            ++i;
        }
    }

    private static File @Nullable [] getTraceFiles(Project project) {
        CoverageSuitesBundle currentSuite = CoverageDataManager.getInstance((Project)project).getCurrentSuitesBundle();
        if (currentSuite == null) {
            return null;
        }
        ArrayList files = new ArrayList();
        for (CoverageSuite coverageSuite : currentSuite.getSuites()) {
            File tracesDir = JavaCoverageEngine.getTracesDirectory(coverageSuite);
            File[] suiteFiles = tracesDir.listFiles();
            if (suiteFiles == null) continue;
            Collections.addAll(files, suiteFiles);
        }
        return files.isEmpty() ? null : files.toArray(new File[0]);
    }

    private static File getTracesDirectory(CoverageSuite coverageSuite) {
        String filePath = coverageSuite.getCoverageDataFileName();
        String dirName = FileUtilRt.getNameWithoutExtension((String)new File(filePath).getName());
        File parentDir = new File(filePath).getParentFile();
        return new File(parentDir, dirName);
    }

    public void collectTestLines(List<String> sanitizedTestNames, CoverageSuite suite, Map<String, Set<Integer>> executionTrace) {
        File tracesDir = JavaCoverageEngine.getTracesDirectory(suite);
        for (String testName : sanitizedTestNames) {
            File file = new File(tracesDir, testName + ".tr");
            if (!file.exists()) continue;
            try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
                int traceSize = in.readInt();
                for (int i = 0; i < traceSize; ++i) {
                    String className = in.readUTF();
                    int linesSize = in.readInt();
                    Set lines = executionTrace.computeIfAbsent(className, k -> new HashSet());
                    for (int l = 0; l < linesSize; ++l) {
                        lines.add(in.readInt());
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void deleteAssociatedTraces(CoverageSuite suite) {
        File tracesDirectory;
        if (suite.isTracingEnabled() && (tracesDirectory = JavaCoverageEngine.getTracesDirectory(suite)).exists()) {
            FileUtil.delete((File)tracesDirectory);
        }
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@Nullable RunConfigurationBase conf) {
        return new JavaCoverageEnabledConfiguration(conf, this);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        void project2;
        if (covRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JavaCoverageEngine.$$$reportNull$$$0(1);
        }
        if (coverageDataFileProvider == null) {
            JavaCoverageEngine.$$$reportNull$$$0(2);
        }
        return this.createSuite(covRunner, name, coverageDataFileProvider, filters, null, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, (Project)project2);
    }

    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (covRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(3);
        }
        if (name == null) {
            JavaCoverageEngine.$$$reportNull$$$0(4);
        }
        if (coverageDataFileProvider == null) {
            JavaCoverageEngine.$$$reportNull$$$0(5);
        }
        if (config == null) {
            JavaCoverageEngine.$$$reportNull$$$0(6);
        }
        if (config instanceof JavaCoverageEnabledConfiguration) {
            JavaCoverageEnabledConfiguration javaConfig = (JavaCoverageEnabledConfiguration)config;
            return this.createSuite(covRunner, name, coverageDataFileProvider, javaConfig.getPatterns(), javaConfig.getExcludePatterns(), new Date().getTime(), javaConfig.isTrackPerTestCoverage() && !javaConfig.isSampling(), !javaConfig.isSampling(), javaConfig.isTrackTestFolders(), config.getConfiguration().getProject());
        }
        return null;
    }

    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        if (coverageRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(7);
        }
        return new JavaCoverageSuite(this);
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(@NotNull Project project) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(8);
        }
        JavaCoverageAnnotator javaCoverageAnnotator = JavaCoverageAnnotator.getInstance(project);
        if (javaCoverageAnnotator == null) {
            JavaCoverageEngine.$$$reportNull$$$0(9);
        }
        return javaCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(10);
        }
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
        return module != null;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(11);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(12);
        }
        if ((virtualFile = psiFile.getVirtualFile()) == null) {
            return false;
        }
        Project project = psiFile.getProject();
        if (!suite.isTrackTestFolders() && ((Boolean)ReadAction.compute(() -> TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project))).booleanValue()) {
            return false;
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (psiFile instanceof PsiClassOwner && javaSuite.isPackageFiltered((String)ReadAction.compute(() -> ((PsiClassOwner)psiFile).getPackageName()))) {
                return true;
            }
            List<PsiClass> classes = javaSuite.getCurrentSuiteClasses(project);
            for (PsiClass aClass : classes) {
                PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiClass)aClass).getContainingFile());
                if (!psiFile.equals(containingFile)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            JavaCoverageEngine.$$$reportNull$$$0(13);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(14);
        }
        if (chooseSuiteAction == null) {
            JavaCoverageEngine.$$$reportNull$$$0(15);
        }
        VirtualFile outputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
        VirtualFile testOutputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPathForTests();
        if (outputpath == null && JavaCoverageEngine.isModuleOutputNeeded(module, JavaSourceRootType.SOURCE) || suite.isTrackTestFolders() && testOutputpath == null && JavaCoverageEngine.isModuleOutputNeeded(module, JavaSourceRootType.TEST_SOURCE)) {
            Project project = module.getProject();
            if (suite.isModuleChecked(module)) {
                return false;
            }
            suite.checkModule(module);
            Runnable runnable = () -> {
                if (Messages.showOkCancelDialog((String)JavaCoverageBundle.message("project.class.files.are.out.of.date", new Object[0]), (String)JavaCoverageBundle.message("project.is.out.of.date", new Object[0]), (Icon)Messages.getWarningIcon()) == 0) {
                    CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
                    compilerManager.make(compilerManager.createProjectCompileScope(project), (aborted, errors, warnings, compileContext) -> {
                        if (aborted || errors != 0) {
                            return;
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project.isDisposed()) {
                                return;
                            }
                            CoverageDataManager.getInstance((Project)project).chooseSuitesBundle(suite);
                        });
                    });
                } else if (!project.isDisposed()) {
                    CoverageDataManager.getInstance((Project)project).chooseSuitesBundle(null);
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable);
            return true;
        }
        return false;
    }

    private static boolean isModuleOutputNeeded(Module module, JavaSourceRootType rootType) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)module.getProject());
        return ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType).stream().anyMatch(vFile -> !compilerManager.isExcludedFromCompilation(vFile));
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        byte[] content;
        if (classFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(16);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(17);
        }
        try {
            content = FileUtil.loadFileBytes((File)classFile);
        }
        catch (IOException e) {
            return null;
        }
        ArrayList<Integer> uncoveredLines = new ArrayList<Integer>();
        try {
            SourceLineCounterUtil.collectSrcLinesForUntouchedFiles(uncoveredLines, content, suite.isTracingEnabled(), suite.getProject());
        }
        catch (Exception e) {
            LOG.error("Fail to process class from: " + classFile.getPath(), (Throwable)e);
        }
        return uncoveredLines;
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            JavaCoverageEngine.$$$reportNull$$$0(18);
        }
        if (outputFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(19);
        }
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(20);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(21);
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (!javaSuite.isClassFiltered(qualifiedName) && !javaSuite.isPackageFiltered(JavaCoverageEngine.getPackageName(sourceFile))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(22);
        }
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(23);
        }
        String packageFQName = JavaCoverageEngine.getPackageName(sourceFile);
        String string = StringUtil.getQualifiedName((String)packageFQName, (String)FileUtilRt.getNameWithoutExtension((String)outputFile.getName()));
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(25);
        }
        PsiClass[] classes = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)sourceFile).getClasses());
        HashSet<String> qNames = new HashSet<String>();
        for (JavaCoverageEngineExtension nameExtension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!((Boolean)ReadAction.compute(() -> nameExtension.suggestQualifiedName(sourceFile, classes, qNames))).booleanValue()) continue;
            HashSet<String> hashSet = qNames;
            if (hashSet == null) {
                JavaCoverageEngine.$$$reportNull$$$0(26);
            }
            return hashSet;
        }
        for (PsiClass aClass : classes) {
            String qName = (String)ReadAction.compute(() -> aClass.getQualifiedName());
            if (qName == null) continue;
            qNames.add(qName);
        }
        HashSet<String> hashSet = qNames;
        if (hashSet == null) {
            JavaCoverageEngine.$$$reportNull$$$0(27);
        }
        return hashSet;
    }

    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite) {
        PsiClass[] classes;
        File vDir;
        if (srcFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(28);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(29);
        }
        if (module == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                JavaCoverageEngine.$$$reportNull$$$0(30);
            }
            return set;
        }
        HashSet<File> classFiles = new HashSet<File>();
        VirtualFile outputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
        VirtualFile testOutputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPathForTests();
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.collectOutputFiles(srcFile, outputpath, testOutputpath, suite, classFiles)) continue;
            HashSet<File> hashSet = classFiles;
            if (hashSet == null) {
                JavaCoverageEngine.$$$reportNull$$$0(31);
            }
            return hashSet;
        }
        String packageFQName = JavaCoverageEngine.getPackageName(srcFile);
        String packageVmName = packageFQName.replace('.', '/');
        ArrayList children = new ArrayList();
        File file = outputpath == null ? null : (vDir = !packageVmName.isEmpty() ? new File(outputpath.getPath() + File.separator + packageVmName) : VfsUtilCore.virtualToIoFile((VirtualFile)outputpath));
        if (vDir != null && vDir.exists()) {
            Collections.addAll(children, vDir.listFiles());
        }
        if (suite.isTrackTestFolders()) {
            File testDir;
            File file2 = testOutputpath == null ? null : (testDir = !packageVmName.isEmpty() ? new File(testOutputpath.getPath() + File.separator + packageVmName) : VfsUtilCore.virtualToIoFile((VirtualFile)testOutputpath));
            if (testDir != null && testDir.exists()) {
                Collections.addAll(children, testDir.listFiles());
            }
        }
        for (PsiClass psiClass : classes = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)srcFile).getClasses())) {
            String className = (String)ReadAction.compute(() -> psiClass.getName());
            for (File child : children) {
                String childName;
                if (!FileUtilRt.extensionEquals((String)child.getName(), (String)JavaClassFileType.INSTANCE.getDefaultExtension()) || !(childName = FileUtilRt.getNameWithoutExtension((String)child.getName())).equals(className) && (!childName.startsWith(className) || childName.charAt(className.length()) != '$')) continue;
                classFiles.add(child);
            }
        }
        HashSet<File> hashSet = classFiles;
        if (hashSet == null) {
            JavaCoverageEngine.$$$reportNull$$$0(32);
        }
        return hashSet;
    }

    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor == null) {
            JavaCoverageEngine.$$$reportNull$$$0(33);
        }
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(34);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Hits: ");
        if (lineData == null) {
            buf.append(0);
            return buf.toString();
        }
        buf.append(lineData.getHits()).append("\n");
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            String report = extension.generateBriefReport(editor, psiFile, lineNumber, startOffset, endOffset, lineData);
            if (report == null) continue;
            buf.append(report);
            return report;
        }
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        Project project = editor.getProject();
        for (int offset = startOffset; offset < endOffset; ++offset) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), PsiStatement.class);
            PsiExpression condition = null;
            if (parent instanceof PsiIfStatement) {
                condition = ((PsiIfStatement)parent).getCondition();
            } else if (parent instanceof PsiSwitchStatement) {
                condition = ((PsiSwitchStatement)parent).getExpression();
            } else if (parent instanceof PsiConditionalLoopStatement) {
                condition = ((PsiConditionalLoopStatement)parent).getCondition();
            } else if (parent instanceof PsiForeachStatement) {
                condition = ((PsiForeachStatement)parent).getIteratedValue();
            } else if (parent instanceof PsiAssertStatement) {
                condition = ((PsiAssertStatement)parent).getAssertCondition();
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)psiFile.findElementAt(offset), (boolean)false)) continue;
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance((Project)project).getControlFlow(parent, (ControlFlowPolicy)AllVariablesControlFlowPolicy.getInstance());
                for (Instruction instruction : controlFlow.getInstructions()) {
                    PsiExpression psiExpression;
                    if (!(instruction instanceof ConditionalBranchingInstruction) || expressions.contains(psiExpression = ((ConditionalBranchingInstruction)instruction).expression)) continue;
                    expressions.add(psiExpression);
                }
                continue;
            }
            catch (AnalysisCanceledException e) {
                return buf.toString();
            }
        }
        try {
            int idx = 0;
            int hits = 0;
            String indent = "    ";
            if (lineData.getJumps() != null) {
                for (JumpData jumpData : lineData.getJumps()) {
                    PsiExpression expression;
                    PsiElement parentExpression;
                    JumpData jumpData2 = jumpData;
                    if (jumpData2.getTrueHits() + jumpData2.getFalseHits() <= 0) continue;
                    boolean reverse = (parentExpression = (expression = (PsiExpression)expressions.get(idx++)).getParent()) instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parentExpression).getOperationTokenType() == JavaTokenType.OROR || parentExpression instanceof PsiDoWhileStatement || parentExpression instanceof PsiAssertStatement;
                    buf.append("    ").append(expression.getText()).append("\n");
                    buf.append("    ").append("    ").append("true hits: ").append(reverse ? jumpData2.getFalseHits() : jumpData2.getTrueHits()).append("\n");
                    buf.append("    ").append("    ").append("false hits: ").append(reverse ? jumpData2.getTrueHits() : jumpData2.getFalseHits()).append("\n");
                    hits += jumpData2.getTrueHits() + jumpData2.getFalseHits();
                }
            }
            if (lineData.getSwitches() != null) {
                for (JumpData jumpData : lineData.getSwitches()) {
                    SwitchData switchData = (SwitchData)jumpData;
                    PsiExpression conditionExpression = (PsiExpression)expressions.get(idx++);
                    buf.append("    ").append(conditionExpression.getText()).append("\n");
                    int i = 0;
                    for (int key : switchData.getKeys()) {
                        int switchHits = switchData.getHits()[i++];
                        buf.append("    ").append("    ").append("case ").append(key).append(": ").append(switchHits).append("\n");
                        hits += switchHits;
                    }
                    int defaultHits = switchData.getDefaultHits();
                    boolean hasDefaultLabel = JavaCoverageEngine.hasDefaultLabel((PsiElement)conditionExpression);
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    if (!hasDefaultLabel) {
                        defaultHits -= hits;
                    }
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    buf.append("    ").append("    ").append("default: ").append(defaultHits).append("\n");
                    hits += defaultHits;
                }
            }
            if (lineData.getHits() > hits && hits > 0) {
                buf.append("Unknown outcome: ").append(lineData.getHits() - hits);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return "Hits: " + lineData.getHits();
        }
        return buf.toString();
    }

    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        String qualifiedName;
        PsiMethod method;
        PsiClass aClass;
        if (element == null) {
            JavaCoverageEngine.$$$reportNull$$$0(35);
        }
        if (testProxy == null) {
            JavaCoverageEngine.$$$reportNull$$$0(36);
        }
        if (element instanceof PsiMethod && (aClass = (method = (PsiMethod)element).getContainingClass()) != null && (qualifiedName = ClassUtil.getJVMClassName((PsiClass)aClass)) != null) {
            return qualifiedName + "," + CoverageListener.sanitize((String)method.getName(), (int)qualifiedName.length());
        }
        return testProxy.toString();
    }

    @NotNull
    public List<PsiElement> findTestsByNames(String @NotNull [] testNames, @NotNull Project project) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(37);
        }
        if (testNames == null) {
            JavaCoverageEngine.$$$reportNull$$$0(38);
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (String testName : testNames) {
            int index = testName.indexOf(",");
            if (index <= 0) {
                ArrayList<PsiElement> arrayList = elements;
                if (arrayList == null) {
                    JavaCoverageEngine.$$$reportNull$$$0(39);
                }
                return arrayList;
            }
            JavaCoverageEngine.collectTestsByName(elements, testName.substring(index + 1), testName.substring(0, index), psiManager);
        }
        ArrayList<PsiElement> arrayList = elements;
        if (arrayList == null) {
            JavaCoverageEngine.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    private static void collectTestsByName(List<? super PsiElement> elements, String testName, String className, PsiManager psiManager) {
        PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)psiManager, (String)className);
        if (psiClass == null) {
            return;
        }
        TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
        if (testFramework == null) {
            return;
        }
        Arrays.stream(psiClass.getAllMethods()).filter(method -> testFramework.isTestMethod((PsiElement)method) && testName.equals(CoverageListener.sanitize((String)method.getName(), (int)className.length()))).forEach(elements::add);
    }

    private static boolean hasDefaultLabel(PsiElement conditionExpression) {
        PsiElement bodyElement;
        boolean hasDefault = false;
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)conditionExpression, PsiSwitchStatement.class);
        PsiCodeBlock body = ((PsiSwitchStatementImpl)conditionExpression.getParent()).getBody();
        if (body != null && (bodyElement = body.getFirstBodyElement()) != null) {
            PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)bodyElement, PsiSwitchLabelStatement.class);
            while (label != null) {
                if (label.getEnclosingSwitchStatement() == switchStatement) {
                    hasDefault |= label.isDefaultCase();
                }
                label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiSwitchLabelStatement.class);
            }
        }
        return hasDefault;
    }

    protected JavaCoverageSuite createSuite(CoverageRunner acceptedCovRunner, String name, CoverageFileProvider coverageDataFileProvider, String[] filters, String[] excludePatterns, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        return new JavaCoverageSuite(name, coverageDataFileProvider, filters, excludePatterns, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, acceptedCovRunner, this, project);
    }

    @NotNull
    protected static String getPackageName(PsiFile sourceFile) {
        String string = (String)ReadAction.compute(() -> ((PsiClassOwner)sourceFile).getPackageName());
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(41);
        }
        return string;
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        Sdk projectSdk;
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(42);
        }
        if (dataContext == null) {
            JavaCoverageEngine.$$$reportNull$$$0(43);
        }
        if (currentSuite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(44);
        }
        return (projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null;
    }

    public final void generateReport(final @NotNull Project project, @NotNull DataContext dataContext, final @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(45);
        }
        if (dataContext == null) {
            JavaCoverageEngine.$$$reportNull$$$0(46);
        }
        if (currentSuite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(47);
        }
        final ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaCoverageBundle.message("generating.coverage.report", new Object[0])){
            final Exception[] myExceptions;
            {
                super(arg0, arg1);
                this.myExceptions = new Exception[1];
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    ((JavaCoverageRunner)currentSuite.getSuites()[0].getRunner()).generateReport(currentSuite, project);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (ReportGenerationFailedException e) {
                    this.myExceptions[0] = e;
                }
            }

            public void onSuccess() {
                if (this.myExceptions[0] != null) {
                    Messages.showErrorDialog((Project)project, (String)this.myExceptions[0].getMessage(), (String)CommonBundle.getErrorTitle());
                    return;
                }
                if (settings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)new File(settings.OUTPUT_DIRECTORY, "index.html"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coverage/JavaCoverageEngine$1", "run"));
            }
        });
    }

    public String getPresentableText() {
        return "Java Coverage";
    }

    public boolean isGeneratedCode(Project project, String qualifiedName, Object lineData) {
        if (JavaCoverageOptionsProvider.getInstance(project).isGeneratedConstructor(qualifiedName, ((LineData)lineData).getMethodSignature())) {
            return true;
        }
        return super.isGeneratedCode(project, qualifiedName, lineData);
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return new JavaCoverageViewExtension((JavaCoverageAnnotator)this.getCoverageAnnotator(project), project, suiteBundle, stateBean);
    }

    public static boolean isSourceMapNeeded(RunConfigurationBase configuration) {
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.isSourceMapNeeded(configuration)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageRunner";
                break;
            }
            case 8: 
            case 37: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/JavaCoverageEngine";
                break;
            }
            case 10: 
            case 11: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseSuiteAction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/JavaCoverageEngine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageAnnotator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingOutputFiles";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsByNames";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyCoverageSuite";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageAnnotator";
                break;
            }
            case 9: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "recompileProjectAndRerunAction";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOutputFiles";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodName";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findTestsByNames";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

