/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            StructuralSearchAction.$$$reportNull$$$0(0);
        }
        StructuralSearchAction.triggerAction(null, new SearchContext(event.getDataContext()), false);
    }

    public static void triggerAction(Configuration config, SearchContext searchContext, boolean replace) {
        Project project = searchContext.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DialogWrapper dialog = StructuralSearchPlugin.getInstance(project).getDialog();
        if (dialog != null) {
            assert (!dialog.isDisposed() && dialog.isVisible());
            JComponent component = dialog.getPreferredFocusedComponent();
            assert (component != null);
            IdeFocusManager.getInstance((Project)project).requestFocus((Component)component, true);
            return;
        }
        StructuralSearchDialog searchDialog = new StructuralSearchDialog(searchContext, replace);
        if (config != null) {
            searchDialog.setUseLastConfiguration(true);
            searchDialog.loadConfiguration(config);
        }
        searchDialog.show();
    }

    public void update(@NotNull AnActionEvent event) {
        StructuralSearchPlugin plugin;
        if (event == null) {
            StructuralSearchAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Project project = event.getProject();
        StructuralSearchPlugin structuralSearchPlugin = plugin = project == null ? null : StructuralSearchPlugin.getInstance(project);
        if (plugin == null || plugin.isSearchInProgress()) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/structuralsearch/plugin/StructuralSearchAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

