/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import java.util.HashMap;
import java.util.Map;

public class DocumentBasedReplaceHandler
extends StructuralReplaceHandler {
    private final Project myProject;
    private final Map<ReplacementInfo, RangeMarker> myRangeMarkers = new HashMap<ReplacementInfo, RangeMarker>();

    public DocumentBasedReplaceHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void replace(ReplacementInfo info, ReplaceOptions options) {
        RangeMarker rangeMarker = this.myRangeMarkers.get(info);
        Document document = rangeMarker.getDocument();
        document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)info.getReplacement());
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
    }

    @Override
    public void prepare(ReplacementInfo info) {
        PsiElement firstElement = StructuralSearchUtil.getPresentableElement(info.getMatch(0));
        if (firstElement == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(firstElement.getContainingFile());
        assert (document != null);
        TextRange range = firstElement.getTextRange();
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int count = info.getMatchesCount();
        for (int i = 1; i < count; ++i) {
            PsiElement match = info.getMatch(i);
            if (match == null) continue;
            TextRange range1 = match.getTextRange();
            startOffset = Math.min(startOffset, range1.getStartOffset());
            endOffset = Math.max(endOffset, range1.getEndOffset());
        }
        RangeMarker rangeMarker = document.createRangeMarker(startOffset, endOffset);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        this.myRangeMarkers.put(info, rangeMarker);
    }
}

