/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\n2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\n2\u0006\u0010\f\u001a\u00020\tR \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "missingClassifiers", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "", "doGetMissingClassifiers", "descriptor", "getMissingSuperClassifiers", "frontend"})
public final class MissingSupertypesResolver {
    private final MemoizedFunctionToNotNull<ClassifierDescriptor, Set<ClassifierDescriptor>> missingClassifiers;
    private final ModuleDescriptor moduleDescriptor;

    @NotNull
    public final Set<ClassifierDescriptor> getMissingSuperClassifiers(@NotNull ClassifierDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return (Set)this.missingClassifiers.invoke(descriptor2);
    }

    private final Set<ClassifierDescriptor> doGetMissingClassifiers(ClassifierDescriptor descriptor2) {
        boolean bl = false;
        Set missingSuperClassifiers = new LinkedHashSet();
        SimpleType simpleType2 = descriptor2.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"descriptor.defaultType");
        SimpleType type2 = simpleType2;
        for (KotlinType supertype : TypeUtilsKt.supertypes(type2)) {
            ClassId superTypeClassId;
            ClassifierDescriptor supertypeDeclaration = supertype.getConstructor().getDeclarationDescriptor();
            if (!(supertypeDeclaration instanceof ClassDescriptor) || ((ClassDescriptor)supertypeDeclaration).isExpect() || Intrinsics.areEqual((Object)((ClassDescriptor)supertypeDeclaration).getVisibility(), (Object)Visibilities.LOCAL)) continue;
            if (DescriptorUtilsKt.getClassId(supertypeDeclaration) == null) {
                continue;
            }
            ClassDescriptor dependency = FindClassInModuleKt.findClassAcrossModuleDependencies(this.moduleDescriptor, superTypeClassId);
            if (dependency != null && !(dependency instanceof NotFoundClasses.MockClassDescriptor)) continue;
            missingSuperClassifiers.add(supertypeDeclaration);
        }
        return CollectionsKt.toSet((Iterable)missingSuperClassifiers);
    }

    public MissingSupertypesResolver(@NotNull StorageManager storageManager, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        this.moduleDescriptor = moduleDescriptor;
        this.missingClassifiers = storageManager.createMemoizedFunction((Function1)new Function1<ClassifierDescriptor, Set<? extends ClassifierDescriptor>>(this){
            final /* synthetic */ MissingSupertypesResolver this$0;

            @NotNull
            public final Set<ClassifierDescriptor> invoke(@NotNull ClassifierDescriptor classifier) {
                Intrinsics.checkParameterIsNotNull((Object)classifier, (String)"classifier");
                return MissingSupertypesResolver.access$doGetMissingClassifiers(this.this$0, classifier);
            }
            {
                this.this$0 = missingSupertypesResolver;
                super(1);
            }
        });
    }

    public static final /* synthetic */ Set access$doGetMissingClassifiers(MissingSupertypesResolver $this, ClassifierDescriptor descriptor2) {
        return $this.doGetMissingClassifiers(descriptor2);
    }
}

