/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.postProcessing.processings;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.nj2k.postProcessing.InspectionLikeProcessingForElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/nj2k/postProcessing/processings/RemoveRedundantVisibilityModifierProcessing;", "Lorg/jetbrains/kotlin/nj2k/postProcessing/InspectionLikeProcessingForElement;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "()V", "apply", "", "element", "isApplicableTo", "", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "nj2k-services"})
public final class RemoveRedundantVisibilityModifierProcessing
extends InspectionLikeProcessingForElement<KtDeclaration> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApplicableTo(@NotNull KtDeclaration element3, @Nullable ConverterSettings settings2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3.hasModifier(KtTokens.PUBLIC_KEYWORD) && element3.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return false;
        }
        if (element3.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element3);
            if (ktClassOrObject != null) {
                if (ktClassOrObject.isLocal()) {
                    return true;
                }
            }
        }
        if (!Intrinsics.areEqual((Object)((Object)KtPsiUtilKt.visibilityModifierType(element3)), (Object)((Object)PsiModificationUtilsKt.implicitVisibility(element3)))) return false;
        return true;
    }

    @Override
    protected void apply(@NotNull KtDeclaration element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtModifierKeywordToken ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierType(element3);
        if (ktModifierKeywordToken == null) {
            return;
        }
        element3.removeModifier(ktModifierKeywordToken);
    }

    public RemoveRedundantVisibilityModifierProcessing() {
        super(KtDeclaration.class);
    }
}

