/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeImpl;
import org.jetbrains.kotlin.load.java.typeEnhancement.EnhancedTypeAnnotations;
import org.jetbrains.kotlin.load.java.typeEnhancement.EnhancementResult;
import org.jetbrains.kotlin.load.java.typeEnhancement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhancement.MutabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.NotNullTypeParameter;
import org.jetbrains.kotlin.load.java.typeEnhancement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.Result;
import org.jetbrains.kotlin.load.java.typeEnhancement.SimpleResult;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeComponentPosition;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt$WhenMappings;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContext;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.SimpleClassicTypeSystemContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u0005H\u0002\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u001a0\u0010\f\u001a\u00020\r*\u00020\u000e2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u00142\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a(\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\nH\u0002\u001a\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0013\"\u0004\b\u0000\u0010\u0019*\u0002H\u0019H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0013\"\u0004\b\u0000\u0010\u0019*\u0002H\u0019H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0013*\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\n\u0010\u001e\u001a\u00020\u001d*\u00020\u0007\u001a\u0012\u0010\u001e\u001a\u00020\u001d*\u00020\u001f2\u0006\u0010 \u001a\u00020!\u001a\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0013\"\u0004\b\u0000\u0010\u0019*\u0002H\u0019H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\n\u0010#\u001a\u00020\u001d*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"ENHANCED_MUTABILITY_ANNOTATIONS", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancedTypeAnnotations;", "ENHANCED_NULLABILITY_ANNOTATIONS", "compositeAnnotationsOrSingle", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "", "enhance", "Lorg/jetbrains/kotlin/types/KotlinType;", "qualifiers", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeQualifiers;", "enhanceInflexible", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/SimpleResult;", "Lorg/jetbrains/kotlin/types/SimpleType;", "index", "position", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/TypeComponentPosition;", "enhanceMutability", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancementResult;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "enhancePossiblyFlexible", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/Result;", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "enhancedMutability", "T", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancementResult;", "enhancedNullability", "getEnhancedNullability", "", "hasEnhancedNullability", "Lorg/jetbrains/kotlin/types/TypeSystemCommonBackendContext;", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "noChange", "shouldEnhance", "descriptors.jvm"})
public final class TypeEnhancementKt {
    private static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    @Nullable
    public static final KotlinType enhance(@NotNull KotlinType $this$enhance, @NotNull Function1<? super Integer, JavaTypeQualifiers> qualifiers) {
        Intrinsics.checkParameterIsNotNull((Object)$this$enhance, (String)"$this$enhance");
        Intrinsics.checkParameterIsNotNull(qualifiers, (String)"qualifiers");
        return TypeEnhancementKt.enhancePossiblyFlexible($this$enhance.unwrap(), qualifiers, 0).getTypeIfChanged();
    }

    public static final boolean hasEnhancedNullability(@NotNull KotlinType $this$hasEnhancedNullability) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasEnhancedNullability, (String)"$this$hasEnhancedNullability");
        return TypeEnhancementKt.hasEnhancedNullability(SimpleClassicTypeSystemContext.INSTANCE, $this$hasEnhancedNullability);
    }

    public static final boolean hasEnhancedNullability(@NotNull TypeSystemCommonBackendContext $this$hasEnhancedNullability, @NotNull KotlinTypeMarker type2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasEnhancedNullability, (String)"$this$hasEnhancedNullability");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        return $this$hasEnhancedNullability.hasAnnotation(type2, fqName2);
    }

    private static final Result enhancePossiblyFlexible(@NotNull UnwrappedType $this$enhancePossiblyFlexible, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index2) {
        Result result2;
        if (KotlinTypeKt.isError($this$enhancePossiblyFlexible)) {
            return new Result($this$enhancePossiblyFlexible, 1, false);
        }
        UnwrappedType unwrappedType2 = $this$enhancePossiblyFlexible;
        if (unwrappedType2 instanceof FlexibleType) {
            KotlinType enhancement2;
            SimpleResult lowerResult = TypeEnhancementKt.enhanceInflexible(((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound(), qualifiers, index2, TypeComponentPosition.FLEXIBLE_LOWER);
            SimpleResult upperResult = TypeEnhancementKt.enhanceInflexible(((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound(), qualifiers, index2, TypeComponentPosition.FLEXIBLE_UPPER);
            boolean bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-TypeEnhancementKt$enhancePossiblyFlexible$22 = false;
                String $i$a$-assert-TypeEnhancementKt$enhancePossiblyFlexible$22 = "Different tree sizes of bounds: " + "lower = (" + ((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), " + "upper = (" + ((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound() + ", " + upperResult.getSubtreeSize() + ')';
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TypeEnhancementKt$enhancePossiblyFlexible$22));
            }
            boolean wereChanges = lowerResult.getWereChanges() || upperResult.getWereChanges();
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancement(lowerResult.getType());
            if (kotlinType == null) {
                kotlinType = enhancement2 = TypeWithEnhancementKt.getEnhancement(upperResult.getType());
            }
            UnwrappedType type2 = !wereChanges ? $this$enhancePossiblyFlexible : TypeWithEnhancementKt.wrapEnhancement($this$enhancePossiblyFlexible instanceof RawTypeImpl ? (UnwrappedType)new RawTypeImpl(lowerResult.getType(), upperResult.getType()) : KotlinTypeFactory.flexibleType(lowerResult.getType(), upperResult.getType()), enhancement2);
            result2 = new Result(type2, lowerResult.getSubtreeSize(), wereChanges);
        } else if (unwrappedType2 instanceof SimpleType) {
            result2 = TypeEnhancementKt.enhanceInflexible((SimpleType)$this$enhancePossiblyFlexible, qualifiers, index2, TypeComponentPosition.INFLEXIBLE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final SimpleResult enhanceInflexible(@NotNull SimpleType $this$enhanceInflexible, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index2, TypeComponentPosition position2) {
        UnwrappedType result2;
        void enhancedNullability;
        EnhancementResult<Boolean> $this$mapIndexedTo$iv$iv;
        void enhancedClassifier;
        boolean shouldEnhance = TypeEnhancementKt.shouldEnhance(position2);
        if (!shouldEnhance && $this$enhanceInflexible.getArguments().isEmpty()) {
            return new SimpleResult($this$enhanceInflexible, 1, false);
        }
        ClassifierDescriptor classifierDescriptor = $this$enhanceInflexible.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new SimpleResult($this$enhanceInflexible, 1, false);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"constructor.declarationD\u2026pleResult(this, 1, false)");
        ClassifierDescriptor originalClass = classifierDescriptor;
        JavaTypeQualifiers effectiveQualifiers = (JavaTypeQualifiers)qualifiers.invoke((Object)index2);
        EnhancementResult<ClassifierDescriptor> enhancementResult2 = TypeEnhancementKt.enhanceMutability(originalClass, effectiveQualifiers, position2);
        ClassifierDescriptor classifierDescriptor2 = enhancementResult2.component1();
        Annotations enhancedMutabilityAnnotations = enhancementResult2.component2();
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"enhancedClassifier.typeConstructor");
        TypeConstructor typeConstructor3 = typeConstructor2;
        int globalArgIndex = index2 + 1;
        boolean wereChanges = enhancedMutabilityAnnotations != null;
        Iterable $this$mapIndexed$iv22 = $this$enhanceInflexible.getArguments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv22, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        Iterator iterator2 = $this$mapIndexedTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeProjection typeProjection;
            void localArgIndex;
            void arg;
            Object item$iv$iv = iterator2.next();
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl2 = false;
            if (arg.isStarProjection()) {
                int n4 = globalArgIndex;
                globalArgIndex = n4 + 1;
                TypeConstructor typeConstructor4 = enhancedClassifier.getTypeConstructor();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor4, (String)"enhancedClassifier.typeConstructor");
                typeProjection = TypeUtils.makeStarProjection(typeConstructor4.getParameters().get((int)localArgIndex));
            } else {
                Result enhanced = TypeEnhancementKt.enhancePossiblyFlexible(arg.getType().unwrap(), qualifiers, globalArgIndex);
                wereChanges = wereChanges || enhanced.getWereChanges();
                globalArgIndex += enhanced.getSubtreeSize();
                KotlinType kotlinType = enhanced.getType();
                Variance variance = arg.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance), (String)"arg.projectionKind");
                typeProjection = TypeUtilsKt.createProjection(kotlinType, variance, typeConstructor3.getParameters().get((int)localArgIndex));
            }
            TypeProjection typeProjection3 = typeProjection;
            collection2.add(typeProjection3);
        }
        List enhancedArguments = (List)destination$iv$iv;
        $this$mapIndexedTo$iv$iv = TypeEnhancementKt.getEnhancedNullability($this$enhanceInflexible, effectiveQualifiers, position2);
        boolean $this$mapIndexed$iv22 = $this$mapIndexedTo$iv$iv.component1();
        Annotations enhancedNullabilityAnnotations = $this$mapIndexedTo$iv$iv.component2();
        wereChanges = wereChanges || enhancedNullabilityAnnotations != null;
        int subtreeSize = globalArgIndex - index2;
        if (!wereChanges) {
            return new SimpleResult($this$enhanceInflexible, subtreeSize, false);
        }
        Annotations newAnnotations = TypeEnhancementKt.compositeAnnotationsOrSingle(CollectionsKt.listOfNotNull((Object[])new Annotations[]{$this$enhanceInflexible.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations}));
        SimpleType enhancedType = KotlinTypeFactory.simpleType$default(newAnnotations, typeConstructor3, enhancedArguments, (boolean)enhancedNullability, null, 16, null);
        SimpleType enhancement2 = effectiveQualifiers.isNotNullTypeParameter() ? (SimpleType)new NotNullTypeParameter(enhancedType) : enhancedType;
        boolean nullabilityForWarning = enhancedNullabilityAnnotations != null && effectiveQualifiers.isNullabilityQualifierForWarning();
        UnwrappedType unwrappedType2 = result2 = nullabilityForWarning ? TypeWithEnhancementKt.wrapEnhancement($this$enhanceInflexible, enhancement2) : (UnwrappedType)enhancement2;
        if (unwrappedType2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        }
        return new SimpleResult((SimpleType)unwrappedType2, subtreeSize, true);
    }

    private static final Annotations compositeAnnotationsOrSingle(@NotNull List<? extends Annotations> $this$compositeAnnotationsOrSingle) {
        Annotations annotations2;
        switch ($this$compositeAnnotationsOrSingle.size()) {
            case 0: {
                String string = "At least one Annotations object expected";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 1: {
                annotations2 = (Annotations)CollectionsKt.single($this$compositeAnnotationsOrSingle);
                break;
            }
            default: {
                annotations2 = new CompositeAnnotations(CollectionsKt.toList((Iterable)$this$compositeAnnotationsOrSingle));
            }
        }
        return annotations2;
    }

    public static final boolean shouldEnhance(@NotNull TypeComponentPosition $this$shouldEnhance) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$shouldEnhance), (String)"$this$shouldEnhance");
        return $this$shouldEnhance != TypeComponentPosition.INFLEXIBLE;
    }

    private static final <T> EnhancementResult<T> noChange(T $this$noChange) {
        return new EnhancementResult<T>($this$noChange, null);
    }

    private static final <T> EnhancementResult<T> enhancedNullability(T $this$enhancedNullability) {
        return new EnhancementResult<T>($this$enhancedNullability, ENHANCED_NULLABILITY_ANNOTATIONS);
    }

    private static final <T> EnhancementResult<T> enhancedMutability(T $this$enhancedMutability) {
        return new EnhancementResult<T>($this$enhancedMutability, ENHANCED_MUTABILITY_ANNOTATIONS);
    }

    private static final EnhancementResult<ClassifierDescriptor> enhanceMutability(@NotNull ClassifierDescriptor $this$enhanceMutability, JavaTypeQualifiers qualifiers, TypeComponentPosition position2) {
        if (!TypeEnhancementKt.shouldEnhance(position2)) {
            return TypeEnhancementKt.noChange($this$enhanceMutability);
        }
        if (!($this$enhanceMutability instanceof ClassDescriptor)) {
            return TypeEnhancementKt.noChange($this$enhanceMutability);
        }
        JavaToKotlinClassMap mapping2 = JavaToKotlinClassMap.INSTANCE;
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        if (mutabilityQualifier != null) {
            switch (TypeEnhancementKt$WhenMappings.$EnumSwitchMapping$0[mutabilityQualifier.ordinal()]) {
                case 1: {
                    if (position2 != TypeComponentPosition.FLEXIBLE_LOWER || !mapping2.isMutable((ClassDescriptor)$this$enhanceMutability)) break;
                    return TypeEnhancementKt.enhancedMutability(mapping2.convertMutableToReadOnly((ClassDescriptor)$this$enhanceMutability));
                }
                case 2: {
                    if (position2 != TypeComponentPosition.FLEXIBLE_UPPER || !mapping2.isReadOnly((ClassDescriptor)$this$enhanceMutability)) break;
                    return TypeEnhancementKt.enhancedMutability(mapping2.convertReadOnlyToMutable((ClassDescriptor)$this$enhanceMutability));
                }
            }
        }
        return TypeEnhancementKt.noChange($this$enhanceMutability);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final EnhancementResult<Boolean> getEnhancedNullability(@NotNull KotlinType $this$getEnhancedNullability, JavaTypeQualifiers qualifiers, TypeComponentPosition position2) {
        EnhancementResult<Boolean> enhancementResult2;
        if (!TypeEnhancementKt.shouldEnhance(position2)) {
            return TypeEnhancementKt.noChange($this$getEnhancedNullability.isMarkedNullable());
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        if (nullabilityQualifier != null) {
            switch (TypeEnhancementKt$WhenMappings.$EnumSwitchMapping$1[nullabilityQualifier.ordinal()]) {
                case 1: {
                    enhancementResult2 = TypeEnhancementKt.enhancedNullability(true);
                    return enhancementResult2;
                }
                case 2: {
                    enhancementResult2 = TypeEnhancementKt.enhancedNullability(false);
                    return enhancementResult2;
                }
            }
        }
        enhancementResult2 = TypeEnhancementKt.noChange($this$getEnhancedNullability.isMarkedNullable());
        return enhancementResult2;
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        FqName fqName3 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName3);
    }
}

