/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/util/ProgressIndicatorUtils;", "", "()V", "awaitWithCheckCanceled", "T", "future", "Ljava/util/concurrent/Future;", "(Ljava/util/concurrent/Future;)Ljava/lang/Object;", "checkCancelledEvenWithPCEDisabled", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/progress/ProgressIndicator;)Lkotlin/Unit;", "idea"})
public final class ProgressIndicatorUtils {
    public static final ProgressIndicatorUtils INSTANCE;

    @JvmStatic
    public static final <T> T awaitWithCheckCanceled(@NotNull Future<T> future) {
        Intrinsics.checkParameterIsNotNull(future, (String)"future");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator indicator = progressManager.getProgressIndicator();
        while (true) {
            INSTANCE.checkCancelledEvenWithPCEDisabled(indicator);
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof CancellationException) {
                    throw (Throwable)new ProcessCanceledException(cause);
                }
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw (Throwable)new RuntimeException(e);
            }
            break;
        }
    }

    private final Unit checkCancelledEvenWithPCEDisabled(ProgressIndicator indicator) {
        Unit unit;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            ProgressIndicator progressIndicator2 = progressIndicator;
            boolean bl = false;
            boolean bl2 = false;
            ProgressIndicator it = progressIndicator2;
            boolean bl3 = false;
            if (it.isCanceled()) {
                it.checkCanceled();
                throw (Throwable)new ProcessCanceledException();
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private ProgressIndicatorUtils() {
    }

    static {
        ProgressIndicatorUtils progressIndicatorUtils;
        INSTANCE = progressIndicatorUtils = new ProgressIndicatorUtils();
    }
}

