/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForExistingElement;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.Mover;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0012J*\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'2\b\u0010(\u001a\u0004\u0018\u00010)H$J\b\u0010*\u001a\u00020\u0002H\u0016J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\rH\u0016J\b\u0010,\u001a\u00020-H\u0002J\n\u0010.\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010/\u001a\u00020\bH\u0002R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0019R\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesToUpperLevelModel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/Model;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "innerClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "target", "Lcom/intellij/psi/PsiElement;", "parameter", "", "className", "passOuterClass", "", "searchInComments", "isSearchInNonJavaFiles", "packageName", "isOpenInEditor", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Ljava/lang/String;ZZZLjava/lang/String;Z)V", "getClassName", "()Ljava/lang/String;", "getInnerClass", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "innerClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "()Z", "getPackageName", "getParameter", "getPassOuterClass", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSearchInComments", "getTarget", "()Lcom/intellij/psi/PsiElement;", "chooseSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "newPackage", "Lcom/intellij/refactoring/PackageWrapper;", "contentSourceRoots", "", "initialDir", "Lcom/intellij/psi/PsiDirectory;", "computeModelResult", "throwOnConflicts", "getMoveTarget", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/KotlinMoveTarget;", "getTargetContainer", "getTargetContainerWithValidation", "idea"})
public abstract class MoveKotlinNestedClassesToUpperLevelModel
implements Model<MoveKotlinDeclarationsProcessor> {
    private final ClassDescriptor innerClassDescriptor;
    @NotNull
    private final Project project;
    @NotNull
    private final KtClassOrObject innerClass;
    @NotNull
    private final PsiElement target;
    @Nullable
    private final String parameter;
    @NotNull
    private final String className;
    private final boolean passOuterClass;
    private final boolean searchInComments;
    private final boolean isSearchInNonJavaFiles;
    @NotNull
    private final String packageName;
    private final boolean isOpenInEditor;

    @Nullable
    protected abstract VirtualFile chooseSourceRoot(@NotNull PackageWrapper var1, @NotNull List<? extends VirtualFile> var2, @Nullable PsiDirectory var3);

    /*
     * WARNING - void declaration
     */
    private final PsiElement getTargetContainer() {
        if (this.target instanceof PsiDirectory) {
            FqName oldPackageFqName = MoveUtilsKt.getTargetPackageFqName(this.target);
            String targetName = this.packageName;
            FqName fqName2 = oldPackageFqName;
            if (!Comparing.equal((String)(fqName2 != null ? fqName2.asString() : null), (String)targetName)) {
                void directory;
                Ref.ObjectRef oldPackage;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
                List<VirtualFile> contentSourceRoots = ProjectRootUtilsKt.getSuitableDestinationSourceRoots(this.project);
                PackageWrapper newPackage = new PackageWrapper(PsiManager.getInstance((Project)this.project), targetName);
                VirtualFile targetSourceRoot = null;
                if (contentSourceRoots.size() > 1) {
                    Ref.ObjectRef objectRef;
                    FqName fqName3 = oldPackageFqName;
                    if (fqName3 != null) {
                        FqName fqName4 = fqName3;
                        boolean bl = false;
                        boolean bl2 = false;
                        FqName it = fqName4;
                        boolean bl3 = false;
                        objectRef = JavaPsiFacade.getInstance((Project)this.project).findPackage(it.asString());
                    } else {
                        objectRef = null;
                    }
                    oldPackage = objectRef;
                    PsiDirectory initialDir = null;
                    if (oldPackage != null) {
                        PsiDirectory psiDirectory;
                        block10: {
                            ProjectRootManager projectRootManager2 = projectRootManager;
                            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager2, (String)"projectRootManager");
                            VirtualFile root2 = projectRootManager2.getFileIndex().getContentRootForFile(((PsiDirectory)this.target).getVirtualFile());
                            PsiDirectory[] psiDirectoryArray = oldPackage.getDirectories();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectoryArray, (String)"oldPackage.directories");
                            PsiDirectory[] $this$firstOrNull$iv = psiDirectoryArray;
                            boolean $i$f$firstOrNull = false;
                            PsiDirectory[] psiDirectoryArray2 = $this$firstOrNull$iv;
                            int n = psiDirectoryArray2.length;
                            for (int j = 0; j < n; ++j) {
                                PsiDirectory element$iv;
                                PsiDirectory it = element$iv = psiDirectoryArray2[j];
                                boolean bl = false;
                                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                                PsiDirectory psiDirectory2 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory2, (String)"it");
                                if (!Comparing.equal((Object)projectFileIndex.getContentRootForFile(psiDirectory2.getVirtualFile()), (Object)root2)) continue;
                                psiDirectory = element$iv;
                                break block10;
                            }
                            psiDirectory = null;
                        }
                        initialDir = psiDirectory;
                    }
                    VirtualFile virtualFile2 = this.chooseSourceRoot(newPackage, contentSourceRoots, initialDir);
                    if (virtualFile2 == null) {
                        return null;
                    }
                    targetSourceRoot = virtualFile2;
                } else {
                    targetSourceRoot = contentSourceRoots.get(0);
                }
                oldPackage = new Ref.ObjectRef();
                oldPackage.element = RefactoringUtil.findPackageDirectoryInSourceRoot((PackageWrapper)newPackage, (VirtualFile)targetSourceRoot);
                if ((PsiDirectory)directory.element == null) {
                    boolean $i$f$runWriteAction = false;
                    ApplicationManager.getApplication().runWriteAction(new Computable<T>((Ref.ObjectRef)directory, newPackage, targetSourceRoot){
                        final /* synthetic */ Ref.ObjectRef $directory$inlined;
                        final /* synthetic */ PackageWrapper $newPackage$inlined;
                        final /* synthetic */ VirtualFile $targetSourceRoot$inlined;
                        {
                            this.$directory$inlined = objectRef;
                            this.$newPackage$inlined = packageWrapper;
                            this.$targetSourceRoot$inlined = virtualFile2;
                        }

                        public final T compute() {
                            boolean bl = false;
                            try {
                                this.$directory$inlined.element = RefactoringUtil.createPackageDirectoryInSourceRoot((PackageWrapper)this.$newPackage$inlined, (VirtualFile)this.$targetSourceRoot$inlined);
                            }
                            catch (IncorrectOperationException e) {
                                this.$directory$inlined.element = null;
                            }
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
                return (PsiElement)((PsiDirectory)directory.element);
            }
            return this.target;
        }
        return this.target instanceof KtFile || this.target instanceof KtClassOrObject ? this.target : null;
    }

    private final PsiElement getTargetContainerWithValidation() throws ConfigurationException {
        PsiElement targetContainer;
        CharSequence charSequence = this.className;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new ConfigurationException(RefactoringBundle.message((String)"no.class.name.specified"));
        }
        if (!KtPsiUtilKt.isIdentifier(this.className)) {
            throw (Throwable)new ConfigurationException(RefactoringMessageUtil.getIncorrectIdentifierMessage((String)this.className));
        }
        if (this.passOuterClass) {
            charSequence = this.parameter;
            bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                throw (Throwable)new ConfigurationException(RefactoringBundle.message((String)"no.parameter.name.specified"));
            }
            if (!KtPsiUtilKt.isIdentifier(this.parameter)) {
                throw (Throwable)new ConfigurationException(RefactoringMessageUtil.getIncorrectIdentifierMessage((String)this.parameter));
            }
        }
        if ((targetContainer = this.getTargetContainer()) instanceof KtClassOrObject) {
            KtClassOrObject targetClass = (KtClassOrObject)targetContainer;
            for (KtDeclaration member : targetClass.getDeclarations()) {
                if (!(member instanceof KtClassOrObject) || !Intrinsics.areEqual((Object)this.className, (Object)member.getName())) continue;
                throw (Throwable)new ConfigurationException(RefactoringBundle.message((String)"inner.class.exists", (Object[])new Object[]{this.className, targetClass.getName()}));
            }
        }
        if (targetContainer instanceof PsiDirectory || targetContainer instanceof KtFile) {
            PsiDirectory psiDirectory;
            FqName fqName2 = MoveUtilsKt.getTargetPackageFqName(this.target);
            if (fqName2 == null) {
                throw (Throwable)new ConfigurationException(KotlinBundle.message("text.no.package.corresponds.to.directory", new Object[0]));
            }
            FqName targetPackageFqName = fqName2;
            MemberScope memberScope2 = DescriptorUtils.getContainingModule(this.innerClassDescriptor).getPackage(targetPackageFqName).getMemberScope();
            Name name2 = Name.identifier(this.className);
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(className)");
            ClassifierDescriptor existingClass = memberScope2.getContributedClassifier(name2, NoLookupLocation.FROM_IDE);
            if (existingClass != null) {
                throw (Throwable)new ConfigurationException(KotlinBundle.message("text.class.0.already.exists.in.package.1", this.className, targetPackageFqName));
            }
            PsiElement psiElement2 = targetContainer;
            if (!(psiElement2 instanceof PsiDirectory)) {
                psiElement2 = null;
            }
            if ((psiDirectory = (PsiDirectory)psiElement2) == null) {
                PsiFile psiFile2 = targetContainer.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"targetContainer.containingFile");
                psiDirectory = psiFile2.getContainingDirectory();
            }
            PsiDirectory targetDir = psiDirectory;
            String message2 = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)targetDir, (String)(this.className + ".kt"));
            if (message2 != null) {
                throw (Throwable)new ConfigurationException(message2);
            }
        }
        PsiElement psiElement3 = targetContainer;
        if (psiElement3 == null) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.invalid.target.specified", new Object[0]));
        }
        return psiElement3;
    }

    private final KotlinMoveTarget getMoveTarget() throws ConfigurationException {
        PsiElement target = this.getTargetContainerWithValidation();
        if (target instanceof PsiDirectory) {
            PsiElement targetDir = target;
            FqName fqName2 = MoveUtilsKt.getTargetPackageFqName(target);
            if (fqName2 == null) {
                throw (Throwable)new ConfigurationException(KotlinBundle.message("text.cannot.find.target.package.name", new Object[0]));
            }
            FqName targetPackageFqName = fqName2;
            String suggestedName2 = KotlinNameSuggester.INSTANCE.suggestNameByName(this.className, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(targetDir){
                final /* synthetic */ PsiElement $targetDir;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return ((PsiDirectory)this.$targetDir).findFile(it + "." + "kt") == null;
                }
                {
                    this.$targetDir = psiElement2;
                    super(1);
                }
            }));
            String targetFileName = suggestedName2 + "." + "kt";
            return new KotlinMoveTargetForDeferredFile(targetPackageFqName, (PsiDirectory)targetDir, null, (Function1<? super KtFile, ? extends KtFile>)((Function1)new Function1<KtFile, KtFile>(targetFileName, targetDir, targetPackageFqName){
                final /* synthetic */ String $targetFileName;
                final /* synthetic */ PsiElement $targetDir;
                final /* synthetic */ FqName $targetPackageFqName;

                @NotNull
                public final KtFile invoke(@NotNull KtFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return KotlinRefactoringUtilKt.createKotlinFile(this.$targetFileName, (PsiDirectory)this.$targetDir, this.$targetPackageFqName.asString());
                }
                {
                    this.$targetFileName = string;
                    this.$targetDir = psiElement2;
                    this.$targetPackageFqName = fqName2;
                    super(1);
                }
            }));
        }
        PsiElement psiElement2 = target;
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        }
        return new KotlinMoveTargetForExistingElement((KtElement)psiElement2);
    }

    @Override
    @NotNull
    public MoveKotlinDeclarationsProcessor computeModelResult() throws ConfigurationException {
        return this.computeModelResult(false);
    }

    @Override
    @NotNull
    public MoveKotlinDeclarationsProcessor computeModelResult(boolean throwOnConflicts) throws ConfigurationException {
        KotlinMoveTarget moveTarget2 = this.getMoveTarget();
        String outerInstanceParameterName = this.passOuterClass ? this.packageName : null;
        MoveDeclarationsDelegate.NestedClass delegate2 = new MoveDeclarationsDelegate.NestedClass(this.className, outerInstanceParameterName);
        MoveDeclarationsDescriptor moveDescriptor2 = new MoveDeclarationsDescriptor(this.project, MoveKotlinDeclarationsProcessorKt.MoveSource(this.innerClass), moveTarget2, delegate2, this.searchInComments, this.isSearchInNonJavaFiles, false, null, this.isOpenInEditor, null, false, false, 3584, null);
        return new MoveKotlinDeclarationsProcessor(moveDescriptor2, Mover.Default.INSTANCE, throwOnConflicts);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final KtClassOrObject getInnerClass() {
        return this.innerClass;
    }

    @NotNull
    public final PsiElement getTarget() {
        return this.target;
    }

    @Nullable
    public final String getParameter() {
        return this.parameter;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public final boolean getPassOuterClass() {
        return this.passOuterClass;
    }

    public final boolean getSearchInComments() {
        return this.searchInComments;
    }

    public final boolean isSearchInNonJavaFiles() {
        return this.isSearchInNonJavaFiles;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    public final boolean isOpenInEditor() {
        return this.isOpenInEditor;
    }

    public MoveKotlinNestedClassesToUpperLevelModel(@NotNull Project project2, @NotNull KtClassOrObject innerClass, @NotNull PsiElement target, @Nullable String parameter, @NotNull String className2, boolean passOuterClass, boolean searchInComments, boolean isSearchInNonJavaFiles, @NotNull String packageName, boolean isOpenInEditor) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)innerClass, (String)"innerClass");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        this.project = project2;
        this.innerClass = innerClass;
        this.target = target;
        this.parameter = parameter;
        this.className = className2;
        this.passOuterClass = passOuterClass;
        this.searchInComments = searchInComments;
        this.isSearchInNonJavaFiles = isSearchInNonJavaFiles;
        this.packageName = packageName;
        this.isOpenInEditor = isOpenInEditor;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor((KtDeclaration)this.innerClass, (BodyResolveMode)BodyResolveMode.FULL);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        this.innerClassDescriptor = (ClassDescriptor)declarationDescriptor;
    }
}

