/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveValVarFromParameterFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;", "element", "(Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;)V", "varOrVal", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class RemoveValVarFromParameterFix
extends KotlinQuickFixAction<KtValVarKeywordOwner> {
    private final String varOrVal;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("remove.val.var.from.parameter", new Object[0]);
    }

    @NotNull
    public String getText() {
        KtValVarKeywordOwner ktValVarKeywordOwner = (KtValVarKeywordOwner)this.getElement();
        if (ktValVarKeywordOwner == null) {
            return "";
        }
        KtValVarKeywordOwner element3 = ktValVarKeywordOwner;
        Object object = element3.getValOrVarKeyword();
        if (object == null || (object = object.getText()) == null) {
            return this.getFamilyName();
        }
        Object varOrVal = object;
        return KotlinBundle.message("remove.0.from.parameter", varOrVal);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtValVarKeywordOwner ktValVarKeywordOwner = (KtValVarKeywordOwner)this.getElement();
            if (ktValVarKeywordOwner == null || (ktValVarKeywordOwner = ktValVarKeywordOwner.getValOrVarKeyword()) == null) break block0;
            ktValVarKeywordOwner.delete();
        }
    }

    public RemoveValVarFromParameterFix(@NotNull KtValVarKeywordOwner element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
        PsiElement psiElement2 = element3.getValOrVarKeyword();
        if (psiElement2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Val or var node not found for " + PsiUtilsKt.getElementTextWithContext(element3))));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.valOrVarKeyword \u2026ElementTextWithContext())");
        PsiElement valOrVarNode = psiElement2;
        String string = valOrVarNode.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"valOrVarNode.text");
        this.varOrVal = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveValVarFromParameterFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveValVarFromParameterFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @NotNull
        protected RemoveValVarFromParameterFix createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement psiElement3 = psiElement2.getParent();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValVarKeywordOwner");
            }
            return new RemoveValVarFromParameterFix((KtValVarKeywordOwner)psiElement3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

