/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.modules;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightJavaModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;

public class ModuleHighlightUtil2 {
    private static final Attributes.Name MULTI_RELEASE = new Attributes.Name("Multi-Release");

    @Nullable
    static PsiJavaModule getModuleDescriptor(@NotNull VirtualFile file2, @NotNull Project project2) {
        ProjectFileIndex index2;
        if (file2 == null) {
            ModuleHighlightUtil2.$$$reportNull$$$1(0);
        }
        if (project2 == null) {
            ModuleHighlightUtil2.$$$reportNull$$$1(1);
        }
        if (file2 == null) {
            ModuleHighlightUtil2.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ModuleHighlightUtil2.$$$reportNull$$$0(1);
        }
        if ((index2 = ProjectFileIndex.SERVICE.getInstance((Project)project2)).isInLibrary(file2)) {
            VirtualFile root3 = index2.getClassRootForFile(file2);
            if (root3 != null) {
                VirtualFile alt;
                VirtualFile descriptorFile = root3.findChild("module-info.class");
                if (descriptorFile == null && (alt = root3.findFileByRelativePath("META-INF/versions/9/module-info.class")) != null && ModuleHighlightUtil2.isMultiReleaseJar(root3)) {
                    descriptorFile = alt;
                }
                if (descriptorFile != null) {
                    PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(descriptorFile);
                    if (psiFile2 instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile2).getModuleDeclaration();
                    }
                } else if (root3.getFileSystem() instanceof JarFileSystem && "jar".equalsIgnoreCase(root3.getExtension())) {
                    return LightJavaModule.findModule((PsiManager)PsiManager.getInstance((Project)project2), (VirtualFile)root3);
                }
            } else {
                PsiFile psiFile3;
                VirtualFile descriptorFile;
                root3 = index2.getSourceRootForFile(file2);
                if (root3 != null && (descriptorFile = root3.findChild("module-info.java")) != null && (psiFile3 = PsiManager.getInstance((Project)project2).findFile(descriptorFile)) instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile3).getModuleDeclaration();
                }
            }
        } else {
            Module module = index2.getModuleForFile(file2);
            if (module != null) {
                boolean isTest = FileIndexUtilsKt.isInTestSourceContentKotlinAware((FileIndex)index2, file2);
                VirtualFile modularRoot = (VirtualFile)ArraysKt.singleOrNull((Object[])ModuleRootManager.getInstance((Module)module).getSourceRoots(isTest), root2 -> root2.findChild("module-info.java") != null);
                if (modularRoot != null) {
                    VirtualFile moduleInfo2 = modularRoot.findChild("module-info.java");
                    assert (moduleInfo2 != null) : modularRoot;
                    PsiFile psiFile4 = PsiManager.getInstance((Project)project2).findFile(moduleInfo2);
                    if (psiFile4 instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile4).getModuleDeclaration();
                    }
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMultiReleaseJar(VirtualFile root2) {
        if (!(root2.getFileSystem() instanceof JarFileSystem)) return false;
        VirtualFile manifest = root2.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifest == null) return false;
        try (InputStream stream = manifest.getInputStream();){
            boolean bl = Boolean.valueOf(new Manifest(stream).getMainAttributes().getValue(MULTI_RELEASE));
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/modules/ModuleHighlightUtil2";
        objectArray[2] = "getModuleDescriptor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/modules/ModuleHighlightUtil2";
        objectArray[2] = "getModuleDescriptor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

