/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.migration.CoroutineMigrationProblem;
import org.jetbrains.kotlin.idea.inspections.migration.ExperimentalImportUsage;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCoroutineUsageFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExperimentalCoroutinesInspectionKt;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ExperimentalImportUsage;", "Lorg/jetbrains/kotlin/idea/inspections/migration/CoroutineMigrationProblem;", "()V", "report", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Companion", "idea"})
final class ExperimentalImportUsage
implements CoroutineMigrationProblem {
    private static final Map<String, String> PACKAGE_BINDING;
    private static final Set<String> IMPORTS_TO_REMOVE;
    private static final String EXPERIMENTAL_COROUTINES_MARKER = "experimental";
    public static final Companion Companion;

    @Override
    public boolean report(@NotNull ProblemsHolder holder2, boolean isOnTheFly, @NotNull KtSimpleNameExpression simpleNameExpression) {
        KtExpression reportExpression;
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)simpleNameExpression, (String)"simpleNameExpression");
        if (Intrinsics.areEqual((Object)simpleNameExpression.getText(), (Object)EXPERIMENTAL_COROUTINES_MARKER) ^ true) {
            return false;
        }
        PsiElement psiElement2 = simpleNameExpression.getParent();
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        KtExpression ktExpression = (KtExpression)psiElement2;
        if (ktExpression == null) {
            return false;
        }
        KtExpression parent2 = ktExpression;
        KtExpression ktExpression2 = parent2;
        if (!(ktExpression2 instanceof KtDotQualifiedExpression)) {
            ktExpression2 = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression2;
        KtExpression ktExpression3 = reportExpression = ktDotQualifiedExpression != null ? (KtExpression)ktDotQualifiedExpression : (KtExpression)simpleNameExpression;
        if (ExperimentalImportUsage.Companion.findBinding(simpleNameExpression) == null) {
            return false;
        }
        LocalQuickFix[] localQuickFixArray = ObsoleteExperimentalCoroutinesInspectionKt.access$fixesWithWholeProject(isOnTheFly, new ObsoleteCoroutineUsageFix(Companion.ObsoleteCoroutineImportFix.INSTANCE));
        holder2.registerProblem((PsiElement)reportExpression, KotlinBundle.message("experimental.coroutines.usages.are.obsolete.since.1.3", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        return true;
    }

    static {
        Companion = new Companion(null);
        PACKAGE_BINDING = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"kotlinx.coroutines.experimental", (Object)"kotlinx.coroutines"), TuplesKt.to((Object)"kotlin.coroutines.experimental", (Object)"kotlin.coroutines")});
        IMPORTS_TO_REMOVE = SetsKt.setOf((Object[])new String[]{"kotlin.coroutines.experimental.buildSequence", "kotlin.coroutines.experimental.buildIterator"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ExperimentalImportUsage$Companion;", "", "()V", "EXPERIMENTAL_COROUTINES_MARKER", "", "IMPORTS_TO_REMOVE", "", "PACKAGE_BINDING", "", "PACKAGE_BINDING$annotations", "findBinding", "Lorg/jetbrains/kotlin/idea/inspections/migration/ExperimentalImportUsage$Companion$Binding;", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Binding", "ObsoleteCoroutineImportFix", "idea"})
    public static final class Companion {
        private static /* synthetic */ void PACKAGE_BINDING$annotations() {
        }

        private final Binding findBinding(KtSimpleNameExpression simpleNameExpression) {
            Object v3;
            Object fqNameStr;
            KtImportDirective importDirective2;
            block6: {
                if (Intrinsics.areEqual((Object)simpleNameExpression.getText(), (Object)ExperimentalImportUsage.EXPERIMENTAL_COROUTINES_MARKER) ^ true) {
                    return null;
                }
                Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParents((PsiElement)simpleNameExpression), (Function1)findBinding.importDirective.1.INSTANCE));
                if (!(object instanceof KtImportDirective)) {
                    object = null;
                }
                KtImportDirective ktImportDirective = (KtImportDirective)object;
                if (ktImportDirective == null) {
                    return null;
                }
                importDirective2 = ktImportDirective;
                Object object2 = importDirective2.getImportedFqName();
                if (object2 == null || (object2 = ((FqName)object2).asString()) == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"importDirective.imported\u2026asString() ?: return null");
                fqNameStr = object2;
                Iterable iterable = PACKAGE_BINDING.entrySet();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    Map.Entry $dstr$affectedImportPrefix$_u24__u24 = (Map.Entry)t;
                    boolean bl3 = false;
                    Map.Entry entry = $dstr$affectedImportPrefix$_u24__u24;
                    boolean bl4 = false;
                    String affectedImportPrefix = (String)entry.getKey();
                    if (!StringsKt.startsWith$default((String)fqNameStr, (String)affectedImportPrefix, (boolean)false, (int)2, null)) continue;
                    v3 = t;
                    break block6;
                }
                v3 = null;
            }
            Map.Entry entry = v3;
            if (entry == null) {
                return null;
            }
            Map.Entry bindEntry = entry;
            return new Binding(new FqName((String)bindEntry.getValue()), IMPORTS_TO_REMOVE.contains(fqNameStr), importDirective2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ExperimentalImportUsage$Companion$Binding;", "", "bindTo", "Lorg/jetbrains/kotlin/name/FqName;", "shouldRemove", "", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "(Lorg/jetbrains/kotlin/name/FqName;ZLorg/jetbrains/kotlin/psi/KtImportDirective;)V", "getBindTo", "()Lorg/jetbrains/kotlin/name/FqName;", "getImportDirective", "()Lorg/jetbrains/kotlin/psi/KtImportDirective;", "getShouldRemove", "()Z", "idea"})
        private static final class Binding {
            @NotNull
            private final FqName bindTo;
            private final boolean shouldRemove;
            @NotNull
            private final KtImportDirective importDirective;

            @NotNull
            public final FqName getBindTo() {
                return this.bindTo;
            }

            public final boolean getShouldRemove() {
                return this.shouldRemove;
            }

            @NotNull
            public final KtImportDirective getImportDirective() {
                return this.importDirective;
            }

            public Binding(@NotNull FqName bindTo, boolean shouldRemove2, @NotNull KtImportDirective importDirective2) {
                Intrinsics.checkParameterIsNotNull((Object)bindTo, (String)"bindTo");
                Intrinsics.checkParameterIsNotNull((Object)importDirective2, (String)"importDirective");
                this.bindTo = bindTo;
                this.shouldRemove = shouldRemove2;
                this.importDirective = importDirective2;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ExperimentalImportUsage$Companion$ObsoleteCoroutineImportFix;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCoroutineUsageFix$Companion$CoroutineFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "idea"})
        private static final class ObsoleteCoroutineImportFix
        implements ObsoleteCoroutineUsageFix.Companion.CoroutineFix {
            public static final ObsoleteCoroutineImportFix INSTANCE;

            @Override
            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                KtSimpleNameExpression ktSimpleNameExpression;
                PsiElement element3;
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = element3 = descriptor2.getPsiElement();
                if (psiElement2 instanceof KtSimpleNameExpression) {
                    ktSimpleNameExpression = (KtSimpleNameExpression)element3;
                } else if (psiElement2 instanceof KtDotQualifiedExpression) {
                    KtExpression ktExpression = ((KtDotQualifiedExpression)element3).getSelectorExpression();
                    if (!(ktExpression instanceof KtSimpleNameExpression)) {
                        ktExpression = null;
                    }
                    ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
                } else {
                    ktSimpleNameExpression = null;
                }
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression simpleNameExpression = ktSimpleNameExpression;
                Binding binding = Companion.findBinding(simpleNameExpression);
                if (binding == null) {
                    return;
                }
                Binding binding2 = binding;
                if (binding2.getShouldRemove()) {
                    binding2.getImportDirective().delete();
                } else {
                    KtSimpleNameReference.bindToFqName$default(ReferenceUtilKt.getMainReference(simpleNameExpression), binding2.getBindTo(), KtSimpleNameReference.ShorteningMode.NO_SHORTENING, null, 4, null);
                }
            }

            private ObsoleteCoroutineImportFix() {
            }

            static {
                ObsoleteCoroutineImportFix obsoleteCoroutineImportFix;
                INSTANCE = obsoleteCoroutineImportFix = new ObsoleteCoroutineImportFix();
            }
        }
    }
}

