/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFix;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantModalityModifierInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "idea"})
public final class RedundantModalityModifierInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return VisitorWrappersKt.declarationVisitor((Function1<? super KtDeclaration, Unit>)((Function1)new Function1<KtDeclaration, Unit>(holder2){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtDeclaration declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                PsiElement psiElement2 = KtPsiUtilKt.modalityModifier(declaration2);
                if (psiElement2 == null) {
                    return;
                }
                PsiElement modalityModifier = psiElement2;
                ASTNode aSTNode = modalityModifier.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"modalityModifier.node");
                IElementType iElementType = aSTNode.getElementType();
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"modalityModifier.node.elementType");
                IElementType modalityModifierType = iElementType;
                KtModifierKeywordToken implicitModality = PsiModificationUtilsKt.implicitModality(declaration2);
                if (Intrinsics.areEqual((Object)modalityModifierType, (Object)((Object)implicitModality)) ^ true) {
                    return;
                }
                this.$holder.registerProblem(modalityModifier, KotlinBundle.message("redundant.modality.modifier", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new RemoveModifierFix(declaration2, implicitModality, true), declaration2.getContainingFile())});
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }
}

