/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0002H\u0016J\f\u0010\u0019\u001a\u00020\u0018*\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\u0005*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MoveLambdaOutsideParenthesesInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "verb", "getVerb", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inspectionText", "isApplicable", "", "withInformationLevel", "idea"})
public final class MoveLambdaOutsideParenthesesInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    @NotNull
    private final String defaultFixText = KotlinBundle.message("move.lambda.argument.out.of.parentheses", new Object[0]);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean withInformationLevel(@NotNull KtCallExpression $this$withInformationLevel) {
        int n;
        List<KtValueArgument> list2 = $this$withInformationLevel.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.lastOrNull(list2);
        if (ktValueArgument != null) {
            if (ktValueArgument.isNamed()) {
                return true;
            }
        }
        List<KtValueArgument> list3 = $this$withInformationLevel.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"valueArguments");
        Iterable $this$count$iv = list3;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KtValueArgument it = (KtValueArgument)element$iv;
                boolean bl = false;
                KtExpression ktExpression = it.getArgumentExpression();
                if (!((ktExpression != null ? KtElementUtilsKt.unpackFunctionLiteral$default(ktExpression, false, 1, null) : null) != null)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n <= true) return false;
        return true;
    }

    private final String getVerb(@NotNull KtCallExpression $this$verb) {
        return this.withInformationLevel($this$verb) ? KotlinBundle.message("text.can", new Object[0]) : KotlinBundle.message("text.should", new Object[0]);
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return this.withInformationLevel(element3) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    @Override
    public boolean isApplicable(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(element3);
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        if (PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(element3)) {
            PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(element3);
        }
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return KotlinBundle.message("lambda.argument.0.be.moved.out", this.getVerb(element3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtLambdaExpression ktLambdaExpression = PsiModificationUtilsKt.getLastLambdaExpression(element3);
        KtElement ktElement = ktLambdaExpression;
        if (ktLambdaExpression == null) return null;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)ktElement;
        boolean $i$f$getStrictParentOfType = false;
        KtValueArgument ktValueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtValueArgument.class, (boolean)true);
        ktElement = ktValueArgument;
        if (ktValueArgument == null) return null;
        KtElement ktElement2 = ((KtValueArgument)ktElement).asElement();
        ktElement = ktElement2;
        if (ktElement2 == null) return null;
        TextRange textRange = ExpressionExtKt.textRangeIn((PsiElement)ktElement, (PsiElement)element3);
        return textRange;
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    public MoveLambdaOutsideParenthesesInspection() {
        super(KtCallExpression.class);
    }
}

