/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.highlighter.HighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/BeforeResolveHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/HighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitArgument", "", "argument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "visitElement", "element", "Lcom/intellij/psi/PsiElement;", "visitExpressionWithLabel", "expression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "willApplyRainbowHighlight", "", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "idea-core"})
public final class BeforeResolveHighlightingVisitor
extends HighlightingVisitor {
    public void visitElement(@NotNull PsiElement element3) {
        TextAttributesKey textAttributesKey;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        ASTNode aSTNode = element3.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"element.node.elementType");
        IElementType elementType = iElementType;
        if (element3 instanceof KDocLink && !this.willApplyRainbowHighlight((KDocLink)element3)) {
            textAttributesKey = KotlinHighlightingColors.KDOC_LINK;
        } else if (KtTokens.SOFT_KEYWORDS.contains(elementType)) {
            IElementType iElementType2 = elementType;
            textAttributesKey = KtTokens.MODIFIER_KEYWORDS.contains(iElementType2) ? KotlinHighlightingColors.BUILTIN_ANNOTATION : KotlinHighlightingColors.KEYWORD;
        } else if (Intrinsics.areEqual((Object)elementType, (Object)((Object)KtTokens.SAFE_ACCESS))) {
            textAttributesKey = KotlinHighlightingColors.SAFE_ACCESS;
        } else if (Intrinsics.areEqual((Object)elementType, (Object)((Object)KtTokens.EXCLEXCL))) {
            textAttributesKey = KotlinHighlightingColors.EXCLEXCL;
        } else {
            return;
        }
        TextAttributesKey attributes = textAttributesKey;
        this.createInfoAnnotation(element3, null).setTextAttributes(attributes);
    }

    private final boolean willApplyRainbowHighlight(KDocLink element3) {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        if (!RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)((TextAttributesScheme)editorColorsManager.getGlobalScheme()), (Language)KotlinLanguage.INSTANCE)) {
            return false;
        }
        PsiElement psiElement2 = element3.getParent();
        if (!(psiElement2 instanceof KDocTag)) {
            psiElement2 = null;
        }
        KDocTag kDocTag = (KDocTag)psiElement2;
        return (kDocTag != null ? kDocTag.getKnownTag() : null) == KDocKnownTag.PARAM;
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        PsiElement arrow;
        Intrinsics.checkParameterIsNotNull((Object)lambdaExpression2, (String)"lambdaExpression");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        KtFunctionLiteral ktFunctionLiteral = lambdaExpression2.getFunctionLiteral();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        PsiElement psiElement2 = functionLiteral.getLBrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"functionLiteral.lBrace");
        this.createInfoAnnotation(psiElement2, null).setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        PsiElement closingBrace = functionLiteral.getRBrace();
        if (closingBrace != null) {
            this.createInfoAnnotation(closingBrace, null).setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        }
        if ((arrow = functionLiteral.getArrow()) != null) {
            this.createInfoAnnotation(arrow, null).setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        }
    }

    @Override
    public void visitArgument(@NotNull KtValueArgument argument2) {
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        KtValueArgumentName ktValueArgumentName = argument2.getArgumentName();
        if (ktValueArgumentName == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgumentName, (String)"argument.getArgumentName() ?: return");
        KtValueArgumentName argumentName = ktValueArgumentName;
        PsiElement psiElement2 = argument2.getEqualsToken();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"argument.equalsToken ?: return");
        PsiElement eq = psiElement2;
        this.createInfoAnnotation(new TextRange(PsiUtilsKt.getStartOffset((PsiElement)argumentName), PsiUtilsKt.getEndOffset(eq)), null).setTextAttributes(KotlinHighlightingColors.NAMED_ARGUMENT);
    }

    @Override
    public void visitExpressionWithLabel(@NotNull KtExpressionWithLabel expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtSimpleNameExpression targetLabel = expression2.getTargetLabel();
        if (targetLabel != null) {
            PsiElement psiElement2 = (PsiElement)targetLabel;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.LABEL;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"KotlinHighlightingColors.LABEL");
            HighlightingVisitor.highlightName$default((HighlightingVisitor)this, psiElement2, textAttributesKey, null, 4, null);
        }
    }

    public BeforeResolveHighlightingVisitor(@NotNull AnnotationHolder holder2) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        super(holder2);
    }
}

