/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$10;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$13;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$14;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$15;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$2;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$20;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$22;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$4;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$8;
import org.jetbrains.kotlin.idea.formatter.KtCodeStyleSettingsKt;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.kdoc.lexer.KDocToken;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fH\u0002\u001a\u0012\u0010$\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a\u0012\u0010%\u001a\u0004\u0018\u00010\u00132\u0006\u0010&\u001a\u00020\u0013H\u0002\u001a\u001c\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010&\u001a\u00020\u00132\b\b\u0002\u0010(\u001a\u00020\u0012H\u0002\u001a\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\fH\u0002\u001aC\u0010-\u001a#\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(+\u0012\u0006\u0012\u0004\u0018\u00010*0.j\u0002`12\u0006\u0010,\u001a\u00020\f2\u0006\u00102\u001a\u00020\u001f2\b\b\u0002\u00103\u001a\u00020\u0012H\u0002\u001aC\u0010-\u001a#\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(+\u0012\u0006\u0012\u0004\u0018\u00010*0.j\u0002`12\u0006\u0010,\u001a\u00020\f2\u0006\u00104\u001a\u00020\u00012\b\b\u0002\u00103\u001a\u00020\u0012H\u0002\u001a\u0010\u00105\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a\u000e\u00106\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0013\u001a\u0010\u00107\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a\u000e\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:\u001a\u0010\u0010;\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0013\u001a1\u0010<\u001a#\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(+\u0012\u0006\u0012\u0004\u0018\u00010*0.j\u0002`12\u0006\u0010,\u001a\u00020\fH\u0002\u001a(\u0010=\u001a\u00020\t*\u00020>2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\u00120.2\b\b\u0002\u0010A\u001a\u00020\u0012\u001a\u001a\u0010B\u001a\u00020\f*\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010E\u001a\u00020\u0001H\u0002\u001a\f\u0010F\u001a\u00020\u0012*\u00020\u0013H\u0002\u001a\u000e\u0010G\u001a\u0004\u0018\u00010\u0013*\u00020\u0013H\u0002\u001a\f\u0010H\u001a\u00020\u0012*\u00020\u0013H\u0002\u001a\f\u0010I\u001a\u00020\u0012*\u00020\u0013H\u0002\u001a\u000f\u0010J\u001a\u0004\u0018\u00010\u0013*\u00020\u0013H\u0082\u0010\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0005\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0006\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\r\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000e\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000f\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0010\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0014\"\u0018\u0010\u0015\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014\"\u0018\u0010\u0016\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014*D\u0010K\"\u001f\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(+\u0012\u0006\u0012\u0004\u0018\u00010*0.2\u001f\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(+\u0012\u0006\u0012\u0004\u0018\u00010*0.\u00a8\u0006L"}, d2={"ALIGN_FOR_BINARY_OPERATIONS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "ANNOTATIONS", "BINARY_EXPRESSIONS", "CODE_BLOCKS", "ELVIS_SET", "INDENT_RULES", "", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "[Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "KDOC_COMMENT_INDENT", "", "KDOC_CONTENT", "QUALIFIED_EXPRESSIONS", "QUALIFIED_EXPRESSIONS_WITHOUT_WRAP", "QUALIFIED_OPERATION", "isCall", "", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)Z", "isCallChainWithoutWrap", "isQualifier", "anyCallInCallChainIsWrapped", "node", "extractIndent", "", "getAlignmentForChildInParenthesis", "Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;", "shouldAlignChild", "parameter", "Lcom/intellij/psi/tree/IElementType;", "delimiter", "shouldAlignParenthesis", "openBracket", "closeBracket", "getOperationType", "getPrevWithoutWhitespace", "pNode", "getSiblingWithoutWhitespaceAndComments", "forward", "getWrapAfterAnnotation", "Lcom/intellij/formatting/Wrap;", "childElement", "wrapType", "getWrappingStrategyForItemList", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/kotlin/idea/formatter/WrappingStrategy;", "itemType", "wrapFirstElement", "itemTypes", "hasDoubleLineBreakBefore", "hasErrorElementBefore", "hasLineBreakBefore", "needWrapArgumentList", "psi", "Lcom/intellij/psi/PsiElement;", "noWrapping", "wrapAfterAnnotation", "continuationIf", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "option", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "indentFirst", "indexOfBlockWithType", "", "Lcom/intellij/formatting/ASTBlock;", "tokenSet", "isFirstParameter", "qualifierReceiver", "receiverIsCall", "suppressBinaryExpressionIndent", "unwrapQualifier", "WrappingStrategy", "formatter"})
public final class KotlinCommonBlockKt {
    private static final TokenSet QUALIFIED_OPERATION;
    private static final TokenSet QUALIFIED_EXPRESSIONS;
    private static final TokenSet ELVIS_SET;
    private static final TokenSet QUALIFIED_EXPRESSIONS_WITHOUT_WRAP;
    private static final int KDOC_COMMENT_INDENT = 1;
    private static final TokenSet BINARY_EXPRESSIONS;
    private static final TokenSet KDOC_CONTENT;
    private static final TokenSet CODE_BLOCKS;
    private static final TokenSet ALIGN_FOR_BINARY_OPERATIONS;
    private static final TokenSet ANNOTATIONS;
    private static final NodeIndentStrategy[] INDENT_RULES;

    @Nullable
    public static final Wrap noWrapping(@NotNull ASTNode childElement) {
        Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ASTNode qualifierReceiver(@NotNull ASTNode $this$qualifierReceiver) {
        ASTNode aSTNode = KotlinCommonBlockKt.unwrapQualifier($this$qualifierReceiver);
        Object object = aSTNode;
        if (aSTNode == null) return null;
        PsiElement psiElement2 = object.getPsi();
        object = psiElement2;
        if (psiElement2 == null) return null;
        ASTNode $this$safeAs$iv = object;
        boolean $i$f$safeAs = false;
        ASTNode aSTNode2 = $this$safeAs$iv;
        if (!(aSTNode2 instanceof KtQualifiedExpression)) {
            aSTNode2 = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)aSTNode2;
        object = ktQualifiedExpression;
        if (ktQualifiedExpression == null) return null;
        KtExpression ktExpression = object.getReceiverExpression();
        object = ktExpression;
        if (ktExpression == null) return null;
        ASTNode aSTNode3 = object.getNode();
        object = aSTNode3;
        if (aSTNode3 == null) return null;
        ASTNode aSTNode4 = KotlinCommonBlockKt.unwrapQualifier((ASTNode)object);
        return aSTNode4;
    }

    private static final ASTNode unwrapQualifier(@NotNull ASTNode $this$unwrapQualifier) {
        while (true) {
            KtPostfixExpression psi2;
            if (QUALIFIED_EXPRESSIONS.contains($this$unwrapQualifier.getElementType())) {
                return $this$unwrapQualifier;
            }
            PsiElement psiElement2 = $this$unwrapQualifier.getPsi();
            if (!(psiElement2 instanceof KtPostfixExpression)) {
                psiElement2 = null;
            }
            if ((KtPostfixExpression)psiElement2 == null) {
                return null;
            }
            if (Intrinsics.areEqual((Object)psi2.getOperationToken(), (Object)((Object)KtTokens.EXCLEXCL)) ^ true) {
                return null;
            }
            KtExpression ktExpression = psi2.getBaseExpression();
            if (ktExpression == null || (ktExpression = ktExpression.getNode()) == null) break;
            $this$unwrapQualifier = ktExpression;
        }
        return null;
    }

    private static final boolean receiverIsCall(@NotNull ASTNode $this$receiverIsCall) {
        ASTNode aSTNode = KotlinCommonBlockKt.qualifierReceiver($this$receiverIsCall);
        return aSTNode != null && KotlinCommonBlockKt.isCall(aSTNode);
    }

    private static final boolean isCallChainWithoutWrap(@NotNull ASTNode $this$isCallChainWithoutWrap) {
        Object v0;
        block2: {
            Sequence<ASTNode> $this$firstOrNull$iv = PsiUtilsKt.parents($this$isCallChainWithoutWrap);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!(!KotlinCommonBlockKt.isQualifier(it))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ASTNode aSTNode = v0;
        if (aSTNode == null) {
            return true;
        }
        ASTNode callChainParent = aSTNode;
        return QUALIFIED_EXPRESSIONS_WITHOUT_WRAP.contains(callChainParent.getElementType());
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean isQualifier(@NotNull ASTNode $this$isQualifier) {
        for (currentNode = $this$isQualifier; currentNode != null; currentNode = currentNode.getTreeParent()) {
            if (KotlinCommonBlockKt.QUALIFIED_EXPRESSIONS.contains(currentNode.getElementType())) {
                return true;
            }
            v0 = currentNode.getPsi();
            if (v0 == null) ** GOTO lbl-1000
            $this$safeAs$iv = v0;
            $i$f$safeAs = false;
            v1 = $this$safeAs$iv;
            if (!(v1 instanceof KtPostfixExpression)) {
                v1 = null;
            }
            if ((v0 = (KtPostfixExpression)v1) != null) {
                v2 = v0.getOperationToken();
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            if (!(Intrinsics.areEqual(v2, (Object)KtTokens.EXCLEXCL) ^ true)) continue;
            return false;
        }
        return false;
    }

    private static final boolean isCall(@NotNull ASTNode $this$isCall) {
        ASTNode aSTNode = KotlinCommonBlockKt.unwrapQualifier($this$isCall);
        return Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getLastChildNode()) != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.CALL_EXPRESSION);
    }

    private static final boolean anyCallInCallChainIsWrapped(ASTNode node2) {
        boolean bl;
        block1: {
            Sequence sequentialNodes2;
            Sequence $this$any$iv = sequentialNodes2 = SequencesKt.generateSequence((Object)node2, (Function1)anyCallInCallChainIsWrapped.sequentialNodes.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode checkedElement;
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                IElementType iElementType = it.getElementType();
                Object object = QUALIFIED_EXPRESSIONS.contains(iElementType) ? it.findChildByType(QUALIFIED_OPERATION) : (checkedElement = Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PARENTHESIZED) ? it.getLastChildNode() : null);
                boolean bl3 = checkedElement != null && KotlinCommonBlockKt.hasLineBreakBefore(checkedElement);
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean isFirstParameter(@NotNull ASTNode $this$isFirstParameter) {
        ASTNode aSTNode = $this$isFirstParameter.getTreePrev();
        return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.LPAR));
    }

    private static final Function1<ASTNode, Wrap> wrapAfterAnnotation(int wrapType) {
        return (Function1)new Function1<ASTNode, Wrap>(wrapType){
            final /* synthetic */ int $wrapType;

            @Nullable
            public final Wrap invoke(@NotNull ASTNode childElement) {
                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                return KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, this.$wrapType);
            }
            {
                this.$wrapType = n;
                super(1);
            }
        };
    }

    private static final Wrap getWrapAfterAnnotation(ASTNode childElement, int wrapType) {
        ASTNode aSTNode;
        if (KtTokens.COMMENTS.contains(childElement.getElementType())) {
            return null;
        }
        ASTNode prevLeaf2 = childElement.getTreePrev();
        while (true) {
            ASTNode aSTNode2 = prevLeaf2;
            if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)TokenType.WHITE_SPACE)) break;
            ASTNode aSTNode3 = prevLeaf2;
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"prevLeaf");
            prevLeaf2 = aSTNode3.getTreePrev();
        }
        ASTNode aSTNode4 = prevLeaf2;
        if (Intrinsics.areEqual((Object)(aSTNode4 != null ? aSTNode4.getElementType() : null), (Object)KtNodeTypes.MODIFIER_LIST) && ANNOTATIONS.contains((aSTNode = prevLeaf2) != null && (aSTNode = aSTNode.getLastChildNode()) != null ? aSTNode.getElementType() : null)) {
            return Wrap.createWrap((int)wrapType, (boolean)true);
        }
        return null;
    }

    public static final boolean needWrapArgumentList(@NotNull PsiElement psi2) {
        Intrinsics.checkParameterIsNotNull((Object)psi2, (String)"psi");
        PsiElement psiElement2 = psi2;
        if (!(psiElement2 instanceof KtValueArgumentList)) {
            psiElement2 = null;
        }
        KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement2;
        List<KtValueArgument> args = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list2 = args;
        return !((list2 != null && (list2 = (KtValueArgument)CollectionsKt.singleOrNull(list2)) != null ? ((KtValueArgument)((Object)list2)).getArgumentExpression() : null) instanceof KtObjectLiteralExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasLineBreakBefore(ASTNode node2) {
        ASTNode prevSibling2;
        ASTNode aSTNode = prevSibling2 = (ASTNode)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile(PsiUtilsKt.leaves(node2, false), (Function1)hasLineBreakBefore.prevSibling.1.INSTANCE));
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)TokenType.WHITE_SPACE)) return false;
        ASTNode aSTNode2 = prevSibling2;
        if (aSTNode2 == null) return false;
        if (!aSTNode2.textContains('\n')) return false;
        return true;
    }

    private static final boolean hasDoubleLineBreakBefore(ASTNode node2) {
        ASTNode aSTNode = (ASTNode)SequencesKt.firstOrNull(PsiUtilsKt.leaves(node2, false));
        if (aSTNode == null) {
            return false;
        }
        ASTNode prevSibling2 = aSTNode;
        String string = prevSibling2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prevSibling.text");
        CharSequence $this$count$iv = string;
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (int j = 0; j < charSequence.length(); ++j) {
            char element$iv;
            char it = element$iv = charSequence.charAt(j);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        return count$iv >= 2;
    }

    @NotNull
    public static final NodeIndentStrategy continuationIf(@NotNull NodeIndentStrategy.PositionStrategy $this$continuationIf, @NotNull Function1<? super KotlinCodeStyleSettings, Boolean> option, boolean indentFirst) {
        Intrinsics.checkParameterIsNotNull((Object)$this$continuationIf, (String)"$this$continuationIf");
        Intrinsics.checkParameterIsNotNull(option, (String)"option");
        return $this$continuationIf.set((Function1<? super CodeStyleSettings, ? extends Indent>)((Function1)new Function1<CodeStyleSettings, Indent>(option, indentFirst){
            final /* synthetic */ Function1 $option;
            final /* synthetic */ boolean $indentFirst;

            @NotNull
            public final Indent invoke(@NotNull CodeStyleSettings settings2) {
                Indent indent;
                Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
                if (((Boolean)this.$option.invoke((Object)((Object)KtCodeStyleSettingsKt.getKotlinCustomSettings(settings2)))).booleanValue()) {
                    Indent indent2 = this.$indentFirst ? Indent.getContinuationIndent() : Indent.getContinuationWithoutFirstIndent();
                    indent = indent2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)indent2, (String)"if (indentFirst)\n       \u2026ationWithoutFirstIndent()");
                } else {
                    Indent indent3 = Indent.getNormalIndent();
                    indent = indent3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)indent3, (String)"Indent.getNormalIndent()");
                }
                return indent;
            }
            {
                this.$option = function1;
                this.$indentFirst = bl;
                super(1);
            }
        }));
    }

    public static /* synthetic */ NodeIndentStrategy continuationIf$default(NodeIndentStrategy.PositionStrategy positionStrategy, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KotlinCommonBlockKt.continuationIf(positionStrategy, (Function1<? super KotlinCodeStyleSettings, Boolean>)function1, bl);
    }

    private static final IElementType getOperationType(ASTNode node2) {
        ASTNode aSTNode = node2.findChildByType(KtNodeTypes.OPERATION_REFERENCE);
        return aSTNode != null && (aSTNode = aSTNode.getFirstChildNode()) != null ? aSTNode.getElementType() : null;
    }

    public static final boolean hasErrorElementBefore(@NotNull ASTNode node2) {
        ASTNode lastChild;
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        ASTNode aSTNode = KotlinCommonBlockKt.getPrevWithoutWhitespace(node2);
        if (aSTNode == null) {
            return false;
        }
        ASTNode prevSibling2 = aSTNode;
        if (Intrinsics.areEqual((Object)prevSibling2.getElementType(), (Object)TokenType.ERROR_ELEMENT)) {
            return true;
        }
        ASTNode aSTNode2 = lastChild = TreeUtil.getLastChild((ASTNode)prevSibling2);
        return Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)TokenType.ERROR_ELEMENT);
    }

    private static final boolean suppressBinaryExpressionIndent(@NotNull ASTNode $this$suppressBinaryExpressionIndent) {
        PsiElement psiElement2 = $this$suppressBinaryExpressionIndent.getPsi();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"psi");
        PsiElement psiElement3 = psiElement2.getParent();
        if (!(psiElement3 instanceof KtBinaryExpression)) {
            psiElement3 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement3;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression psi2 = ktBinaryExpression;
        while (psi2.getParent() instanceof KtBinaryExpression) {
            PsiElement psiElement4 = psi2.getParent();
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            }
            psi2 = (KtBinaryExpression)psiElement4;
        }
        PsiElement psiElement5 = psi2.getParent();
        return Intrinsics.areEqual((Object)(psiElement5 != null && (psiElement5 = psiElement5.getNode()) != null ? psiElement5.getElementType() : null), (Object)KtNodeTypes.CONDITION) || Intrinsics.areEqual((Object)psi2.getOperationToken(), (Object)((Object)KtTokens.ELVIS));
    }

    private static final CommonAlignmentStrategy getAlignmentForChildInParenthesis(boolean shouldAlignChild, IElementType parameter, IElementType delimiter, boolean shouldAlignParenthesis, IElementType openBracket, IElementType closeBracket) {
        Alignment parameterAlignment = shouldAlignChild ? Alignment.createAlignment() : null;
        Alignment bracketsAlignment = shouldAlignParenthesis ? Alignment.createAlignment() : null;
        return new CommonAlignmentStrategy(closeBracket, parameterAlignment, openBracket, bracketsAlignment, parameter, delimiter){
            final /* synthetic */ IElementType $closeBracket;
            final /* synthetic */ Alignment $parameterAlignment;
            final /* synthetic */ IElementType $openBracket;
            final /* synthetic */ Alignment $bracketsAlignment;
            final /* synthetic */ IElementType $parameter;
            final /* synthetic */ IElementType $delimiter;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public Alignment getAlignment(@NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                v0 = node.getElementType();
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"node.elementType");
                childNodeType = v0;
                prev = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(node);
                if (childNodeType != this.$closeBracket) ** GOTO lbl-1000
                v1 = prev;
                if (Intrinsics.areEqual((Object)(v1 != null ? v1.getElementType() : null), (Object)KtTokens.COMMA)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = hasTrailingComma = false;
                }
                if (hasTrailingComma && KotlinCommonBlockKt.access$hasDoubleLineBreakBefore(node)) {
                    return this.$parameterAlignment;
                }
                if (childNodeType == this.$openBracket || childNodeType == this.$closeBracket) {
                    return this.$bracketsAlignment;
                }
                if (childNodeType == this.$parameter || childNodeType == this.$delimiter) {
                    return this.$parameterAlignment;
                }
                return null;
            }
            {
                this.$closeBracket = $captured_local_variable$0;
                this.$parameterAlignment = $captured_local_variable$1;
                this.$openBracket = $captured_local_variable$2;
                this.$bracketsAlignment = $captured_local_variable$3;
                this.$parameter = $captured_local_variable$4;
                this.$delimiter = $captured_local_variable$5;
            }
        };
    }

    private static final ASTNode getPrevWithoutWhitespace(ASTNode pNode) {
        Object v0;
        block1: {
            Sequence<ASTNode> $this$firstOrNull$iv = PsiUtilsKt.siblings(pNode, false);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)TokenType.WHITE_SPACE) ^ true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final ASTNode getSiblingWithoutWhitespaceAndComments(ASTNode pNode, boolean forward) {
        Object v0;
        block1: {
            Sequence<ASTNode> $this$firstOrNull$iv = PsiUtilsKt.siblings(pNode, forward);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)TokenType.WHITE_SPACE) ^ true && !KtTokens.COMMENTS.contains(it.getElementType()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    static /* synthetic */ ASTNode getSiblingWithoutWhitespaceAndComments$default(ASTNode aSTNode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments(aSTNode, bl);
    }

    private static final Function1<ASTNode, Wrap> getWrappingStrategyForItemList(int wrapType, IElementType itemType, boolean wrapFirstElement) {
        Wrap itemWrap = Wrap.createWrap((int)wrapType, (boolean)wrapFirstElement);
        return (Function1)new Function1<ASTNode, Wrap>(itemType, itemWrap){
            final /* synthetic */ IElementType $itemType;
            final /* synthetic */ Wrap $itemWrap;

            @Nullable
            public final Wrap invoke(@NotNull ASTNode childElement) {
                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                return childElement.getElementType() == this.$itemType ? this.$itemWrap : null;
            }
            {
                this.$itemType = iElementType;
                this.$itemWrap = wrap2;
                super(1);
            }
        };
    }

    static /* synthetic */ Function1 getWrappingStrategyForItemList$default(int n, IElementType iElementType, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(n, iElementType, bl);
    }

    private static final Function1<ASTNode, Wrap> getWrappingStrategyForItemList(int wrapType, TokenSet itemTypes, boolean wrapFirstElement) {
        Wrap itemWrap = Wrap.createWrap((int)wrapType, (boolean)wrapFirstElement);
        return (Function1)new Function1<ASTNode, Wrap>(itemTypes, itemWrap){
            final /* synthetic */ TokenSet $itemTypes;
            final /* synthetic */ Wrap $itemWrap;

            @Nullable
            public final Wrap invoke(@NotNull ASTNode childElement) {
                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                IElementType iElementType = childElement.getElementType();
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"childElement.elementType");
                IElementType thisType = iElementType;
                ASTNode aSTNode = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(childElement);
                IElementType prevType = aSTNode != null ? aSTNode.getElementType() : null;
                return this.$itemTypes.contains(thisType) || this.$itemTypes.contains(prevType) && Intrinsics.areEqual((Object)thisType, (Object)((Object)KtTokens.EOL_COMMENT)) ^ true && Intrinsics.areEqual((Object)prevType, (Object)((Object)KtTokens.EOL_COMMENT)) ^ true ? this.$itemWrap : null;
            }
            {
                this.$itemTypes = tokenSet;
                this.$itemWrap = wrap2;
                super(1);
            }
        };
    }

    static /* synthetic */ Function1 getWrappingStrategyForItemList$default(int n, TokenSet tokenSet, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(n, tokenSet, bl);
    }

    private static final int indexOfBlockWithType(@NotNull List<? extends ASTBlock> $this$indexOfBlockWithType, TokenSet tokenSet) {
        int n;
        block2: {
            List<? extends ASTBlock> $this$indexOfFirst$iv = $this$indexOfBlockWithType;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<? extends ASTBlock> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                ASTBlock item$iv;
                ASTBlock block2 = item$iv = iterator2.next();
                boolean bl = false;
                ASTNode aSTNode = block2.getNode();
                if (tokenSet.contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private static final String extractIndent(ASTNode node2) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node2.getTreePrev();
        if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)TokenType.WHITE_SPACE) ^ true) {
            return "";
        }
        ASTNode aSTNode2 = prevNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"prevNode");
        String string = aSTNode2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prevNode.text");
        String string2 = prevNode.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"prevNode.text");
        return StringsKt.substringAfterLast((String)string, (String)"\n", (String)string2);
    }

    static {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{KtTokens.DOT, KtTokens.SAFE_ACCESS});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(DOT, SAFE_ACCESS)");
        QUALIFIED_OPERATION = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.SAFE_ACCESS_EXPRESSION});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"TokenSet.create(DOT_QUAL\u2026, SAFE_ACCESS_EXPRESSION)");
        QUALIFIED_EXPRESSIONS = tokenSet2;
        TokenSet tokenSet3 = TokenSet.create((IElementType[])new IElementType[]{KtTokens.ELVIS});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet3, (String)"TokenSet.create(ELVIS)");
        ELVIS_SET = tokenSet3;
        TokenSet tokenSet4 = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.IMPORT_DIRECTIVE, KtNodeTypes.PACKAGE_DIRECTIVE});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet4, (String)"TokenSet.create(IMPORT_D\u2026CTIVE, PACKAGE_DIRECTIVE)");
        QUALIFIED_EXPRESSIONS_WITHOUT_WRAP = tokenSet4;
        TokenSet tokenSet5 = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BINARY_EXPRESSION, KtNodeTypes.BINARY_WITH_TYPE, KtNodeTypes.IS_EXPRESSION});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet5, (String)"TokenSet.create(BINARY_E\u2026WITH_TYPE, IS_EXPRESSION)");
        BINARY_EXPRESSIONS = tokenSet5;
        TokenSet tokenSet6 = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KDocTokens.KDOC, KDocElementTypes.KDOC_SECTION, KDocElementTypes.KDOC_TAG});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet6, (String)"TokenSet.create(KDocToke\u2026DocElementTypes.KDOC_TAG)");
        KDOC_CONTENT = tokenSet6;
        TokenSet tokenSet7 = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BLOCK, KtNodeTypes.CLASS_BODY, KtNodeTypes.FUNCTION_LITERAL});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet7, (String)"TokenSet.create(BLOCK, C\u2026S_BODY, FUNCTION_LITERAL)");
        CODE_BLOCKS = tokenSet7;
        TokenSet tokenSet8 = TokenSet.create((IElementType[])new IElementType[]{KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.PLUS, KtTokens.MINUS, KtTokens.ELVIS, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.ANDAND, KtTokens.OROR});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet8, (String)"TokenSet.create(MUL, DIV\u2026LTEQ, GTEQ, ANDAND, OROR)");
        ALIGN_FOR_BINARY_OPERATIONS = tokenSet8;
        TokenSet tokenSet9 = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.ANNOTATION_ENTRY, KtNodeTypes.ANNOTATION});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet9, (String)"TokenSet.create(ANNOTATION_ENTRY, ANNOTATION)");
        ANNOTATIONS = tokenSet9;
        NodeIndentStrategy[] nodeIndentStrategyArray = new NodeIndentStrategy[30];
        NodeIndentStrategy.PositionStrategy positionStrategy = NodeIndentStrategy.Companion.strategy("No indent for braces in blocks");
        IElementType iElementType = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"BLOCK");
        IElementType[] iElementTypeArray = new IElementType[2];
        IElementType iElementType2 = KtNodeTypes.CLASS_BODY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"CLASS_BODY");
        iElementTypeArray[0] = iElementType2;
        IElementType iElementType3 = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"FUNCTION_LITERAL");
        iElementTypeArray[1] = iElementType3;
        NodeIndentStrategy.PositionStrategy positionStrategy2 = positionStrategy.within(iElementType, iElementTypeArray);
        KtSingleValueToken ktSingleValueToken = KtTokens.RBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"RBRACE");
        IElementType iElementType4 = ktSingleValueToken;
        IElementType[] iElementTypeArray2 = new IElementType[1];
        KtSingleValueToken ktSingleValueToken2 = KtTokens.LBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken2), (String)"LBRACE");
        iElementTypeArray2[0] = ktSingleValueToken2;
        NodeIndentStrategy.PositionStrategy positionStrategy3 = positionStrategy2.forType(iElementType4, iElementTypeArray2);
        Indent indent = Indent.getNoneIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent, (String)"Indent.getNoneIndent()");
        nodeIndentStrategyArray[0] = positionStrategy3.set(indent);
        NodeIndentStrategy.PositionStrategy positionStrategy4 = NodeIndentStrategy.Companion.strategy("Indent for block content");
        IElementType iElementType5 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType5, (String)"BLOCK");
        IElementType[] iElementTypeArray3 = new IElementType[2];
        IElementType iElementType6 = KtNodeTypes.CLASS_BODY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType6, (String)"CLASS_BODY");
        iElementTypeArray3[0] = iElementType6;
        IElementType iElementType7 = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType7, (String)"FUNCTION_LITERAL");
        iElementTypeArray3[1] = iElementType7;
        NodeIndentStrategy.PositionStrategy positionStrategy5 = positionStrategy4.within(iElementType5, iElementTypeArray3);
        KtSingleValueToken ktSingleValueToken3 = KtTokens.RBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken3), (String)"RBRACE");
        IElementType iElementType8 = ktSingleValueToken3;
        IElementType[] iElementTypeArray4 = new IElementType[2];
        KtSingleValueToken ktSingleValueToken4 = KtTokens.LBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken4), (String)"LBRACE");
        iElementTypeArray4[0] = ktSingleValueToken4;
        IElementType iElementType9 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType9, (String)"BLOCK");
        iElementTypeArray4[1] = iElementType9;
        NodeIndentStrategy.PositionStrategy positionStrategy6 = positionStrategy5.notForType(iElementType8, iElementTypeArray4);
        Indent indent2 = Indent.getNormalIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent2, (String)"Indent.getNormalIndent(false)");
        nodeIndentStrategyArray[1] = positionStrategy6.set(indent2);
        NodeIndentStrategy.PositionStrategy positionStrategy7 = NodeIndentStrategy.Companion.strategy("Indent for property accessors");
        IElementType iElementType10 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType10, (String)"PROPERTY");
        NodeIndentStrategy.PositionStrategy positionStrategy8 = positionStrategy7.within(iElementType10, new IElementType[0]);
        IElementType iElementType11 = KtNodeTypes.PROPERTY_ACCESSOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType11, (String)"PROPERTY_ACCESSOR");
        NodeIndentStrategy.PositionStrategy positionStrategy9 = positionStrategy8.forType(iElementType11, new IElementType[0]);
        Indent indent3 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent3, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[2] = positionStrategy9.set(indent3);
        NodeIndentStrategy.PositionStrategy positionStrategy10 = NodeIndentStrategy.Companion.strategy("For a single statement in 'for'");
        IElementType iElementType12 = KtNodeTypes.BODY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType12, (String)"BODY");
        NodeIndentStrategy.PositionStrategy positionStrategy11 = positionStrategy10.within(iElementType12, new IElementType[0]);
        IElementType iElementType13 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType13, (String)"BLOCK");
        NodeIndentStrategy.PositionStrategy positionStrategy12 = positionStrategy11.notForType(iElementType13, new IElementType[0]);
        Indent indent4 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent4, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[3] = positionStrategy12.set(indent4);
        NodeIndentStrategy.PositionStrategy positionStrategy13 = NodeIndentStrategy.Companion.strategy("For WHEN content");
        IElementType iElementType14 = KtNodeTypes.WHEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType14, (String)"WHEN");
        NodeIndentStrategy.PositionStrategy positionStrategy14 = positionStrategy13.within(iElementType14, new IElementType[0]);
        KtSingleValueToken ktSingleValueToken5 = KtTokens.RBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken5), (String)"RBRACE");
        IElementType iElementType15 = ktSingleValueToken5;
        IElementType[] iElementTypeArray5 = new IElementType[2];
        KtSingleValueToken ktSingleValueToken6 = KtTokens.LBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken6), (String)"LBRACE");
        iElementTypeArray5[0] = ktSingleValueToken6;
        KtKeywordToken ktKeywordToken = KtTokens.WHEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"WHEN_KEYWORD");
        iElementTypeArray5[1] = ktKeywordToken;
        NodeIndentStrategy.PositionStrategy positionStrategy15 = positionStrategy14.notForType(iElementType15, iElementTypeArray5);
        Indent indent5 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent5, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[4] = positionStrategy15.set(indent5);
        NodeIndentStrategy.PositionStrategy positionStrategy16 = NodeIndentStrategy.Companion.strategy("For single statement in THEN and ELSE");
        IElementType iElementType16 = KtNodeTypes.THEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType16, (String)"THEN");
        IElementType[] iElementTypeArray6 = new IElementType[1];
        IElementType iElementType17 = KtNodeTypes.ELSE;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType17, (String)"ELSE");
        iElementTypeArray6[0] = iElementType17;
        NodeIndentStrategy.PositionStrategy positionStrategy17 = positionStrategy16.within(iElementType16, iElementTypeArray6);
        IElementType iElementType18 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType18, (String)"BLOCK");
        NodeIndentStrategy.PositionStrategy positionStrategy18 = positionStrategy17.notForType(iElementType18, new IElementType[0]);
        Indent indent6 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent6, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[5] = positionStrategy18.set(indent6);
        NodeIndentStrategy.PositionStrategy positionStrategy19 = NodeIndentStrategy.Companion.strategy("Expression body");
        IElementType iElementType19 = KtNodeTypes.FUN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType19, (String)"FUN");
        nodeIndentStrategyArray[6] = KotlinCommonBlockKt.continuationIf(positionStrategy19.within(iElementType19, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.1.INSTANCE)), (Function1<? super KotlinCodeStyleSettings, Boolean>)((Function1)KotlinCommonBlockKt$INDENT_RULES$2.INSTANCE), true);
        nodeIndentStrategyArray[7] = KotlinCommonBlockKt.continuationIf(NodeIndentStrategy.Companion.strategy("Line comment at expression body position").forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.3.INSTANCE)), (Function1<? super KotlinCodeStyleSettings, Boolean>)((Function1)KotlinCommonBlockKt$INDENT_RULES$4.INSTANCE), true);
        NodeIndentStrategy.PositionStrategy positionStrategy20 = NodeIndentStrategy.Companion.strategy("If condition");
        IElementType iElementType20 = KtNodeTypes.CONDITION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType20, (String)"CONDITION");
        nodeIndentStrategyArray[8] = positionStrategy20.within(iElementType20, new IElementType[0]).set((Function1<? super CodeStyleSettings, ? extends Indent>)((Function1)INDENT_RULES.5.INSTANCE));
        NodeIndentStrategy.PositionStrategy positionStrategy21 = NodeIndentStrategy.Companion.strategy("Property accessor expression body");
        IElementType iElementType21 = KtNodeTypes.PROPERTY_ACCESSOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType21, (String)"PROPERTY_ACCESSOR");
        NodeIndentStrategy.PositionStrategy positionStrategy22 = positionStrategy21.within(iElementType21, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.6.INSTANCE));
        Indent indent7 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent7, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[9] = positionStrategy22.set(indent7);
        NodeIndentStrategy.PositionStrategy positionStrategy23 = NodeIndentStrategy.Companion.strategy("Property initializer");
        IElementType iElementType22 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType22, (String)"PROPERTY");
        nodeIndentStrategyArray[10] = KotlinCommonBlockKt.continuationIf$default(positionStrategy23.within(iElementType22, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.7.INSTANCE)), (Function1)KotlinCommonBlockKt$INDENT_RULES$8.INSTANCE, false, 2, null);
        NodeIndentStrategy.PositionStrategy positionStrategy24 = NodeIndentStrategy.Companion.strategy("Destructuring declaration");
        IElementType iElementType23 = KtNodeTypes.DESTRUCTURING_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType23, (String)"DESTRUCTURING_DECLARATION");
        nodeIndentStrategyArray[11] = KotlinCommonBlockKt.continuationIf$default(positionStrategy24.within(iElementType23, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.9.INSTANCE)), (Function1)KotlinCommonBlockKt$INDENT_RULES$10.INSTANCE, false, 2, null);
        NodeIndentStrategy.PositionStrategy positionStrategy25 = NodeIndentStrategy.Companion.strategy("Assignment expressions");
        IElementType iElementType24 = KtNodeTypes.BINARY_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType24, (String)"BINARY_EXPRESSION");
        nodeIndentStrategyArray[12] = KotlinCommonBlockKt.continuationIf$default(positionStrategy25.within(iElementType24, new IElementType[0]).within((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.11.INSTANCE)).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.12.INSTANCE)), (Function1)KotlinCommonBlockKt$INDENT_RULES$13.INSTANCE, false, 2, null);
        NodeIndentStrategy.PositionStrategy positionStrategy26 = NodeIndentStrategy.Companion.strategy("Indent for parts");
        IElementType iElementType25 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType25, (String)"PROPERTY");
        IElementType[] iElementTypeArray7 = new IElementType[3];
        IElementType iElementType26 = KtNodeTypes.FUN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType26, (String)"FUN");
        iElementTypeArray7[0] = iElementType26;
        IElementType iElementType27 = KtNodeTypes.DESTRUCTURING_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType27, (String)"DESTRUCTURING_DECLARATION");
        iElementTypeArray7[1] = iElementType27;
        IElementType iElementType28 = KtNodeTypes.SECONDARY_CONSTRUCTOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType28, (String)"SECONDARY_CONSTRUCTOR");
        iElementTypeArray7[2] = iElementType28;
        NodeIndentStrategy.PositionStrategy positionStrategy27 = positionStrategy26.within(iElementType25, iElementTypeArray7);
        IElementType iElementType29 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType29, (String)"BLOCK");
        IElementType[] iElementTypeArray8 = new IElementType[6];
        KtKeywordToken ktKeywordToken2 = KtTokens.FUN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken2), (String)"FUN_KEYWORD");
        iElementTypeArray8[0] = ktKeywordToken2;
        KtKeywordToken ktKeywordToken3 = KtTokens.VAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken3), (String)"VAL_KEYWORD");
        iElementTypeArray8[1] = ktKeywordToken3;
        KtKeywordToken ktKeywordToken4 = KtTokens.VAR_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken4), (String)"VAR_KEYWORD");
        iElementTypeArray8[2] = ktKeywordToken4;
        KtKeywordToken ktKeywordToken5 = KtTokens.CONSTRUCTOR_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken5), (String)"CONSTRUCTOR_KEYWORD");
        iElementTypeArray8[3] = ktKeywordToken5;
        KtSingleValueToken ktSingleValueToken7 = KtTokens.RPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken7), (String)"RPAR");
        iElementTypeArray8[4] = ktSingleValueToken7;
        KtToken ktToken = KtTokens.EOL_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken), (String)"EOL_COMMENT");
        iElementTypeArray8[5] = ktToken;
        NodeIndentStrategy.PositionStrategy positionStrategy28 = positionStrategy27.notForType(iElementType29, iElementTypeArray8);
        Indent indent8 = Indent.getContinuationWithoutFirstIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent8, (String)"Indent.getContinuationWithoutFirstIndent()");
        nodeIndentStrategyArray[13] = positionStrategy28.set(indent8);
        NodeIndentStrategy.PositionStrategy positionStrategy29 = NodeIndentStrategy.Companion.strategy("Chained calls").within(QUALIFIED_EXPRESSIONS);
        KtToken ktToken2 = KtTokens.EOL_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken2), (String)"EOL_COMMENT");
        IElementType iElementType30 = ktToken2;
        IElementType[] iElementTypeArray9 = new IElementType[3];
        KtToken ktToken3 = KtTokens.BLOCK_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken3), (String)"BLOCK_COMMENT");
        iElementTypeArray9[0] = ktToken3;
        IElementType iElementType31 = KtTokens.DOC_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType31, (String)"DOC_COMMENT");
        iElementTypeArray9[1] = iElementType31;
        KtToken ktToken4 = KtTokens.SHEBANG_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken4), (String)"SHEBANG_COMMENT");
        iElementTypeArray9[2] = ktToken4;
        nodeIndentStrategyArray[14] = KotlinCommonBlockKt.continuationIf$default(positionStrategy29.forType(iElementType30, iElementTypeArray9), (Function1)KotlinCommonBlockKt$INDENT_RULES$14.INSTANCE, false, 2, null);
        NodeIndentStrategy.PositionStrategy positionStrategy30 = NodeIndentStrategy.Companion.strategy("Colon of delegation list");
        IElementType iElementType32 = KtNodeTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType32, (String)"CLASS");
        IElementType[] iElementTypeArray10 = new IElementType[1];
        IElementType iElementType33 = KtNodeTypes.OBJECT_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType33, (String)"OBJECT_DECLARATION");
        iElementTypeArray10[0] = iElementType33;
        NodeIndentStrategy.PositionStrategy positionStrategy31 = positionStrategy30.within(iElementType32, iElementTypeArray10);
        KtSingleValueToken ktSingleValueToken8 = KtTokens.COLON;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken8), (String)"COLON");
        NodeIndentStrategy.PositionStrategy positionStrategy32 = positionStrategy31.forType(ktSingleValueToken8, new IElementType[0]);
        Indent indent9 = Indent.getNormalIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent9, (String)"Indent.getNormalIndent(false)");
        nodeIndentStrategyArray[15] = positionStrategy32.set(indent9);
        NodeIndentStrategy.PositionStrategy positionStrategy33 = NodeIndentStrategy.Companion.strategy("Delegation list");
        IElementType iElementType34 = KtNodeTypes.SUPER_TYPE_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType34, (String)"SUPER_TYPE_LIST");
        nodeIndentStrategyArray[16] = KotlinCommonBlockKt.continuationIf(positionStrategy33.within(iElementType34, new IElementType[0]), (Function1<? super KotlinCodeStyleSettings, Boolean>)((Function1)KotlinCommonBlockKt$INDENT_RULES$15.INSTANCE), true);
        NodeIndentStrategy.PositionStrategy positionStrategy34 = NodeIndentStrategy.Companion.strategy("Indices");
        IElementType iElementType35 = KtNodeTypes.INDICES;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType35, (String)"INDICES");
        NodeIndentStrategy.PositionStrategy positionStrategy35 = positionStrategy34.within(iElementType35, new IElementType[0]);
        KtSingleValueToken ktSingleValueToken9 = KtTokens.RBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken9), (String)"RBRACKET");
        NodeIndentStrategy.PositionStrategy positionStrategy36 = positionStrategy35.notForType(ktSingleValueToken9, new IElementType[0]);
        Indent indent10 = Indent.getContinuationIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent10, (String)"Indent.getContinuationIndent(false)");
        nodeIndentStrategyArray[17] = positionStrategy36.set(indent10);
        NodeIndentStrategy.PositionStrategy positionStrategy37 = NodeIndentStrategy.Companion.strategy("Binary expressions").within(BINARY_EXPRESSIONS).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.16.INSTANCE));
        Indent indent11 = Indent.getContinuationWithoutFirstIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent11, (String)"Indent.getContinuationWithoutFirstIndent(false)");
        nodeIndentStrategyArray[18] = positionStrategy37.set(indent11);
        NodeIndentStrategy.PositionStrategy positionStrategy38 = NodeIndentStrategy.Companion.strategy("Parenthesized expression");
        IElementType iElementType36 = KtNodeTypes.PARENTHESIZED;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType36, (String)"PARENTHESIZED");
        NodeIndentStrategy.PositionStrategy positionStrategy39 = positionStrategy38.within(iElementType36, new IElementType[0]);
        Indent indent12 = Indent.getContinuationWithoutFirstIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent12, (String)"Indent.getContinuationWithoutFirstIndent(false)");
        nodeIndentStrategyArray[19] = positionStrategy39.set(indent12);
        NodeIndentStrategy.PositionStrategy positionStrategy40 = NodeIndentStrategy.Companion.strategy("Opening parenthesis for conditions");
        KtSingleValueToken ktSingleValueToken10 = KtTokens.LPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken10), (String)"LPAR");
        NodeIndentStrategy.PositionStrategy positionStrategy41 = positionStrategy40.forType(ktSingleValueToken10, new IElementType[0]);
        IElementType iElementType37 = KtNodeTypes.IF;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType37, (String)"IF");
        IElementType[] iElementTypeArray11 = new IElementType[3];
        IElementType iElementType38 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType38, (String)"WHEN_ENTRY");
        iElementTypeArray11[0] = iElementType38;
        IElementType iElementType39 = KtNodeTypes.WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType39, (String)"WHILE");
        iElementTypeArray11[1] = iElementType39;
        IElementType iElementType40 = KtNodeTypes.DO_WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType40, (String)"DO_WHILE");
        iElementTypeArray11[2] = iElementType40;
        NodeIndentStrategy.PositionStrategy positionStrategy42 = positionStrategy41.within(iElementType37, iElementTypeArray11);
        Indent indent13 = Indent.getContinuationWithoutFirstIndent((boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent13, (String)"Indent.getContinuationWithoutFirstIndent(true)");
        nodeIndentStrategyArray[20] = positionStrategy42.set(indent13);
        NodeIndentStrategy.PositionStrategy positionStrategy43 = NodeIndentStrategy.Companion.strategy("Closing parenthesis for conditions");
        KtSingleValueToken ktSingleValueToken11 = KtTokens.RPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken11), (String)"RPAR");
        NodeIndentStrategy.PositionStrategy positionStrategy44 = positionStrategy43.forType(ktSingleValueToken11, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.17.INSTANCE));
        IElementType iElementType41 = KtNodeTypes.IF;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType41, (String)"IF");
        IElementType[] iElementTypeArray12 = new IElementType[3];
        IElementType iElementType42 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType42, (String)"WHEN_ENTRY");
        iElementTypeArray12[0] = iElementType42;
        IElementType iElementType43 = KtNodeTypes.WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType43, (String)"WHILE");
        iElementTypeArray12[1] = iElementType43;
        IElementType iElementType44 = KtNodeTypes.DO_WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType44, (String)"DO_WHILE");
        iElementTypeArray12[2] = iElementType44;
        NodeIndentStrategy.PositionStrategy positionStrategy45 = positionStrategy44.within(iElementType41, iElementTypeArray12);
        Indent indent14 = Indent.getNoneIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent14, (String)"Indent.getNoneIndent()");
        nodeIndentStrategyArray[21] = positionStrategy45.set(indent14);
        NodeIndentStrategy.PositionStrategy positionStrategy46 = NodeIndentStrategy.Companion.strategy("Closing parenthesis for incomplete conditions");
        KtSingleValueToken ktSingleValueToken12 = KtTokens.RPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken12), (String)"RPAR");
        NodeIndentStrategy.PositionStrategy positionStrategy47 = positionStrategy46.forType(ktSingleValueToken12, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.18.INSTANCE));
        IElementType iElementType45 = KtNodeTypes.IF;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType45, (String)"IF");
        IElementType[] iElementTypeArray13 = new IElementType[3];
        IElementType iElementType46 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType46, (String)"WHEN_ENTRY");
        iElementTypeArray13[0] = iElementType46;
        IElementType iElementType47 = KtNodeTypes.WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType47, (String)"WHILE");
        iElementTypeArray13[1] = iElementType47;
        IElementType iElementType48 = KtNodeTypes.DO_WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType48, (String)"DO_WHILE");
        iElementTypeArray13[2] = iElementType48;
        NodeIndentStrategy.PositionStrategy positionStrategy48 = positionStrategy47.within(iElementType45, iElementTypeArray13);
        Indent indent15 = Indent.getContinuationWithoutFirstIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent15, (String)"Indent.getContinuationWithoutFirstIndent()");
        nodeIndentStrategyArray[22] = positionStrategy48.set(indent15);
        NodeIndentStrategy.PositionStrategy positionStrategy49 = NodeIndentStrategy.Companion.strategy("KDoc comment indent").within(KDOC_CONTENT);
        KDocToken kDocToken = KDocTokens.LEADING_ASTERISK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kDocToken), (String)"KDocTokens.LEADING_ASTERISK");
        IElementType iElementType49 = kDocToken;
        IElementType[] iElementTypeArray14 = new IElementType[1];
        KDocToken kDocToken2 = KDocTokens.END;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kDocToken2), (String)"KDocTokens.END");
        iElementTypeArray14[0] = kDocToken2;
        NodeIndentStrategy.PositionStrategy positionStrategy50 = positionStrategy49.forType(iElementType49, iElementTypeArray14);
        Indent indent16 = Indent.getSpaceIndent((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent16, (String)"Indent.getSpaceIndent(KDOC_COMMENT_INDENT)");
        nodeIndentStrategyArray[23] = positionStrategy50.set(indent16);
        NodeIndentStrategy.PositionStrategy positionStrategy51 = NodeIndentStrategy.Companion.strategy("Block in when entry");
        IElementType iElementType50 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType50, (String)"WHEN_ENTRY");
        NodeIndentStrategy.PositionStrategy positionStrategy52 = positionStrategy51.within(iElementType50, new IElementType[0]);
        IElementType iElementType51 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType51, (String)"BLOCK");
        IElementType[] iElementTypeArray15 = new IElementType[5];
        IElementType iElementType52 = KtNodeTypes.WHEN_CONDITION_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType52, (String)"WHEN_CONDITION_EXPRESSION");
        iElementTypeArray15[0] = iElementType52;
        IElementType iElementType53 = KtNodeTypes.WHEN_CONDITION_IN_RANGE;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType53, (String)"WHEN_CONDITION_IN_RANGE");
        iElementTypeArray15[1] = iElementType53;
        IElementType iElementType54 = KtNodeTypes.WHEN_CONDITION_IS_PATTERN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType54, (String)"WHEN_CONDITION_IS_PATTERN");
        iElementTypeArray15[2] = iElementType54;
        KtKeywordToken ktKeywordToken6 = KtTokens.ELSE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken6), (String)"ELSE_KEYWORD");
        iElementTypeArray15[3] = ktKeywordToken6;
        KtSingleValueToken ktSingleValueToken13 = KtTokens.ARROW;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken13), (String)"ARROW");
        iElementTypeArray15[4] = ktSingleValueToken13;
        NodeIndentStrategy.PositionStrategy positionStrategy53 = positionStrategy52.notForType(iElementType51, iElementTypeArray15);
        Indent indent17 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent17, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[24] = positionStrategy53.set(indent17);
        NodeIndentStrategy.PositionStrategy positionStrategy54 = NodeIndentStrategy.Companion.strategy("Parameter list");
        IElementType iElementType55 = KtNodeTypes.VALUE_PARAMETER_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType55, (String)"VALUE_PARAMETER_LIST");
        nodeIndentStrategyArray[25] = KotlinCommonBlockKt.continuationIf(positionStrategy54.within(iElementType55, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.19.INSTANCE)), (Function1<? super KotlinCodeStyleSettings, Boolean>)((Function1)KotlinCommonBlockKt$INDENT_RULES$20.INSTANCE), true);
        NodeIndentStrategy.PositionStrategy positionStrategy55 = NodeIndentStrategy.Companion.strategy("Where clause");
        IElementType iElementType56 = KtNodeTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType56, (String)"CLASS");
        IElementType[] iElementTypeArray16 = new IElementType[2];
        IElementType iElementType57 = KtNodeTypes.FUN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType57, (String)"FUN");
        iElementTypeArray16[0] = iElementType57;
        IElementType iElementType58 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType58, (String)"PROPERTY");
        iElementTypeArray16[1] = iElementType58;
        NodeIndentStrategy.PositionStrategy positionStrategy56 = positionStrategy55.within(iElementType56, iElementTypeArray16);
        KtKeywordToken ktKeywordToken7 = KtTokens.WHERE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken7), (String)"WHERE_KEYWORD");
        NodeIndentStrategy.PositionStrategy positionStrategy57 = positionStrategy56.forType(ktKeywordToken7, new IElementType[0]);
        Indent indent18 = Indent.getContinuationIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent18, (String)"Indent.getContinuationIndent()");
        nodeIndentStrategyArray[26] = positionStrategy57.set(indent18);
        NodeIndentStrategy.PositionStrategy positionStrategy58 = NodeIndentStrategy.Companion.strategy("Array literals");
        IElementType iElementType59 = KtNodeTypes.COLLECTION_LITERAL_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType59, (String)"COLLECTION_LITERAL_EXPRESSION");
        NodeIndentStrategy.PositionStrategy positionStrategy59 = positionStrategy58.within(iElementType59, new IElementType[0]);
        KtSingleValueToken ktSingleValueToken14 = KtTokens.LBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken14), (String)"LBRACKET");
        IElementType iElementType60 = ktSingleValueToken14;
        IElementType[] iElementTypeArray17 = new IElementType[1];
        KtSingleValueToken ktSingleValueToken15 = KtTokens.RBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken15), (String)"RBRACKET");
        iElementTypeArray17[0] = ktSingleValueToken15;
        NodeIndentStrategy.PositionStrategy positionStrategy60 = positionStrategy59.notForType(iElementType60, iElementTypeArray17);
        Indent indent19 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent19, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[27] = positionStrategy60.set(indent19);
        NodeIndentStrategy.PositionStrategy positionStrategy61 = NodeIndentStrategy.Companion.strategy("Type aliases");
        IElementType iElementType61 = KtNodeTypes.TYPEALIAS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType61, (String)"TYPEALIAS");
        NodeIndentStrategy.PositionStrategy positionStrategy62 = positionStrategy61.within(iElementType61, new IElementType[0]);
        KtKeywordToken ktKeywordToken8 = KtTokens.TYPE_ALIAS_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken8), (String)"TYPE_ALIAS_KEYWORD");
        IElementType iElementType62 = ktKeywordToken8;
        IElementType[] iElementTypeArray18 = new IElementType[4];
        KtToken ktToken5 = KtTokens.EOL_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken5), (String)"EOL_COMMENT");
        iElementTypeArray18[0] = ktToken5;
        IElementType iElementType63 = KtNodeTypes.MODIFIER_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType63, (String)"MODIFIER_LIST");
        iElementTypeArray18[1] = iElementType63;
        KtToken ktToken6 = KtTokens.BLOCK_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken6), (String)"BLOCK_COMMENT");
        iElementTypeArray18[2] = ktToken6;
        IElementType iElementType64 = KtTokens.DOC_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType64, (String)"DOC_COMMENT");
        iElementTypeArray18[3] = iElementType64;
        NodeIndentStrategy.PositionStrategy positionStrategy63 = positionStrategy62.notForType(iElementType62, iElementTypeArray18);
        Indent indent20 = Indent.getContinuationIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent20, (String)"Indent.getContinuationIndent()");
        nodeIndentStrategyArray[28] = positionStrategy63.set(indent20);
        NodeIndentStrategy.PositionStrategy positionStrategy64 = NodeIndentStrategy.Companion.strategy("Default parameter values");
        IElementType iElementType65 = KtNodeTypes.VALUE_PARAMETER;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType65, (String)"VALUE_PARAMETER");
        nodeIndentStrategyArray[29] = KotlinCommonBlockKt.continuationIf(positionStrategy64.within(iElementType65, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.21.INSTANCE)), (Function1<? super KotlinCodeStyleSettings, Boolean>)((Function1)KotlinCommonBlockKt$INDENT_RULES$22.INSTANCE), true);
        INDENT_RULES = nodeIndentStrategyArray;
    }

    public static final /* synthetic */ TokenSet access$getQUALIFIED_EXPRESSIONS$p() {
        return QUALIFIED_EXPRESSIONS;
    }

    public static final /* synthetic */ boolean access$isQualifier$p(ASTNode $this$access_u24isQualifier_u24p) {
        return KotlinCommonBlockKt.isQualifier($this$access_u24isQualifier_u24p);
    }

    public static final /* synthetic */ boolean access$isCallChainWithoutWrap$p(ASTNode $this$access_u24isCallChainWithoutWrap_u24p) {
        return KotlinCommonBlockKt.isCallChainWithoutWrap($this$access_u24isCallChainWithoutWrap_u24p);
    }

    public static final /* synthetic */ int access$indexOfBlockWithType(List $this$access_u24indexOfBlockWithType, TokenSet tokenSet) {
        return KotlinCommonBlockKt.indexOfBlockWithType($this$access_u24indexOfBlockWithType, tokenSet);
    }

    public static final /* synthetic */ TokenSet access$getQUALIFIED_OPERATION$p() {
        return QUALIFIED_OPERATION;
    }

    public static final /* synthetic */ boolean access$anyCallInCallChainIsWrapped(ASTNode node2) {
        return KotlinCommonBlockKt.anyCallInCallChainIsWrapped(node2);
    }

    public static final /* synthetic */ ASTNode access$unwrapQualifier(ASTNode $this$access_u24unwrapQualifier) {
        return KotlinCommonBlockKt.unwrapQualifier($this$access_u24unwrapQualifier);
    }

    public static final /* synthetic */ boolean access$isCall$p(ASTNode $this$access_u24isCall_u24p) {
        return KotlinCommonBlockKt.isCall($this$access_u24isCall_u24p);
    }

    public static final /* synthetic */ boolean access$receiverIsCall(ASTNode $this$access_u24receiverIsCall) {
        return KotlinCommonBlockKt.receiverIsCall($this$access_u24receiverIsCall);
    }

    public static final /* synthetic */ TokenSet access$getELVIS_SET$p() {
        return ELVIS_SET;
    }

    public static final /* synthetic */ ASTNode access$getPrevWithoutWhitespace(ASTNode pNode) {
        return KotlinCommonBlockKt.getPrevWithoutWhitespace(pNode);
    }

    public static final /* synthetic */ NodeIndentStrategy[] access$getINDENT_RULES$p() {
        return INDENT_RULES;
    }

    public static final /* synthetic */ boolean access$hasDoubleLineBreakBefore(ASTNode node2) {
        return KotlinCommonBlockKt.hasDoubleLineBreakBefore(node2);
    }

    public static final /* synthetic */ TokenSet access$getCODE_BLOCKS$p() {
        return CODE_BLOCKS;
    }

    public static final /* synthetic */ CommonAlignmentStrategy access$getAlignmentForChildInParenthesis(boolean shouldAlignChild, IElementType parameter, IElementType delimiter, boolean shouldAlignParenthesis, IElementType openBracket, IElementType closeBracket) {
        return KotlinCommonBlockKt.getAlignmentForChildInParenthesis(shouldAlignChild, parameter, delimiter, shouldAlignParenthesis, openBracket, closeBracket);
    }

    public static final /* synthetic */ TokenSet access$getBINARY_EXPRESSIONS$p() {
        return BINARY_EXPRESSIONS;
    }

    public static final /* synthetic */ TokenSet access$getALIGN_FOR_BINARY_OPERATIONS$p() {
        return ALIGN_FOR_BINARY_OPERATIONS;
    }

    public static final /* synthetic */ IElementType access$getOperationType(ASTNode node2) {
        return KotlinCommonBlockKt.getOperationType(node2);
    }

    public static final /* synthetic */ String access$extractIndent(ASTNode node2) {
        return KotlinCommonBlockKt.extractIndent(node2);
    }

    public static final /* synthetic */ Function1 access$getWrappingStrategyForItemList(int wrapType, TokenSet itemTypes, boolean wrapFirstElement) {
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(wrapType, itemTypes, wrapFirstElement);
    }

    public static final /* synthetic */ TokenSet access$getANNOTATIONS$p() {
        return ANNOTATIONS;
    }

    public static final /* synthetic */ boolean access$isFirstParameter(ASTNode $this$access_u24isFirstParameter) {
        return KotlinCommonBlockKt.isFirstParameter($this$access_u24isFirstParameter);
    }

    public static final /* synthetic */ Function1 access$wrapAfterAnnotation(int wrapType) {
        return KotlinCommonBlockKt.wrapAfterAnnotation(wrapType);
    }

    public static final /* synthetic */ Wrap access$getWrapAfterAnnotation(ASTNode childElement, int wrapType) {
        return KotlinCommonBlockKt.getWrapAfterAnnotation(childElement, wrapType);
    }

    public static final /* synthetic */ ASTNode access$getSiblingWithoutWhitespaceAndComments(ASTNode pNode, boolean forward) {
        return KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments(pNode, forward);
    }

    public static final /* synthetic */ boolean access$suppressBinaryExpressionIndent(ASTNode $this$access_u24suppressBinaryExpressionIndent) {
        return KotlinCommonBlockKt.suppressBinaryExpressionIndent($this$access_u24suppressBinaryExpressionIndent);
    }
}

