/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.textBuilder;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.decompiler.navigation.ByDescriptorIndexer;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.BuildDecompiledTextKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextIndex;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextIndexer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0012\b\u0002\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DECOMPILED_CODE_COMMENT", "", "DECOMPILED_COMMENT_FOR_PARAMETER", "DECOMPILED_CONTRACT_STUB", "FLEXIBLE_TYPE_COMMENT", "buildDecompiledText", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptorRenderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "indexers", "", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledTextIndexer;", "defaultDecompilerRendererOptions", "", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "idea-core"})
public final class BuildDecompiledTextKt {
    private static final String DECOMPILED_CODE_COMMENT = "/* compiled code */";
    private static final String DECOMPILED_COMMENT_FOR_PARAMETER = "/* = compiled code */";
    private static final String FLEXIBLE_TYPE_COMMENT = "/* platform type */";
    private static final String DECOMPILED_CONTRACT_STUB = "contract { /* compiled contract */ }";

    public static final void defaultDecompilerRendererOptions(@NotNull DescriptorRendererOptions $this$defaultDecompilerRendererOptions) {
        Intrinsics.checkParameterIsNotNull((Object)$this$defaultDecompilerRendererOptions, (String)"$this$defaultDecompilerRendererOptions");
        $this$defaultDecompilerRendererOptions.setWithDefinedIn(false);
        $this$defaultDecompilerRendererOptions.setClassWithPrimaryConstructor(true);
        $this$defaultDecompilerRendererOptions.setSecondaryConstructorsAsPrimary(false);
        $this$defaultDecompilerRendererOptions.setModifiers(DescriptorRendererModifier.ALL);
        $this$defaultDecompilerRendererOptions.setExcludedTypeAnnotationClasses(SetsKt.emptySet());
        $this$defaultDecompilerRendererOptions.setAlwaysRenderModifiers(true);
        $this$defaultDecompilerRendererOptions.setParameterNamesInFunctionalTypes(false);
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@NotNull FqName packageFqName, @NotNull List<? extends DeclarationDescriptor> descriptors2, @NotNull DescriptorRenderer descriptorRenderer2, @NotNull Collection<? extends DecompiledTextIndexer<?>> indexers) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull(descriptors2, (String)"descriptors");
        Intrinsics.checkParameterIsNotNull((Object)descriptorRenderer2, (String)"descriptorRenderer");
        Intrinsics.checkParameterIsNotNull(indexers, (String)"indexers");
        StringBuilder builder2 = new StringBuilder();
        Function0<Unit> $fun$appendDecompiledTextAndPackageName$1 = new Function0<Unit>(builder2, packageFqName){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ FqName $packageFqName;

            public final void invoke() {
                this.$builder.append("// IntelliJ API Decompiler stub source generated from a class file\n// Implementation of methods is not available");
                this.$builder.append("\n\n");
                if (!this.$packageFqName.isRoot()) {
                    this.$builder.append("package ").append(UtilsKt.quoteIfNeeded(this.$packageFqName)).append("\n\n");
                }
            }
            {
                this.$builder = stringBuilder2;
                this.$packageFqName = fqName2;
                super(0);
            }
        };
        DecompiledTextIndex textIndex = new DecompiledTextIndex(indexers);
        Function3<DeclarationDescriptor, Integer, Integer, Unit> $fun$indexDescriptor$2 = new Function3<DeclarationDescriptor, Integer, Integer, Unit>(textIndex){
            final /* synthetic */ DecompiledTextIndex $textIndex;

            public final void invoke(@NotNull DeclarationDescriptor descriptor2, int startOffset, int endOffset) {
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                this.$textIndex.addToIndex(descriptor2, new TextRange(startOffset, endOffset));
            }
            {
                this.$textIndex = decompiledTextIndex;
                super(3);
            }
        };
        Function3<DeclarationDescriptor, String, Boolean, Unit> $fun$appendDescriptor$3 = new Function3<DeclarationDescriptor, String, Boolean, Unit>(builder2, descriptorRenderer2, $fun$indexDescriptor$2){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ DescriptorRenderer $descriptorRenderer;
            final /* synthetic */ buildDecompiledText.2 $indexDescriptor$2;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DeclarationDescriptor descriptor2, @NotNull String indent, @Nullable Boolean lastEnumEntry) {
                ClassConstructorDescriptor primaryConstructor2;
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
                int startOffset = this.$builder.length();
                if (DescriptorUtils.isEnumEntry(descriptor2)) {
                    for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
                        this.$builder.append(DescriptorRenderer.renderAnnotation$default(this.$descriptorRenderer, annotation2, null, 2, null));
                        this.$builder.append(" ");
                    }
                    String string = descriptor2.getName().asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.name.asString()");
                    this.$builder.append(KtPsiUtilKt.quoteIfNeeded(string));
                    Boolean bl = lastEnumEntry;
                    if (bl == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$builder.append(bl != false ? ";" : ",");
                } else {
                    this.$builder.append(StringsKt.replace$default((String)this.$descriptorRenderer.render(descriptor2), (String)"= ...", (String)"/* = compiled code */", (boolean)false, (int)4, null));
                }
                int endOffset = this.$builder.length();
                if (descriptor2 instanceof CallableDescriptor) {
                    KotlinType kotlinType = ((CallableDescriptor)descriptor2).getReturnType();
                    if (kotlinType == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"descriptor.returnType!!");
                    if (FlexibleTypesKt.isFlexible(kotlinType)) {
                        this.$builder.append(" ").append("/* platform type */");
                    }
                }
                if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PropertyDescriptor) {
                    if (((MemberDescriptor)descriptor2).getModality() != Modality.ABSTRACT) {
                        if (descriptor2 instanceof FunctionDescriptor) {
                            StringBuilder stringBuilder2 = this.$builder;
                            boolean bl = false;
                            boolean bl2 = false;
                            Object $this$with = stringBuilder2;
                            boolean bl3 = false;
                            ((StringBuilder)$this$with).append(" { ");
                            AbstractContractProvider abstractContractProvider = (AbstractContractProvider)((FunctionDescriptor)descriptor2).getUserData(ContractProviderKey.INSTANCE);
                            if ((abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null) != null) {
                                ((StringBuilder)$this$with).append("contract { /* compiled contract */ }").append("; ");
                            }
                            ((StringBuilder)$this$with).append("/* compiled code */").append(" }");
                        } else {
                            this.$builder.append(" ").append("/* compiled code */");
                        }
                        endOffset = this.$builder.length();
                    }
                } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtils.isEnumEntry(descriptor2)) {
                    void enumEntries;
                    void firstPassed;
                    this.$builder.append(" {\n");
                    String subindent = indent + "    ";
                    Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                    booleanRef.element = false;
                    Function0<Unit> $fun$newlineExceptFirst$2 = new Function0<Unit>(this, (Ref.BooleanRef)firstPassed){
                        final /* synthetic */ buildDecompiledText.3 this$0;
                        final /* synthetic */ Ref.BooleanRef $firstPassed;

                        public final void invoke() {
                            if (this.$firstPassed.element) {
                                this.this$0.$builder.append("\n");
                            } else {
                                this.$firstPassed.element = true;
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$firstPassed = booleanRef;
                            super(0);
                        }
                    };
                    List allDescriptors2 = CollectionsKt.plus((Collection)DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)descriptor2), (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getDefaultType().getMemberScope(), null, null, 3, null));
                    Iterable $this$partition$iv = allDescriptors2;
                    boolean $i$f$partition = false;
                    ArrayList<T> first$iv = new ArrayList<T>();
                    ArrayList<T> second$iv = new ArrayList<T>();
                    for (T element$iv : $this$partition$iv) {
                        DeclarationDescriptor p1 = (DeclarationDescriptor)element$iv;
                        boolean bl = false;
                        if (DescriptorUtils.isEnumEntry(p1)) {
                            first$iv.add(element$iv);
                            continue;
                        }
                        second$iv.add(element$iv);
                    }
                    Pair pair2 = new Pair(first$iv, second$iv);
                    List bl3 = (List)pair2.component1();
                    List members2 = (List)pair2.component2();
                    boolean bl = false;
                    for (DeclarationDescriptor enumEntry : (Iterable)enumEntries) {
                        void index2;
                        $fun$newlineExceptFirst$2.invoke();
                        this.$builder.append(subindent);
                        this.invoke(enumEntry, subindent, index2 == CollectionsKt.getLastIndex((List)enumEntries));
                        ++index2;
                    }
                    ClassDescriptor companionObject = ((ClassDescriptor)descriptor2).getCompanionObjectDescriptor();
                    if (companionObject != null) {
                        $fun$newlineExceptFirst$2.invoke();
                        this.$builder.append(subindent);
                        buildDecompiledText.3.invoke$default(this, companionObject, subindent, null, 4, null);
                    }
                    for (DeclarationDescriptor member : members2) {
                        if (Intrinsics.areEqual((Object)member.getContainingDeclaration(), (Object)descriptor2) ^ true || Intrinsics.areEqual((Object)member, (Object)companionObject)) continue;
                        if (member instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)member).getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
                            Name name2 = ((CallableMemberDescriptor)member).getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"member.name");
                            if (!DataClassDescriptorResolver.INSTANCE.isComponentLike(name2)) continue;
                        }
                        $fun$newlineExceptFirst$2.invoke();
                        this.$builder.append(subindent);
                        buildDecompiledText.3.invoke$default(this, member, subindent, null, 4, null);
                    }
                    this.$builder.append(indent).append("}");
                    endOffset = this.$builder.length();
                }
                this.$builder.append("\n");
                this.$indexDescriptor$2.invoke(descriptor2, startOffset, endOffset);
                if (descriptor2 instanceof ClassDescriptor && (primaryConstructor2 = ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor()) != null) {
                    this.$indexDescriptor$2.invoke(primaryConstructor2, startOffset, endOffset);
                }
            }

            public static /* synthetic */ void invoke$default(buildDecompiledText.3 var0, DeclarationDescriptor declarationDescriptor, String string, Boolean bl, int n, Object object) {
                if ((n & 4) != 0) {
                    bl = null;
                }
                var0.invoke(declarationDescriptor, string, bl);
            }
            {
                this.$builder = stringBuilder2;
                this.$descriptorRenderer = descriptorRenderer2;
                this.$indexDescriptor$2 = var3_3;
                super(3);
            }
        };
        $fun$appendDecompiledTextAndPackageName$1.invoke();
        for (DeclarationDescriptor declarationDescriptor : descriptors2) {
            buildDecompiledText.3.invoke$default($fun$appendDescriptor$3, declarationDescriptor, "", null, 4, null);
            builder2.append("\n");
        }
        String string = builder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return new DecompiledText(string, textIndex);
    }

    public static /* synthetic */ DecompiledText buildDecompiledText$default(FqName fqName2, List list2, DescriptorRenderer descriptorRenderer2, Collection collection, int n, Object object) {
        if ((n & 8) != 0) {
            collection = CollectionsKt.listOf((Object)ByDescriptorIndexer.INSTANCE);
        }
        return BuildDecompiledTextKt.buildDecompiledText(fqName2, list2, descriptorRenderer2, collection);
    }
}

