/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.TypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.AsyncStackTraceContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/LookupContinuation;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "frame", "Ljava/lang/StackTraceElement;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Ljava/lang/StackTraceElement;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "getFrame", "()Ljava/lang/StackTraceElement;", "createAsyncStackTraceContext", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/AsyncStackTraceContext;", "stackTraceElementMethodRef", "Lcom/sun/jdi/Method;", "debugMetadataClassType", "Lcom/sun/jdi/ClassType;", "continuation", "Lcom/sun/jdi/ObjectReference;", "findContinuation", "initialContinuation", "findGetStackTraceElementMethodRef", "findMethod", "getNextFrame", "isApplicable", "", "suspendOrInvokeSuspend", "method", "jvm-debugger-coroutine"})
public final class LookupContinuation {
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private final StackTraceElement frame;

    private final boolean suspendOrInvokeSuspend(Method method) {
        String string = method.signature();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.signature()");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Lkotlin/coroutines/Continuation;)", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)method.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;");
    }

    private final Method findMethod() {
        Method method;
        Method element$iv;
        block2: {
            String string = this.frame.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"frame.className");
            ReferenceType referenceType = ExecutionContext.findClass$default(this.context, string, null, 2, null);
            if (referenceType == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            ClassType clazz = (ClassType)referenceType;
            List<Method> list2 = clazz.methodsByName(this.frame.getMethodName());
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"clazz.methodsByName(frame.methodName)");
            List<Method> $this$last$iv = list2;
            boolean $i$f$last = false;
            ListIterator<Method> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                Method it = element$iv = iterator$iv.previous();
                boolean bl = false;
                int loc = it.location().lineNumber();
                boolean bl2 = loc < 0 && this.frame.getLineNumber() < 0 || loc > 0 && loc <= this.frame.getLineNumber();
                if (!bl2) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("List contains no element matching the predicate.");
        }
        Method method2 = method = element$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
        return method2;
    }

    public final boolean isApplicable() {
        Method method = this.findMethod();
        return this.suspendOrInvokeSuspend(method);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ObjectReference findContinuation(@Nullable ObjectReference initialContinuation) {
        void continuation2;
        if (!this.isApplicable()) {
            return null;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        ObjectReference objectReference = initialContinuation;
        if (objectReference == null) {
            return null;
        }
        objectRef.element = objectReference;
        String baseType = "kotlin.coroutines.jvm.internal.BaseContinuationImpl";
        Type type2 = ((ObjectReference)continuation2.element).type();
        if (type2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
        }
        Method getTrace = ((ClassType)type2).concreteMethodByName("getStackTraceElement", "()Ljava/lang/StackTraceElement;");
        ReferenceType referenceType = ExecutionContext.findClass$default(this.context, "java.lang.StackTraceElement", null, 2, null);
        if (referenceType == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
        }
        ClassType stackTraceType = (ClassType)referenceType;
        Method getClassName = stackTraceType.concreteMethodByName("getClassName", "()Ljava/lang/String;");
        Method getLineNumber = stackTraceType.concreteMethodByName("getLineNumber", "()I");
        Function0 className2 = (Function0)new Function0<String>(this, (Ref.ObjectRef)continuation2, getTrace, getClassName){
            final /* synthetic */ LookupContinuation this$0;
            final /* synthetic */ Ref.ObjectRef $continuation;
            final /* synthetic */ Method $getTrace;
            final /* synthetic */ Method $getClassName;

            @Nullable
            public final String invoke() {
                String string;
                ObjectReference trace;
                ExecutionContext executionContext = this.this$0.getContext();
                ObjectReference objectReference = (ObjectReference)this.$continuation.element;
                Method method = this.$getTrace;
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"getTrace");
                Value value2 = ExecutionContext.invokeMethod$default(executionContext, objectReference, method, CollectionsKt.emptyList(), 0, 8, null);
                if (!(value2 instanceof ObjectReference)) {
                    value2 = null;
                }
                if ((trace = (ObjectReference)value2) != null) {
                    ExecutionContext executionContext2 = this.this$0.getContext();
                    Method method2 = this.$getClassName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"getClassName");
                    Value value3 = ExecutionContext.invokeMethod$default(executionContext2, trace, method2, CollectionsKt.emptyList(), 0, 8, null);
                    if (value3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.StringReference");
                    }
                    string = ((StringReference)value3).value();
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = lookupContinuation;
                this.$continuation = objectRef;
                this.$getTrace = method;
                this.$getClassName = method2;
                super(0);
            }
        };
        Function0 lineNumber2 = (Function0)new Function0<Integer>(this, (Ref.ObjectRef)continuation2, getTrace, getLineNumber){
            final /* synthetic */ LookupContinuation this$0;
            final /* synthetic */ Ref.ObjectRef $continuation;
            final /* synthetic */ Method $getTrace;
            final /* synthetic */ Method $getLineNumber;

            @Nullable
            public final Integer invoke() {
                Integer n;
                ObjectReference trace;
                ExecutionContext executionContext = this.this$0.getContext();
                ObjectReference objectReference = (ObjectReference)this.$continuation.element;
                Method method = this.$getTrace;
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"getTrace");
                Value value2 = ExecutionContext.invokeMethod$default(executionContext, objectReference, method, CollectionsKt.emptyList(), 0, 8, null);
                if (!(value2 instanceof ObjectReference)) {
                    value2 = null;
                }
                if ((trace = (ObjectReference)value2) != null) {
                    ExecutionContext executionContext2 = this.this$0.getContext();
                    Method method2 = this.$getLineNumber;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"getLineNumber");
                    Value value3 = ExecutionContext.invokeMethod$default(executionContext2, trace, method2, CollectionsKt.emptyList(), 0, 8, null);
                    if (value3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.IntegerValue");
                    }
                    n = ((IntegerValue)value3).value();
                } else {
                    n = null;
                }
                return n;
            }
            {
                this.this$0 = lookupContinuation;
                this.$continuation = objectRef;
                this.$getTrace = method;
                this.$getLineNumber = method2;
                super(0);
            }
        };
        while (true) {
            Type type3 = ((ObjectReference)continuation2.element).type();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"continuation.type()");
            if (!TypeUtilsKt.isSubtype(type3, baseType)) break;
            if (!(Intrinsics.areEqual((Object)this.frame.getClassName(), (Object)((String)className2.invoke())) ^ true)) {
                Integer n = (Integer)lineNumber2.invoke();
                if (n != null && this.frame.getLineNumber() == n.intValue()) break;
            }
            if (this.getNextFrame((ObjectReference)continuation2.element, this.context) == null) {
                Object cfr_ignored_0 = continuation2.element;
                return null;
            }
            continuation2.element = continuation2.element;
        }
        Type type4 = ((ObjectReference)continuation2.element).type();
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"continuation.type()");
        return TypeUtilsKt.isSubtype(type4, baseType) ? (ObjectReference)continuation2.element : null;
    }

    private final ObjectReference getNextFrame(ObjectReference continuation2, ExecutionContext context2) {
        Method next2;
        Type type2 = continuation2.type();
        if (type2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
        }
        ClassType type3 = (ClassType)type2;
        if (!TypeUtilsKt.isSubtype((Type)type3, "kotlin.coroutines.jvm.internal.BaseContinuationImpl")) {
            return null;
        }
        Method method = next2 = type3.concreteMethodByName("getCompletion", "()Lkotlin/coroutines/Continuation;");
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"next");
        Value value2 = ExecutionContext.invokeMethod$default(context2, continuation2, method, CollectionsKt.emptyList(), 0, 8, null);
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        return (ObjectReference)value2;
    }

    @NotNull
    public final Method findGetStackTraceElementMethodRef(@NotNull ObjectReference continuation2) {
        Intrinsics.checkParameterIsNotNull((Object)continuation2, (String)"continuation");
        Type type2 = continuation2.type();
        if (type2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
        }
        Method method = ((ClassType)type2).concreteMethodByName("getStackTraceElement", "()Ljava/lang/StackTraceElement;");
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"(continuation.type() as \u2026lang/StackTraceElement;\")");
        return method;
    }

    @NotNull
    public final AsyncStackTraceContext createAsyncStackTraceContext(@NotNull Method stackTraceElementMethodRef, @NotNull ClassType debugMetadataClassType) {
        Intrinsics.checkParameterIsNotNull((Object)stackTraceElementMethodRef, (String)"stackTraceElementMethodRef");
        Intrinsics.checkParameterIsNotNull((Object)debugMetadataClassType, (String)"debugMetadataClassType");
        return new AsyncStackTraceContext(this.context, stackTraceElementMethodRef, debugMetadataClassType);
    }

    @Nullable
    public final AsyncStackTraceContext createAsyncStackTraceContext(@NotNull ObjectReference continuation2) {
        Intrinsics.checkParameterIsNotNull((Object)continuation2, (String)"continuation");
        Method getStackTraceElementMethodRef = this.findGetStackTraceElementMethodRef(continuation2);
        ClassType classType = this.context.findClassSafe("kotlin.coroutines.jvm.internal.DebugMetadataKt");
        if (classType == null) {
            return null;
        }
        ClassType debugMetadataClassType = classType;
        return this.createAsyncStackTraceContext(getStackTraceElementMethodRef, debugMetadataClassType);
    }

    @NotNull
    public final ExecutionContext getContext() {
        return this.context;
    }

    @NotNull
    public final StackTraceElement getFrame() {
        return this.frame;
    }

    public LookupContinuation(@NotNull ExecutionContext context2, @NotNull StackTraceElement frame) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        this.context = context2;
        this.frame = frame;
    }
}

