/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.KotlinFileTypeFactory;
import org.jetbrains.kotlin.idea.debugger.FileRankingCalculatorForIde;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompositeBindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u00042\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0004J<\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00042\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\nJ.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J8\u0010)\u001a\u0004\u0018\u00010\u001b2\u0006\u0010%\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020(0\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010+\u001a\u0004\u0018\u00010,J4\u0010-\u001a\u0004\u0018\u00010\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020(2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,J\u0010\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$R\u001c\u0010\u0003\u001a\u00020\u00048FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/DebuggerUtils;", "", "()V", "forceRanking", "", "getForceRanking", "()Z", "setForceRanking", "(Z)V", "analyzeElementWithInline", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "deep", "", "analyzedElements", "", "analyzeInlineFunctions", "fullResolveContext", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "analyzeInlinedFunctions", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacadeForFile", "file", "analyzeOnlyReifiedInlineFunctions", "bindingContext", "findFilesByNameInPackage", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findSourceFileForClass", "scopes", "location", "Lcom/sun/jdi/Location;", "findSourceFileForClassIncludeLibrarySources", "scope", "hasReifiedTypeParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isKotlinSourceFile", "jvm-debugger-util"})
public final class DebuggerUtils {
    private static boolean forceRanking;
    public static final DebuggerUtils INSTANCE;

    public final boolean getForceRanking() {
        return forceRanking;
    }

    public final void setForceRanking(boolean bl) {
        forceRanking = bl;
    }

    @Nullable
    public final KtFile findSourceFileForClassIncludeLibrarySources(@NotNull Project project2, @NotNull GlobalSearchScope scope2, @NotNull JvmClassName className2, @NotNull String fileName, @Nullable Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>(project2, scope2, className2, fileName, location2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Location $location;

            @Nullable
            public final KtFile invoke() {
                Object[] objectArray = new GlobalSearchScope[2];
                objectArray[0] = this.$scope;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
                objectArray[1] = KotlinSourceFilterScope.Companion.librarySources(globalSearchScope, this.$project);
                return DebuggerUtils.INSTANCE.findSourceFileForClass(this.$project, kotlin.collections.CollectionsKt.listOf((Object[])objectArray), this.$className, this.$fileName, this.$location);
            }
            {
                this.$project = project2;
                this.$scope = globalSearchScope;
                this.$className = jvmClassName;
                this.$fileName = string;
                this.$location = location2;
                super(0);
            }
        });
    }

    public static /* synthetic */ KtFile findSourceFileForClassIncludeLibrarySources$default(DebuggerUtils debuggerUtils, Project project2, GlobalSearchScope globalSearchScope, JvmClassName jvmClassName, String string, Location location2, int n, Object object) {
        if ((n & 0x10) != 0) {
            location2 = null;
        }
        return debuggerUtils.findSourceFileForClassIncludeLibrarySources(project2, globalSearchScope, jvmClassName, string, location2);
    }

    @Nullable
    public final KtFile findSourceFileForClass(@NotNull Project project2, @NotNull List<? extends GlobalSearchScope> scopes, @NotNull JvmClassName className2, @NotNull String fileName, @Nullable Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        if (!this.isKotlinSourceFile(fileName)) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(project)");
        if (dumbService.isDumb()) {
            return null;
        }
        FqName fqName2 = className2.getFqNameForClassNameWithoutDollars();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"className.fqNameForClassNameWithoutDollars");
        FqName partFqName = fqName2;
        for (GlobalSearchScope globalSearchScope : scopes) {
            Object v2;
            List<KtFile> files2;
            block7: {
                files2 = this.findFilesByNameInPackage(className2, fileName, project2, globalSearchScope);
                if (files2.isEmpty()) continue;
                if (files2.size() == 1 && !forceRanking || location2 == null) {
                    return (KtFile)kotlin.collections.CollectionsKt.first(files2);
                }
                Iterable $this$singleOrNull$iv = StaticFacadeIndexUtil.findFilesForFilePart(partFqName, globalSearchScope, project2);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KtFile it = (KtFile)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
                    if (found$iv) {
                        v2 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            KtFile ktFile = v2;
            if (ktFile != null) {
                KtFile ktFile2 = ktFile;
                boolean bl = false;
                boolean bl2 = false;
                KtFile it = ktFile2;
                boolean bl3 = false;
                return it;
            }
            return FileRankingCalculatorForIde.INSTANCE.findMostAppropriateSource((Collection<? extends KtFile>)files2, location2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFilesByNameInPackage(JvmClassName className2, String fileName, Project project2, GlobalSearchScope searchScope2) {
        void $this$filterTo$iv$iv;
        FqName fqName2 = className2.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"className.packageFqName");
        Iterable $this$filter$iv = PackageIndexUtil.findFilesWithExactPackage(fqName2, searchScope2, project2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files2 = (List)destination$iv$iv;
        return kotlin.collections.CollectionsKt.sortedWith((Iterable)files2, JavaElementFinder.Companion.byClasspathComparator(searchScope2));
    }

    @NotNull
    public final Pair<BindingContext, List<KtFile>> analyzeInlinedFunctions(@NotNull ResolutionFacade resolutionFacadeForFile, @NotNull KtFile file2, boolean analyzeOnlyReifiedInlineFunctions, @Nullable BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacadeForFile, (String)"resolutionFacadeForFile");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        HashSet analyzedElements = new HashSet();
        BindingContext context2 = this.analyzeElementWithInline(resolutionFacadeForFile, file2, 1, analyzedElements, !analyzeOnlyReifiedInlineFunctions, bindingContext2);
        LinkedHashSet<KtFile> toProcess = new LinkedHashSet<KtFile>();
        toProcess.add(file2);
        Iterator iterator2 = analyzedElements.iterator();
        while (iterator2.hasNext()) {
            KtFile containingFile;
            KtElement collectedElement;
            KtElement ktElement = collectedElement = (KtElement)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"collectedElement");
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement.getContainingKtFile(), (String)"collectedElement.containingKtFile");
            toProcess.add(containingFile);
        }
        return new Pair((Object)context2, new ArrayList(toProcess));
    }

    public static /* synthetic */ Pair analyzeInlinedFunctions$default(DebuggerUtils debuggerUtils, ResolutionFacade resolutionFacade2, KtFile ktFile, boolean bl, BindingContext bindingContext2, int n, Object object) {
        if ((n & 8) != 0) {
            bindingContext2 = null;
        }
        return debuggerUtils.analyzeInlinedFunctions(resolutionFacade2, ktFile, bl, bindingContext2);
    }

    @NotNull
    public final Collection<KtElement> analyzeElementWithInline(@NotNull KtNamedFunction function2, boolean analyzeInlineFunctions) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        HashSet analyzedElements = new HashSet();
        DebuggerUtils.analyzeElementWithInline$default(this, ResolutionUtils.getResolutionFacade((KtElement)function2), function2, 1, analyzedElements, !analyzeInlineFunctions, null, 32, null);
        return analyzedElements;
    }

    public final boolean isKotlinSourceFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        String string = FileUtilRt.getExtension((String)fileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtilRt.getExtension(fileName)");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String extension2 = string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)KotlinFileTypeFactory.KOTLIN_EXTENSIONS, (String)"KotlinFileTypeFactory.KOTLIN_EXTENSIONS");
        return ArraysKt.contains((Object[])KotlinFileTypeFactory.KOTLIN_EXTENSIONS, (Object)extension2);
    }

    private final BindingContext analyzeElementWithInline(ResolutionFacade resolutionFacade2, KtElement element3, int deep, Set<KtElement> analyzedElements, boolean analyzeInlineFunctions, BindingContext fullResolveContext) {
        Project project2 = element3.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"element.project");
        Project project3 = project2;
        HashSet declarationsWithBody = new HashSet();
        ArrayList<BindingContext> innerContexts = new ArrayList<BindingContext>();
        CollectionsKt.addIfNotNull((Collection)innerContexts, fullResolveContext);
        element3.accept(new KtTreeVisitorVoid(resolutionFacade2, innerContexts, analyzeInlineFunctions, project3, analyzedElements, declarationsWithBody){
            final /* synthetic */ ResolutionFacade $resolutionFacade;
            final /* synthetic */ ArrayList $innerContexts;
            final /* synthetic */ boolean $analyzeInlineFunctions;
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $analyzedElements;
            final /* synthetic */ HashSet $declarationsWithBody;

            public void visitExpression(@NotNull KtExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)expression2, null, (int)2, null);
                this.$innerContexts.add(bindingContext2);
                Call call2 = (Call)bindingContext2.get(BindingContext.CALL, expression2);
                if (call2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"bindingContext.get(Bindi\u2026LL, expression) ?: return");
                Call call3 = call2;
                ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get(BindingContext.RESOLVED_CALL, call3);
                this.checkResolveCall(resolvedCall2);
            }

            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkParameterIsNotNull((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)destructuringDeclaration, null, (int)2, null);
                this.$innerContexts.add(bindingContext2);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                    this.checkResolveCall(resolvedCall2);
                }
            }

            public void visitForExpression(@NotNull KtForExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitForExpression(expression2);
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)expression2, null, (int)2, null);
                this.$innerContexts.add(bindingContext2);
                this.checkResolveCall((ResolvedCall)bindingContext2.get(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext2.get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext2.get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
            }

            private final void checkResolveCall(ResolvedCall<?> resolvedCall2) {
                if (resolvedCall2 == null) {
                    return;
                }
                ? descriptor2 = resolvedCall2.getResultingDescriptor();
                if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
                    return;
                }
                ? obj = descriptor2;
                Intrinsics.checkExpressionValueIsNotNull(obj, (String)"descriptor");
                this.isAdditionalResolveNeededForDescriptor((CallableDescriptor)obj);
                if (descriptor2 instanceof PropertyDescriptor) {
                    Iterator<PropertyAccessorDescriptor> iterator2 = ((PropertyDescriptor)descriptor2).getAccessors().iterator();
                    while (iterator2.hasNext()) {
                        PropertyAccessorDescriptor accessor;
                        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)propertyAccessorDescriptor, (String)"accessor");
                        this.isAdditionalResolveNeededForDescriptor(propertyAccessorDescriptor);
                    }
                }
            }

            private final void isAdditionalResolveNeededForDescriptor(CallableDescriptor descriptor2) {
                if (!InlineUtil.isInline(descriptor2) || !this.$analyzeInlineFunctions && !DebuggerUtils.access$hasReifiedTypeParameters(DebuggerUtils.INSTANCE, descriptor2)) {
                    return;
                }
                PsiElement declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, descriptor2);
                if (declaration2 != null && declaration2 instanceof KtDeclarationWithBody && !this.$analyzedElements.contains(declaration2)) {
                    this.$declarationsWithBody.add(declaration2);
                    return;
                }
            }
            {
                this.$resolutionFacade = $captured_local_variable$0;
                this.$innerContexts = $captured_local_variable$1;
                this.$analyzeInlineFunctions = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                this.$analyzedElements = $captured_local_variable$4;
                this.$declarationsWithBody = $captured_local_variable$5;
            }
        });
        analyzedElements.add(element3);
        if (!declarationsWithBody.isEmpty() && deep < 10) {
            Iterator iterator2 = declarationsWithBody.iterator();
            while (iterator2.hasNext()) {
                KtDeclarationWithBody inlineFunction;
                KtDeclarationWithBody ktDeclarationWithBody = inlineFunction = (KtDeclarationWithBody)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclarationWithBody, (String)"inlineFunction");
                KtExpression body2 = ktDeclarationWithBody.getBodyExpression();
                if (body2 == null) continue;
                innerContexts.add(DebuggerUtils.analyzeElementWithInline$default(this, resolutionFacade2, inlineFunction, deep + 1, analyzedElements, analyzeInlineFunctions, null, 32, null));
            }
            analyzedElements.addAll(declarationsWithBody);
        }
        return CompositeBindingContext.Companion.create((List<? extends BindingContext>)innerContexts);
    }

    static /* synthetic */ BindingContext analyzeElementWithInline$default(DebuggerUtils debuggerUtils, ResolutionFacade resolutionFacade2, KtElement ktElement, int n, Set set2, boolean bl, BindingContext bindingContext2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bindingContext2 = null;
        }
        return debuggerUtils.analyzeElementWithInline(resolutionFacade2, ktElement, n, set2, bl, bindingContext2);
    }

    private final boolean hasReifiedTypeParameters(CallableDescriptor descriptor2) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.typeParameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    TypeParameterDescriptor typeParameterDescriptor = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"it");
                    if (!typeParameterDescriptor.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private DebuggerUtils() {
    }

    static {
        DebuggerUtils debuggerUtils;
        INSTANCE = debuggerUtils = new DebuggerUtils();
    }

    public static final /* synthetic */ boolean access$hasReifiedTypeParameters(DebuggerUtils $this, CallableDescriptor descriptor2) {
        return $this.hasReifiedTypeParameters(descriptor2);
    }
}

