/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.utils;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;

@State(name="ScriptClassRootsStorage", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\u0000H\u0016J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0016J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016H\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "()V", "classpath", "", "", "sdks", "sources", "containsAll", "", "configuration", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage$Companion$ScriptClassRoots;", "getState", "loadClasspathRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadSourcesRoots", "loadState", "", "state", "save", "toStringNames", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "toStringValues", "prop", "Ljava/io/File;", "toVirtualFiles", "Companion", "idea-core"})
public final class ScriptClassRootsStorage
implements PersistentStateComponent<ScriptClassRootsStorage> {
    private Set<String> classpath;
    private Set<String> sources;
    private Set<String> sdks;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public ScriptClassRootsStorage getState() {
        return this;
    }

    public void loadState(@NotNull ScriptClassRootsStorage state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> toStringNames(Collection<? extends Sdk> sdks) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = sdks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Sdk sdk2 = (Sdk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> toStringValues(Collection<? extends File> prop) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = prop;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if ((it.isDirectory() ? it.getAbsolutePath() : (it.isFile() ? it.getAbsolutePath() + "!/" : null)) == null) continue;
            string = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> toVirtualFiles(Set<String> prop, boolean sources) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        OrderRootType rootType = sources ? OrderRootType.SOURCES : OrderRootType.CLASSES;
        Iterable $this$mapNotNull$iv = prop;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Sdk sdk2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (ProjectJdkTable.getInstance().findJdk(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Sdk it$iv$iv = sdk2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            boolean bl = false;
            Sdk sdk3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)sdk3, (String)"it");
            Object[] objectArray = sdk3.getRootProvider().getFiles(rootType);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.rootProvider.getFiles(rootType)");
            Iterable list$iv$iv = ArraysKt.toList((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> toVirtualFiles(Collection<String> prop) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = prop;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFileSystem virtualFileSystem;
            VirtualFileSystem it;
            boolean bl;
            boolean bl2;
            VirtualFileSystem virtualFileSystem2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            String it2 = (String)element$iv$iv;
            boolean bl4 = false;
            VirtualFileSystem virtualFileSystem3 = StandardFileSystems.local();
            if (virtualFileSystem3 != null && (virtualFileSystem3 = virtualFileSystem3.findFileByPath(it2)) != null) {
                virtualFileSystem2 = virtualFileSystem3;
                bl2 = false;
                bl = false;
                it = virtualFileSystem2;
                boolean bl5 = false;
                virtualFileSystem = it;
            } else {
                VirtualFileSystem virtualFileSystem4 = StandardFileSystems.jar();
                if (virtualFileSystem4 != null && (virtualFileSystem4 = virtualFileSystem4.findFileByPath(it2)) != null) {
                    virtualFileSystem2 = virtualFileSystem4;
                    bl2 = false;
                    bl = false;
                    it = virtualFileSystem2;
                    boolean bl6 = false;
                    virtualFileSystem = it;
                } else {
                    virtualFileSystem = null;
                }
            }
            if (virtualFileSystem == null) continue;
            VirtualFileSystem virtualFileSystem5 = virtualFileSystem;
            boolean bl7 = false;
            boolean bl8 = false;
            VirtualFileSystem it$iv$iv = virtualFileSystem5;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    public final boolean containsAll(@NotNull Companion.ScriptClassRoots configuration2) {
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        if (!this.classpath.containsAll((Collection)this.toStringValues((Collection<? extends File>)configuration2.getClasspathFiles()))) {
            ScriptUtilsKt.debug$default(null, (Function0)new Function0<String>(this, configuration2){
                final /* synthetic */ ScriptClassRootsStorage this$0;
                final /* synthetic */ Companion.ScriptClassRoots $configuration;

                @NotNull
                public final String invoke() {
                    return "class roots were changed: old = " + ScriptClassRootsStorage.access$getClasspath$p(this.this$0) + ", new = " + this.$configuration.getClasspathFiles();
                }
                {
                    this.this$0 = scriptClassRootsStorage;
                    this.$configuration = scriptClassRoots;
                    super(0);
                }
            }, 1, null);
            return false;
        }
        if (!this.sources.containsAll((Collection)this.toStringValues((Collection<? extends File>)configuration2.getSourcesFiles()))) {
            ScriptUtilsKt.debug$default(null, (Function0)new Function0<String>(this, configuration2){
                final /* synthetic */ ScriptClassRootsStorage this$0;
                final /* synthetic */ Companion.ScriptClassRoots $configuration;

                @NotNull
                public final String invoke() {
                    return "source roots were changed: old = " + ScriptClassRootsStorage.access$getSources$p(this.this$0) + ", new = " + this.$configuration.getSourcesFiles();
                }
                {
                    this.this$0 = scriptClassRootsStorage;
                    this.$configuration = scriptClassRoots;
                    super(0);
                }
            }, 1, null);
            return false;
        }
        if (!this.sdks.containsAll((Collection)this.toStringNames((Collection<? extends Sdk>)configuration2.getSdks()))) {
            ScriptUtilsKt.debug$default(null, (Function0)new Function0<String>(this, configuration2){
                final /* synthetic */ ScriptClassRootsStorage this$0;
                final /* synthetic */ Companion.ScriptClassRoots $configuration;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke() {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$configuration.getSdks();
                    StringBuilder stringBuilder2 = new StringBuilder().append("sdk classes were changed: old = ").append(ScriptClassRootsStorage.access$getSdks$p(this.this$0)).append(", new = ");
                    boolean $i$f$map = false;
                    void var3_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Sdk sdk2 = (Sdk)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        String string = it.getHomePath();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    return stringBuilder2.append(collection).toString();
                }
                {
                    this.this$0 = scriptClassRootsStorage;
                    this.$configuration = scriptClassRoots;
                    super(0);
                }
            }, 1, null);
            return false;
        }
        return true;
    }

    public final void save(@NotNull Companion.ScriptClassRoots configuration2) {
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        this.classpath = this.toStringValues((Collection<? extends File>)configuration2.getClasspathFiles());
        this.sources = this.toStringValues((Collection<? extends File>)configuration2.getSourcesFiles());
        this.sdks = this.toStringNames((Collection<? extends Sdk>)configuration2.getSdks());
    }

    @NotNull
    public final List<VirtualFile> loadClasspathRoots() {
        return CollectionsKt.plus((Collection)this.toVirtualFiles(this.sdks, false), (Iterable)this.toVirtualFiles((Collection<String>)this.classpath));
    }

    @NotNull
    public final List<VirtualFile> loadSourcesRoots() {
        return CollectionsKt.plus((Collection)this.toVirtualFiles(this.sdks, true), (Iterable)this.toVirtualFiles((Collection<String>)this.sources));
    }

    public ScriptClassRootsStorage() {
        ScriptClassRootsStorage scriptClassRootsStorage = this;
        boolean bl = false;
        HashSet hashSet = new HashSet();
        scriptClassRootsStorage.classpath = hashSet;
        scriptClassRootsStorage = this;
        bl = false;
        hashSet = new HashSet();
        scriptClassRootsStorage.sources = hashSet;
        scriptClassRootsStorage = this;
        bl = false;
        hashSet = new HashSet();
        scriptClassRootsStorage.sdks = hashSet;
    }

    public static final /* synthetic */ Set access$getClasspath$p(ScriptClassRootsStorage $this) {
        return $this.classpath;
    }

    public static final /* synthetic */ void access$setClasspath$p(ScriptClassRootsStorage $this, Set set2) {
        $this.classpath = set2;
    }

    public static final /* synthetic */ Set access$getSources$p(ScriptClassRootsStorage $this) {
        return $this.sources;
    }

    public static final /* synthetic */ void access$setSources$p(ScriptClassRootsStorage $this, Set set2) {
        $this.sources = set2;
    }

    public static final /* synthetic */ Set access$getSdks$p(ScriptClassRootsStorage $this) {
        return $this.sdks;
    }

    public static final /* synthetic */ void access$setSdks$p(ScriptClassRootsStorage $this, Set set2) {
        $this.sdks = set2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage;", "project", "Lcom/intellij/openapi/project/Project;", "ScriptClassRoots", "idea-core"})
    public static final class Companion {
        @NotNull
        public final ScriptClassRootsStorage getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Object object = ServiceManager.getService((Project)project2, ScriptClassRootsStorage.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026RootsStorage::class.java)");
            return (ScriptClassRootsStorage)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J9\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage$Companion$ScriptClassRoots;", "", "classpathFiles", "", "Ljava/io/File;", "sourcesFiles", "sdks", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getClasspathFiles", "()Ljava/util/List;", "getSdks", "getSourcesFiles", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea-core"})
        public static final class ScriptClassRoots {
            @NotNull
            private final List<File> classpathFiles;
            @NotNull
            private final List<File> sourcesFiles;
            @NotNull
            private final List<Sdk> sdks;

            @NotNull
            public final List<File> getClasspathFiles() {
                return this.classpathFiles;
            }

            @NotNull
            public final List<File> getSourcesFiles() {
                return this.sourcesFiles;
            }

            @NotNull
            public final List<Sdk> getSdks() {
                return this.sdks;
            }

            public ScriptClassRoots(@NotNull List<? extends File> classpathFiles, @NotNull List<? extends File> sourcesFiles, @NotNull List<? extends Sdk> sdks) {
                Intrinsics.checkParameterIsNotNull(classpathFiles, (String)"classpathFiles");
                Intrinsics.checkParameterIsNotNull(sourcesFiles, (String)"sourcesFiles");
                Intrinsics.checkParameterIsNotNull(sdks, (String)"sdks");
                this.classpathFiles = classpathFiles;
                this.sourcesFiles = sourcesFiles;
                this.sdks = sdks;
            }

            @NotNull
            public final List<File> component1() {
                return this.classpathFiles;
            }

            @NotNull
            public final List<File> component2() {
                return this.sourcesFiles;
            }

            @NotNull
            public final List<Sdk> component3() {
                return this.sdks;
            }

            @NotNull
            public final ScriptClassRoots copy(@NotNull List<? extends File> classpathFiles, @NotNull List<? extends File> sourcesFiles, @NotNull List<? extends Sdk> sdks) {
                Intrinsics.checkParameterIsNotNull(classpathFiles, (String)"classpathFiles");
                Intrinsics.checkParameterIsNotNull(sourcesFiles, (String)"sourcesFiles");
                Intrinsics.checkParameterIsNotNull(sdks, (String)"sdks");
                return new ScriptClassRoots(classpathFiles, sourcesFiles, sdks);
            }

            public static /* synthetic */ ScriptClassRoots copy$default(ScriptClassRoots scriptClassRoots, List list2, List list3, List list4, int n, Object object) {
                if ((n & 1) != 0) {
                    list2 = scriptClassRoots.classpathFiles;
                }
                if ((n & 2) != 0) {
                    list3 = scriptClassRoots.sourcesFiles;
                }
                if ((n & 4) != 0) {
                    list4 = scriptClassRoots.sdks;
                }
                return scriptClassRoots.copy(list2, list3, list4);
            }

            @NotNull
            public String toString() {
                return "ScriptClassRoots(classpathFiles=" + this.classpathFiles + ", sourcesFiles=" + this.sourcesFiles + ", sdks=" + this.sdks + ")";
            }

            public int hashCode() {
                List<File> list2 = this.classpathFiles;
                List<File> list3 = this.sourcesFiles;
                List<Sdk> list4 = this.sdks;
                return ((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (list4 != null ? ((Object)list4).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ScriptClassRoots)) break block3;
                        ScriptClassRoots scriptClassRoots = (ScriptClassRoots)object;
                        if (!Intrinsics.areEqual(this.classpathFiles, scriptClassRoots.classpathFiles) || !Intrinsics.areEqual(this.sourcesFiles, scriptClassRoots.sourcesFiles) || !Intrinsics.areEqual(this.sdks, scriptClassRoots.sdks)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

