/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.ModuleInfosFromIdeaModelKt;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.ScriptClassRootsStorage;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0006J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u000e\u0010)\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0006J\u0010\u0010*\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020\u0006J\u0014\u0010*\u001a\u0004\u0018\u00010\u001c2\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002J\u000e\u0010,\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0007J\b\u0010-\u001a\u00020.H\u0002J\f\u0010/\u001a\u00020$*\u00020\u001cH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000e\u001a\u0004\b\u0016\u0010\fR \u0010\u0018\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000e\u001a\u0004\b\u0019\u0010\u0013R\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000e\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "all", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "allDependenciesClassFiles", "", "getAllDependenciesClassFiles", "()Ljava/util/List;", "allDependenciesClassFiles$delegate", "Lkotlin/Lazy;", "allDependenciesClassFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "getAllDependenciesClassFilesScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "allDependenciesClassFilesScope$delegate", "allDependenciesSources", "getAllDependenciesSources", "allDependenciesSources$delegate", "allDependenciesSourcesScope", "getAllDependenciesSourcesScope", "allDependenciesSourcesScope$delegate", "firstScriptSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getFirstScriptSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "firstScriptSdk$delegate", "scriptsDependenciesClasspathScopeCache", "", "scriptsSdksCache", "contains", "", "file", "extractRoots", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage$Companion$ScriptClassRoots;", "configuration", "getScriptDependenciesClassFilesScope", "getScriptSdk", "compilationConfiguration", "hasNotCachedRoots", "saveClassRootsToStorage", "", "isAlreadyIndexed", "idea-core"})
public final class ScriptClassRootsCache {
    private final Map<VirtualFile, Sdk> scriptsSdksCache;
    @Nullable
    private final Lazy firstScriptSdk$delegate;
    @NotNull
    private final Lazy allDependenciesClassFiles$delegate;
    @NotNull
    private final Lazy allDependenciesSources$delegate;
    @NotNull
    private final Lazy allDependenciesClassFilesScope$delegate;
    @NotNull
    private final Lazy allDependenciesSourcesScope$delegate;
    private final Map<VirtualFile, GlobalSearchScope> scriptsDependenciesClasspathScopeCache;
    private final Project project;
    private final Map<VirtualFile, ScriptCompilationConfigurationWrapper> all;

    @Nullable
    public final Sdk getScriptSdk(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.scriptsSdksCache.get(file2);
    }

    private final Sdk getScriptSdk(ScriptCompilationConfigurationWrapper compilationConfiguration) {
        Sdk sdk2;
        block6: {
            boolean bl;
            Sdk[] sdkArray;
            try {
                Object object;
                Object object2 = compilationConfiguration;
                if (object2 != null && (object2 = object2.getJavaHome()) != null) {
                    sdkArray = object2;
                    bl = false;
                    boolean bl2 = false;
                    Object it = sdkArray;
                    boolean bl3 = false;
                    object = VfsUtil.findFileByIoFile((File)it, (boolean)true);
                } else {
                    object = null;
                }
                sdkArray = object;
            }
            catch (Throwable e) {
                sdkArray = null;
            }
            Object object = sdkArray;
            if (object == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"try {\n            compil\u2026\n        } ?: return null");
            Object javaHome = object;
            sdkArray = ModuleInfosFromIdeaModelKt.getAllProjectSdks();
            bl = false;
            Sdk[] sdkArray2 = sdkArray;
            boolean bl4 = false;
            Sdk[] sdkArray3 = sdkArray2;
            int n = sdkArray3.length;
            for (int j = 0; j < n; ++j) {
                Sdk sdk3;
                Sdk it = sdk3 = sdkArray3[j];
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it.getHomeDirectory(), (Object)javaHome)) continue;
                sdk2 = sdk3;
                break block6;
            }
            sdk2 = null;
        }
        return sdk2;
    }

    @Nullable
    public final Sdk getFirstScriptSdk() {
        Lazy lazy = this.firstScriptSdk$delegate;
        ScriptClassRootsCache scriptClassRootsCache = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Sdk)lazy.getValue();
    }

    private final boolean isAlreadyIndexed(@NotNull Sdk $this$isAlreadyIndexed) {
        boolean bl;
        block1: {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Module[] moduleArray = moduleManager.getModules();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
            Module[] $this$any$iv = moduleArray;
            boolean $i$f$any = false;
            Module[] moduleArray2 = $this$any$iv;
            int n = moduleArray2.length;
            for (int j = 0; j < n; ++j) {
                Module element$iv;
                Module it = element$iv = moduleArray2[j];
                boolean bl2 = false;
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(it)");
                if (!Intrinsics.areEqual((Object)moduleRootManager.getSdk(), (Object)$this$isAlreadyIndexed)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<VirtualFile> getAllDependenciesClassFiles() {
        Lazy lazy = this.allDependenciesClassFiles$delegate;
        ScriptClassRootsCache scriptClassRootsCache = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<VirtualFile> getAllDependenciesSources() {
        Lazy lazy = this.allDependenciesSources$delegate;
        ScriptClassRootsCache scriptClassRootsCache = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final GlobalSearchScope getAllDependenciesClassFilesScope() {
        Lazy lazy = this.allDependenciesClassFilesScope$delegate;
        ScriptClassRootsCache scriptClassRootsCache = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GlobalSearchScope)lazy.getValue();
    }

    @NotNull
    public final GlobalSearchScope getAllDependenciesSourcesScope() {
        Lazy lazy = this.allDependenciesSourcesScope$delegate;
        ScriptClassRootsCache scriptClassRootsCache = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GlobalSearchScope)lazy.getValue();
    }

    @NotNull
    public final GlobalSearchScope getScriptDependenciesClassFilesScope(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        GlobalSearchScope globalSearchScope = this.scriptsDependenciesClasspathScopeCache.get(file2);
        if (globalSearchScope == null) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.EMPTY_SCOPE;
            globalSearchScope = globalSearchScope2;
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"GlobalSearchScope.EMPTY_SCOPE");
        }
        return globalSearchScope;
    }

    public final boolean hasNotCachedRoots(@NotNull ScriptCompilationConfigurationWrapper compilationConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)compilationConfiguration, (String)"compilationConfiguration");
        return !ScriptClassRootsStorage.Companion.getInstance(this.project).containsAll(this.extractRoots(compilationConfiguration));
    }

    private final ScriptClassRootsStorage.Companion.ScriptClassRoots extractRoots(ScriptCompilationConfigurationWrapper configuration2) {
        Sdk scriptSdk;
        Sdk sdk2 = this.getScriptSdk(configuration2);
        if (sdk2 == null) {
            sdk2 = scriptSdk = ScriptConfigurationManager.Companion.getScriptDefaultSdk(this.project);
        }
        if (scriptSdk != null && !this.isAlreadyIndexed(scriptSdk)) {
            return new ScriptClassRootsStorage.Companion.ScriptClassRoots(configuration2.getDependenciesClassPath(), configuration2.getDependenciesSources(), CollectionsKt.listOf((Object)scriptSdk));
        }
        return new ScriptClassRootsStorage.Companion.ScriptClassRoots(configuration2.getDependenciesClassPath(), configuration2.getDependenciesSources(), CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final void saveClassRootsToStorage() {
        if (this.all.isEmpty()) {
            return;
        }
        boolean bl = false;
        Set classpath = new LinkedHashSet();
        boolean bl2 = false;
        Set sources = new LinkedHashSet();
        boolean bl3 = false;
        Set sdks = new LinkedHashSet();
        VirtualFile virtualFile2 = this.all;
        boolean bl4 = false;
        Iterator<Map.Entry<VirtualFile, ScriptCompilationConfigurationWrapper>> iterator2 = virtualFile2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void file2;
            Map.Entry<VirtualFile, ScriptCompilationConfigurationWrapper> entry;
            Map.Entry<VirtualFile, ScriptCompilationConfigurationWrapper> entry2 = entry = iterator2.next();
            boolean bl5 = false;
            virtualFile2 = entry2.getKey();
            entry2 = entry;
            bl5 = false;
            ScriptCompilationConfigurationWrapper configuration2 = entry2.getValue();
            Sdk scriptSdk = this.getScriptSdk((VirtualFile)file2);
            if (scriptSdk != null && !this.isAlreadyIndexed(scriptSdk)) {
                sdks.add(scriptSdk);
            }
            classpath.addAll(configuration2.getDependenciesClassPath());
            sources.addAll(configuration2.getDependenciesSources());
        }
        ScriptClassRootsStorage rootsStorage = ScriptClassRootsStorage.Companion.getInstance(this.project);
        rootsStorage.save(new ScriptClassRootsStorage.Companion.ScriptClassRoots(CollectionsKt.toList((Iterable)classpath), CollectionsKt.toList((Iterable)sources), CollectionsKt.toList((Iterable)sdks)));
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.all.containsKey(file2);
    }

    public ScriptClassRootsCache(@NotNull Project project2, @NotNull Map<VirtualFile, ? extends ScriptCompilationConfigurationWrapper> all2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(all2, (String)"all");
        this.project = project2;
        this.all = all2;
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createWeakMap((Function)new Function<T, V>(this){
            final /* synthetic */ ScriptClassRootsCache this$0;

            @Nullable
            public final Sdk fun(VirtualFile file2) {
                Sdk sdk2 = ScriptClassRootsCache.access$getScriptSdk(this.this$0, (ScriptCompilationConfigurationWrapper)ScriptClassRootsCache.access$getAll$p(this.this$0).get(file2));
                if (sdk2 == null) {
                    sdk2 = ScriptConfigurationManager.Companion.getScriptDefaultSdk(ScriptClassRootsCache.access$getProject$p(this.this$0));
                }
                return sdk2;
            }
            {
                this.this$0 = scriptClassRootsCache;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026ultSdk(project)\n        }");
        this.scriptsSdksCache = concurrentMap;
        this.firstScriptSdk$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Sdk>(this){
            final /* synthetic */ ScriptClassRootsCache this$0;

            @Nullable
            public final Sdk invoke() {
                VirtualFile virtualFile2 = (VirtualFile)CollectionsKt.firstOrNull((Iterable)ScriptClassRootsCache.access$getAll$p(this.this$0).keySet());
                if (virtualFile2 == null) {
                    return null;
                }
                VirtualFile firstCachedScript = virtualFile2;
                return this.this$0.getScriptSdk(firstCachedScript);
            }
            {
                this.this$0 = scriptClassRootsCache;
                super(0);
            }
        }));
        this.allDependenciesClassFiles$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends VirtualFile>>(this){
            final /* synthetic */ ScriptClassRootsCache this$0;

            @NotNull
            public final List<VirtualFile> invoke() {
                return ScriptClassRootsStorage.Companion.getInstance(ScriptClassRootsCache.access$getProject$p(this.this$0)).loadClasspathRoots();
            }
            {
                this.this$0 = scriptClassRootsCache;
                super(0);
            }
        }));
        this.allDependenciesSources$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends VirtualFile>>(this){
            final /* synthetic */ ScriptClassRootsCache this$0;

            @NotNull
            public final List<VirtualFile> invoke() {
                return ScriptClassRootsStorage.Companion.getInstance(ScriptClassRootsCache.access$getProject$p(this.this$0)).loadSourcesRoots();
            }
            {
                this.this$0 = scriptClassRootsCache;
                super(0);
            }
        }));
        this.allDependenciesClassFilesScope$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GlobalSearchScope>(this){
            final /* synthetic */ ScriptClassRootsCache this$0;

            @NotNull
            public final GlobalSearchScope invoke() {
                return NonClasspathDirectoriesScope.compose(this.this$0.getAllDependenciesClassFiles());
            }
            {
                this.this$0 = scriptClassRootsCache;
                super(0);
            }
        }));
        this.allDependenciesSourcesScope$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GlobalSearchScope>(this){
            final /* synthetic */ ScriptClassRootsCache this$0;

            @NotNull
            public final GlobalSearchScope invoke() {
                return NonClasspathDirectoriesScope.compose(this.this$0.getAllDependenciesSources());
            }
            {
                this.this$0 = scriptClassRootsCache;
                super(0);
            }
        }));
        ConcurrentMap concurrentMap2 = ConcurrentFactoryMap.createWeakMap((Function)new Function<T, V>(this){
            final /* synthetic */ ScriptClassRootsCache this$0;

            public final GlobalSearchScope fun(VirtualFile file2) {
                ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = (ScriptCompilationConfigurationWrapper)ScriptClassRootsCache.access$getAll$p(this.this$0).get(file2);
                if (scriptCompilationConfigurationWrapper == null) {
                    return GlobalSearchScope.EMPTY_SCOPE;
                }
                ScriptCompilationConfigurationWrapper compilationConfiguration = scriptCompilationConfigurationWrapper;
                List roots = compilationConfiguration.getDependenciesClassPath();
                Sdk sdk2 = (Sdk)ScriptClassRootsCache.access$getScriptsSdksCache$p(this.this$0).get(file2);
                if (sdk2 == null) {
                    return NonClasspathDirectoriesScope.compose(ScriptConfigurationManager.Companion.toVfsRoots(roots));
                }
                Object[] objectArray = sdk2.getRootProvider().getFiles(OrderRootType.CLASSES);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"sdk.rootProvider.getFiles(OrderRootType.CLASSES)");
                return NonClasspathDirectoriesScope.compose((List)CollectionsKt.plus((Collection)ArraysKt.toList((Object[])objectArray), (Iterable)ScriptConfigurationManager.Companion.toVfsRoots(roots)));
            }
            {
                this.this$0 = scriptClassRootsCache;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap2, (String)"ConcurrentFactoryMap.cre\u2026)\n            )\n        }");
        this.scriptsDependenciesClasspathScopeCache = concurrentMap2;
        this.saveClassRootsToStorage();
    }

    public static final /* synthetic */ Sdk access$getScriptSdk(ScriptClassRootsCache $this, ScriptCompilationConfigurationWrapper compilationConfiguration) {
        return $this.getScriptSdk(compilationConfiguration);
    }

    public static final /* synthetic */ Map access$getAll$p(ScriptClassRootsCache $this) {
        return $this.all;
    }

    public static final /* synthetic */ Project access$getProject$p(ScriptClassRootsCache $this) {
        return $this.project;
    }

    public static final /* synthetic */ Map access$getScriptsSdksCache$p(ScriptClassRootsCache $this) {
        return $this.scriptsSdksCache;
    }
}

