/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.lightClasses;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.lightClasses.ByJvmSignatureIndexer;
import org.jetbrains.kotlin.idea.caches.lightClasses.ClassNameAndSignature;
import org.jetbrains.kotlin.idea.caches.lightClasses.LightMemberOriginForCompiledElementKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KtClsFile;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextIndexer;
import org.jetbrains.kotlin.load.kotlin.MemberSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\tH\u0002\u001a\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u000eH\u0002\"\u0015\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0012"}, d2={"BySignatureIndexer", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledTextIndexer;", "getBySignatureIndexer", "()Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledTextIndexer;", "findDeclarationInCompiledFile", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "file", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/KtClsFile;", "member", "Lcom/intellij/psi/PsiMember;", "signature", "Lorg/jetbrains/kotlin/load/kotlin/MemberSignature;", "desc", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "relativeClassName", "", "Lorg/jetbrains/kotlin/name/Name;", "idea-core"})
public final class LightMemberOriginForCompiledElementKt {
    @NotNull
    private static final DecompiledTextIndexer<?> BySignatureIndexer = ByJvmSignatureIndexer.INSTANCE;

    /*
     * WARNING - void declaration
     */
    private static final KtDeclaration findDeclarationInCompiledFile(KtClsFile file2, PsiMember member, MemberSignature signature) {
        List<Name> relativeClassName2 = LightMemberOriginForCompiledElementKt.relativeClassName(member);
        ClassNameAndSignature key = new ClassNameAndSignature(relativeClassName2, signature);
        String memberName2 = member.getName();
        if (memberName2 != null && !file2.isContentsLoaded() && file2.hasDeclarationWithKey(ByJvmSignatureIndexer.INSTANCE, key)) {
            KtDeclaration declaration2;
            KtDeclaration ktDeclaration;
            KtDeclarationContainer container2;
            Object object;
            KtDeclarationContainer ktDeclarationContainer;
            if (relativeClassName2.isEmpty()) {
                ktDeclarationContainer = file2;
            } else {
                Object object2 = CollectionsKt.singleOrNull(file2.getDeclarations());
                if (!(object2 instanceof KtClassOrObject)) {
                    object2 = null;
                }
                KtClassOrObject topClassOrObject = (KtClassOrObject)object2;
                Iterable $this$fold$iv = relativeClassName2;
                boolean $i$f$fold = false;
                KtClassOrObject accumulator$iv = topClassOrObject;
                for (Object element$iv : $this$fold$iv) {
                    KtDeclaration ktDeclaration2;
                    KtDeclaration ktDeclaration3;
                    Name name2 = (Name)element$iv;
                    KtClassOrObject classOrObject = accumulator$iv;
                    boolean bl = false;
                    Object object3 = classOrObject;
                    if (object3 != null && (object3 = ((KtClassOrObject)object3).getDeclarations()) != null) {
                        Object v3;
                        block15: {
                            Iterable $this$singleOrNull$iv = (Iterable)object3;
                            boolean $i$f$singleOrNull = false;
                            Object single$iv = null;
                            boolean found$iv = false;
                            for (Object element$iv2 : $this$singleOrNull$iv) {
                                void name3;
                                KtDeclaration it = (KtDeclaration)element$iv2;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name3.asString())) continue;
                                if (found$iv) {
                                    v3 = null;
                                    break block15;
                                }
                                single$iv = element$iv2;
                                found$iv = true;
                            }
                            v3 = !found$iv ? null : single$iv;
                        }
                        ktDeclaration3 = v3;
                    } else {
                        ktDeclaration3 = ktDeclaration2 = null;
                    }
                    if (!(ktDeclaration3 instanceof KtClassOrObject)) {
                        ktDeclaration2 = null;
                    }
                    accumulator$iv = (KtClassOrObject)ktDeclaration2;
                }
                ktDeclarationContainer = accumulator$iv;
            }
            if ((object = (container2 = ktDeclarationContainer)) != null && (object = object.getDeclarations()) != null) {
                Object v8;
                block16: {
                    Iterable $this$singleOrNull$iv = (Iterable)object;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl = false;
                        KtDeclaration ktDeclaration4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration4, (String)"it");
                        if (!Intrinsics.areEqual((Object)ktDeclaration4.getName(), (Object)memberName2)) continue;
                        if (found$iv) {
                            v8 = null;
                            break block16;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v8 = !found$iv ? null : single$iv;
                }
                ktDeclaration = v8;
            } else {
                ktDeclaration = declaration2 = null;
            }
            if (declaration2 != null) {
                return declaration2;
            }
        }
        return file2.getDeclaration(ByJvmSignatureIndexer.INSTANCE, key);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Name> relativeClassName(@NotNull PsiMember $this$relativeClassName) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.reversed((Iterable)CollectionsKt.dropLast((List)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)$this$relativeClassName.getContainingClass(), (Function1)relativeClassName.1.INSTANCE)), (int)1));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiClass psiClass2 = (PsiClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
            String string = v0.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Name name2 = Name.identifier(string);
            collection.add(name2);
        }
        return (List)destination$iv$iv;
    }

    private static final List<Name> relativeClassName(@NotNull ClassDescriptor $this$relativeClassName) {
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)$this$relativeClassName);
        if (classId == null) {
            Intrinsics.throwNpe();
        }
        List<Name> list2 = classId.getRelativeClassName().pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classId!!.relativeClassName.pathSegments()");
        return CollectionsKt.drop((Iterable)list2, (int)1);
    }

    private static final String desc(@NotNull ClassDescriptor $this$desc) {
        StringBuilder stringBuilder2 = new StringBuilder().append("L");
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)$this$desc);
        if (classId == null) {
            Intrinsics.throwNpe();
        }
        JvmClassName jvmClassName = JvmClassName.byClassId(classId);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byClassId(classId!!)");
        return stringBuilder2.append(jvmClassName.getInternalName()).append(";").toString();
    }

    @NotNull
    public static final DecompiledTextIndexer<?> getBySignatureIndexer() {
        return BySignatureIndexer;
    }

    public static final /* synthetic */ KtDeclaration access$findDeclarationInCompiledFile(KtClsFile file2, PsiMember member, MemberSignature signature) {
        return LightMemberOriginForCompiledElementKt.findDeclarationInCompiledFile(file2, member, signature);
    }

    public static final /* synthetic */ String access$desc(ClassDescriptor $this$access_u24desc) {
        return LightMemberOriginForCompiledElementKt.desc($this$access_u24desc);
    }

    public static final /* synthetic */ List access$relativeClassName(ClassDescriptor $this$access_u24relativeClassName) {
        return LightMemberOriginForCompiledElementKt.relativeClassName($this$access_u24relativeClassName);
    }
}

