/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageUtil {
    @NotNull
    public static BufferedImage createImage(int width, int height, int type) {
        if (StartupUiUtil.isJreHiDPI()) {
            BufferedImage bufferedImage = RetinaImage.create(width, height, type);
            if (bufferedImage == null) {
                ImageUtil.$$$reportNull$$$0(0);
            }
            return bufferedImage;
        }
        return new BufferedImage(width, height, type);
    }

    @NotNull
    public static BufferedImage createImage(GraphicsConfiguration gc, int width, int height, int type) {
        if (JreHiDpiUtil.isJreHiDPI(gc)) {
            BufferedImage bufferedImage = RetinaImage.create(gc, width, height, type);
            if (bufferedImage == null) {
                ImageUtil.$$$reportNull$$$0(1);
            }
            return bufferedImage;
        }
        return new BufferedImage(width, height, type);
    }

    @NotNull
    public static BufferedImage createImage(Graphics g, int width, int height, int type) {
        return ImageUtil.createImage(g, width, height, type, PaintUtil.RoundingMode.FLOOR);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(Graphics g, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            ImageUtil.$$$reportNull$$$0(2);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (JreHiDpiUtil.isJreHiDPI(g2d)) {
                BufferedImage bufferedImage = RetinaImage.create(g2d, width, height, (int)type, (PaintUtil.RoundingMode)rm);
                if (bufferedImage == null) {
                    ImageUtil.$$$reportNull$$$0(3);
                }
                return bufferedImage;
            }
            return new BufferedImage(rm.round(width), rm.round(height), (int)type);
        }
        return ImageUtil.createImage(rm.round(width), rm.round(height), (int)type);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(4);
        }
        return ImageUtil.toBufferedImage(image, false);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image, boolean inUserSize) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(5);
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jbImage = (JBHiDPIScaledImage)image;
            Image delegate = jbImage.getDelegate();
            if (delegate != null) {
                image = delegate;
            }
            if (inUserSize) {
                image = ImageUtil.scaleImage(image, 1.0 / jbImage.getScale());
            }
        }
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (bufferedImage == null) {
                ImageUtil.$$$reportNull$$$0(6);
            }
            return bufferedImage;
        }
        final int width = image.getWidth(null);
        final int height = image.getHeight(null);
        if (width <= 0 || height <= 0) {
            return new BufferedImage(Math.max(width, 1), Math.max(height, 1), 2){

                @Override
                public int getWidth() {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight() {
                    return Math.max(height, 0);
                }

                @Override
                public int getWidth(ImageObserver observer) {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight(ImageObserver observer) {
                    return Math.max(height, 0);
                }
            };
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ImageUtil.$$$reportNull$$$0(7);
        }
        return bufferedImage2;
    }

    public static double getImageScale(Image image) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getScale();
        }
        return 1.0;
    }

    public static int getRealWidth(@NotNull Image image) {
        Image img;
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(8);
        }
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getWidth(null);
    }

    public static int getRealHeight(@NotNull Image image) {
        Image img;
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(9);
        }
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getHeight(null);
    }

    public static int getUserWidth(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(10);
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserWidth(null);
        }
        return image.getWidth(null);
    }

    public static int getUserHeight(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(11);
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserHeight(null);
        }
        return image.getHeight(null);
    }

    public static Image filter(Image image, ImageFilter filter) {
        if (image == null || filter == null) {
            return image;
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image).getSource(), filter));
    }

    public static Image scaleImage(Image image, double scale) {
        return ImageLoader.scaleImage(image, scale);
    }

    public static Image scaleImage(Image image, int width, int height) {
        if (width <= 0 || height <= 0) {
            return image;
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).scale(width, height);
        }
        return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull ScaleContext ctx) {
        if (ctx == null) {
            ImageUtil.$$$reportNull$$$0(12);
        }
        if (image == null) {
            return null;
        }
        if (StartupUiUtil.isJreHiDPI(ctx)) {
            return RetinaImage.createFrom(image, ctx.getScale(ScaleType.SYS_SCALE), null);
        }
        return image;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull JBUI.ScaleContext ctx) {
        if (ctx == null) {
            ImageUtil.$$$reportNull$$$0(13);
        }
        return ImageUtil.ensureHiDPI(image, (ScaleContext)ctx);
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="null, _, _, _ -> null; !null, _, _, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull ScaleContext ctx, double userWidth, double d) {
        if (ctx == null) {
            ImageUtil.$$$reportNull$$$0(14);
        }
        if (image == null) {
            return null;
        }
        if (StartupUiUtil.isJreHiDPI(ctx)) {
            void userHeight;
            return new JBHiDPIScaledImage(image, userWidth, (double)userHeight, 2);
        }
        return image;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ImageUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ImageUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toBufferedImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toBufferedImage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRealWidth";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRealHeight";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserWidth";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserHeight";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ensureHiDPI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

