/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaStatisticsManager {
    private static final Logger LOG = Logger.getInstance(JavaStatisticsManager.class);
    @NonNls
    public static final String CLASS_PREFIX = "class#";

    @NotNull
    private static StatisticsInfo createVariableUseInfo(String name, VariableKind variableKind, String propertyName, PsiType type) {
        String key1 = JavaStatisticsManager.getVariableNameUseKey1(propertyName, type);
        String key2 = JavaStatisticsManager.getVariableNameUseKey2(variableKind, name);
        return new StatisticsInfo(key1, key2);
    }

    @NotNull
    private static String getVariableNameUseKey1(String propertyName, PsiType type) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("variableName#");
        if (propertyName != null) {
            buffer.append(propertyName);
        }
        buffer.append("#");
        if (type != null) {
            buffer.append(type.getCanonicalText());
        }
        String string = buffer.toString();
        if (string == null) {
            JavaStatisticsManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getVariableNameUseKey2(VariableKind kind, String name) {
        String string = (Object)((Object)kind) + "#" + name;
        if (string == null) {
            JavaStatisticsManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static int getVariableNameUseCount(String name, VariableKind variableKind, String propertyName, PsiType type) {
        return StatisticsManager.getInstance().getUseCount(JavaStatisticsManager.createVariableUseInfo(name, variableKind, propertyName, type));
    }

    public static void incVariableNameUseCount(String name, VariableKind variableKind, String propertyName, PsiType type) {
        StatisticsManager.getInstance().incUseCount(JavaStatisticsManager.createVariableUseInfo(name, variableKind, propertyName, type));
    }

    @Nullable
    public static String getName(@NotNull String key2) {
        int startIndex;
        if (key2 == null) {
            JavaStatisticsManager.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((startIndex = key2.indexOf(35)) >= 0);
        String s = key2.substring(0, startIndex);
        if (!"variableName".equals(s)) {
            return null;
        }
        int index = key2.indexOf(35, startIndex + 1);
        LOG.assertTrue(index >= 0);
        return key2.substring(index + 1);
    }

    @NotNull
    private static VariableKind getVariableKindFromKey2(@NotNull String key2) {
        int index;
        if (key2 == null) {
            JavaStatisticsManager.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((index = key2.indexOf(35)) >= 0);
        String s = key2.substring(0, index);
        VariableKind variableKind = VariableKind.valueOf(s);
        if (variableKind == null) {
            JavaStatisticsManager.$$$reportNull$$$0(4);
        }
        return variableKind;
    }

    @NotNull
    private static String getVariableNameFromKey2(@NotNull String key2) {
        int index;
        if (key2 == null) {
            JavaStatisticsManager.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((index = key2.indexOf(35)) >= 0);
        String string = key2.substring(index + 1);
        if (string == null) {
            JavaStatisticsManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NonNls
    @NotNull
    public static String getMemberUseKey1(@Nullable PsiType qualifierType) {
        qualifierType = TypeConversionUtil.erasure(qualifierType);
        String string = "member#" + (qualifierType == null ? "" : qualifierType.getCanonicalText());
        if (string == null) {
            JavaStatisticsManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NonNls
    @NotNull
    public static String getMemberUseKey2(@NotNull PsiMember member) {
        if (member == null) {
            JavaStatisticsManager.$$$reportNull$$$0(8);
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            StringBuilder buffer = new StringBuilder();
            buffer.append("method#");
            buffer.append(method.getName());
            for (PsiParameter param : method.getParameterList().getParameters()) {
                buffer.append("#");
                buffer.append(param.getType().getPresentableText());
            }
            String string = buffer.toString();
            if (string == null) {
                JavaStatisticsManager.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (member instanceof PsiField) {
            String string = "field#" + member.getName();
            if (string == null) {
                JavaStatisticsManager.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (member instanceof PsiRecordComponent) {
            String string = "record#" + member.getName();
            if (string == null) {
                JavaStatisticsManager.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = CLASS_PREFIX + ((PsiClass)member).getQualifiedName();
        if (string == null) {
            JavaStatisticsManager.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static StatisticsInfo createInfo(@Nullable PsiType qualifierType, @NotNull PsiMember member) {
        if (member == null) {
            JavaStatisticsManager.$$$reportNull$$$0(13);
        }
        return new StatisticsInfo(JavaStatisticsManager.getMemberUseKey1(qualifierType), JavaStatisticsManager.getMemberUseKey2(member));
    }

    public static String @NotNull [] getAllVariableNamesUsed(VariableKind variableKind, String propertyName, PsiType type) {
        StatisticsInfo[] keys2 = StatisticsManager.getInstance().getAllValues(JavaStatisticsManager.getVariableNameUseKey1(propertyName, type));
        ArrayList<String> list = new ArrayList<String>();
        for (StatisticsInfo key2 : keys2) {
            VariableKind variableKind1 = JavaStatisticsManager.getVariableKindFromKey2(key2.getValue());
            if (variableKind1 != variableKind) continue;
            String name = JavaStatisticsManager.getVariableNameFromKey2(key2.getValue());
            list.add(name);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(list);
        if (stringArray == null) {
            JavaStatisticsManager.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    @NotNull
    public static String getAfterNewKey(@Nullable PsiType expectedType) {
        String string = JavaStatisticsManager.getMemberUseKey1(expectedType) + "###smartAfterNew";
        if (string == null) {
            JavaStatisticsManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/statistics/JavaStatisticsManager";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key2";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNameUseKey1";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNameUseKey2";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/statistics/JavaStatisticsManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableKindFromKey2";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNameFromKey2";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberUseKey1";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberUseKey2";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVariableNamesUsed";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterNewKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariableKindFromKey2";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNameFromKey2";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMemberUseKey2";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

