/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class FileFinder {
    public static List<VirtualFile> findPomFiles(VirtualFile[] roots, final boolean lookForNested, final @NotNull MavenProgressIndicator indicator, final @NotNull List<VirtualFile> result) throws MavenProcessCanceledException {
        if (indicator == null) {
            FileFinder.$$$reportNull$$$0(0);
        }
        if (result == null) {
            FileFinder.$$$reportNull$$$0(1);
        }
        for (VirtualFile f : roots) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean visitFile(@NotNull VirtualFile f) {
                    if (f == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        indicator.checkCanceled();
                        indicator.setText2(f.getPath());
                        if (f.isDirectory()) {
                            if (!lookForNested) return false;
                            f.refresh(false, false);
                            return true;
                        } else {
                            if (!MavenUtil.isPomFile(f)) return true;
                            result.add(f);
                        }
                        return true;
                    }
                    catch (InvalidVirtualFileAccessException e) {
                        MavenLog.LOG.info((Throwable)e);
                        return true;
                    }
                    catch (MavenProcessCanceledException e) {
                        throw new VirtualFileVisitor.VisitorException((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/idea/maven/utils/FileFinder$1", "visitFile"));
                }
            }, MavenProcessCanceledException.class);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/utils/FileFinder";
        objectArray[2] = "findPomFiles";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

