/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.google.common.collect.Sets;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.DefaultJavaProgramRunner;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTasksProvider;
import org.jetbrains.idea.maven.tasks.MavenCompilerTask;
import org.jetbrains.idea.maven.tasks.MavenTasksManagerState;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;

@State(name="MavenCompilerTasksManager")
public final class MavenTasksManager
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenTasksManagerState> {
    private final AtomicBoolean isInitialized;
    private MavenTasksManagerState myState;
    private final MavenProjectsManager myProjectsManager;
    private final List<Listener> myListeners;

    public static MavenTasksManager getInstance(@NotNull Project project) {
        if (project == null) {
            MavenTasksManager.$$$reportNull$$$0(0);
        }
        return (MavenTasksManager)project.getService(MavenTasksManager.class);
    }

    public MavenTasksManager(@NotNull Project project) {
        if (project == null) {
            MavenTasksManager.$$$reportNull$$$0(1);
        }
        super(project);
        this.isInitialized = new AtomicBoolean();
        this.myState = new MavenTasksManagerState();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProjectsManager = MavenProjectsManager.getInstance(project);
    }

    public synchronized MavenTasksManagerState getState() {
        MavenTasksManagerState result = new MavenTasksManagerState();
        result.afterCompileTasks = new THashSet(this.myState.afterCompileTasks);
        result.beforeCompileTasks = new THashSet(this.myState.beforeCompileTasks);
        result.afterRebuildTask = new THashSet(this.myState.afterRebuildTask);
        result.beforeRebuildTask = new THashSet(this.myState.beforeRebuildTask);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull MavenTasksManagerState state) {
        if (state == null) {
            MavenTasksManager.$$$reportNull$$$0(2);
        }
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState = state;
        }
        if (this.isInitialized.get()) {
            this.fireTasksChanged();
        }
    }

    public void initializeComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        class MyCompileTask
        implements CompileTask {
            private final boolean myBefore;

            MyCompileTask(boolean before) {
                this.myBefore = before;
            }

            public boolean execute(@NotNull CompileContext context) {
                if (context == null) {
                    MyCompileTask.$$$reportNull$$$0(0);
                }
                return MavenTasksManager.this.doExecute(this.myBefore, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/tasks/MavenTasksManager$1MyCompileTask", "execute"));
            }
        }
        compilerManager.addBeforeTask((CompileTask)new MyCompileTask(true));
        compilerManager.addAfterTask((CompileTask)new MyCompileTask(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecute(boolean before, CompileContext context) {
        ArrayList<MavenRunnerParameters> parametersList;
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            Sets.SetView tasks;
            parametersList = new ArrayList<MavenRunnerParameters>();
            Object object = tasks = before ? this.myState.beforeCompileTasks : this.myState.afterCompileTasks;
            if (context.isRebuild()) {
                tasks = Sets.union(before ? this.myState.beforeRebuildTask : this.myState.afterRebuildTask, tasks);
            }
            for (MavenCompilerTask each : tasks) {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(each.getProjectPath());
                if (file == null) continue;
                MavenExplicitProfiles explicitProfiles = this.myProjectsManager.getExplicitProfiles();
                parametersList.add(new MavenRunnerParameters(true, file.getParent().getPath(), file.getName(), Collections.singletonList(each.getGoal()), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles()));
            }
        }
        return this.doRunTask(context, parametersList);
    }

    private boolean doRunTask(CompileContext context, List<MavenRunnerParameters> parametersList) {
        try {
            ProgramRunner runner = DefaultJavaProgramRunner.getInstance();
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            long executionId = ExecutionEnvironment.getNextUnusedExecutionId();
            int count = 0;
            for (MavenRunnerParameters params : parametersList) {
                RunnerAndConfigurationSettings configuration = MavenRunConfigurationType.createRunnerAndConfigurationSettings(null, null, params, context.getProject());
                if (parametersList.size() > 1) {
                    configuration.setName(MavenProjectBundle.message("maven.before.build.of.count", ++count, parametersList.size(), configuration.getName()));
                }
                ExecutionEnvironment environment = new ExecutionEnvironment(executor, runner, configuration, context.getProject());
                environment.setExecutionId(executionId);
                boolean result = RunConfigurationBeforeRunProvider.doRunTask((String)executor.getId(), (ExecutionEnvironment)environment, (ProgramRunner)runner);
                if (result) continue;
                return false;
            }
            return true;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            MavenLog.LOG.error("Cannot execute:", (Throwable)e);
            return false;
        }
    }

    public synchronized boolean isCompileTaskOfPhase(@NotNull MavenCompilerTask task, @NotNull Phase phase) {
        if (task == null) {
            MavenTasksManager.$$$reportNull$$$0(3);
        }
        if (phase == null) {
            MavenTasksManager.$$$reportNull$$$0(4);
        }
        return this.myState.getTasks(phase).contains(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompileTasks(List<MavenCompilerTask> tasks, @NotNull Phase phase) {
        if (phase == null) {
            MavenTasksManager.$$$reportNull$$$0(5);
        }
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState.getTasks(phase).addAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompileTasks(List<MavenCompilerTask> tasks, @NotNull Phase phase) {
        if (phase == null) {
            MavenTasksManager.$$$reportNull$$$0(6);
        }
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState.getTasks(phase).removeAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(MavenProject project, String goal) {
        ArrayList<String> result = new ArrayList<String>();
        MavenCompilerTask compilerTask = new MavenCompilerTask(project.getPath(), goal);
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            for (Phase phase : Phase.values()) {
                if (!this.myState.getTasks(phase).contains(compilerTask)) continue;
                result.add(TasksBundle.message(phase.myMessageKey, new Object[0]));
            }
        }
        for (MavenBeforeRunTask each : RunManagerEx.getInstanceEx((Project)this.myProject).getBeforeRunTasks(MavenBeforeRunTasksProvider.ID)) {
            if (!each.isFor(project, goal)) continue;
            result.add(TasksBundle.message("maven.tasks.goal.before.run", new Object[0]));
            break;
        }
        return StringUtil.join(result, (String)", ");
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void fireTasksChanged() {
        for (Listener each : this.myListeners) {
            each.compileTasksChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenTasksManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompileTaskOfPhase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompileTasks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCompileTasks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void compileTasksChanged();
    }

    public static enum Phase {
        BEFORE_COMPILE("maven.tasks.goal.before.compile"),
        AFTER_COMPILE("maven.tasks.goal.after.compile"),
        BEFORE_REBUILD("maven.tasks.goal.before.rebuild"),
        AFTER_REBUILD("maven.tasks.goal.after.rebuild");

        @PropertyKey(resourceBundle="messages.MavenTasksBundle")
        public final String myMessageKey;

        private Phase(String messageKey) {
            this.myMessageKey = messageKey;
        }
    }
}

