/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionConverter;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerLogger;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerRemoteProcessSupport;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenServerConnector
implements Disposable {
    private final RemoteMavenServerLogger myLogger;
    private final RemoteMavenServerDownloadListener myDownloadListener;
    private final Project myProject;
    private final MavenServerManager myManager;
    private final Integer myDebugPort;
    private boolean myLoggerExported;
    private boolean myDownloadListenerExported;
    private final Sdk myJdk;
    private final MavenDistribution myDistribution;
    private final String myVmOptions;
    private MavenServerRemoteProcessSupport mySupport;
    private MavenServer myMavenServer;

    public MavenServerConnector(@NotNull Project project, @NotNull MavenServerManager manager, @NotNull MavenWorkspaceSettings settings, @NotNull Sdk jdk, @Nullable Integer debugPort) {
        if (project == null) {
            MavenServerConnector.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MavenServerConnector.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            MavenServerConnector.$$$reportNull$$$0(2);
        }
        if (jdk == null) {
            MavenServerConnector.$$$reportNull$$$0(3);
        }
        this.myLogger = new RemoteMavenServerLogger();
        this.myDownloadListener = new RemoteMavenServerDownloadListener();
        this.myProject = project;
        this.myManager = manager;
        this.myDebugPort = debugPort;
        this.myDistribution = MavenServerConnector.findMavenDistribution(project, settings);
        settings.generalSettings.setMavenHome(this.myDistribution.getMavenHome().getAbsolutePath());
        this.myVmOptions = MavenServerConnector.readVmOptions(project, settings);
        this.myJdk = jdk;
        this.connect();
    }

    public MavenServerConnector(@NotNull Project project, @NotNull MavenServerManager manager, @NotNull MavenWorkspaceSettings settings, @NotNull Sdk jdk) {
        if (project == null) {
            MavenServerConnector.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            MavenServerConnector.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            MavenServerConnector.$$$reportNull$$$0(6);
        }
        if (jdk == null) {
            MavenServerConnector.$$$reportNull$$$0(7);
        }
        this(project, manager, settings, jdk, null);
    }

    public boolean isSettingsStillValid(MavenWorkspaceSettings settings) {
        String baseDir = this.myProject.getBasePath();
        if (baseDir == null) {
            return true;
        }
        String distributionUrl = MavenWrapperSupport.getWrapperDistributionUrl(LocalFileSystem.getInstance().findFileByPath(baseDir));
        if (distributionUrl != null && !distributionUrl.equals(this.myDistribution.getName())) {
            return false;
        }
        String newVmOptions = MavenServerConnector.readVmOptions(this.myProject, settings);
        return StringUtil.equals((CharSequence)newVmOptions, (CharSequence)this.myVmOptions);
    }

    private static String readVmOptions(Project project, MavenWorkspaceSettings settings) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return settings.importingSettings.getVmOptionsForImporter();
        }
        VirtualFile mvn = baseDir.findChild(".mvn");
        if (mvn == null) {
            return settings.importingSettings.getVmOptionsForImporter();
        }
        VirtualFile jdkOpts = mvn.findChild("jvm.config");
        if (jdkOpts == null) {
            return settings.importingSettings.getVmOptionsForImporter();
        }
        try {
            return new String(jdkOpts.contentsToByteArray(true), CharsetToolkit.UTF8_CHARSET);
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
            return settings.importingSettings.getVmOptionsForImporter();
        }
    }

    private static MavenDistribution findMavenDistribution(Project project, MavenWorkspaceSettings settings) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return MavenServerManager.resolveEmbeddedMavenHome();
        }
        MavenSyncConsole console = MavenProjectsManager.getInstance(project).getSyncConsole();
        String distributionUrl = MavenWrapperSupport.getWrapperDistributionUrl(baseDir);
        if (distributionUrl == null) {
            MavenDistribution distribution = new MavenDistributionConverter().fromString(settings.generalSettings.getMavenHome());
            if (distribution == null) {
                console.addWarning(SyncBundle.message("cannot.resolve.maven.home", new Object[0]), SyncBundle.message("is.not.correct.maven.home.reverting.to.embedded", settings.generalSettings.getMavenHome()));
                return MavenServerManager.resolveEmbeddedMavenHome();
            }
            return distribution;
        }
        try {
            console.startWrapperResolving();
            MavenDistribution distribution = new MavenWrapperSupport().downloadAndInstallMaven(distributionUrl);
            console.finishWrapperResolving(null);
            return distribution;
        }
        catch (IOException | RuntimeException e) {
            MavenLog.LOG.info((Throwable)e);
            console.finishWrapperResolving(e);
            return MavenServerManager.resolveEmbeddedMavenHome();
        }
    }

    private void connect() {
        if (this.mySupport != null || this.myMavenServer != null) {
            throw new IllegalStateException("Already connected");
        }
        try {
            if (this.myDebugPort != null) {
                System.out.println("Listening for transport dt_socket at address: " + this.myDebugPort);
            }
            this.mySupport = new MavenServerRemoteProcessSupport(this.myJdk, this.myVmOptions, this.myDistribution, this.myProject, this.myDebugPort);
            this.myMavenServer = (MavenServer)this.mySupport.acquire(this, "");
            boolean bl = this.myLoggerExported = MavenRemoteObjectWrapper.doWrapAndExport(this.myLogger) != null;
            if (!this.myLoggerExported) {
                throw new RemoteException("Cannot export logger object");
            }
            boolean bl2 = this.myDownloadListenerExported = MavenRemoteObjectWrapper.doWrapAndExport(this.myDownloadListener) != null;
            if (!this.myDownloadListenerExported) {
                throw new RemoteException("Cannot export download listener object");
            }
            this.myMavenServer.set((MavenServerLogger)this.myLogger, (MavenServerDownloadListener)this.myDownloadListener, MavenRemoteObjectWrapper.ourToken);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot start maven service", e);
        }
    }

    private void cleanUp() {
        if (this.myLoggerExported) {
            try {
                UnicastRemoteObject.unexportObject((Remote)((Object)this.myLogger), true);
            }
            catch (RemoteException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
            this.myLoggerExported = false;
        }
        if (this.myDownloadListenerExported) {
            try {
                UnicastRemoteObject.unexportObject((Remote)((Object)this.myDownloadListener), true);
            }
            catch (RemoteException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
            this.myDownloadListenerExported = false;
        }
        this.myMavenServer = null;
        this.mySupport = null;
    }

    public MavenServerEmbedder createEmbedder(MavenEmbedderSettings settings) throws RemoteException {
        return this.myMavenServer.createEmbedder(settings, MavenRemoteObjectWrapper.ourToken);
    }

    public MavenServerIndexer createIndexer() throws RemoteException {
        return this.myMavenServer.createIndexer(MavenRemoteObjectWrapper.ourToken);
    }

    public void addDownloadListener(MavenServerDownloadListener listener) {
        this.myDownloadListener.myListeners.add(listener);
    }

    public void removeDownloadListener(MavenServerDownloadListener listener) {
        this.myDownloadListener.myListeners.remove(listener);
    }

    @NotNull
    public MavenModel interpolateAndAlignModel(MavenModel model, File basedir) {
        MavenModel mavenModel = this.perform(() -> this.myMavenServer.interpolateAndAlignModel(model, basedir, MavenRemoteObjectWrapper.ourToken));
        if (mavenModel == null) {
            MavenServerConnector.$$$reportNull$$$0(8);
        }
        return mavenModel;
    }

    public MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) {
        return this.perform(() -> this.myMavenServer.assembleInheritance(model, parentModel, MavenRemoteObjectWrapper.ourToken));
    }

    public ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        return this.perform(() -> this.myMavenServer.applyProfiles(model, basedir, explicitProfiles, alwaysOnProfiles, MavenRemoteObjectWrapper.ourToken));
    }

    public void shutdown(boolean wait) {
        this.myManager.unregisterConnector(this);
        if (this.mySupport != null) {
            this.mySupport.stopAll(wait);
        }
        this.cleanUp();
    }

    protected <R, E extends Exception> R perform(RemoteObjectWrapper.Retriable<R, E> r) throws E {
        Throwable last = null;
        for (int i = 0; i < 2; ++i) {
            try {
                return r.execute();
            }
            catch (RemoteException e) {
                MavenServerRemoteProcessSupport processSupport = this.mySupport;
                if (processSupport != null) {
                    processSupport.stopAll(false);
                }
                this.cleanUp();
                this.connect();
                continue;
            }
        }
        throw new RuntimeException("Cannot reconnect.", last);
    }

    public void dispose() {
        this.shutdown(true);
    }

    @NotNull
    public Sdk getJdk() {
        Sdk sdk = this.myJdk;
        if (sdk == null) {
            MavenServerConnector.$$$reportNull$$$0(9);
        }
        return sdk;
    }

    public MavenDistribution getMavenDistribution() {
        return this.myDistribution;
    }

    public String getVMOptions() {
        return this.myVmOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerConnector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerConnector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoteMavenServerDownloadListener
    extends MavenRemoteObject
    implements MavenServerDownloadListener {
        private final List<MavenServerDownloadListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private RemoteMavenServerDownloadListener() {
        }

        public void artifactDownloaded(File file, String relativePath) throws RemoteException {
            for (MavenServerDownloadListener each : this.myListeners) {
                each.artifactDownloaded(file, relativePath);
            }
        }
    }

    private static class RemoteMavenServerLogger
    extends MavenRemoteObject
    implements MavenServerLogger {
        private RemoteMavenServerLogger() {
        }

        public void info(Throwable e) {
            MavenLog.LOG.info(e);
        }

        public void warn(Throwable e) {
            MavenLog.LOG.warn(e);
        }

        public void error(Throwable e) {
            MavenLog.LOG.error(e);
        }

        public void print(String s) {
            System.out.println(s);
        }
    }
}

